/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.client.renderer;

import com.stevekung.moreplanets.client.renderer.ccl.CCLAlienDefenderBeacon;
import com.stevekung.moreplanets.client.renderer.ccl.CCLBlackHoleStorage;
import com.stevekung.moreplanets.client.renderer.ccl.CCLChest;
import com.stevekung.moreplanets.client.renderer.ccl.CCLDarkEnergyCore;
import com.stevekung.moreplanets.client.renderer.ccl.CCLDarkEnergyGenerator;
import com.stevekung.moreplanets.client.renderer.ccl.CCLDarkEnergyReceiver;
import com.stevekung.moreplanets.client.renderer.ccl.CCLInfectedPurloniteBomb;
import com.stevekung.moreplanets.client.renderer.ccl.CCLInfectedPurloniteCrystal;
import com.stevekung.moreplanets.client.renderer.ccl.CCLJuicerEgg;
import com.stevekung.moreplanets.client.renderer.ccl.CCLMultalicCrystal;
import com.stevekung.moreplanets.client.renderer.ccl.CCLNuclearWasteTank;
import com.stevekung.moreplanets.client.renderer.ccl.CCLShieldGenerator;
import com.stevekung.moreplanets.client.renderer.ccl.CCLVeinFrame;
import com.stevekung.moreplanets.client.renderer.ccl.CCLZeliusEgg;
import com.stevekung.moreplanets.core.MorePlanetsMod;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPItems;
import com.stevekung.moreplanets.planets.chalos.tileentity.TileEntityChalosAncientChest;
import com.stevekung.moreplanets.planets.chalos.tileentity.TileEntityChalosTreasureChest;
import com.stevekung.moreplanets.planets.chalos.tileentity.TileEntityCheeseSporeChest;
import com.stevekung.moreplanets.planets.diona.tileentity.TileEntityDionaAncientChest;
import com.stevekung.moreplanets.planets.diona.tileentity.TileEntityDionaTreasureChest;
import com.stevekung.moreplanets.planets.nibiru.tileentity.TileEntityAlienBerryChest;
import com.stevekung.moreplanets.planets.nibiru.tileentity.TileEntityInfectedChest;
import com.stevekung.moreplanets.planets.nibiru.tileentity.TileEntityNibiruAncientChest;
import com.stevekung.moreplanets.planets.nibiru.tileentity.TileEntityNibiruTreasureChest;
import com.stevekung.moreplanets.tileentity.TileEntityAlienChest;
import com.stevekung.moreplanets.utils.BlocksItemsRegistry;
import com.stevekung.moreplanets.utils.LoggerMP;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;

public class ItemModelRenderer {
    public static void init() {
        ItemModelRenderer.registerBlockRenderer();
        ItemModelRenderer.registerItemRenderer();
    }

    private static void registerBlockRenderer() {
        BlocksItemsRegistry.SINGLE_BLOCK_RENDER_LIST.forEach((block, name) -> MorePlanetsMod.CLIENT_REGISTRY.registerModelRender(block, name));
    }

    private static void registerItemRenderer() {
        BlocksItemsRegistry.SINGLE_ITEM_RENDER_LIST.forEach((item, name) -> MorePlanetsMod.CLIENT_REGISTRY.registerModelRender(item, name));
    }

    public static void registerCCLRenderer() {
        try {
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.BLACK_HOLE_STORAGE, (Object)new CCLBlackHoleStorage());
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.DARK_ENERGY_RECEIVER, (Object)new CCLDarkEnergyReceiver());
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.SHIELD_GENERATOR, (Object)new CCLShieldGenerator());
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.DARK_ENERGY_CORE, (Object)new CCLDarkEnergyCore());
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.DARK_ENERGY_GENERATOR, (Object)new CCLDarkEnergyGenerator());
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.NUCLEAR_WASTE_TANK, (Object)new CCLNuclearWasteTank());
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.CHEESE_SPORE_CHEST, (Object)new CCLChest((TileEntity)new TileEntityCheeseSporeChest()));
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.DIONA_ANCIENT_CHEST, (Object)new CCLChest((TileEntity)new TileEntityDionaAncientChest()));
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.DIONA_TREASURE_CHEST, (Object)new CCLChest((TileEntity)new TileEntityDionaTreasureChest()));
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.CHALOS_ANCIENT_CHEST, (Object)new CCLChest((TileEntity)new TileEntityChalosAncientChest()));
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.CHALOS_TREASURE_CHEST, (Object)new CCLChest((TileEntity)new TileEntityChalosTreasureChest()));
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.NIBIRU_ANCIENT_CHEST, (Object)new CCLChest((TileEntity)new TileEntityNibiruAncientChest()));
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.NIBIRU_TREASURE_CHEST, (Object)new CCLChest((TileEntity)new TileEntityNibiruTreasureChest()));
            ItemModelRenderer.registerCCLItemRenderer((Block)MPBlocks.INFECTED_CHEST, (Object)new CCLChest((TileEntity)new TileEntityInfectedChest()));
            ItemModelRenderer.registerCCLItemRenderer((Block)MPBlocks.ALIEN_BERRY_CHEST, (Object)new CCLChest((TileEntity)new TileEntityAlienBerryChest()));
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.ALIEN_DEFENDER_BEACON, (Object)new CCLAlienDefenderBeacon());
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.ZELIUS_EGG, (Object)new CCLZeliusEgg());
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.INFECTED_PURLONITE_CRYSTAL, (Object)new CCLInfectedPurloniteCrystal());
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.MULTALIC_CRYSTAL, (Object)new CCLMultalicCrystal());
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.JUICER_EGG, (Object)new CCLJuicerEgg());
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.VEIN_FRAME, (Object)new CCLVeinFrame());
            ItemModelRenderer.registerCCLItemRenderer(MPItems.INFECTED_PURLONITE_BOMB, (Object)new CCLInfectedPurloniteBomb());
            ItemModelRenderer.registerCCLItemRenderer(MPBlocks.ALIEN_CHEST, (Object)new CCLChest((TileEntity)new TileEntityAlienChest()));
            LoggerMP.info("Successfully registered CodeChickenCore item renderer for More Planets blocks/items");
        }
        catch (Exception e) {
            LoggerMP.info("CodeChickenCore not loaded, using vanilla TileEntityItemStackRenderer");
        }
    }

    private static void registerCCLItemRenderer(Block block, Object obj) throws Exception {
        ItemModelRenderer.registerCCLItemRenderer(Item.func_150898_a((Block)block), obj);
    }

    private static void registerCCLItemRenderer(Item item, Object obj) throws Exception {
        Class<?> clazz = Class.forName("codechicken.lib.model.ModelRegistryHelper");
        Class<?> itemRenderClass = Class.forName("codechicken.lib.render.item.IItemRenderer");
        Method method = clazz.getDeclaredMethod("registerItemRenderer", Item.class, itemRenderClass);
        method.invoke(clazz, item, obj);
    }
}

