/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.client.renderer;

import com.google.common.collect.ImmutableList;
import com.stevekung.lib.utils.ColorUtils;
import com.stevekung.moreplanets.client.renderer.OBJLoaderMP;
import com.stevekung.moreplanets.tileentity.TileEntityShieldGenerator;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class ShieldRenderer {
    private static final ResourceLocation OBJ = new ResourceLocation("moreplanets:shield.obj");
    private static final List<TileEntityShieldGenerator> SHIELD = new ArrayList<TileEntityShieldGenerator>();
    private static IBakedModel SPHERE;

    public static void clearShields() {
        SHIELD.clear();
    }

    public static void addShield(TileEntityShieldGenerator tile) {
        SHIELD.add(tile);
    }

    private static void updateModels() {
        try {
            SPHERE = OBJLoaderMP.getModelFromOBJ(OBJ, (List<String>)ImmutableList.of((Object)"Shield"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void renderShields(EntityPlayer player, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        if (SPHERE == null) {
            ShieldRenderer.updateModels();
        }
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179132_a((boolean)false);
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        for (TileEntityShieldGenerator tile : SHIELD) {
            if (!tile.getBubbleVisible()) continue;
            GlStateManager.func_179094_E();
            float x = (float)((double)tile.func_174877_v().func_177958_n() - interpPosX);
            float y = (float)((double)tile.func_174877_v().func_177956_o() - interpPosY);
            float z = (float)((double)tile.func_174877_v().func_177952_p() - interpPosZ);
            GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 1.0f), (float)(z + 0.5f));
            GlStateManager.func_179152_a((float)tile.getBubbleSize(), (float)tile.getBubbleSize(), (float)tile.getBubbleSize());
            int capacity = tile.shieldCapacity * 171 / tile.maxShieldCapacity;
            int color = ColorUtils.to32BitColor((int)(capacity + 84), (int)255, (int)255, (int)255);
            ClientUtil.drawBakedModelColored((IBakedModel)SPHERE, (int)color);
            GlStateManager.func_179121_F();
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
        GlStateManager.func_179121_F();
    }
}

