/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.core;

import com.google.common.collect.Lists;
import com.stevekung.lib.utils.CommonRegistryUtils;
import com.stevekung.lib.utils.CommonUtils;
import com.stevekung.lib.utils.VersionChecker;
import com.stevekung.lib.utils.client.ClientRegistryUtils;
import com.stevekung.lib.utils.client.ClientUtils;
import com.stevekung.moreplanets.command.CommandOpenCelestialScreen;
import com.stevekung.moreplanets.core.capability.CapabilityHandlerMP;
import com.stevekung.moreplanets.core.config.ConfigManagerMP;
import com.stevekung.moreplanets.core.event.ClientEventHandler;
import com.stevekung.moreplanets.core.event.EntityEventHandler;
import com.stevekung.moreplanets.core.event.GeneralEventHandler;
import com.stevekung.moreplanets.core.event.WorldTickEventHandler;
import com.stevekung.moreplanets.core.handler.DataFixersMP;
import com.stevekung.moreplanets.core.handler.GuiHandlerMP;
import com.stevekung.moreplanets.core.handler.MissingMappingHandler;
import com.stevekung.moreplanets.init.MPBiomes;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPDimensions;
import com.stevekung.moreplanets.init.MPEntities;
import com.stevekung.moreplanets.init.MPItems;
import com.stevekung.moreplanets.init.MPOreDictionary;
import com.stevekung.moreplanets.init.MPOthers;
import com.stevekung.moreplanets.init.MPPlanets;
import com.stevekung.moreplanets.init.MPPotions;
import com.stevekung.moreplanets.init.MPSchematics;
import com.stevekung.moreplanets.init.MPSounds;
import com.stevekung.moreplanets.init.MPTileEntities;
import com.stevekung.moreplanets.network.PacketSimpleMP;
import com.stevekung.moreplanets.proxy.ServerProxyMP;
import com.stevekung.moreplanets.recipe.CraftingManagerMP;
import com.stevekung.moreplanets.recipe.SmeltingManagerMP;
import com.stevekung.moreplanets.utils.BlocksItemsRegistry;
import com.stevekung.moreplanets.utils.CompatibilityManagerMP;
import com.stevekung.moreplanets.utils.CreativeTabsMP;
import com.stevekung.moreplanets.utils.LoggerMP;
import com.stevekung.moreplanets.utils.PaintingMP;
import com.stevekung.moreplanets.utils.SchematicsRegistry;
import com.stevekung.moreplanets.utils.SurvivalPlanetUtils;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.advancements.FrameType;
import net.minecraft.command.ICommand;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;

@Mod(modid="moreplanets", name="MorePlanets", version="2.4.1", dependencies="required-after:stevekung_lib@[1.4.0,); required-after:galacticraftcore@[4.0.6,); required-after:galacticraftplanets@[4.0.6,); required-after:micdoodlecore; required-after:mixinbooter@[10.7,); after:forge@[14.23.5.2768,); after:jei@[4.15.0.268,); ", updateJSON="https://raw.githubusercontent.com/SteveKunG/VersionCheckLibrary/master/more_planets_version.json")
public class MorePlanetsMod {
    public static final String MOD_ID = "moreplanets";
    private static final String FORGE_VERSION = "after:forge@[14.23.5.2768,); ";
    private static final String DEPENDENCIES = "after:jei@[4.15.0.268,); ";
    protected static final String MAIN_DEPENDENCIES = "required-after:stevekung_lib@[1.4.0,); required-after:galacticraftcore@[4.0.6,); required-after:galacticraftplanets@[4.0.6,); required-after:micdoodlecore; required-after:mixinbooter@[10.7,); after:forge@[14.23.5.2768,); after:jei@[4.15.0.268,); ";
    public static final String URL = "https://www.curseforge.com/minecraft/mc-mods/more-planets-gc-addon";
    protected static final String JSON_URL = "https://raw.githubusercontent.com/SteveKunG/VersionCheckLibrary/master/more_planets_version.json";
    public static boolean isDevelopment;
    @SidedProxy(clientSide="com.stevekung.moreplanets.proxy.ClientProxyMP", serverSide="com.stevekung.moreplanets.proxy.ServerProxyMP")
    public static ServerProxyMP PROXY;
    @Mod.Instance(value="moreplanets")
    public static MorePlanetsMod INSTANCE;
    public static VersionChecker CHECKER;
    public static final CreativeTabsMP BLOCK_TAB;
    public static final CreativeTabsMP ITEM_TAB;
    public static ClientRegistryUtils CLIENT_REGISTRY;
    public static final CommonRegistryUtils COMMON_REGISTRY;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CompatibilityManagerMP.init();
        MorePlanetsMod.initModInfo(event.getModMetadata());
        CommonUtils.registerEventHandler((Object)this);
        CapabilityHandlerMP.register();
        MPBlocks.init();
        MPItems.init();
        MPEntities.init();
        MPPlanets.init();
        MPPotions.init();
        MPBiomes.init();
        MPOthers.init();
        MPPlanets.register();
        PROXY.preInit(event);
        CHECKER = new VersionChecker((Object)INSTANCE, "MorePlanets", URL);
        if (ConfigManagerMP.moreplanets_general.enableVersionChecker) {
            CHECKER.startCheck();
        }
        EnumHelper.addEnum(FrameType.class, (String)"TASK_PURPLE", (Class[])new Class[]{String.class, Integer.TYPE, TextFormatting.class}, (Object[])new Object[]{"task_purple", 0, TextFormatting.DARK_PURPLE});
        PaintingMP.RONG = EnumHelper.addArt((String)"RONG", (String)"rong", (int)32, (int)32, (int)0, (int)128);
        if (ClientUtils.isClient()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandOpenCelestialScreen());
        }
        CompatibilityManagerMP.registerAsmodeusCoreCompatibility();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MPTileEntities.init();
        MPOreDictionary.init();
        DataFixersMP.init();
        GalacticraftCore.packetPipeline.addDiscriminator(1999, PacketSimpleMP.class);
        BLOCK_TAB.setDisplayItemStack(new ItemStack(MPBlocks.CRASHED_ALIEN_PROBE));
        ITEM_TAB.setDisplayItemStack(new ItemStack(MPItems.SPACE_WARPER_CORE));
        PROXY.init(event);
        if (ClientUtils.isClient()) {
            BlocksItemsRegistry.postRegisteredSortBlock();
            BlocksItemsRegistry.postRegisteredSortItem();
            CommonUtils.registerEventHandler((Object)new ClientEventHandler());
        }
        CommonUtils.registerEventHandler((Object)new EntityEventHandler());
        CommonUtils.registerEventHandler((Object)new GeneralEventHandler());
        CommonUtils.registerEventHandler((Object)new WorldTickEventHandler());
        CommonUtils.registerEventHandler((Object)new MissingMappingHandler());
        SchematicsRegistry.registerSchematicDungeonLoot(4, new ItemStack(MPItems.BLACK_HOLE_STORAGE_SCHEMATIC));
        SchematicsRegistry.registerSchematicDungeonLoot(4, new ItemStack(MPItems.ION_CANNON_SCHEMATIC));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit(event);
        CommonUtils.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandlerMP());
        CraftingManagerMP.init();
        SmeltingManagerMP.init();
        MPSchematics.init();
        MPDimensions.init();
        MPBlocks.gatherAllInfectedBlocks();
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        if (SurvivalPlanetUtils.hasSurvivalPlanetDataForServer()) {
            WorldProvider provider = WorldUtil.getProviderForNameServer((String)SurvivalPlanetUtils.getFormattedDimensionName());
            LoggerMP.info(String.format("Server started with survival planet '%s' selected", WorldUtil.getDimensionName((WorldProvider)provider)));
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public void onBiomeRegister(RegistryEvent.Register<Biome> event) {
        MPBiomes.registerTypes();
    }

    @SubscribeEvent
    public void onSoundRegister(RegistryEvent.Register<SoundEvent> event) {
        LoggerMP.info("Initialize sounds from {}", MPSounds.class);
    }

    private static void initModInfo(ModMetadata info) {
        info.autogenerated = false;
        info.modId = MOD_ID;
        info.name = "MorePlanets";
        info.version = "2.4.1";
        info.description = "An add-on adds new exotic planets into Galacticraft!";
        info.url = URL;
        info.credits = "Thanks to Galacticraft Sources/API and contributors.";
        info.authorList = Lists.newArrayList((Object[])new String[]{"SteveKunG", "PloyiinGz"});
    }

    static {
        BLOCK_TAB = new CreativeTabsMP("more_planets_blocks");
        ITEM_TAB = new CreativeTabsMP("more_planets_items");
        COMMON_REGISTRY = new CommonRegistryUtils(MOD_ID);
        FluidRegistry.enableUniversalBucket();
        try {
            isDevelopment = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ClientUtils.isClient()) {
            CLIENT_REGISTRY = new ClientRegistryUtils(MOD_ID);
        }
    }
}

