/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.core.event;

import com.stevekung.lib.utils.event.WeatherTickEvent;
import com.stevekung.moreplanets.core.config.ConfigManagerMP;
import com.stevekung.moreplanets.core.data.WorldDataSurvivalPlanet;
import com.stevekung.moreplanets.init.MPBiomes;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.planets.diona.dimension.WorldProviderDiona;
import com.stevekung.moreplanets.planets.diona.entity.EntityAlienBeam;
import com.stevekung.moreplanets.planets.nibiru.dimension.WorldProviderNibiru;
import com.stevekung.moreplanets.planets.nibiru.entity.weather.EntityNibiruLightningBolt;
import com.stevekung.moreplanets.planets.nibiru.world.gen.biome.BiomeInfectedBadlands;
import com.stevekung.moreplanets.planets.nibiru.world.gen.biome.BiomeInfectedDesert;
import com.stevekung.moreplanets.planets.nibiru.world.gen.biome.BiomeInfectedMountains;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class WorldTickEventHandler {
    public static WorldDataSurvivalPlanet survivalPlanetData = null;

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.loadPlanetData();
    }

    @SubscribeEvent
    public void onClientConnectServer(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        this.loadPlanetData();
    }

    @SubscribeEvent
    public void onWeatherTick(WeatherTickEvent event) {
        WorldServer world = event.getWorldServer();
        int chunkX = event.getChunkX();
        int chunkZ = event.getChunkZ();
        if (DimensionManager.getWorld((int)ConfigManagerMP.moreplanets_dimension.idDimensionDiona) != null && world.field_73011_w instanceof WorldProviderDiona && world.field_73012_v.nextInt(75000) == 0) {
            world.field_73005_l = world.field_73005_l * 3 + 1013904223;
            int l = world.field_73005_l >> 2;
            BlockPos pos = world.func_175736_a(new BlockPos(chunkX + (l & 0xF), 0, chunkZ + (l >> 8 & 0xF)));
            if (world.func_175667_e(pos) && this.canBeamStrike((World)world, pos)) {
                EntityAlienBeam beam = new EntityAlienBeam((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                beam.spawnWeather();
            }
        }
        if (DimensionManager.getWorld((int)ConfigManagerMP.moreplanets_dimension.idDimensionNibiru) != null && world.field_73011_w instanceof WorldProviderNibiru) {
            BlockPos pos;
            boolean raining = world.func_72896_J();
            boolean thunder = world.func_72911_I();
            if (world.field_73011_w.canDoLightning(event.getChunk()) && raining && thunder && world.field_73012_v.nextInt(1000) == 0) {
                world.field_73005_l = world.field_73005_l * 3 + 1013904223;
                int l = world.field_73005_l >> 2;
                pos = world.func_175736_a(new BlockPos(chunkX + (l & 0xF), 0, chunkZ + (l >> 8 & 0xF)));
                if (world.func_175667_e(pos) && world.func_175727_C(pos)) {
                    EntityNibiruLightningBolt boltFire = new EntityNibiruLightningBolt((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), true);
                    boltFire.spawnWeather();
                }
            }
            if (world.field_73012_v.nextInt(16) == 0) {
                world.field_73005_l = world.field_73005_l * 3 + 1013904223;
                int j2 = world.field_73005_l >> 2;
                BlockPos blockpos1 = world.func_175725_q(new BlockPos(chunkX + (j2 & 0xF), 0, chunkZ + (j2 >> 8 & 0xF)));
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (world.func_175697_a(blockpos2, 1) && world.func_175662_w(blockpos2)) {
                    world.func_175656_a(blockpos2, MPBlocks.INFECTED_ICE.func_176223_P());
                }
                if (raining) {
                    if (world.func_175708_f(blockpos1, true)) {
                        Biome biome = world.func_180494_b(blockpos1);
                        world.func_175656_a(blockpos1, biome == MPBiomes.COLD_GREEN_VEIN_MOUTAINS ? MPBlocks.PURIFIED_SNOW_LAYER.func_176223_P() : MPBlocks.INFECTED_SNOW_LAYER.func_176223_P());
                    }
                    if (world.func_180494_b(blockpos2).func_76738_d()) {
                        world.func_180495_p(blockpos2).func_177230_c().func_176224_k((World)world, blockpos2);
                    }
                }
            }
            if (world.field_73012_v.nextInt(250000) == 0) {
                world.field_73005_l = world.field_73005_l * 3 + 1013904223;
                int l = world.field_73005_l >> 2;
                pos = world.func_175736_a(new BlockPos(chunkX + (l & 0xF), 0, chunkZ + (l >> 8 & 0xF)));
                Biome biome = world.func_180494_b(pos);
                if (biome instanceof BiomeInfectedDesert || biome instanceof BiomeInfectedMountains || biome instanceof BiomeInfectedBadlands) {
                    EntityNibiruLightningBolt bolt = new EntityNibiruLightningBolt((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), false);
                    bolt.spawnWeather();
                }
            }
        }
    }

    private boolean canBeamStrike(World world, BlockPos strikePosition) {
        if (!world.func_175678_i(strikePosition)) {
            return false;
        }
        if (world.func_175725_q(strikePosition).func_177956_o() > strikePosition.func_177956_o()) {
            return false;
        }
        return this.getSunBrightness(world) < 0.1f;
    }

    private float getSunBrightness(World world) {
        float angle = world.func_72826_c(1.0f);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.1f);
        value = MathHelper.func_76131_a((float)value, (float)0.55f, (float)1.0f);
        value = 1.0f - value;
        return value * 0.9f;
    }

    private void loadPlanetData() {
        World world = WorldUtil.getWorldForDimensionServer((int)0);
        if (world == null) {
            return;
        }
        survivalPlanetData = (WorldDataSurvivalPlanet)world.func_72943_a(WorldDataSurvivalPlanet.class, "SurvivalPlanetData");
        if (survivalPlanetData == null) {
            survivalPlanetData = new WorldDataSurvivalPlanet("SurvivalPlanetData");
            world.func_72823_a("SurvivalPlanetData", (WorldSavedData)survivalPlanetData);
        }
    }
}

