/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.init;

import com.stevekung.moreplanets.core.config.ConfigManagerMP;
import com.stevekung.moreplanets.moons.koentus.dimension.WorldProviderKoentus;
import com.stevekung.moreplanets.planets.chalos.dimension.WorldProviderChalos;
import com.stevekung.moreplanets.planets.diona.dimension.WorldProviderDiona;
import com.stevekung.moreplanets.planets.fronos.dimension.WorldProviderFronos;
import com.stevekung.moreplanets.planets.nibiru.dimension.WorldProviderNibiru;
import com.stevekung.moreplanets.utils.CelestialRegistryUtils;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeMoon;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeOverworld;

public class MPPlanets {
    public static Planet DIONA;
    public static Planet CHALOS;
    public static Planet NIBIRU;
    public static Planet FRONOS;
    public static Moon KOENTUS;
    public static SolarSystem LAZENDUS_SOLAR_SYSTEM;
    public static Star LAZENDUS;

    public static void init() {
        LAZENDUS_SOLAR_SYSTEM = CelestialRegistryUtils.createSolarSystem("lazendus", new Vector3(0.75, 1.25, 0.0));
        LAZENDUS = CelestialRegistryUtils.createStar("lazendus", "lazendus_celestial", LAZENDUS_SOLAR_SYSTEM);
        LAZENDUS_SOLAR_SYSTEM.setMainStar(LAZENDUS);
        DIONA = CelestialRegistryUtils.createPlanet("diona", LAZENDUS_SOLAR_SYSTEM, -14.25f, 4.25f, 20.0f, 0.876f, ConfigManagerMP.moreplanets_planet_settings.planetDionaTier, ConfigManagerMP.moreplanets_dimension.idDimensionDiona, WorldProviderDiona.class);
        CHALOS = CelestialRegistryUtils.createPlanet("chalos", LAZENDUS_SOLAR_SYSTEM, 8.75f, 3.5f, 60.5f, 1.25f, ConfigManagerMP.moreplanets_planet_settings.planetChalosTier, ConfigManagerMP.moreplanets_dimension.idDimensionChalos, WorldProviderChalos.class);
        NIBIRU = CelestialRegistryUtils.createPlanet("nibiru", LAZENDUS_SOLAR_SYSTEM, 27.0f, 2.0f, 1050.5f, 1.2f, ConfigManagerMP.moreplanets_planet_settings.planetNibiruTier, ConfigManagerMP.moreplanets_dimension.idDimensionNibiru, WorldProviderNibiru.class);
        FRONOS = CelestialRegistryUtils.createPlanet("fronos", LAZENDUS_SOLAR_SYSTEM, 10.0f, 1.5f, 100.0f, 1.1f, ConfigManagerMP.moreplanets_planet_settings.planetFronosTier, ConfigManagerMP.moreplanets_dimension.idDimensionFronos, WorldProviderFronos.class);
        KOENTUS = CelestialRegistryUtils.createMoon("koentus", DIONA, 2.436f, 9.5f, 100.0f, 0.3867f, ConfigManagerMP.moreplanets_moon_settings.moonKoentusTier, ConfigManagerMP.moreplanets_dimension.idDimensionKoentus, WorldProviderKoentus.class);
        CelestialRegistryUtils.setAtmosphereComponentList((CelestialBody)DIONA, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.HELIUM);
        CelestialRegistryUtils.setAtmosphere((CelestialBody)DIONA, false, false, false, 0.0f, 0.0f, 0.0f);
        CelestialRegistryUtils.setChecklistKeys((CelestialBody)DIONA, "equip_oxygen_suit");
        CelestialRegistryUtils.setAtmosphereComponentList((CelestialBody)CHALOS, EnumAtmosphericGas.HYDROGEN, EnumAtmosphericGas.WATER, EnumAtmosphericGas.CO2);
        CelestialRegistryUtils.setAtmosphere((CelestialBody)CHALOS, false, false, false, 0.0f, 0.65f, 28.0f);
        CelestialRegistryUtils.setChecklistKeys((CelestialBody)CHALOS, "equip_oxygen_suit");
        CelestialRegistryUtils.setAtmosphereComponentList((CelestialBody)NIBIRU, EnumAtmosphericGas.WATER, EnumAtmosphericGas.HELIUM, EnumAtmosphericGas.CO2, EnumAtmosphericGas.ARGON);
        CelestialRegistryUtils.setAtmosphere((CelestialBody)NIBIRU, false, true, true, 0.0f, 1.25f, 46.5f);
        CelestialRegistryUtils.setChecklistKeys((CelestialBody)NIBIRU, "equip_oxygen_suit", "thermal_padding_t2", "equip_shield_controller", "craft_infected_spore_protection_capsule");
        CelestialRegistryUtils.setAtmosphereComponentList((CelestialBody)FRONOS, EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.WATER, EnumAtmosphericGas.CO2);
        CelestialRegistryUtils.setAtmosphere((CelestialBody)FRONOS, true, true, false, 0.0f, 1.0f, 2.0f);
        CelestialRegistryUtils.setAtmosphereComponentList((CelestialBody)KOENTUS, EnumAtmosphericGas.HYDROGEN, EnumAtmosphericGas.NITROGEN, EnumAtmosphericGas.HELIUM);
        CelestialRegistryUtils.setAtmosphere((CelestialBody)KOENTUS, false, false, false, -2.0f, 2.0f, 5.0f);
    }

    public static void register() {
        TeleportTypeMoon teleport = new TeleportTypeMoon();
        CelestialRegistryUtils.register(LAZENDUS_SOLAR_SYSTEM);
        CelestialRegistryUtils.register(DIONA);
        CelestialRegistryUtils.register(CHALOS);
        CelestialRegistryUtils.register(NIBIRU);
        CelestialRegistryUtils.register(FRONOS);
        CelestialRegistryUtils.register(KOENTUS);
        CelestialRegistryUtils.registerTeleportType(WorldProviderDiona.class, (ITeleportType)teleport);
        CelestialRegistryUtils.registerTeleportType(WorldProviderChalos.class, (ITeleportType)teleport);
        CelestialRegistryUtils.registerTeleportType(WorldProviderNibiru.class, (ITeleportType)teleport);
        CelestialRegistryUtils.registerTeleportType(WorldProviderKoentus.class, (ITeleportType)teleport);
        CelestialRegistryUtils.registerTeleportType(WorldProviderFronos.class, (ITeleportType)new TeleportTypeOverworld());
        CelestialRegistryUtils.registerRocketGui(WorldProviderDiona.class, "diona");
        CelestialRegistryUtils.registerRocketGui(WorldProviderChalos.class, "chalos");
        CelestialRegistryUtils.registerRocketGui(WorldProviderNibiru.class, "nibiru");
        CelestialRegistryUtils.registerRocketGui(WorldProviderFronos.class, "fronos");
        CelestialRegistryUtils.registerRocketGui(WorldProviderKoentus.class, "koentus");
    }
}

