/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.items;

import com.stevekung.moreplanets.entity.projectile.EntityLaserBullet;
import com.stevekung.moreplanets.init.MPItems;
import com.stevekung.moreplanets.init.MPSounds;
import com.stevekung.moreplanets.utils.BlocksItemsRegistry;
import com.stevekung.moreplanets.utils.items.ItemBaseMP;
import com.stevekung.moreplanets.utils.items.MPItemCategory;
import com.stevekung.moreplanets.utils.items.MorePlanetsItem;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLaserGun
extends ItemBaseMP
implements MorePlanetsItem,
IItemElectric {
    private final float transferMax = 200.0f;
    private static final int DAMAGE_RANGE = 100;

    public ItemLaserGun(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("pull"), (itemStack, world, living) -> {
            if (living != null) {
                ItemStack gun = living.func_184607_cu();
                if (living instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)living;
                    if (!gun.func_190926_b() && gun.func_77973_b() == MPItems.LASER_GUN) {
                        int i = itemStack.func_77988_m() - player.func_184605_cv();
                        if (i > 12) {
                            return 0.9f;
                        }
                        if (i > 0) {
                            return 0.65f;
                        }
                    }
                }
            }
            return 0.0f;
        });
        this.func_185043_a(new ResourceLocation("pulling"), (itemStack, world, living) -> living != null && living.func_184587_cr() && living.func_184607_cu() == itemStack ? 1.0f : 0.0f);
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 16;
    }

    public void func_150895_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        if (BlocksItemsRegistry.isItemTab(creativeTabs)) {
            list.add((Object)ElectricItemHelper.getUncharged((ItemStack)new ItemStack((Item)this)));
            list.add((Object)ElectricItemHelper.getWithCharge((ItemStack)new ItemStack((Item)this), (float)this.getMaxElectricityStored(new ItemStack((Item)this))));
        }
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityLivingBase living) {
        if (living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            boolean flag = player.field_71075_bZ.field_75098_d;
            ItemStack bulletStack = this.findBullet(player);
            if (this.getElectricityStored(itemStack) > 0.0f && (flag || !bulletStack.func_190926_b())) {
                EntityLaserBullet laser = new EntityLaserBullet(world, (EntityLivingBase)player, 1.0f);
                world.func_184133_a(player, player.func_180425_c(), MPSounds.LASER_SHOOTED, SoundCategory.PLAYERS, 1.0f, 1.75f);
                int slot = -1;
                if (bulletStack.func_190926_b()) {
                    bulletStack = new ItemStack(MPItems.LASER_BULLET);
                }
                for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    if (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b() || ((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77973_b() != bulletStack.func_77973_b()) continue;
                    if (bulletStack.func_77973_b() == MPItems.LASER_BULLET) {
                        laser.setLaserType(EntityLaserBullet.LaserType.NORMAL);
                    }
                    if (bulletStack.func_77973_b() == MPItems.INFECTED_PURLONITE_LASER_BULLET) {
                        laser.setLaserType(EntityLaserBullet.LaserType.INFECTED_PURLONITE);
                    }
                    slot = i;
                    break;
                }
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)laser);
                }
                if (!flag && slot >= 0) {
                    this.setElectricity(itemStack, this.getElectricityStored(itemStack) - 50.0f);
                    player.field_71071_by.func_70298_a(slot, 1);
                }
            }
        }
        return itemStack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        boolean flag = !this.findBullet(player).func_190926_b();
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.getElectricityStored(itemStack) > 0.0f) {
            if (!player.field_71075_bZ.field_75098_d && !flag) {
                return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
            }
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    public float getMaxElectricityStored(ItemStack itemStack) {
        return 100000.0f;
    }

    public float recharge(ItemStack itemStack, float energy, boolean doRecharge) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.transferMax) {
            energyToReceive = this.transferMax;
        }
        if (doRecharge) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    public float discharge(ItemStack itemStack, float energy, boolean doDischarge) {
        float thisEnergy = this.getElectricityStored(itemStack);
        float energyToTransfer = Math.min(Math.min(thisEnergy, energy), this.transferMax);
        if (doDischarge) {
            this.setElectricity(itemStack, thisEnergy - energyToTransfer);
        }
        return energyToTransfer;
    }

    public float getElectricityStored(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase base = itemStack.func_77978_p().func_74781_a("electricity");
            if (base instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)base).func_150288_h();
            } else if (base instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)base).func_150288_h();
            }
        } else {
            if (itemStack.func_77952_i() == 100) {
                return 0.0f;
            }
            energyStored = this.getMaxElectricityStored(itemStack) * (float)(100 - itemStack.func_77952_i()) / 100.0f;
            itemStack.func_77978_p().func_74776_a("electricity", energyStored);
        }
        itemStack.func_77964_b(100 - (int)(energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    public void setElectricity(ItemStack itemStack, float joules) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        if (joules > 0.0f || itemStack.func_77978_p().func_74764_b("electricity")) {
            itemStack.func_77978_p().func_74776_a("electricity", electricityStored);
        }
        itemStack.func_77964_b(100 - (int)(electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    public float getTransfer(ItemStack itemStack) {
        return Math.min(this.transferMax, this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    @Override
    public MPItemCategory getItemCategory() {
        return MPItemCategory.OTHER_TOOL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        TextFormatting color = TextFormatting.GOLD;
        float joules = this.getElectricityStored(itemStack);
        if (joules <= this.getMaxElectricityStored(itemStack) / 3.0f) {
            color = TextFormatting.DARK_RED;
        } else if (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f) {
            color = TextFormatting.DARK_GREEN;
        }
        tooltip.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(itemStack)));
    }

    private ItemStack findBullet(EntityPlayer player) {
        if (this.isBullet(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isBullet(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemStack = player.field_71071_by.func_70301_a(i);
            if (!this.isBullet(itemStack)) continue;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    private boolean isBullet(ItemStack itemStack) {
        return !itemStack.func_190926_b() && (itemStack.func_77973_b() == MPItems.LASER_BULLET || itemStack.func_77973_b() == MPItems.INFECTED_PURLONITE_LASER_BULLET);
    }
}

