/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.moons.koentus.dimension;

import com.stevekung.moreplanets.core.config.ConfigManagerMP;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPDimensions;
import com.stevekung.moreplanets.init.MPPlanets;
import com.stevekung.moreplanets.moons.koentus.client.sky.SkyProviderKoentus;
import com.stevekung.moreplanets.moons.koentus.world.gen.BiomeProviderKoentus;
import com.stevekung.moreplanets.moons.koentus.world.gen.ChunkGeneratorKoentus;
import com.stevekung.moreplanets.utils.dimension.WorldProviderMP;
import com.stevekung.moreplanets.world.IMeteorType;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderKoentus
extends WorldProviderMP
implements IExitHeight {
    public Vector3 getFogColor() {
        float f = 1.2f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.09019608f * f), (double)(0.19215687f * f), (double)(0.35686275f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.3f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.13725491f * f), (double)(0.2901961f * f), (double)(0.47058824f * f));
    }

    public long getDayLength() {
        return 12000L;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        return value * value * 0.75f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        value = MathHelper.func_76131_a((float)value, (float)0.3f, (float)1.0f);
        value = 1.0f - value;
        return value * 0.8f;
    }

    public double getSolarEnergyMultiplier() {
        return 1.6;
    }

    public float getGravity() {
        return 0.07f;
    }

    public double getYCoordinateToTeleport() {
        return 512.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= ConfigManagerMP.moreplanets_moon_settings.moonKoentusTier;
    }

    public float getFallDamageModifier() {
        return 0.24f;
    }

    public CelestialBody getCelestialBody() {
        return MPPlanets.KOENTUS;
    }

    public float getThermalLevelModifier() {
        if (this.isDaytime()) {
            return 1.0f;
        }
        return -2.5f;
    }

    @Override
    public int getDarkEnergyMultiplier(World world, BlockPos pos) {
        return 100;
    }

    public List<Block> getSurfaceBlocks() {
        return Collections.singletonList(MPBlocks.KOENTUS_REGOLITH);
    }

    @Override
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderKoentus(this.getSolarSize()));
    }

    @Override
    protected void func_76572_b() {
        super.func_76572_b();
        this.field_76578_c = new BiomeProviderKoentus();
    }

    @Override
    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorKoentus(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public DimensionType func_186058_p() {
        return MPDimensions.KOENTUS;
    }

    @Override
    public IMeteorType.EnumMeteorType getMeteorType() {
        return IMeteorType.EnumMeteorType.KOENTUS;
    }

    @Override
    public double getMeteorSpawnFrequency() {
        return 2.5;
    }
}

