/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.moons.koentus.entity;

import com.stevekung.moreplanets.init.MPBlocks;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityKoentusMeteor
extends Entity {
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityKoentusMeteor.class, (DataSerializer)DataSerializers.field_187192_b);
    private int size = 1;

    public EntityKoentusMeteor(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityKoentusMeteor(World world, double x, double y, double z, double motX, double motY, double motZ, int size) {
        this(world);
        this.size = size;
        this.func_70105_a(1.0f, 1.0f);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(x, y, z);
        this.field_70159_w = motX;
        this.field_70181_x = motY;
        this.field_70179_y = motZ;
        this.setSize(size);
    }

    public void func_70071_h_() {
        this.func_70101_b(this.field_70177_z + 2.0f, this.field_70125_A + 2.0f);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.04f;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        }
        Vec3d vec1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult ray = this.field_70170_p.func_147447_a(vec1, vec2, true, true, false);
        vec1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (ray != null) {
            vec2 = new Vec3d(ray.field_72307_f.field_72450_a, ray.field_72307_f.field_72448_b, ray.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List entityList = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(2.0));
        double distance = 0.0;
        for (Entity entity2 : entityList) {
            double maxDistance;
            AxisAlignedBB aabb;
            RayTraceResult result2;
            if (!entity2.func_70067_L() || (result2 = (aabb = entity2.func_174813_aQ().func_186662_g(0.01)).func_72327_a(vec1, vec2)) == null || !((maxDistance = vec1.func_72438_d(result2.field_72307_f)) < distance) && distance != 0.0) continue;
            entity = entity2;
            distance = maxDistance;
        }
        if (entity != null) {
            ray = new RayTraceResult(entity);
        }
        if (ray != null) {
            this.onImpact(ray);
        }
        if (this.field_70163_u <= -20.0 || this.field_70163_u >= 400.0) {
            this.func_70106_y();
        }
    }

    public boolean func_174816_a(Explosion explosion, World world, BlockPos pos, IBlockState state, float range) {
        return ConfigManagerCore.meteorBlockDamageEnabled;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SIZE, (Object)this.size);
        this.field_70145_X = true;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setSize(nbt.func_74762_e("Size"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("Size", this.size);
    }

    public int getSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    private void setSize(int size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)size);
    }

    private void onImpact(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            BlockPos pos;
            BlockPos above;
            if (result != null && this.field_70170_p.func_180495_p(above = (pos = result.func_178782_a()).func_177984_a()).func_177230_c() instanceof BlockAir) {
                this.field_70170_p.func_180501_a(above, MPBlocks.FALLEN_KOENTUS_METEOR.func_176223_P(), 3);
            }
            this.field_70170_p.func_175718_b(2001, this.func_180425_c(), Block.func_176210_f((IBlockState)MPBlocks.FALLEN_KOENTUS_METEOR.func_176223_P()));
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.size / 3.0f + 2.0f, false, true);
        }
        this.func_70106_y();
    }

    private void spawnParticles() {
        GalacticraftCore.proxy.spawnParticle("distanceSmoke", new Vector3(this.field_70165_t, this.field_70163_u + 1.0 + Math.random(), this.field_70161_v), new Vector3(0.0, 0.0, 0.0), new Object[0]);
        GalacticraftCore.proxy.spawnParticle("distanceSmoke", new Vector3(this.field_70165_t + Math.random() / 2.0, this.field_70163_u + 1.0 + Math.random() / 2.0, this.field_70161_v), new Vector3(0.0, 0.0, 0.0), new Object[0]);
        GalacticraftCore.proxy.spawnParticle("distanceSmoke", new Vector3(this.field_70165_t, this.field_70163_u + 1.0 + Math.random(), this.field_70161_v + Math.random()), new Vector3(0.0, 0.0, 0.0), new Object[0]);
        GalacticraftCore.proxy.spawnParticle("distanceSmoke", new Vector3(this.field_70165_t - Math.random() / 2.0, this.field_70163_u + 1.0 + Math.random() / 2.0, this.field_70161_v), new Vector3(0.0, 0.0, 0.0), new Object[0]);
        GalacticraftCore.proxy.spawnParticle("distanceSmoke", new Vector3(this.field_70165_t, this.field_70163_u + 1.0 + Math.random(), this.field_70161_v - Math.random()), new Vector3(0.0, 0.0, 0.0), new Object[0]);
    }
}

