/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.chalos.dimension;

import com.stevekung.moreplanets.core.config.ConfigManagerMP;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPDimensions;
import com.stevekung.moreplanets.init.MPPlanets;
import com.stevekung.moreplanets.planets.chalos.client.sky.SkyProviderChalos;
import com.stevekung.moreplanets.planets.chalos.world.gen.BiomeProviderChalos;
import com.stevekung.moreplanets.planets.chalos.world.gen.ChunkGeneratorChalos;
import com.stevekung.moreplanets.utils.dimension.WorldProviderMP;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderChalos
extends WorldProviderMP {
    public Vector3 getFogColor() {
        float f = 0.65f - this.getStarBrightness(1.0f);
        return new Vector3((double)f, (double)(0.75686276f * f), (double)(0.023529412f * f));
    }

    public Vector3 getSkyColor() {
        float f = 0.6f - this.getStarBrightness(1.0f);
        return new Vector3((double)f, (double)(0.8745098f * f), (double)(0.5019608f * f));
    }

    @Override
    public boolean hasSunset() {
        return true;
    }

    public long getDayLength() {
        return 48000L;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        return value * value * 0.4f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        value = 1.0f - value;
        return value;
    }

    public double getSolarEnergyMultiplier() {
        return 1.5;
    }

    public float getGravity() {
        return 0.027f;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= ConfigManagerMP.moreplanets_planet_settings.planetChalosTier;
    }

    public float getFallDamageModifier() {
        return 0.75f;
    }

    public CelestialBody getCelestialBody() {
        return MPPlanets.CHALOS;
    }

    public float getThermalLevelModifier() {
        float angle = this.field_76579_a.func_72826_c((float)this.getDayLength());
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        value = 1.0f - value;
        return value;
    }

    public float getArrowGravity() {
        return 0.035f;
    }

    @Override
    public int getDarkEnergyMultiplier(World world, BlockPos pos) {
        return 50 + pos.func_177956_o();
    }

    @Override
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderChalos(this.getSolarSize()));
    }

    @Override
    public void func_76572_b() {
        super.func_76572_b();
        this.field_76578_c = new BiomeProviderChalos(this.field_76579_a.func_72905_C());
    }

    @Override
    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorChalos(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public DimensionType func_186058_p() {
        return MPDimensions.CHALOS;
    }

    public List<Block> getSurfaceBlocks() {
        return Arrays.asList(MPBlocks.CHEESE_GRASS_BLOCK, MPBlocks.CHEESE_DIRT, MPBlocks.CHEESE_COARSE_DIRT, MPBlocks.CHALOS_ROCK);
    }
}

