/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.chalos.world.gen;

import com.google.common.collect.Sets;
import com.stevekung.lib.world.gen.MapGenCavesBase;
import com.stevekung.lib.world.gen.MapGenRavineBase;
import com.stevekung.lib.world.gen.WorldGenLiquidLake;
import com.stevekung.moreplanets.init.MPBiomes;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.planets.chalos.world.gen.BiomeDecoratorChalosOre;
import com.stevekung.moreplanets.planets.chalos.world.gen.MapGenCheeseSporeHutFeature;
import com.stevekung.moreplanets.planets.chalos.world.gen.dungeon.MapGenChalosDungeon;
import com.stevekung.moreplanets.planets.chalos.world.gen.dungeon.RoomBossChalos;
import com.stevekung.moreplanets.planets.chalos.world.gen.dungeon.RoomSpawnerChalos;
import com.stevekung.moreplanets.planets.chalos.world.gen.dungeon.RoomTreasureChalos;
import com.stevekung.moreplanets.utils.world.gen.ChunkGeneratorBaseMP;
import com.stevekung.moreplanets.utils.world.gen.dungeon.DungeonConfigurationMP;
import com.stevekung.moreplanets.utils.world.gen.dungeon.RoomChestMP;
import com.stevekung.moreplanets.utils.world.gen.feature.WorldGenSpaceDungeons;
import java.util.Set;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;

public class ChunkGeneratorChalos
extends ChunkGeneratorBaseMP {
    private final MapGenCavesBase caveGenerator = new MapGenCavesBase(MPBlocks.CHEESE_GRASS_BLOCK.func_176223_P(), Blocks.field_150353_l.func_176223_P(), (Set)Sets.newHashSet((Object[])new Block[]{MPBlocks.CHEESE_DIRT, MPBlocks.CHALOS_ROCK}));
    private final MapGenRavineBase ravineGenerator = new MapGenRavineBase(MPBlocks.CHEESE_GRASS_BLOCK.func_176223_P(), Blocks.field_150353_l.func_176223_P(), (Set)Sets.newHashSet((Object[])new Block[]{MPBlocks.CHEESE_DIRT, MPBlocks.CHALOS_ROCK}), (Set)Sets.newHashSet((Object[])new Block[]{MPBlocks.CHEESE_MILK_FLUID_BLOCK}));
    private final BiomeDecoratorChalosOre decorator = new BiomeDecoratorChalosOre();
    private final MapGenCheeseSporeHutFeature cheeseSporeHutFeatureGenerator = new MapGenCheeseSporeHutFeature();
    private final MapGenChalosDungeon dungeonGenerator = new MapGenChalosDungeon(new DungeonConfigurationMP(MPBlocks.CHALOS_DUNGEON_BRICK.func_176223_P(), MPBlocks.DUNGEON_GLOWSTONE.func_176223_P(), Blocks.field_150321_G.func_176223_P(), GCBlocks.unlitTorch.func_176223_P(), MPBlocks.CHALOS_ANCIENT_CHEST.func_176223_P(), 30, 8, 16, 7, 7, RoomBossChalos.class, RoomTreasureChalos.class, RoomSpawnerChalos.class, RoomChestMP.class));

    public ChunkGeneratorChalos(World world, long seed) {
        super(world, seed);
        this.isSingleBiomePlanet = false;
    }

    @Override
    protected void preGenerateChunk(ChunkPrimer primer, int chunkX, int chunkZ) {
    }

    @Override
    protected void generateChunk(ChunkPrimer primer, int chunkX, int chunkZ) {
        this.caveGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.ravineGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.cheeseSporeHutFeatureGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
    }

    @Override
    protected void populate(BlockPos pos, ChunkPos chunkpos, Biome biome, int chunkX, int chunkZ, int x, int z) {
        biome.func_180624_a(this.world, this.rand, pos);
        this.decorator.func_180292_a(this.world, this.rand, biome, pos);
        int pocketX = chunkX << 4;
        int pocketZ = chunkZ << 4;
        ChunkGeneratorBaseMP.generatePocket(this.world, this.rand, pocketX + 15, pocketZ + 15, MPBlocks.GASEOUS_CHEESE_MILK_BLOCK.func_176223_P(), Sets.newHashSet((Object[])new Biome[]{MPBiomes.SLIMELY_STREAM}), 16 + this.rand.nextInt(16), 3 + this.rand.nextInt(2));
        this.dungeonGenerator.func_175794_a(this.world, this.rand, new ChunkPos(chunkX, chunkZ));
        this.cheeseSporeHutFeatureGenerator.func_175794_a(this.world, this.rand, new ChunkPos(chunkX, chunkZ));
        for (int i = 0; i < 8; ++i) {
            new WorldGenSpaceDungeons(MPBlocks.CHALOS_ANCIENT_CHEST.func_176223_P(), MPBlocks.CHALOS_ROCK.func_176223_P(), MPBlocks.CHEESE_SLIME_BLOCK.func_176223_P()).func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
        }
        if (biome != MPBiomes.SLIMELY_STREAM && this.rand.nextInt(8) == 0) {
            new WorldGenLiquidLake(MPBlocks.CHEESE_MILK_FLUID_BLOCK.func_176223_P(), MPBlocks.CHALOS_ROCK.func_176223_P(), false).func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
        }
    }

    @Override
    protected IBlockState getTopBlock() {
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    protected IBlockState getSubBlock() {
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    protected IBlockState getStoneBlock() {
        return MPBlocks.CHALOS_ROCK.func_176223_P();
    }

    @Override
    protected IBlockState getLiquidBlock() {
        return MPBlocks.CHEESE_MILK_FLUID_BLOCK.func_176223_P();
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        this.dungeonGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
        this.cheeseSporeHutFeatureGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        return "CheeseSporeHut".equals(structureName) && this.cheeseSporeHutFeatureGenerator != null && this.cheeseSporeHutFeatureGenerator.func_175795_b(pos);
    }

    @Nullable
    public BlockPos func_180513_a(World world, String structureName, BlockPos position, boolean findUnexplored) {
        return "CheeseSporeHut".equals(structureName) && this.cheeseSporeHutFeatureGenerator != null ? this.cheeseSporeHutFeatureGenerator.func_180706_b(world, position, findUnexplored) : null;
    }
}

