/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.chalos.world.gen.structure;

import com.stevekung.lib.utils.BlockStateProperty;
import com.stevekung.lib.utils.enums.CachedEnum;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPLootTables;
import com.stevekung.moreplanets.utils.LoggerMP;
import com.stevekung.moreplanets.utils.tileentity.TileEntityChestMP;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public abstract class ComponentCheeseSporeHutPieces
extends StructureComponent {
    protected int width;
    protected int height;
    protected int depth;
    protected int horizontalPos = -1;

    public ComponentCheeseSporeHutPieces() {
    }

    protected ComponentCheeseSporeHutPieces(Random rand, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        super(0);
        this.width = sizeX;
        this.height = sizeY;
        this.depth = sizeZ;
        this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, y, z, x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1) : new StructureBoundingBox(x, y, z, x + sizeZ - 1, y + sizeY - 1, z + sizeX - 1);
    }

    protected void func_143012_a(NBTTagCompound nbt) {
        nbt.func_74768_a("Width", this.width);
        nbt.func_74768_a("Height", this.height);
        nbt.func_74768_a("Depth", this.depth);
        nbt.func_74768_a("HPos", this.horizontalPos);
    }

    protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
        this.width = nbt.func_74762_e("Width");
        this.height = nbt.func_74762_e("Height");
        this.depth = nbt.func_74762_e("Depth");
        this.horizontalPos = nbt.func_74762_e("HPos");
    }

    protected boolean offsetToAverageGroundLevel(World world, StructureBoundingBox bb, int yOffset) {
        if (this.horizontalPos >= 0) {
            return true;
        }
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
            for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                pos.func_181079_c(l, 64, k);
                if (!bb.func_175898_b((Vec3i)pos)) continue;
                i += Math.max(world.func_175672_r((BlockPos)pos).func_177956_o(), world.field_73011_w.func_76557_i());
                ++j;
            }
        }
        if (j == 0) {
            return false;
        }
        this.horizontalPos = i / j;
        this.field_74887_e.func_78886_a(0, this.horizontalPos - this.field_74887_e.field_78895_b + yOffset, 0);
        return true;
    }

    public static class CheeseSporeHut
    extends ComponentCheeseSporeHutPieces {
        private static final ResourceLocation CHEESE_SPORE_HUT_STEM = new ResourceLocation("moreplanets:cheese_spore_hut/cheese_spore_hut_stem");
        private static final ResourceLocation CHEESE_SPORE_HUT_TOP = new ResourceLocation("moreplanets:cheese_spore_hut/cheese_spore_hut_top");

        public CheeseSporeHut() {
        }

        public CheeseSporeHut(Random rand, int x, int z) {
            super(rand, x, 64, z, 8, 11, 8);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.offsetToAverageGroundLevel(world, box, -1)) {
                return false;
            }
            StructureBoundingBox box1 = this.func_74874_b();
            BlockPos pos = new BlockPos(box1.field_78897_a, box1.field_78895_b, box1.field_78896_c);
            Rotation[] arotation = CachedEnum.rotationValues;
            MinecraftServer server = world.func_73046_m();
            TemplateManager manager = world.func_72860_G().func_186340_h();
            PlacementSettings settings = new PlacementSettings().func_186220_a(arotation[rand.nextInt(arotation.length)]).func_186225_a(Blocks.field_189881_dj).func_186223_a(box1);
            Template template = manager.func_186237_a(server, CHEESE_SPORE_HUT_STEM);
            Template template1 = manager.func_186237_a(server, CHEESE_SPORE_HUT_TOP);
            BlockPos blockpos1 = pos.func_177971_a((Vec3i)template.func_186262_a(settings, new BlockPos(7, -4, 0), settings, new BlockPos(9, -9, 2)));
            template.func_186260_a(world, pos, settings);
            template1.func_186260_a(world, blockpos1, settings);
            LoggerMP.debug("Generate Cheese Spore Hut at {} {} {}", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            Map map = template1.func_186258_a(blockpos1, settings);
            for (Map.Entry entry : map.entrySet()) {
                TileEntity tileDown;
                BlockPos pos2;
                if ("hut_shulker".equals(entry.getValue()) || "hut_chest".equals(entry.getValue())) {
                    pos2 = (BlockPos)entry.getKey();
                    world.func_180501_a(pos2, Blocks.field_150350_a.func_176223_P(), 3);
                    tileDown = world.func_175625_s(pos2.func_177977_b());
                    if (tileDown instanceof TileEntityChestMP) {
                        ((TileEntityChestMP)tileDown).func_189404_a(MPLootTables.COMMON_SPACE_DUNGEON, rand.nextLong());
                    }
                    if (tileDown instanceof TileEntityShulkerBox) {
                        ((TileEntityShulkerBox)tileDown).func_189404_a(MPLootTables.COMMON_SPACE_DUNGEON, rand.nextLong());
                    }
                }
                if ("hut_brewing".equals(entry.getValue())) {
                    pos2 = (BlockPos)entry.getKey();
                    world.func_180501_a(pos2, Blocks.field_150350_a.func_176223_P(), 3);
                    tileDown = world.func_175625_s(pos2.func_177977_b());
                    if (tileDown instanceof TileEntityBrewingStand) {
                        ((TileEntityBrewingStand)tileDown).func_174885_b(1, rand.nextInt(20));
                    }
                }
                if (!"cheese_cake".equals(entry.getValue())) continue;
                pos2 = (BlockPos)entry.getKey();
                world.func_180501_a(pos2, MPBlocks.CHEESE_MILK_CAKE.func_176223_P().func_177226_a((IProperty)BlockStateProperty.BITES, (Comparable)Integer.valueOf(1 + rand.nextInt(4))), 3);
            }
            return true;
        }
    }
}

