/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.diona.blocks;

import com.stevekung.lib.utils.BlockStateProperty;
import com.stevekung.lib.utils.ColorUtils;
import com.stevekung.lib.utils.enums.CachedEnum;
import com.stevekung.moreplanets.init.MPItems;
import com.stevekung.moreplanets.init.MPPotions;
import com.stevekung.moreplanets.planets.diona.tileentity.TileEntityInfectedPurloniteCrystal;
import com.stevekung.moreplanets.utils.blocks.BlockDirectionalMP;
import com.stevekung.moreplanets.utils.blocks.MPBlockCategory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInfectedPurloniteCrystal
extends BlockDirectionalMP
implements ITileEntityProvider {
    private static final AxisAlignedBB NORTH = new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 1.0);
    private static final AxisAlignedBB EAST = new AxisAlignedBB(0.0, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);
    private static final AxisAlignedBB WEST = new AxisAlignedBB(0.0625, 0.0625, 0.0625, 1.0, 0.9375, 0.9375);
    private static final AxisAlignedBB SOUTH = new AxisAlignedBB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 0.9375);
    private static final AxisAlignedBB UP = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);
    private static final AxisAlignedBB DOWN = new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockInfectedPurloniteCrystal(String name) {
        super(name, Material.field_151592_s);
        this.func_149715_a(0.4f);
        this.func_149752_b(1.0f);
        this.func_149711_c(0.4f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockStateProperty.FACING_ALL, (Comparable)EnumFacing.UP));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockStateProperty.FACING_ALL);
        switch (facing) {
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
        }
        return NORTH;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack heldStack) {
        if (heldStack.func_190926_b() || !(player.func_184614_ca().func_77973_b() instanceof ItemPickaxe)) {
            player.func_70690_d(new PotionEffect(MPPotions.INFECTED_PURLONITE, 60));
        }
        if (!heldStack.func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemPickaxe) {
            super.func_180657_a(world, player, pos, state, tile, heldStack);
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.field_71075_bZ.field_75098_d) {
                EntityLivingBase living = (EntityLivingBase)entity;
                living.func_70690_d(new PotionEffect(MPPotions.INFECTED_PURLONITE, 60));
            }
        }
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(world, pos, state, chance, fortune);
        if (this.func_180660_a(state, world.field_73012_v, fortune) != Item.func_150898_a((Block)this)) {
            this.func_180637_b(world, pos, MathHelper.func_76136_a((Random)world.field_73012_v, (int)3, (int)5));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public int quantityDropped(IBlockState state, int fortune, Random rand) {
        if (fortune > 0 && Item.func_150898_a((Block)this) != this.func_180660_a(state, rand, fortune)) {
            int i = rand.nextInt(fortune + 1) - 1;
            if (i < 0) {
                i = 0;
            }
            return this.func_149745_a(rand) * (i + 1);
        }
        return this.func_149745_a(rand);
    }

    public int func_149745_a(Random rand) {
        return 1 + rand.nextInt(2);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return MPItems.INFECTED_PURLONITE_SHARD;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityInfectedPurloniteCrystal();
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing facing) {
        return this.canPlaceBlock(world, pos, facing.func_176734_d());
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing facing : CachedEnum.facingValues) {
            if (!this.canPlaceBlock(world, pos, facing)) continue;
            return true;
        }
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.canPlaceBlock(world, pos, facing.func_176734_d()) ? this.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_ALL, (Comparable)facing) : this.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_ALL, (Comparable)EnumFacing.DOWN);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (this.checkForDrop(world, pos) && !this.canPlaceBlock(world, pos, ((EnumFacing)state.func_177229_b((IProperty)BlockStateProperty.FACING_ALL)).func_176734_d())) {
            world.func_175655_b(pos, false);
            world.func_175698_g(pos);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public MPBlockCategory getBlockCategory() {
        return MPBlockCategory.DECORATION_NON_BLOCK;
    }

    @Override
    public ColorUtils.RGB getRarityColor() {
        return ColorUtils.stringToRGB((String)"178, 109, 237");
    }

    private boolean canPlaceBlock(World world, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing);
        return world.func_180495_p(blockpos).isSideSolid((IBlockAccess)world, blockpos, facing.func_176734_d());
    }

    private boolean checkForDrop(World world, BlockPos pos) {
        if (this.func_176196_c(world, pos)) {
            return true;
        }
        world.func_175655_b(pos, false);
        return false;
    }
}

