/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.diona.blocks;

import com.stevekung.lib.utils.ColorUtils;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPItems;
import com.stevekung.moreplanets.init.MPSounds;
import com.stevekung.moreplanets.planets.diona.tileentity.TileEntityInfectedPurloniteEnderCore;
import com.stevekung.moreplanets.utils.CompatibilityManagerMP;
import com.stevekung.moreplanets.utils.blocks.BlockBaseMP;
import com.stevekung.moreplanets.utils.blocks.MPBlockCategory;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInfectedPurloniteSegment
extends BlockBaseMP
implements ITileEntityProvider {
    private final BlockType type;

    public BlockInfectedPurloniteSegment(String name, BlockType type) {
        super(name, Material.field_151578_c);
        this.func_149711_c(0.5f);
        this.func_149752_b(50.0f);
        this.func_149672_a(MPSounds.ALIEN_EGG);
        this.setDefaultSlipperiness(0.8f);
        this.type = type;
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.func_70093_af()) {
            super.func_180658_a(world, pos, entity, fallDistance);
        } else {
            entity.func_180430_e(fallDistance, 0.0f);
        }
    }

    public void func_176216_a(World world, Entity entity) {
        if (entity.func_70093_af()) {
            super.func_176216_a(world, entity);
        } else if (entity.field_70181_x < 0.0) {
            entity.field_70181_x = -entity.field_70181_x;
            if (!(entity instanceof EntityLivingBase)) {
                entity.field_70181_x *= 0.8;
            }
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (Math.abs(entity.field_70181_x) < 0.1 && !entity.func_70093_af()) {
            double d0 = 0.4 + Math.abs(entity.field_70181_x) * 0.2;
            entity.field_70159_w *= d0;
            entity.field_70179_y *= d0;
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.type != BlockType.INFECTED_PURLONITE_SEGMENT ? Item.func_150898_a((Block)MPBlocks.INFECTED_PURLONITE_SEGMENT) : Item.func_150898_a((Block)this);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.type == BlockType.INFECTED_PURLONITE_SEGMENT && !heldItem.func_190926_b()) {
            if (heldItem.func_77973_b() == MPItems.INFECTED_PURLONITE_SLIMEBALL) {
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                world.func_175656_a(pos, MPBlocks.INFECTED_PURLONITE_EYE_CORE.func_176223_P());
                return true;
            }
            if (heldItem.func_77973_b() == Items.field_151061_bv) {
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                world.func_175656_a(pos, MPBlocks.INFECTED_PURLONITE_ENDER_CORE.func_176223_P());
                return true;
            }
        }
        return false;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return CompatibilityManagerMP.isCTMLoaded && this.type != BlockType.INFECTED_PURLONITE_SEGMENT ? layer == BlockRenderLayer.CUTOUT : layer == BlockRenderLayer.SOLID;
    }

    @Override
    public MPBlockCategory getBlockCategory() {
        return MPBlockCategory.DECORATION_NON_BLOCK;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.type == BlockType.INFECTED_PURLONITE_ENDER_CORE ? new TileEntityInfectedPurloniteEnderCore() : null;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.MIDDLE_POLE;
    }

    @Override
    public ColorUtils.RGB getRarityColor() {
        return ColorUtils.stringToRGB((String)"178, 109, 237");
    }

    public static enum BlockType {
        INFECTED_PURLONITE_SEGMENT,
        INFECTED_PURLONITE_EYE_CORE,
        INFECTED_PURLONITE_ENDER_CORE;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

