/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.diona.client.renderer.tileentity;

import com.stevekung.lib.client.event.ClientEventHandler;
import com.stevekung.lib.utils.ColorUtils;
import com.stevekung.moreplanets.planets.diona.tileentity.TileEntityInfectedPurloniteCrystal;
import com.stevekung.moreplanets.utils.client.model.ModelCrystal;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityInfectedPurloniteCrystalRenderer
extends TileEntitySpecialRenderer<TileEntityInfectedPurloniteCrystal> {
    private final ModelCrystal model = new ModelCrystal();
    private static final ResourceLocation TEXTURE = new ResourceLocation("moreplanets:textures/model/infected_purlonite_crystal.png");
    public static final TileEntityInfectedPurloniteCrystalRenderer INSTANCE = new TileEntityInfectedPurloniteCrystalRenderer();

    public void render(TileEntityInfectedPurloniteCrystal tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int meta = !tile.func_145830_o() ? 0 : tile.func_145832_p();
        Random rand = new Random((long)tile.func_174877_v().func_177958_n() + (long)tile.func_174877_v().func_177956_o() * (long)tile.func_174877_v().func_177952_p());
        for (int i = 0; i < 6; ++i) {
            int[] colorList = new int[]{ColorUtils.rgbToDecimal((int)148, (int)114, (int)214), ColorUtils.rgbToDecimal((int)106, (int)75, (int)165), ColorUtils.rgbToDecimal((int)120, (int)86, (int)188), ColorUtils.rgbToDecimal((int)111, (int)78, (int)172), ColorUtils.rgbToDecimal((int)112, (int)80, (int)174), ColorUtils.rgbToDecimal((int)82, (int)58, (int)128)};
            for (int spike = 0; spike < 6; ++spike) {
                int angle1 = rand.nextInt(32) + 72 * spike;
                int angle2 = 16 + rand.nextInt(16);
                this.drawCrystal(tile, (float)x, (float)y, (float)z, angle1, angle2, rand, colorList[i], 1.15f, meta);
            }
        }
    }

    private void drawCrystal(TileEntityInfectedPurloniteCrystal tile, float x, float y, float z, float angle1, float angle2, Random rand, int color, float size, int facing) {
        float shade = MathHelper.func_76126_a((float)((float)(tile.renderTicks + rand.nextInt(20)) / (16.0f + rand.nextFloat()))) * 0.075f + 0.925f;
        Color c = new Color(color);
        float r = (float)c.getRed() / 220.0f;
        float g = (float)c.getGreen() / 200.0f;
        float b = (float)c.getBlue() / 200.0f;
        int shadeLight = (int)(243.0f * shade);
        int lightX = shadeLight % 65536;
        int lightZ = shadeLight / 65536;
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179108_z();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)(z + 0.5f));
        this.translateFromDirection(facing);
        GlStateManager.func_179114_b((float)angle1, (float)0.1f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angle2, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)((0.15f + rand.nextFloat() * 0.075f) * size), (float)((0.5f + rand.nextFloat() * 0.1f) * size), (float)((0.15f + rand.nextFloat() * 0.05f) * size));
        if (tile.renderTicks > 0) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightX, (float)lightZ);
        }
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
        this.func_147499_a(TEXTURE);
        this.model.render();
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
    }

    private void translateFromDirection(int facing) {
        switch (EnumFacing.func_82600_a((int)facing)) {
            case WEST: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.7f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)-0.7f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179109_b((float)-0.7f, (float)0.575f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179109_b((float)0.7f, (float)0.5f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.3f, (float)0.0f);
                break;
            }
            default: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.3f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    public void render() {
        Random rand = new Random(8L);
        for (int i = 0; i < 6; ++i) {
            int[] colorList = new int[]{ColorUtils.rgbToDecimal((int)148, (int)114, (int)214), ColorUtils.rgbToDecimal((int)106, (int)75, (int)165), ColorUtils.rgbToDecimal((int)120, (int)86, (int)188), ColorUtils.rgbToDecimal((int)111, (int)78, (int)172), ColorUtils.rgbToDecimal((int)112, (int)80, (int)174), ColorUtils.rgbToDecimal((int)82, (int)58, (int)128)};
            for (int spike = 0; spike < 6; ++spike) {
                float shade = MathHelper.func_76126_a((float)((ClientEventHandler.renderPartialTicks + (float)rand.nextInt(1)) / (16.0f + rand.nextFloat()))) * 0.075f + 0.925f;
                int angle1 = rand.nextInt(32) + 72 * spike;
                int angle2 = 16 + rand.nextInt(16);
                float size = 1.15f;
                Color c = new Color(colorList[i]);
                float r = (float)c.getRed() / 220.0f;
                float g = (float)c.getGreen() / 200.0f;
                float b = (float)c.getBlue() / 200.0f;
                int shadeLight = (int)(243.0f * shade);
                int lightX = shadeLight % 65536;
                int lightZ = shadeLight / 65536;
                float lightMapSaveX = OpenGlHelper.lastBrightnessX;
                float lightMapSaveY = OpenGlHelper.lastBrightnessY;
                GlStateManager.func_179094_E();
                GlStateManager.func_179091_B();
                GlStateManager.func_179147_l();
                GlStateManager.func_179108_z();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179109_b((float)0.45f, (float)-0.3f, (float)0.5f);
                GlStateManager.func_179114_b((float)angle1, (float)0.1f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)angle2, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)((0.15f + rand.nextFloat() * 0.075f) * size), (float)((0.5f + rand.nextFloat() * 0.1f) * size), (float)((0.15f + rand.nextFloat() * 0.05f) * size));
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightX, (float)lightZ);
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
                this.model.render();
                GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                GlStateManager.func_179101_C();
                GlStateManager.func_179121_F();
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                GlStateManager.func_179145_e();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
                GlStateManager.func_179147_l();
            }
        }
    }
}

