/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.diona.dimension;

import com.stevekung.moreplanets.core.config.ConfigManagerMP;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPDimensions;
import com.stevekung.moreplanets.init.MPPlanets;
import com.stevekung.moreplanets.planets.diona.client.sky.SkyProviderDiona;
import com.stevekung.moreplanets.planets.diona.world.gen.BiomeProviderDiona;
import com.stevekung.moreplanets.planets.diona.world.gen.ChunkGeneratorDiona;
import com.stevekung.moreplanets.utils.dimension.WorldProviderMP;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderDiona
extends WorldProviderMP {
    public Vector3 getFogColor() {
        float f = 1.2f - this.getStarBrightness(1.0f);
        return new Vector3(0.09411764705882353 * (double)f, 0.09411764705882353 * (double)f, 0.09411764705882353 * (double)f);
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public long getDayLength() {
        return 96000L;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        return value * value * 0.5f + 0.3f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.1f);
        value = MathHelper.func_76131_a((float)value, (float)0.55f, (float)1.0f);
        value = 1.0f - value;
        return value * 0.9f;
    }

    public double getSolarEnergyMultiplier() {
        return 2.5;
    }

    public float getGravity() {
        return 0.065f;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= ConfigManagerMP.moreplanets_planet_settings.planetDionaTier;
    }

    public float getFallDamageModifier() {
        return 0.4f;
    }

    public CelestialBody getCelestialBody() {
        return MPPlanets.DIONA;
    }

    public float getThermalLevelModifier() {
        if (this.isDaytime()) {
            return -0.5f;
        }
        return -1.75f;
    }

    @Override
    public int getDarkEnergyMultiplier(World world, BlockPos pos) {
        if (this.isDaytime()) {
            return 120 + pos.func_177956_o() * 2;
        }
        return 150 + pos.func_177956_o() * 4;
    }

    @Override
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderDiona(this.getSolarSize()));
    }

    @Override
    public void func_76572_b() {
        super.func_76572_b();
        this.field_76578_c = new BiomeProviderDiona();
    }

    @Override
    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorDiona(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public DimensionType func_186058_p() {
        return MPDimensions.DIONA;
    }

    public List<Block> getSurfaceBlocks() {
        return Arrays.asList(MPBlocks.DIONA_SURFACE_ROCK, MPBlocks.DIONA_SUB_SURFACE_ROCK);
    }
}

