/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.diona.entity;

import com.google.common.base.Predicate;
import com.stevekung.moreplanets.core.MorePlanetsMod;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPLootTables;
import com.stevekung.moreplanets.init.MPPotions;
import com.stevekung.moreplanets.init.MPSounds;
import com.stevekung.moreplanets.utils.EnumParticleTypesMP;
import com.stevekung.moreplanets.utils.entity.ISpaceMob;
import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAlienMiner
extends EntityMob
implements IEntityBreathable,
ISpaceMob {
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityAlienMiner.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HOVER = EntityDataManager.func_187226_a(EntityAlienMiner.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityLivingBase targetedEntity;
    private int chargedTime;

    public EntityAlienMiner(World world) {
        super(world);
        this.func_70105_a(0.5f, 1.65f);
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AILaserBeamAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityGuardian.class, 12.0f, 0.01f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new AISplashBlood(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new AlienMinerTargetSelector(this)));
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals(key)) {
            this.chargedTime = 0;
            this.targetedEntity = null;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
        this.field_70180_af.func_187214_a(HOVER, (Object)true);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() + 2.5f;
    }

    protected SoundEvent func_184639_G() {
        return MPSounds.ALIEN_MINER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MPSounds.ALIEN_MINER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MPSounds.ALIEN_MINER_DEATH;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.field_70170_p.field_72995_K && this.hasTargetedEntity()) {
            if (this.chargedTime < 80) {
                ++this.chargedTime;
            }
            MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.ALIEN_MINER_SPARK, this.field_70165_t, this.field_70163_u + 0.85 + (double)this.getHoverTick(FMLClientHandler.instance().getClient().func_184121_ak()), this.field_70161_v, new Object[]{Float.valueOf(-this.getChargedTime(0.0f))});
            EntityLivingBase entity = this.getTargetedEntity();
            if (entity != null) {
                this.func_70671_ap().func_75651_a((Entity)entity, 90.0f, 90.0f);
                this.func_70671_ap().func_75649_a();
            }
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        if (this.hasTargetedEntity()) {
            this.field_70181_x += (0.1 - this.field_70181_x) * 0.1;
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    public boolean func_70687_e(PotionEffect effect) {
        Potion potion = effect.func_188419_a();
        return potion != MobEffects.field_76436_u && potion != MobEffects.field_76433_i && potion != MobEffects.field_82731_v && potion != MPPotions.INFECTED_PURLONITE && potion != MPPotions.INFECTED_SPORE;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Nullable
    public ResourceLocation func_184647_J() {
        return MPLootTables.ALIEN_MINER;
    }

    public boolean canBreath() {
        return true;
    }

    protected boolean func_70814_o() {
        return true;
    }

    @Override
    public ISpaceMob.EnumMobType getMobType() {
        return ISpaceMob.EnumMobType.ROBOT;
    }

    public float func_70047_e() {
        return 1.3f;
    }

    public float getChargedTime(float time) {
        return ((float)this.chargedTime + time) / 80.0f;
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    public void setHovered(boolean hover) {
        this.field_70180_af.func_187227_b(HOVER, (Object)hover);
    }

    public EntityLivingBase getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    @SideOnly(value=Side.CLIENT)
    public float getHoverTick(float partialTicks) {
        if (!this.getHovered()) {
            return 0.0f;
        }
        float partialTicksTime = (float)this.field_70173_aa + partialTicks;
        float hoverTime = MathHelper.func_76126_a((float)(partialTicksTime / 12.0f)) / 30.0f + 0.5f;
        return hoverTime * hoverTime + hoverTime;
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    private boolean getHovered() {
        return (Boolean)this.field_70180_af.func_187225_a(HOVER);
    }

    static class AlienMinerTargetSelector
    implements Predicate<EntityLivingBase> {
        private final EntityAlienMiner entity;

        public AlienMinerTargetSelector(EntityAlienMiner entity) {
            this.entity = entity;
        }

        public boolean apply(EntityLivingBase entity) {
            return !(entity instanceof EntityAlienMiner) && entity.func_70068_e((Entity)this.entity) > 5.0;
        }
    }

    static class AISplashBlood
    extends EntityAIWander {
        private boolean findStone;

        public AISplashBlood(EntityAlienMiner entity) {
            super((EntityCreature)entity, 1.0, 10);
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            BlockPos pos;
            if (this.field_75457_a.func_70638_az() != null) {
                return false;
            }
            if (!this.field_75457_a.func_70661_as().func_75500_f()) {
                return false;
            }
            Random rand = this.field_75457_a.func_70681_au();
            if (rand.nextInt(500) == 0 && this.field_75457_a.field_70170_p.func_180495_p((pos = new BlockPos(this.field_75457_a.field_70165_t, this.field_75457_a.field_70163_u, this.field_75457_a.field_70161_v)).func_177977_b()).func_177230_c() == MPBlocks.DIONA_SURFACE_ROCK) {
                this.findStone = true;
                return true;
            }
            this.findStone = false;
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.findStone && super.func_75253_b();
        }

        public void func_75249_e() {
            if (!this.findStone) {
                super.func_75249_e();
            } else {
                World world = this.field_75457_a.field_70170_p;
                BlockPos pos = new BlockPos(this.field_75457_a.field_70165_t, this.field_75457_a.field_70163_u, this.field_75457_a.field_70161_v);
                if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == MPBlocks.DIONA_SURFACE_ROCK) {
                    world.func_180501_a(pos.func_177977_b(), MPBlocks.ALIEN_MINER_BLOOD.func_176223_P(), 3);
                }
            }
        }
    }

    static class AILaserBeamAttack
    extends EntityAIBase {
        private final EntityAlienMiner entity;
        private int tickCounter;

        public AILaserBeamAttack(EntityAlienMiner entity) {
            this.entity = entity;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entity = this.entity.func_70638_az();
            return entity != null && entity.func_70089_S();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.entity.func_70068_e((Entity)this.entity.func_70638_az()) > 5.0;
        }

        public void func_75249_e() {
            this.tickCounter = -10;
            this.entity.func_70661_as().func_75499_g();
            this.entity.func_70671_ap().func_75651_a((Entity)this.entity.func_70638_az(), 90.0f, 90.0f);
            this.entity.field_70160_al = true;
        }

        public void func_75251_c() {
            this.entity.setTargetedEntity(0);
            this.entity.func_70624_b(null);
        }

        public void func_75246_d() {
            EntityLivingBase entity = this.entity.func_70638_az();
            this.entity.func_70661_as().func_75499_g();
            this.entity.func_70671_ap().func_75651_a((Entity)entity, 90.0f, 90.0f);
            if (!this.entity.func_70685_l((Entity)entity)) {
                this.entity.func_70624_b(null);
            } else {
                ++this.tickCounter;
                if (this.tickCounter == 0) {
                    this.entity.setTargetedEntity(this.entity.func_70638_az().func_145782_y());
                    this.entity.func_184185_a(MPSounds.ALIEN_MINER_CHARGED, 2.0f + this.entity.getChargedTime(0.0f), 0.8f);
                } else if (this.tickCounter >= 80) {
                    float f = 1.0f;
                    if (this.entity.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        f += 2.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76354_b((Entity)this.entity, (Entity)this.entity), f);
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.entity), (float)this.entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    this.entity.func_184185_a(MPSounds.ALIEN_MINER_ATTACK, 1.0f + this.entity.getChargedTime(0.0f), 0.8f);
                    entity.func_184185_a(MPSounds.ALIEN_MINER_SHOCK, 1.0f + this.entity.getChargedTime(0.0f), 1.0f);
                    this.entity.func_70624_b(null);
                    if (entity instanceof EntityPlayer) {
                        MorePlanetsMod.PROXY.resetFloatingTick((EntityPlayer)entity);
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

