/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.diona.world.gen;

import com.google.common.collect.Sets;
import com.stevekung.lib.world.gen.MapGenCavesBase;
import com.stevekung.lib.world.gen.WorldGenLiquidLake;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.planets.diona.world.gen.BiomeDecoratorDiona;
import com.stevekung.moreplanets.planets.diona.world.gen.dungeon.MapGenDionaDungeon;
import com.stevekung.moreplanets.planets.diona.world.gen.dungeon.RoomBossDiona;
import com.stevekung.moreplanets.planets.diona.world.gen.dungeon.RoomSpawnerDiona;
import com.stevekung.moreplanets.planets.diona.world.gen.dungeon.RoomTreasureDiona;
import com.stevekung.moreplanets.planets.diona.world.gen.feature.WorldGenCrashedAlienProbe;
import com.stevekung.moreplanets.planets.diona.world.gen.structure.MapGenAbandonedSatellite;
import com.stevekung.moreplanets.planets.diona.world.gen.structure.MapGenCrashedAlienShipFeature;
import com.stevekung.moreplanets.planets.diona.world.gen.structure.MapGenDionaMineshaft;
import com.stevekung.moreplanets.utils.world.gen.ChunkGeneratorBaseMP;
import com.stevekung.moreplanets.utils.world.gen.dungeon.DungeonConfigurationMP;
import com.stevekung.moreplanets.utils.world.gen.dungeon.RoomChestMP;
import com.stevekung.moreplanets.utils.world.gen.feature.WorldGenSpaceDungeons;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;

public class ChunkGeneratorDiona
extends ChunkGeneratorBaseMP {
    private final BiomeDecoratorDiona decorator = new BiomeDecoratorDiona();
    private final MapGenCavesBase caveGenerator = new MapGenCavesBase(MPBlocks.DIONA_SURFACE_ROCK.func_176223_P(), MPBlocks.INFECTED_PURLONITE_LAVA_FLUID_BLOCK.func_176223_P(), (Set)Sets.newHashSet((Object[])new Block[]{MPBlocks.DIONA_SUB_SURFACE_ROCK, MPBlocks.DIONA_ROCK}));
    private final MapGenDionaMineshaft mineshaftGenerator = new MapGenDionaMineshaft();
    private final MapGenDionaDungeon dungeonGenerator = new MapGenDionaDungeon(new DungeonConfigurationMP(MPBlocks.DIONA_DUNGEON_BRICK.func_176223_P(), MPBlocks.DUNGEON_GLOWSTONE.func_176223_P(), MPBlocks.INFECTED_PURLONITE_COBWEB.func_176223_P(), MPBlocks.INFECTED_PURLONITE_TORCH.func_176223_P(), MPBlocks.DIONA_ANCIENT_CHEST.func_176223_P(), 30, 8, 16, 7, 7, RoomBossDiona.class, RoomTreasureDiona.class, RoomSpawnerDiona.class, RoomChestMP.class));
    private final MapGenCrashedAlienShipFeature alienShipFeatureGenerator = new MapGenCrashedAlienShipFeature();
    private final MapGenAbandonedSatellite abandonedSatellite = new MapGenAbandonedSatellite();

    public ChunkGeneratorDiona(World world, long seed) {
        super(world, seed);
    }

    @Override
    protected void preGenerateChunk(ChunkPrimer primer, int chunkX, int chunkZ) {
        this.createCraters(chunkX, chunkZ, primer);
    }

    @Override
    protected void generateChunk(ChunkPrimer primer, int chunkX, int chunkZ) {
        this.caveGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.mineshaftGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.dungeonGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.alienShipFeatureGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.abandonedSatellite.func_186125_a(this.world, chunkX, chunkZ, primer);
    }

    @Override
    protected void populate(BlockPos pos, ChunkPos chunkpos, Biome biome, int chunkX, int chunkZ, int x, int z) {
        int y = this.rand.nextInt(this.rand.nextInt(248) + 8);
        this.decorator.func_180292_a(this.world, this.rand, biome, pos);
        this.dungeonGenerator.func_175794_a(this.world, this.rand, chunkpos);
        this.mineshaftGenerator.func_175794_a(this.world, this.rand, chunkpos);
        this.alienShipFeatureGenerator.func_175794_a(this.world, this.rand, chunkpos);
        this.abandonedSatellite.func_175794_a(this.world, this.rand, chunkpos);
        if (this.rand.nextInt(4) == 0 && y < 48) {
            new WorldGenLiquidLake(MPBlocks.INFECTED_PURLONITE_WATER_FLUID_BLOCK.func_176223_P(), MPBlocks.DIONA_ROCK.func_176223_P(), false).func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, y, this.rand.nextInt(16) + 8));
        }
        if (this.rand.nextInt(8) == 0 && y < 48) {
            new WorldGenLiquidLake(MPBlocks.INFECTED_PURLONITE_LAVA_FLUID_BLOCK.func_176223_P(), MPBlocks.DIONA_ROCK.func_176223_P(), true).func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, y, this.rand.nextInt(16) + 8));
        }
        for (int i = 0; i < 8; ++i) {
            new WorldGenSpaceDungeons(MPBlocks.DIONA_ANCIENT_CHEST.func_176223_P(), MPBlocks.DIONA_COBBLESTONE.func_176223_P(), MPBlocks.ALBETIUS_WORM_EGG_ROCK.func_176223_P()).func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
        }
        if (this.rand.nextInt(250) == 0) {
            int posX = this.rand.nextInt(16) + 8;
            int posZ = this.rand.nextInt(16) + 8;
            int posY = this.world.func_175672_r(pos.func_177982_a(posX, 0, posZ)).func_177956_o();
            new WorldGenCrashedAlienProbe().func_180709_b(this.world, this.rand, pos.func_177982_a(posX, posY, posZ));
        }
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        this.mineshaftGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
        this.dungeonGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
        this.alienShipFeatureGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
        this.abandonedSatellite.func_186125_a(this.world, chunkX, chunkZ, null);
    }

    public boolean func_193414_a(World world, String name, BlockPos pos) {
        if ("DionaMineshaft".equals(name) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(pos);
        }
        if ("AbandonedSatellite".equals(name) && this.abandonedSatellite != null) {
            return this.abandonedSatellite.func_175795_b(pos);
        }
        return "CrashedAlienShip".equals(name) && this.alienShipFeatureGenerator != null && this.alienShipFeatureGenerator.func_175795_b(pos.func_177982_a(0, 4, 0));
    }

    @Nullable
    public BlockPos func_180513_a(World world, String name, BlockPos pos, boolean findUnexplored) {
        if ("DionaMineshaft".equals(name) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_180706_b(world, pos, findUnexplored);
        }
        if ("AbandonedSatellite".equals(name) && this.abandonedSatellite != null) {
            return this.abandonedSatellite.func_180706_b(world, pos, findUnexplored);
        }
        return "CrashedAlienShip".equals(name) && this.alienShipFeatureGenerator != null ? this.alienShipFeatureGenerator.func_180706_b(world, pos, findUnexplored) : null;
    }

    @Override
    protected IBlockState getTopBlock() {
        return MPBlocks.DIONA_SURFACE_ROCK.func_176223_P();
    }

    @Override
    protected IBlockState getSubBlock() {
        return MPBlocks.DIONA_SUB_SURFACE_ROCK.func_176223_P();
    }

    @Override
    protected IBlockState getStoneBlock() {
        return MPBlocks.DIONA_ROCK.func_176223_P();
    }
}

