/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.fronos.blocks;

import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.utils.blocks.BlockGrassBlockMP;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFronosGrassBlock
extends BlockGrassBlockMP
implements IGrowable {
    private static final PropertyEnum<BlockType> HAS_LAYER = PropertyEnum.func_177709_a((String)"layer", BlockType.class);

    public BlockFronosGrassBlock(String name) {
        super(name);
        this.func_180632_j(this.func_176223_P().func_177226_a(HAS_LAYER, (Comparable)((Object)BlockType.NONE)));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        state = block == Blocks.field_150433_aE || block == Blocks.field_150431_aC ? state.func_177226_a(HAS_LAYER, (Comparable)((Object)BlockType.SNOW)) : state.func_177226_a(HAS_LAYER, (Comparable)((Object)BlockType.NONE));
        return state;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            if (!world.func_175697_a(pos, 3)) {
                return;
            }
            if (world.func_175671_l(pos.func_177984_a()) < 4 && world.getBlockLightOpacity(pos.func_177984_a()) > 2) {
                world.func_175656_a(pos, MPBlocks.FRONOS_DIRT.func_176223_P());
            } else if (world.func_175671_l(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos pos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    if (world.func_180495_p(pos1) != MPBlocks.FRONOS_DIRT.func_176223_P() || world.func_175671_l(pos1.func_177984_a()) < 4 || world.func_180495_p(pos1.func_177984_a()).getLightOpacity((IBlockAccess)world, pos1.func_177984_a()) > 2) continue;
                    world.func_175656_a(pos1, MPBlocks.FRONOS_GRASS_BLOCK.func_176223_P());
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)MPBlocks.FRONOS_DIRT);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HAS_LAYER});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        return plant.func_177230_c() == Blocks.field_150436_aH;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        BlockPos blockpos = pos.func_177984_a();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    if (!world.func_175623_d(blockpos1)) continue block0;
                    if (rand.nextInt(8) == 0) {
                        world.func_180494_b(blockpos1).plantFlower(world, rand, blockpos1);
                        continue block0;
                    }
                    if (!MPBlocks.FRONOS_GRASS.func_176196_c(world, blockpos1)) continue block0;
                    world.func_180501_a(blockpos1, MPBlocks.FRONOS_GRASS.func_176223_P(), 3);
                    continue block0;
                }
                if (world.func_180495_p((blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != MPBlocks.FRONOS_GRASS_BLOCK || world.func_180495_p(blockpos1).func_185915_l()) continue block0;
                ++j;
            }
        }
    }

    public static enum BlockType implements IStringSerializable
    {
        NONE,
        SNOW,
        CREAM;


        public String toString() {
            return this.func_176610_l().toLowerCase(Locale.ROOT);
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

