/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.fronos.client.render.entity;

import com.stevekung.moreplanets.planets.fronos.entity.EntityJellySlime;
import com.stevekung.moreplanets.utils.client.renderer.entity.layer.LayerBaseSlimeGel;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderJellySlime
extends RenderLiving<EntityJellySlime> {
    private static final ResourceLocation STRAWBERRY = new ResourceLocation("moreplanets:textures/entity/jelly_slime/strawberry.png");
    private static final ResourceLocation BERRY = new ResourceLocation("moreplanets:textures/entity/jelly_slime/berry.png");
    private static final ResourceLocation RASPBERRY = new ResourceLocation("moreplanets:textures/entity/jelly_slime/raspberry.png");
    private static final ResourceLocation ORANGE = new ResourceLocation("moreplanets:textures/entity/jelly_slime/orange.png");
    private static final ResourceLocation GRAPE = new ResourceLocation("moreplanets:textures/entity/jelly_slime/grape.png");
    private static final ResourceLocation LIME = new ResourceLocation("moreplanets:textures/entity/jelly_slime/lime.png");
    private static final ResourceLocation GREEN = new ResourceLocation("moreplanets:textures/entity/jelly_slime/green.png");
    private static final ResourceLocation LEMON = new ResourceLocation("moreplanets:textures/entity/jelly_slime/lemon.png");

    public RenderJellySlime(RenderManager render) {
        super(render, (ModelBase)new ModelSlime(16), 0.25f);
        this.func_177094_a(new LayerBaseSlimeGel<EntityJellySlime>(this));
    }

    protected void preRenderCallback(EntityJellySlime entity, float partialTickTime) {
        float f1 = entity.getSlimeSize();
        float f2 = (entity.prevSquishFactor + (entity.squishFactor - entity.prevSquishFactor) * partialTickTime) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        GlStateManager.func_179152_a((float)(f3 * f1), (float)(1.0f / f3 * f1), (float)(f3 * f1));
    }

    protected ResourceLocation getEntityTexture(EntityJellySlime entity) {
        switch (entity.getJellySlimeType()) {
            case 1: {
                return RASPBERRY;
            }
            case 2: {
                return STRAWBERRY;
            }
            case 3: {
                return BERRY;
            }
            case 4: {
                return LIME;
            }
            case 5: {
                return ORANGE;
            }
            case 6: {
                return GREEN;
            }
            case 7: {
                return LEMON;
            }
        }
        return GRAPE;
    }

    public void doRender(EntityJellySlime entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_76989_e = 0.25f * (float)entity.getSlimeSize();
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }
}

