/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.fronos.dimension;

import com.stevekung.moreplanets.core.config.ConfigManagerMP;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPDimensions;
import com.stevekung.moreplanets.init.MPPlanets;
import com.stevekung.moreplanets.planets.fronos.client.renderer.FronosCloudRenderer;
import com.stevekung.moreplanets.planets.fronos.client.renderer.SkyProviderFronos;
import com.stevekung.moreplanets.planets.fronos.world.gen.BiomeProviderFronos;
import com.stevekung.moreplanets.planets.fronos.world.gen.ChunkGeneratorFronos;
import com.stevekung.moreplanets.utils.dimension.WorldProviderMP;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderFronos
extends WorldProviderMP {
    public Vector3 getFogColor() {
        float f = 0.8f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.58431375f * f), (double)(0.8235294f * f), (double)(0.9607843f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.8f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.3254902f * f), (double)(0.7294118f * f), (double)(0.9607843f * f));
    }

    @Override
    public boolean hasSunset() {
        return true;
    }

    public boolean canDoLightning(Chunk chunk) {
        return true;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    public boolean shouldDisablePrecipitation() {
        super.updateWeatherOverride();
        return false;
    }

    public long getDayLength() {
        return 24000L;
    }

    @Override
    public boolean func_76567_e() {
        EventHandlerGC.bedActivated = false;
        return true;
    }

    public boolean func_76569_d() {
        return true;
    }

    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        return WorldProvider.WorldSleepResult.ALLOW;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)0.9f);
        return value * value * 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        value = 1.0f - value;
        value *= 1.0f - this.field_76579_a.func_72867_j(partialTicks) * 6.0f / 16.0f;
        return value *= 1.0f - this.field_76579_a.func_72819_i(partialTicks) * 8.0f / 16.0f;
    }

    public double getSolarEnergyMultiplier() {
        return 1.0;
    }

    public float getGravity() {
        return 0.0f;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= ConfigManagerMP.moreplanets_planet_settings.planetFronosTier;
    }

    public float getFallDamageModifier() {
        return 1.0f;
    }

    public CelestialBody getCelestialBody() {
        return MPPlanets.FRONOS;
    }

    public float getArrowGravity() {
        return 1.0f;
    }

    @Override
    public int getDarkEnergyMultiplier(World world, BlockPos pos) {
        return 100;
    }

    @Override
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderFronos(this.getSolarSize()));
    }

    @Override
    protected void renderCloud() {
        this.setCloudRenderer(new FronosCloudRenderer());
    }

    @Override
    public void func_76572_b() {
        super.func_76572_b();
        this.field_76578_c = new BiomeProviderFronos(this.field_76579_a.func_72905_C());
    }

    @Override
    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorFronos(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public DimensionType func_186058_p() {
        return MPDimensions.FRONOS;
    }

    public List<Block> getSurfaceBlocks() {
        return Arrays.asList(MPBlocks.FRONOS_GRASS_BLOCK, MPBlocks.FRONOS_DIRT, MPBlocks.FRONOS_STONE);
    }
}

