/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.fronos.world.gen;

import com.stevekung.moreplanets.init.MPBiomes;
import com.stevekung.moreplanets.planets.fronos.world.gen.RongHouse;
import com.stevekung.moreplanets.utils.LoggerMP;
import java.util.Collections;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenRongHouse
extends MapGenStructure {
    private boolean ranBiomeCheck;
    private final ChunkPos[] structureCoords = new ChunkPos[1];
    private final double distance;
    private int spread = 2;

    public MapGenRongHouse() {
        this.distance = 12.0;
    }

    public String func_143025_a() {
        return "RongHouse";
    }

    public BlockPos func_180706_b(World world, BlockPos pos, boolean findUnexplored) {
        if (!this.ranBiomeCheck) {
            this.generatePositions();
            this.ranBiomeCheck = true;
        }
        BlockPos blockpos = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(0, 0, 0);
        double d0 = Double.MAX_VALUE;
        for (ChunkPos chunkpos : this.structureCoords) {
            blockpos$mutableblockpos.func_181079_c((chunkpos.field_77276_a << 4) + 8, 32, (chunkpos.field_77275_b << 4) + 8);
            double d1 = blockpos$mutableblockpos.func_177951_i((Vec3i)pos);
            if (blockpos == null) {
                blockpos = new BlockPos((Vec3i)blockpos$mutableblockpos);
                d0 = d1;
                continue;
            }
            if (!(d1 < d0)) continue;
            blockpos = new BlockPos((Vec3i)blockpos$mutableblockpos);
            d0 = d1;
        }
        return blockpos;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        if (!this.ranBiomeCheck) {
            this.generatePositions();
            this.ranBiomeCheck = true;
        }
        for (ChunkPos chunkpos : this.structureCoords) {
            if (chunkX != chunkpos.field_77276_a || chunkZ != chunkpos.field_77275_b) continue;
            return true;
        }
        return false;
    }

    private void generatePositions() {
        this.func_143027_a(this.field_75039_c);
        int i = 0;
        for (StructureStart structurestart : this.field_75053_d.values()) {
            if (i >= this.structureCoords.length) continue;
            this.structureCoords[i++] = new ChunkPos(structurestart.func_143019_e(), structurestart.func_143018_f());
        }
        Random rand = new Random();
        rand.setSeed(this.field_75039_c.func_72905_C());
        double d1 = rand.nextDouble() * Math.PI * 2.0;
        int j = 0;
        int k = 0;
        int l = this.field_75053_d.size();
        if (l < this.structureCoords.length) {
            for (int i1 = 0; i1 < this.structureCoords.length; ++i1) {
                double d0 = 4.0 * this.distance + this.distance * (double)j * 6.0 + (rand.nextDouble() - 0.5) * this.distance * 2.5;
                int j1 = (int)Math.round(Math.cos(d1) * d0);
                int k1 = (int)Math.round(Math.sin(d1) * d0);
                BlockPos blockpos = this.field_75039_c.func_72959_q().func_180630_a((j1 << 4) + 8, (k1 << 4) + 8, 112, Collections.singletonList(MPBiomes.FRONOS_MEADOW), rand);
                if (blockpos != null) {
                    j1 = blockpos.func_177958_n() >> 4;
                    k1 = blockpos.func_177952_p() >> 4;
                }
                if (i1 >= l) {
                    this.structureCoords[i1] = new ChunkPos(j1, k1);
                }
                d1 += Math.PI * 2 / (double)this.spread;
                if (++k != this.spread) continue;
                k = 0;
                this.spread += 2 * this.spread / (++j + 1);
                this.spread = Math.min(this.spread, this.structureCoords.length - i1);
                d1 += rand.nextDouble() * Math.PI * 2.0;
            }
        }
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    static {
        MapGenStructureIO.func_143034_b(Start.class, (String)"RongHouse");
        MapGenStructureIO.func_143031_a(RongHouse.class, (String)"RongHouse");
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World world, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            LoggerMP.debug("Generate rong house at {} {}", chunkX * 16, chunkZ * 16);
            RongHouse house = new RongHouse(random, chunkX * 16, chunkZ * 16);
            this.field_75075_a.add(house);
            house.func_74861_a(house, this.field_75075_a, random);
            this.func_75072_c();
            this.func_75067_a(world, random, 10);
        }
    }
}

