/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.blocks;

import com.stevekung.lib.utils.ColorUtils;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.utils.blocks.BlockBreakableMP;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHugeTerrashroom
extends BlockBreakableMP {
    public static final PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    public BlockHugeTerrashroom(String name) {
        super(name, Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)BlockType.ALL_OUTSIDE)));
        this.func_149711_c(0.2f);
        this.func_149713_g(3);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Nullable
    public float[] getBeaconColorMultiplier(IBlockState state, World world, BlockPos pos, BlockPos beaconPos) {
        return ColorUtils.rgbToFloatArray((int)116, (int)161, (int)212);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public int func_149745_a(Random rand) {
        return Math.max(0, rand.nextInt(10) - 7);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)MPBlocks.TERRASHROOM);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.values[meta]));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals("variant")) continue;
            world.func_175656_a(pos, state.func_177231_a(prop));
            return true;
        }
        return false;
    }

    @Override
    protected boolean isTranslucent() {
        return true;
    }

    @Override
    protected boolean renderSideWithState() {
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                switch ((BlockType)((Object)state.func_177229_b(VARIANT))) {
                    case NORTH_WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH_EAST));
                    }
                    case NORTH: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH));
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH_WEST));
                    }
                    case WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.EAST));
                    }
                    case EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.WEST));
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH_EAST));
                    }
                    case SOUTH: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH));
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH_WEST));
                    }
                }
                return state;
            }
            case COUNTERCLOCKWISE_90: {
                switch ((BlockType)((Object)state.func_177229_b(VARIANT))) {
                    case NORTH_WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH_WEST));
                    }
                    case NORTH: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.WEST));
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH_WEST));
                    }
                    case WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH));
                    }
                    case EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH));
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH_EAST));
                    }
                    case SOUTH: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.EAST));
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH_EAST));
                    }
                }
                return state;
            }
            case CLOCKWISE_90: {
                switch ((BlockType)((Object)state.func_177229_b(VARIANT))) {
                    case NORTH_WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH_EAST));
                    }
                    case NORTH: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.EAST));
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH_EAST));
                    }
                    case WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH));
                    }
                    case EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH));
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH_WEST));
                    }
                    case SOUTH: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.WEST));
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH_WEST));
                    }
                }
                return state;
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        BlockType type = (BlockType)((Object)state.func_177229_b(VARIANT));
        switch (mirror) {
            case LEFT_RIGHT: {
                switch (type) {
                    case NORTH_WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH_WEST));
                    }
                    case NORTH: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH));
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH_EAST));
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH_WEST));
                    }
                    case SOUTH: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH));
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH_EAST));
                    }
                }
                return state;
            }
            case FRONT_BACK: {
                switch (type) {
                    case NORTH_WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH_EAST));
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.NORTH_WEST));
                    }
                    case WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.EAST));
                    }
                    case EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.WEST));
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH_EAST));
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(VARIANT, (Comparable)((Object)BlockType.SOUTH_WEST));
                    }
                }
                return state;
            }
        }
        return state;
    }

    public static enum BlockType implements IStringSerializable
    {
        ALL_INSIDE,
        NORTH_WEST,
        NORTH,
        NORTH_EAST,
        WEST,
        CENTER,
        EAST,
        SOUTH_WEST,
        SOUTH,
        SOUTH_EAST,
        STEM,
        ALL_OUTSIDE,
        ALL_STEM;

        public static final BlockType[] values;

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            values = BlockType.values();
        }
    }
}

