/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.blocks;

import com.stevekung.lib.utils.enums.CachedEnum;
import com.stevekung.moreplanets.core.MorePlanetsMod;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.utils.EnumParticleTypesMP;
import com.stevekung.moreplanets.utils.blocks.BlockBaseMP;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInfectedSponge
extends BlockBaseMP {
    private final boolean isWet;

    public BlockInfectedSponge(String name, boolean isWet) {
        super(name, Material.field_151583_m);
        this.func_149711_c(0.6f);
        this.func_149672_a(SoundType.field_185850_c);
        this.isWet = isWet;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.tryAbsorb(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.tryAbsorb(world, pos);
    }

    private void tryAbsorb(World world, BlockPos pos) {
        if (!this.isWet && this.absorb(world, pos)) {
            world.func_180501_a(pos, MPBlocks.INFECTED_WET_SPONGE.func_176223_P(), 2);
            world.func_175718_b(2001, pos, Block.func_149682_b((Block)MPBlocks.INFECTED_WATER_FLUID_BLOCK));
        }
    }

    private boolean absorb(World world, BlockPos pos) {
        LinkedList<Tuple> queue = new LinkedList<Tuple>();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.func_76341_a();
            int j = (Integer)tuple.func_76340_b();
            for (EnumFacing facing : CachedEnum.facingValues) {
                BlockPos blockpos1 = blockpos.func_177972_a(facing);
                if (world.func_180495_p(blockpos1).func_177230_c() != MPBlocks.INFECTED_WATER_FLUID_BLOCK) continue;
                world.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 2);
                list.add(blockpos1);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        for (BlockPos blockpos2 : list) {
            world.func_175685_c(blockpos2, Blocks.field_150350_a, false);
        }
        return i > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        EnumFacing enumfacing;
        if (this.isWet && (enumfacing = EnumFacing.func_176741_a((Random)rand)) != EnumFacing.UP && !world.func_180495_p(pos.func_177972_a(enumfacing)).isSideSolid((IBlockAccess)world, pos.func_177972_a(enumfacing), EnumFacing.UP)) {
            double d0 = pos.func_177958_n();
            double d1 = pos.func_177956_o();
            double d2 = pos.func_177952_p();
            if (enumfacing == EnumFacing.DOWN) {
                d1 -= 0.05;
                d0 += rand.nextDouble();
                d2 += rand.nextDouble();
            } else {
                d1 += rand.nextDouble() * 0.8;
                if (enumfacing.func_176740_k() == EnumFacing.Axis.X) {
                    d2 += rand.nextDouble();
                    d0 = enumfacing == EnumFacing.EAST ? (d0 += 1.0) : (d0 += 0.05);
                } else {
                    d0 += rand.nextDouble();
                    d2 = enumfacing == EnumFacing.SOUTH ? (d2 += 1.0) : (d2 += 0.05);
                }
            }
            MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.INFECTED_WATER_DRIP, d0, d1, d2);
        }
    }
}

