/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.blocks;

import com.stevekung.lib.utils.ColorUtils;
import com.stevekung.moreplanets.init.MPItems;
import com.stevekung.moreplanets.planets.nibiru.tileentity.TileEntityNuclearWasteTank;
import com.stevekung.moreplanets.utils.blocks.BlockBaseMP;
import com.stevekung.moreplanets.utils.blocks.MPBlockCategory;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockNuclearWasteTank
extends BlockBaseMP
implements ITileEntityProvider {
    public BlockNuclearWasteTank(String name) {
        super(name, Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityNuclearWasteTank) {
            TileEntityNuclearWasteTank tank = (TileEntityNuclearWasteTank)tile;
            if (!itemStack.func_190926_b()) {
                if (tank.hasRod && !tank.createRod) {
                    if (itemStack.func_77973_b() == MPItems.WASTE_ROD_PICKER) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemStack.func_77972_a(1, (EntityLivingBase)player);
                        }
                        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(MPItems.NUCLEAR_WASTE_ROD));
                        tank.hasRod = false;
                        tank.createRod = false;
                        return true;
                    }
                } else {
                    int slot = player.field_71071_by.field_70461_c;
                    FluidActionResult result = FluidUtil.interactWithFluidHandler((ItemStack)player.field_71071_by.func_70448_g(), (IFluidHandler)((IFluidHandler)tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)), (EntityPlayer)player);
                    if (result.isSuccess()) {
                        tank.createRod = true;
                        tank.setTime();
                        player.field_71071_by.func_70299_a(slot, result.result);
                        if (player.field_71069_bz != null) {
                            player.field_71069_bz.func_75142_b();
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityNuclearWasteTank) {
            TileEntityNuclearWasteTank tank = (TileEntityNuclearWasteTank)tile;
            if (tank.hasRod) {
                return 4;
            }
            if (tank.createRod) {
                return 8;
            }
            return 0;
        }
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityNuclearWasteTank) {
            ((TileEntityNuclearWasteTank)tile).onDestroy(tile);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityNuclearWasteTank) {
            TileEntityNuclearWasteTank tank = (TileEntityNuclearWasteTank)tile;
            tank.onCreate(world, pos);
            if (itemStack.func_77942_o()) {
                NBTTagCompound nbt = itemStack.func_77978_p();
                tank.rodCreateTime = nbt.func_74762_e("RodCreateTime");
                tank.time = nbt.func_74762_e("Time");
                tank.hasRod = nbt.func_74767_n("HasRod");
                tank.createRod = nbt.func_74767_n("CreateRod");
                tank.fluidTank.readFromNBT(nbt.func_74775_l("FluidTank"));
            }
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack heldStack) {
        player.func_71020_j(0.025f);
        if (tile instanceof TileEntityNuclearWasteTank) {
            ItemStack machine = new ItemStack((Block)this);
            TileEntityNuclearWasteTank tank = (TileEntityNuclearWasteTank)tile;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("RodCreateTime", tank.rodCreateTime);
            nbt.func_74768_a("Time", tank.time);
            nbt.func_74757_a("HasRod", tank.hasRod);
            nbt.func_74757_a("CreateRod", tank.createRod);
            if (tank.fluidTank.getFluid() != null) {
                nbt.func_74782_a("FluidTank", (NBTBase)tank.fluidTank.writeToNBT(new NBTTagCompound()));
            }
            if (!tank.hasRod) {
                machine.func_77982_d(nbt);
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)machine);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityNuclearWasteTank();
    }

    @Override
    public MPBlockCategory getBlockCategory() {
        return MPBlockCategory.DECORATION_BLOCK;
    }

    @Override
    public ColorUtils.RGB getRarityColor() {
        return ColorUtils.stringToRGB((String)"124, 124, 124");
    }
}

