/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.client.gui;

import com.stevekung.lib.utils.LangUtils;
import com.stevekung.moreplanets.core.event.ClientEventHandler;
import com.stevekung.moreplanets.planets.nibiru.inventory.ContainerNuclearWasteGenerator;
import com.stevekung.moreplanets.planets.nibiru.tileentity.TileEntityNuclearWasteGenerator;
import com.stevekung.moreplanets.utils.client.gui.GuiContainerMP;
import com.stevekung.moreplanets.utils.client.gui.GuiElementInfoRegionMP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckbox;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiNuclearWasteGenerator
extends GuiContainerMP
implements GuiElementCheckbox.ICheckBoxCallback {
    private static final ResourceLocation TEXTURE = new ResourceLocation("moreplanets:textures/gui/nuclear_waste_generator.png");
    private final TileEntityNuclearWasteGenerator tile;
    private GuiButton buttonEnable;
    private GuiElementInfoRegionMP electricInfoRegion;
    private GuiElementCheckbox checkboxRender;

    public GuiNuclearWasteGenerator(InventoryPlayer invPlayer, TileEntityNuclearWasteGenerator tile) {
        super(new ContainerNuclearWasteGenerator(invPlayer, tile));
        this.tile = tile;
        this.field_147000_g = 201;
        this.field_146999_f = 176;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tile.func_174877_v(), 0}));
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.electricInfoRegion = new GuiElementInfoRegionMP(x + 46, y + 24, 56, 9, new ArrayList<String>(), this.field_146294_l, this);
        this.infoRegions.add(this.electricInfoRegion);
        this.infoRegions.add(new GuiElementInfoRegionMP(x + 121, y + 19, 18, 18, Arrays.asList(LangUtils.translate((String)"gui.battery_slot.desc.0"), LangUtils.translate((String)"gui.battery_slot.desc.1")), this.field_146294_l, this));
        this.infoRegions.add(new GuiElementInfoRegionMP(x + 155, y + 87, 13, 13, Collections.singletonList(LangUtils.translate((String)"gui.multiblock_guide.desc")), this.field_146294_l, this));
        this.buttonEnable = new GuiButton(0, this.field_146294_l / 2 - 36, this.field_146295_m / 2 - 19, 72, 20, !this.tile.getDisabled(0) ? LangUtils.translate((String)"gui.button.disable.name") : LangUtils.translate((String)"gui.button.enable.name"));
        this.field_146292_n.add(this.buttonEnable);
        this.buttonEnable.field_146124_l = this.tile.disableCooldown == 0;
        this.checkboxRender = new GuiElementCheckbox(1, (GuiElementCheckbox.ICheckBoxCallback)this, x + 155, y + 87, "");
        this.field_146292_n.add(this.checkboxRender);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int offsetY = 35;
        this.buttonEnable.field_146124_l = this.tile.disableCooldown == 0;
        this.buttonEnable.field_146126_j = !this.tile.getDisabled(0) ? LangUtils.translate((String)"gui.button.disable.name") : LangUtils.translate((String)"gui.button.enable.name");
        String displayString = this.tile.func_70005_c_();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 7, 0x404040);
        displayString = LangUtils.translate((String)"gui.message.status.name") + ": " + this.tile.getStatus();
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 22 + offsetY, 0x404040);
        displayString = LangUtils.translate((String)"gui.message.generating.name") + ": " + (this.tile.generateTick > 0.0f ? EnergyDisplayHelper.getEnergyDisplayS((float)this.tile.generateTick) + "/t" : LangUtils.translate((String)"gui.status.not_generating.name"));
        this.field_146289_q.func_78276_b(displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 11 + offsetY, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.translate((String)"container.inventory"), 8, this.field_147000_g - 94, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tile.getEnergyStoredGC(), (float)this.tile.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(x + 33, y + 24, 176, 0, 11, 10);
        }
        this.func_73729_b(x + 47, y + 25, 187, 0, Math.min(this.tile.getScaledElecticalLevel(54), 54), 7);
        this.checkboxRender.isSelected = ClientEventHandler.WASTE_RENDER_POS.contains(this.tile.func_174877_v());
    }

    public void onSelectionChanged(GuiElementCheckbox checkbox, boolean newSelected) {
        if (ClientEventHandler.WASTE_RENDER_POS.contains(this.tile.func_174877_v())) {
            this.tile.initMultiBlock = true;
            this.tile.multiTileClientLists.clear();
            this.tile.multiBlockClientLists.clear();
            ClientEventHandler.WASTE_RENDER_POS.remove(this.tile.func_174877_v());
        } else {
            ClientEventHandler.WASTE_RENDER_POS.add(this.tile.func_174877_v());
        }
    }

    public boolean canPlayerEdit(GuiElementCheckbox checkbox, EntityPlayer player) {
        return true;
    }

    public boolean getInitiallySelected(GuiElementCheckbox checkbox) {
        return ClientEventHandler.WASTE_RENDER_POS.contains(this.tile.func_174877_v());
    }

    public void onIntruderInteraction() {
    }
}

