/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.client.renderer.tileentity;

import com.stevekung.lib.client.event.ClientEventHandler;
import com.stevekung.lib.utils.ColorUtils;
import com.stevekung.moreplanets.planets.nibiru.tileentity.TileEntityMultalicCrystal;
import com.stevekung.moreplanets.utils.client.model.ModelCrystal;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityMultalicCrystalRenderer
extends TileEntitySpecialRenderer<TileEntityMultalicCrystal> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("moreplanets:textures/model/crystal.png");
    private final ModelCrystal model = new ModelCrystal();
    public static final TileEntityMultalicCrystalRenderer INSTANCE = new TileEntityMultalicCrystalRenderer();

    public void render(TileEntityMultalicCrystal tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int meta = !tile.func_145830_o() ? 0 : tile.func_145832_p();
        Random rand = new Random((long)tile.func_174877_v().func_177958_n() + (long)tile.func_174877_v().func_177956_o() * (long)tile.func_174877_v().func_177952_p());
        for (int i = 0; i < 4; ++i) {
            int angle2;
            int angle1;
            int spike;
            int[] colorList = new int[]{ColorUtils.rgbToDecimal((int)76, (int)132, (int)255), ColorUtils.rgbToDecimal((int)50, (int)101, (int)236), ColorUtils.rgbToDecimal((int)75, (int)131, (int)255), ColorUtils.rgbToDecimal((int)28, (int)60, (int)146)};
            for (spike = 0; spike < 2; ++spike) {
                angle1 = rand.nextInt(16) + 160 * spike;
                angle2 = 8 + rand.nextInt(16);
                this.drawCrystal(tile, (float)x, (float)y, (float)z, angle1, angle2, rand, colorList[i], 1.15f, meta);
            }
            for (spike = 0; spike < 2; ++spike) {
                angle1 = rand.nextInt(74) + 232 * spike;
                angle2 = 3 + rand.nextInt(24);
                this.drawCrystal(tile, (float)x, (float)y, (float)z, angle1, angle2, rand, colorList[i], 1.15f, meta);
            }
        }
    }

    private void drawCrystal(TileEntityMultalicCrystal tile, float x, float y, float z, float angle1, float angle2, Random rand, int color, float size, int facing) {
        float shade = MathHelper.func_76126_a((float)((float)(tile.renderTicks + rand.nextInt(1)) / (8.0f + rand.nextFloat()))) * 0.2f + 1.0f;
        Color c = new Color(color);
        float r = (float)c.getRed() / 200.0f;
        float g = (float)c.getGreen() / 200.0f;
        float b = (float)c.getBlue() / 200.0f;
        int shadeLight = (int)(200.0f * shade);
        int lightX = shadeLight % 65536;
        int lightZ = shadeLight / 65536;
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179108_z();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)(z + 0.5f));
        this.translateFromDirection(facing);
        GlStateManager.func_179114_b((float)angle1, (float)0.1f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angle2, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)((0.15f + rand.nextFloat() * 0.075f) * size), (float)((0.5f + rand.nextFloat() * 0.1f) * size), (float)((0.15f + rand.nextFloat() * 0.05f) * size));
        if (tile.renderTicks > 0) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightX, (float)lightZ);
        }
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)0.75f);
        this.func_147499_a(TEXTURE);
        this.model.render();
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
    }

    private void translateFromDirection(int facing) {
        switch (EnumFacing.func_82600_a((int)facing)) {
            case WEST: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.7f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)-0.7f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179109_b((float)-0.7f, (float)0.575f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179109_b((float)0.7f, (float)0.5f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.3f, (float)0.0f);
                break;
            }
            default: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.3f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    public void render() {
        Random rand = new Random(8L);
        for (int i = 0; i < 4; ++i) {
            int angle2;
            int angle1;
            int spike;
            int[] colorList = new int[]{ColorUtils.rgbToDecimal((int)76, (int)132, (int)255), ColorUtils.rgbToDecimal((int)50, (int)101, (int)236), ColorUtils.rgbToDecimal((int)75, (int)131, (int)255), ColorUtils.rgbToDecimal((int)28, (int)60, (int)146)};
            for (spike = 0; spike < 2; ++spike) {
                angle1 = rand.nextInt(16) + 160 * spike;
                angle2 = 8 + rand.nextInt(16);
                this.drawCrystal(angle1, angle2, rand, colorList[i], 1.15f);
            }
            for (spike = 0; spike < 2; ++spike) {
                angle1 = rand.nextInt(74) + 232 * spike;
                angle2 = 3 + rand.nextInt(24);
                this.drawCrystal(angle1, angle2, rand, colorList[i], 1.15f);
            }
        }
    }

    private void drawCrystal(float angle1, float angle2, Random rand, int color, float size) {
        float shade = MathHelper.func_76126_a((float)((ClientEventHandler.renderPartialTicks + (float)rand.nextInt(1)) / (8.0f + rand.nextFloat()))) * 0.2f + 1.0f;
        Color c = new Color(color);
        float r = (float)c.getRed() / 200.0f;
        float g = (float)c.getGreen() / 200.0f;
        float b = (float)c.getBlue() / 200.0f;
        int shadeLight = (int)(200.0f * shade);
        int lightX = shadeLight % 65536;
        int lightZ = shadeLight / 65536;
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179108_z();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179109_b((float)0.475f, (float)-0.3f, (float)0.5f);
        GlStateManager.func_179114_b((float)angle1, (float)0.1f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angle2, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)((0.15f + rand.nextFloat() * 0.075f) * size), (float)((0.5f + rand.nextFloat() * 0.1f) * size), (float)((0.15f + rand.nextFloat() * 0.05f) * size));
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightX, (float)lightZ);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)0.75f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
        this.model.render();
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
        GlStateManager.func_179147_l();
    }
}

