/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.entity;

import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPItems;
import com.stevekung.moreplanets.init.MPPotions;
import com.stevekung.moreplanets.planets.nibiru.entity.EntityInfectedZombie;
import com.stevekung.moreplanets.planets.nibiru.entity.ai.EntityAINibiruVillagerFollowGolem;
import com.stevekung.moreplanets.planets.nibiru.entity.ai.EntityAINibiruVillagerHarvestFarmland;
import com.stevekung.moreplanets.planets.nibiru.entity.ai.EntityAINibiruVillagerInteract;
import com.stevekung.moreplanets.planets.nibiru.entity.ai.EntityAINibiruVillagerLookAtTradePlayer;
import com.stevekung.moreplanets.planets.nibiru.entity.ai.EntityAINibiruVillagerMate;
import com.stevekung.moreplanets.planets.nibiru.entity.ai.EntityAINibiruVillagerMoveIndoors;
import com.stevekung.moreplanets.planets.nibiru.entity.ai.EntityAINibiruVillagerPlay;
import com.stevekung.moreplanets.planets.nibiru.entity.ai.EntityAINibiruVillagerTradePlayer;
import com.stevekung.moreplanets.planets.nibiru.world.gen.biome.BiomeGreenVeinFields;
import com.stevekung.moreplanets.utils.entity.ISpaceMob;
import com.stevekung.moreplanets.utils.entity.ai.PathNavigateGroundMP;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedWitch;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityNibiruVillager
extends EntityAgeable
implements INpc,
IMerchant,
IEntityBreathable,
ISpaceMob {
    private static final DataParameter<Integer> PROFESSION = EntityDataManager.func_187226_a(EntityNibiruVillager.class, (DataSerializer)DataSerializers.field_187192_b);
    private int randomTickDivider;
    private boolean isMating;
    private boolean isPlaying;
    private Village village;
    @Nullable
    private EntityPlayer buyingPlayer;
    @Nullable
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean needsInitilization;
    private boolean isWillingToMate;
    private int wealth;
    private UUID lastBuyingPlayer;
    private int careerId;
    private int careerLevel;
    private boolean isLookingForHome;
    private boolean areAdditionalTasksSet;
    private final InventoryBasic villagerInventory = new InventoryBasic("Items", false, 8);
    private static final EntityVillager.ITradeList[][][][] DEFAULT_TRADE_LIST_MAP = new EntityVillager.ITradeList[][][][]{{{{new EntityVillager.EmeraldForItems(MPItems.INFECTED_WHEAT, new EntityVillager.PriceInfo(18, 22)), new EntityVillager.ListItemForEmeralds(Items.field_151025_P, new EntityVillager.PriceInfo(-4, -2))}, {new EntityVillager.EmeraldForItems(Item.func_150898_a((Block)MPBlocks.INFECTED_MELON), new EntityVillager.PriceInfo(7, 12)), new EntityVillager.ListItemForEmeralds(MPItems.INFECTED_APPLE, new EntityVillager.PriceInfo(-7, -5))}, {new EntityVillager.ListItemForEmeralds(MPItems.INFECTED_GOLDEN_APPLE, new EntityVillager.PriceInfo(-10, -6)), new EntityVillager.ListItemForEmeralds(MPItems.ENCHANTED_INFECTED_GOLDEN_APPLE, new EntityVillager.PriceInfo(16, 24))}}}, {{{new EntityVillager.EmeraldForItems(Items.field_151121_aF, new EntityVillager.PriceInfo(24, 36)), new EntityVillager.ListEnchantedBookForEmeralds()}, {new EntityVillager.EmeraldForItems(Items.field_151122_aG, new EntityVillager.PriceInfo(8, 10)), new EntityVillager.ListItemForEmeralds(Items.field_151111_aL, new EntityVillager.PriceInfo(10, 12)), new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)MPBlocks.INFECTED_OAK_BOOKSHELF), new EntityVillager.PriceInfo(3, 4))}, {new EntityVillager.EmeraldForItems(Items.field_151164_bB, new EntityVillager.PriceInfo(2, 2)), new EntityVillager.ListItemForEmeralds(Items.field_151113_aN, new EntityVillager.PriceInfo(10, 12)), new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)Blocks.field_150359_w), new EntityVillager.PriceInfo(-5, -3))}, {new EntityVillager.ListEnchantedBookForEmeralds()}, {new EntityVillager.ListEnchantedBookForEmeralds()}, {new EntityVillager.ListEnchantedBookForEmeralds()}}}, {{{new EntityVillager.EmeraldForItems(Items.field_151042_j, new EntityVillager.PriceInfo(12, 24)), new EmeraldForItemStack(new ItemStack(GCItems.basicItem, 1, 4), new EntityVillager.PriceInfo(8, 10)), new EntityVillager.EmeraldForItems(MPItems.EMPTY_CAPSULE, new EntityVillager.PriceInfo(4, 8))}, {new EntityVillager.ListItemForEmeralds(MPItems.CHEESE_SPORE_BERRY, new EntityVillager.PriceInfo(-5, -2)), new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)MPBlocks.CHEESE_SPORE_FLOWER), new EntityVillager.PriceInfo(-4, -2)), new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)MPBlocks.PURE_HERB), new EntityVillager.PriceInfo(-3, -1)), new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)MPBlocks.TERRAPUFF_HERB), new EntityVillager.PriceInfo(3, 6))}, {new EntityVillager.ListItemForEmeralds(MPItems.INFECTED_SPORE_PROTECTION_CAPSULE, new EntityVillager.PriceInfo(-5, -3))}}}, {{{new EntityVillager.EmeraldForItems(MPItems.TERRABERRY, new EntityVillager.PriceInfo(15, 19))}, {new EntityVillager.ListItemForEmeralds(MPItems.ALIEN_BERRY, new EntityVillager.PriceInfo(-10, -6)), new EntityVillager.ListItemForEmeralds(MPItems.GOLDEN_ALIEN_BERRY, new EntityVillager.PriceInfo(5, 10))}}}, {{{new EntityVillager.EmeraldForItems(Items.field_151121_aF, new EntityVillager.PriceInfo(24, 36)), new EntityVillager.ListEnchantedBookForEmeralds()}, {new EntityVillager.EmeraldForItems(Items.field_151122_aG, new EntityVillager.PriceInfo(8, 10)), new EntityVillager.ListItemForEmeralds(Items.field_151111_aL, new EntityVillager.PriceInfo(10, 12)), new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)MPBlocks.ALIEN_BERRY_OAK_BOOKSHELF), new EntityVillager.PriceInfo(3, 4))}, {new EntityVillager.EmeraldForItems(Items.field_151164_bB, new EntityVillager.PriceInfo(2, 2)), new EntityVillager.ListItemForEmeralds(Items.field_151113_aN, new EntityVillager.PriceInfo(10, 12)), new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)Blocks.field_150359_w), new EntityVillager.PriceInfo(-5, -3))}, {new EntityVillager.ListEnchantedBookForEmeralds()}, {new EntityVillager.ListEnchantedBookForEmeralds()}, {new EntityVillager.ListEnchantedBookForEmeralds()}}}, {{{new EntityVillager.EmeraldForItems(Items.field_151042_j, new EntityVillager.PriceInfo(12, 24)), new EmeraldForItemStack(new ItemStack(GCItems.basicItem, 1, 4), new EntityVillager.PriceInfo(8, 10)), new EntityVillager.EmeraldForItems(MPItems.EMPTY_CAPSULE, new EntityVillager.PriceInfo(4, 8))}, {new EntityVillager.ListItemForEmeralds(MPItems.INFERUMITE_CRYSTAL, new EntityVillager.PriceInfo(-5, -2)), new EntityVillager.ListItemForEmeralds(MPItems.INFECTED_PURLONITE_SHARD, new EntityVillager.PriceInfo(-4, -2)), new EntityVillager.ListItemForEmeralds(new ItemStack(MarsItems.marsItemBasic, 1, 0), new EntityVillager.PriceInfo(-3, -1)), new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)MPBlocks.TERRAPUFF_HERB), new EntityVillager.PriceInfo(3, 6))}, {new EntityVillager.ListItemForEmeralds(MPItems.DARK_ENERGY_PROTECTION_CAPSULE, new EntityVillager.PriceInfo(-3, -1))}}}, {new EntityVillager.ITradeList[0][]}};

    public EntityNibiruVillager(World world) {
        this(world, 0);
    }

    public EntityNibiruVillager(World world, int professionId) {
        super(world);
        this.setProfession(professionId);
        this.func_70105_a(0.6f, 1.95f);
        ((PathNavigateGroundMP)this.func_70661_as()).func_179688_b(true);
        this.func_98053_h(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityEvolvedZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityInfectedZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAINibiruVillagerTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAINibiruVillagerLookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAINibiruVillagerMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAINibiruVillagerMate(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAINibiruVillagerFollowGolem(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAINibiruVillagerInteract(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    public boolean func_70687_e(PotionEffect potion) {
        return potion.func_188419_a() != MPPotions.INFECTED_SPORE && super.func_70687_e(potion);
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateGroundMP((EntityLiving)this, world);
    }

    protected void func_175500_n() {
        if (this.getProfession() == 0 || this.getProfession() == 3) {
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAINibiruVillagerHarvestFarmland(this, 0.6));
        }
        super.func_175500_n();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected void func_70619_bc() {
        if (--this.randomTickDivider <= 0) {
            BlockPos pos = new BlockPos((Entity)this);
            this.field_70170_p.func_175714_ae().func_176060_a(pos);
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.village = this.field_70170_p.func_175714_ae().func_176056_a(pos, 32);
            if (this.village == null) {
                this.func_110177_bN();
            } else {
                BlockPos pos1 = this.village.func_180608_a();
                this.func_175449_a(pos1, this.village.func_75568_b());
                if (this.isLookingForHome) {
                    this.isLookingForHome = false;
                    this.village.func_82683_b(5);
                }
            }
        }
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    for (MerchantRecipe recipe : this.buyingList) {
                        if (!recipe.func_82784_g()) continue;
                        recipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    this.populateBuyingList();
                    this.needsInitilization = false;
                    if (this.village != null && this.lastBuyingPlayer != null) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                        this.village.modifyPlayerReputation(this.lastBuyingPlayer, 1);
                    }
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemStack = player.func_184586_b(hand);
        boolean bl = flag = itemStack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            itemStack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (!(this.func_190669_a(itemStack, this.getClass()) || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || player.func_70093_af())) {
            if (this.buyingList == null) {
                this.populateBuyingList();
            }
            if (hand == EnumHand.MAIN_HAND) {
                player.func_71029_a(StatList.field_188074_H);
            }
            if (!this.field_70170_p.field_72995_K && !this.buyingList.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            } else if (this.buyingList.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PROFESSION, (Object)0);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Profession", this.getProfession());
        nbt.func_74768_a("Riches", this.wealth);
        nbt.func_74768_a("Career", this.careerId);
        nbt.func_74768_a("CareerLevel", this.careerLevel);
        nbt.func_74757_a("Willing", this.isWillingToMate);
        if (this.buyingList != null) {
            nbt.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemStack = this.villagerInventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            list.func_74742_a((NBTBase)itemStack.func_77955_b(new NBTTagCompound()));
        }
        nbt.func_74782_a("Inventory", (NBTBase)list);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setProfession(nbt.func_74762_e("Profession"));
        this.wealth = nbt.func_74762_e("Riches");
        this.careerId = nbt.func_74762_e("Career");
        this.careerLevel = nbt.func_74762_e("CareerLevel");
        this.isWillingToMate = nbt.func_74767_n("Willing");
        if (nbt.func_150297_b("Offers", 10)) {
            NBTTagCompound compound = nbt.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(compound);
        }
        NBTTagList list = nbt.func_150295_c("Inventory", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack itemStack = new ItemStack(list.func_150305_b(i));
            if (itemStack.func_190926_b()) continue;
            this.villagerInventory.func_174894_a(itemStack);
        }
        this.func_98053_h(true);
        this.setAdditionalAItasks();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.isTrading() ? SoundEvents.field_187914_gn : SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191184_at;
    }

    public void func_70604_c(@Nullable EntityLivingBase entity) {
        super.func_70604_c(entity);
        if (this.village != null && entity != null) {
            this.village.func_75575_a(entity);
            if (entity instanceof EntityPlayer) {
                int i = -1;
                if (this.func_70631_g_()) {
                    i = -3;
                }
                this.village.modifyPlayerReputation(entity.func_110124_au(), i);
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (this.village != null) {
            Entity entity = cause.func_76346_g();
            if (entity != null) {
                if (entity instanceof EntityPlayer) {
                    this.village.modifyPlayerReputation(entity.func_110124_au(), -2);
                } else if (entity instanceof IMob) {
                    this.village.func_82692_h();
                }
            } else {
                EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 16.0);
                if (player != null) {
                    this.village.func_82692_h();
                }
            }
        }
        super.func_70645_a(cause);
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.buyingPlayer = player;
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
            this.isWillingToMate = true;
            this.lastBuyingPlayer = this.buyingPlayer != null ? this.buyingPlayer.func_110124_au() : null;
            i += 5;
        }
        if (recipe.func_77394_a().func_77973_b() == Items.field_151166_bC) {
            this.wealth += recipe.func_77394_a().func_190916_E();
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public void func_110297_a_(ItemStack itemStack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(itemStack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Nullable
    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    public ITextComponent func_145748_c_() {
        Team team = this.func_96124_cp();
        String customName = this.func_95999_t();
        if (!customName.isEmpty()) {
            TextComponentString component = new TextComponentString(ScorePlayerTeam.func_96667_a((Team)team, (String)customName));
            component.func_150256_b().func_150209_a(this.func_174823_aP());
            component.func_150256_b().func_179989_a(this.func_189512_bd());
            return component;
        }
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        String name = null;
        String type = this.getProfession() > 2 ? "green_vein" : "infected";
        switch (this.getProfession()) {
            case 0: 
            case 3: {
                name = "farmer";
                break;
            }
            case 1: 
            case 4: {
                name = "librarian";
                break;
            }
            case 2: 
            case 5: {
                name = "medic";
            }
        }
        if (name != null) {
            TextComponentTranslation component = new TextComponentTranslation("entity.nibiru_villager." + type + "_" + name, new Object[0]);
            component.func_150256_b().func_150209_a(this.func_174823_aP());
            component.func_150256_b().func_179989_a(this.func_189512_bd());
            if (team != null) {
                component.func_150256_b().func_150238_a(team.func_178775_l());
            }
            return component;
        }
        return super.func_145748_c_();
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? 0.81f : 1.62f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.spawnParticles(EnumParticleTypes.HEART);
        } else if (id == 13) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_ANGRY);
        } else if (id == 14) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_HAPPY);
        } else {
            super.func_70103_a(id);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data) {
        data = super.func_180482_a(difficulty, data);
        this.setProfession(this.field_70170_p.func_180494_b(this.func_180425_c()) instanceof BiomeGreenVeinFields ? 3 + this.field_70146_Z.nextInt(3) : this.field_70146_Z.nextInt(3));
        this.setAdditionalAItasks();
        this.populateBuyingList();
        return data;
    }

    public EntityNibiruVillager createChild(EntityAgeable ageable) {
        EntityNibiruVillager entity = new EntityNibiruVillager(this.field_70170_p);
        entity.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), null);
        entity.setProfession(this.field_70170_p.func_180494_b(this.func_180425_c()) instanceof BiomeGreenVeinFields ? 3 + this.field_70146_Z.nextInt(3) : this.field_70146_Z.nextInt(3));
        return entity;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            EntityEvolvedWitch entitywitch = new EntityEvolvedWitch(this.field_70170_p);
            entitywitch.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitywitch.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entitywitch)), null);
            entitywitch.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                entitywitch.func_96094_a(this.func_95999_t());
                entitywitch.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entitywitch);
            this.func_70106_y();
        }
    }

    public InventoryBasic getVillagerInventory() {
        return this.villagerInventory;
    }

    protected void func_175445_a(EntityItem itemEntity) {
        ItemStack itemStack = itemEntity.func_92059_d();
        Item item = itemStack.func_77973_b();
        if (this.canVillagerPickupItem(item)) {
            ItemStack itemStack1 = this.villagerInventory.func_174894_a(itemStack);
            if (itemStack1.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemStack.func_190920_e(itemStack1.func_190916_E());
            }
        }
    }

    @Override
    public ISpaceMob.EnumMobType getMobType() {
        return ISpaceMob.EnumMobType.NIBIRU;
    }

    public boolean canBreath() {
        return true;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStack) {
        if (super.func_174820_d(inventorySlot, itemStack)) {
            return true;
        }
        int i = inventorySlot - 300;
        if (i >= 0 && i < this.villagerInventory.func_70302_i_()) {
            this.villagerInventory.func_70299_a(i, itemStack);
            return true;
        }
        return false;
    }

    public boolean isFarmItemInInventory() {
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemStack = this.villagerInventory.func_70301_a(i);
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != MPItems.INFECTED_WHEAT_SEEDS && itemStack.func_77973_b() != MPItems.TERRABERRY) continue;
            return true;
        }
        return false;
    }

    public void setProfession(int professionId) {
        this.field_70180_af.func_187227_b(PROFESSION, (Object)professionId);
    }

    public int getProfession() {
        return Math.max((Integer)this.field_70180_af.func_187225_a(PROFESSION), 0);
    }

    public boolean isMating() {
        return this.isMating;
    }

    public void setMating(boolean mating) {
        this.isMating = mating;
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public boolean getIsWillingToMate(boolean updateFirst) {
        if (!this.isWillingToMate && updateFirst && this.hasEnoughFoodToBreed()) {
            boolean flag = false;
            for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
                ItemStack itemStack = this.villagerInventory.func_70301_a(i);
                if (!itemStack.func_190926_b()) {
                    if (itemStack.func_77973_b() == Items.field_151025_P && itemStack.func_190916_E() >= 3) {
                        flag = true;
                        this.villagerInventory.func_70298_a(i, 3);
                    } else if (itemStack.func_77973_b() == MPItems.TERRABERRY && itemStack.func_190916_E() >= 12) {
                        flag = true;
                        this.villagerInventory.func_70298_a(i, 12);
                    }
                }
                if (!flag) continue;
                this.field_70170_p.func_72960_a((Entity)this, (byte)18);
                this.isWillingToMate = true;
                break;
            }
        }
        return this.isWillingToMate;
    }

    public void setIsWillingToMate(boolean isWillingToMate) {
        this.isWillingToMate = isWillingToMate;
    }

    public boolean canAbondonItems() {
        return this.hasEnoughItems(2);
    }

    public boolean wantsMoreFood() {
        boolean flag;
        boolean bl = flag = this.getProfession() == 0 || this.getProfession() == 3;
        if (flag) {
            return !this.hasEnoughItems(5);
        }
        return !this.hasEnoughItems(1);
    }

    private boolean hasEnoughFoodToBreed() {
        return this.hasEnoughItems(1);
    }

    private void setAdditionalAItasks() {
        if (!this.areAdditionalTasksSet) {
            this.areAdditionalTasksSet = true;
            if (this.func_70631_g_()) {
                this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAINibiruVillagerPlay(this, 0.32));
            } else if (this.getProfession() == 0 || this.getProfession() == 3) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAINibiruVillagerHarvestFarmland(this, 0.6));
            }
        }
    }

    private boolean hasEnoughItems(int multiplier) {
        boolean flag = this.getProfession() == 0 || this.getProfession() == 3;
        for (int i = 0; i < this.villagerInventory.func_70302_i_(); ++i) {
            ItemStack itemStack = this.villagerInventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() == Items.field_151025_P && itemStack.func_190916_E() >= 3 * multiplier || itemStack.func_77973_b() == MPItems.TERRABERRY && itemStack.func_190916_E() >= 12 * multiplier) {
                return true;
            }
            if (!flag || itemStack.func_77973_b() != MPItems.INFECTED_WHEAT || itemStack.func_190916_E() < 9 * multiplier) continue;
            return true;
        }
        return false;
    }

    private void populateBuyingList() {
        EntityVillager.ITradeList[][][] tradelist = DEFAULT_TRADE_LIST_MAP[this.getProfession()];
        if (this.careerId != 0 && this.careerLevel != 0) {
            ++this.careerLevel;
        } else {
            this.careerId = this.field_70146_Z.nextInt(tradelist.length) + 1;
            this.careerLevel = 1;
        }
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        int careerId = this.careerId - 1;
        int careerLevel = this.careerLevel - 1;
        if (careerId >= 0 && careerId < tradelist.length) {
            EntityVillager.ITradeList[][] tradelist1 = tradelist[careerId];
            if (careerLevel >= 0 && careerLevel < tradelist1.length) {
                EntityVillager.ITradeList[] tradelist2;
                for (EntityVillager.ITradeList trades : tradelist2 = tradelist1[careerLevel]) {
                    trades.func_190888_a((IMerchant)this, this.buyingList, this.field_70146_Z);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    private boolean canVillagerPickupItem(Item item) {
        return item == Items.field_151025_P || item == MPItems.TERRABERRY || item == MPItems.INFECTED_WHEAT || item == MPItems.INFECTED_WHEAT_SEEDS;
    }

    public static class EmeraldForItemStack
    implements EntityVillager.ITradeList {
        public final ItemStack buyingItem;
        public final EntityVillager.PriceInfo price;

        public EmeraldForItemStack(ItemStack itemStack, EntityVillager.PriceInfo price) {
            this.buyingItem = itemStack;
            this.price = price;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random rand) {
            int i = 1;
            if (this.price != null) {
                i = this.price.func_179412_a(rand);
            }
            this.buyingItem.func_190920_e(i);
            recipeList.add((Object)new MerchantRecipe(this.buyingItem, Items.field_151166_bC));
        }
    }
}

