/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.entity;

import com.stevekung.lib.utils.enums.CachedEnum;
import com.stevekung.moreplanets.init.MPPotions;
import com.stevekung.moreplanets.utils.EntityEffectUtils;
import com.stevekung.moreplanets.utils.entity.ISpaceMob;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityZergius
extends EntityFlying
implements IMob,
IEntityBreathable,
ISpaceMob {
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    private float wingRotDelta = 1.0f;

    public EntityZergius(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.6f);
        this.field_70765_h = new ZergiusMoveHelper();
        this.field_70728_aV = 5;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIZergiusRandomFly());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIZergiusAttackTarget());
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
    }

    public boolean func_70687_e(PotionEffect potion) {
        return potion.func_188419_a() != MPPotions.INFECTED_SPORE && super.func_70687_e(potion);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && this.field_70170_p.func_175724_o(this.func_180425_c()) <= 1.0f;
    }

    public float func_70047_e() {
        return 0.45f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(10.0);
    }

    public boolean func_70652_k(Entity entity) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f) && EntityEffectUtils.addInfectedSpore(entity);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187793_eY;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187850_fa;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187795_eZ;
    }

    public boolean canBreath() {
        return true;
    }

    @Override
    public ISpaceMob.EnumMobType getMobType() {
        return ISpaceMob.EnumMobType.NIBIRU;
    }

    private class AIZergiusAttackTarget
    extends EntityAIBase {
        private final EntityZergius entity;
        private final FlyingMoveTargetPosition targetPos;
        private int attackTick;

        public AIZergiusAttackTarget() {
            this.entity = EntityZergius.this;
            this.targetPos = new FlyingMoveTargetPosition();
            this.attackTick = 0;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            if (this.attackTick > 0) {
                --this.attackTick;
            }
            return this.attackTargetExists();
        }

        public boolean func_75253_b() {
            if (this.attackTick > 0) {
                --this.attackTick;
            }
            if (!this.attackTargetExists()) {
                return false;
            }
            EntityLivingBase attackTarget = this.entity.func_70638_az();
            this.targetPos.setTarget(attackTarget.field_70165_t, attackTarget.field_70163_u, attackTarget.field_70161_v);
            double damageRange = this.entity.field_70130_N + attackTarget.field_70130_N;
            if (this.attackTick <= 0 && this.targetPos.dist < damageRange) {
                this.entity.func_70652_k((Entity)attackTarget);
                this.attackTick = 16;
            }
            if (this.targetPos.isPathClear(1.0)) {
                this.entity.func_70605_aq().func_75642_a(attackTarget.field_70165_t, attackTarget.field_70163_u, attackTarget.field_70161_v, 1.5);
            }
            return true;
        }

        private boolean attackTargetExists() {
            EntityLivingBase attackTarget = this.entity.func_70638_az();
            return attackTarget != null && attackTarget.func_70089_S();
        }
    }

    class AIZergiusRandomFly
    extends EntityAIBase {
        private final EntityZergius entity;
        private final FlyingMoveTargetPosition targetPos;

        public AIZergiusRandomFly() {
            this.entity = EntityZergius.this;
            this.targetPos = new FlyingMoveTargetPosition();
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !this.entity.func_70605_aq().func_75640_a();
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random rand = this.entity.func_70681_au();
            if (this.tryGoingRandomDirection(rand, 6.0)) {
                return;
            }
            if (this.tryGoingRandomDirection(rand, 2.0)) {
                return;
            }
            List<EnumFacing> directions = Arrays.asList(CachedEnum.facingValues);
            Collections.shuffle(directions);
            for (EnumFacing facing : directions) {
                if (!this.tryGoingAlongAxis(rand, facing, 1.0)) continue;
                return;
            }
        }

        private boolean tryGoingRandomDirection(Random rand, double maxDistance) {
            double dirX = (rand.nextDouble() * 2.0 - 1.0) * maxDistance;
            double dirY = (rand.nextDouble() * 2.0 - 1.1) * maxDistance;
            double dirZ = (rand.nextDouble() * 2.0 - 1.0) * maxDistance;
            return this.tryGoing(dirX, dirY, dirZ);
        }

        private boolean tryGoingAlongAxis(Random rand, EnumFacing facing, double maxDistance) {
            double dirX = 0.0;
            double dirY = 0.0;
            double dirZ = 0.0;
            switch (facing.func_176740_k()) {
                case X: {
                    dirX = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                    break;
                }
                case Y: {
                    dirY = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                    break;
                }
                default: {
                    dirZ = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                }
            }
            return this.tryGoing(dirX, dirY, dirZ);
        }

        private boolean tryGoing(double dirX, double dirY, double dirZ) {
            this.targetPos.setTarget(this.entity.field_70165_t + dirX, this.entity.field_70163_u + dirY, this.entity.field_70161_v + dirZ);
            boolean result = this.targetPos.isPathClear(1.0);
            if (result) {
                this.entity.func_70605_aq().func_75642_a(this.targetPos.posX, this.targetPos.posY, this.targetPos.posZ, 1.0);
            }
            return result;
        }
    }

    class ZergiusMoveHelper
    extends EntityMoveHelper {
        private final EntityZergius entity;
        private final FlyingMoveTargetPosition targetPos;
        private int courseChangeCooldown;

        public ZergiusMoveHelper() {
            super((EntityLiving)EntityZergius.this);
            this.entity = EntityZergius.this;
            this.targetPos = new FlyingMoveTargetPosition();
            this.courseChangeCooldown = 0;
        }

        public void func_75642_a(double x, double y, double z, double speed) {
            super.func_75642_a(x, y, z, speed);
            this.targetPos.setTarget(x, y, z);
        }

        public void func_75641_c() {
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                return;
            }
            if (this.courseChangeCooldown-- > 0) {
                return;
            }
            this.courseChangeCooldown += this.entity.func_70681_au().nextInt(5) + 2;
            this.targetPos.refresh();
            double acceleration = 0.1;
            this.entity.field_70159_w += this.targetPos.aimX * acceleration;
            this.entity.field_70181_x += this.targetPos.aimY * acceleration;
            this.entity.field_70179_y += this.targetPos.aimZ * acceleration;
            this.entity.field_70761_aq = this.entity.field_70177_z = -((float)Math.atan2(this.targetPos.distX, this.targetPos.distZ)) * 180.0f / (float)Math.PI;
            if (this.entity.func_70681_au().nextInt(2) == 0) {
                float strafeAmount = this.entity.func_70681_au().nextFloat() * 0.4f - 0.2f;
                this.entity.field_70159_w += (double)(strafeAmount * MathHelper.func_76134_b((float)(this.entity.field_70177_z * (float)Math.PI / 180.0f)));
                this.entity.field_70179_y += (double)(strafeAmount * MathHelper.func_76126_a((float)(this.entity.field_70177_z * (float)Math.PI / 180.0f)));
            }
            double closeEnough = 0.3;
            if (!this.targetPos.isPathClear(1.0)) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            } else if (this.targetPos.dist < closeEnough) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            }
        }
    }

    class FlyingMoveTargetPosition {
        private final EntityZergius entity;
        public double posX;
        public double posY;
        public double posZ;
        public double distX;
        public double distY;
        public double distZ;
        public double dist;
        public double aimX;
        public double aimY;
        public double aimZ;

        public FlyingMoveTargetPosition() {
            this.entity = EntityZergius.this;
            this.setTarget(0.0, 0.0, 0.0);
        }

        public void setTarget(double posX, double posY, double posZ) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.refresh();
        }

        public void refresh() {
            this.distX = this.posX - this.entity.field_70165_t;
            this.distY = this.posY - this.entity.field_70163_u;
            this.distZ = this.posZ - this.entity.field_70161_v;
            this.dist = MathHelper.func_76133_a((double)(this.distX * this.distX + this.distY * this.distY + this.distZ * this.distZ));
            if (this.dist == 0.0) {
                this.aimX = 0.0;
                this.aimY = 0.0;
                this.aimZ = 0.0;
            } else {
                this.aimX = this.distX / this.dist;
                this.aimY = this.distY / this.dist;
                this.aimZ = this.distZ / this.dist;
            }
        }

        public boolean isPathClear(double howFar) {
            howFar = Math.min(howFar, this.dist);
            AxisAlignedBB box = this.entity.func_174813_aQ();
            for (double i = 0.5; i < howFar; i += 1.0) {
                if (!this.isBoxBlocked(box.func_72317_d(this.aimX * i, this.aimY * i, this.aimZ * i))) continue;
                return false;
            }
            return !this.isBoxBlocked(box.func_72317_d(this.aimX * howFar, this.aimY * howFar, this.aimZ * howFar));
        }

        private boolean isBoxBlocked(AxisAlignedBB box) {
            return !this.entity.field_70170_p.func_184144_a((Entity)this.entity, box).isEmpty();
        }
    }
}

