/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.entity.ai;

import com.stevekung.moreplanets.planets.nibiru.entity.EntityNibiruVillager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityAINibiruVillagerMate
extends EntityAIBase {
    private final EntityNibiruVillager entity;
    private final World world;
    private EntityNibiruVillager mate;
    private int matingTimeout;
    private Village village;

    public EntityAINibiruVillagerMate(EntityNibiruVillager entity) {
        this.entity = entity;
        this.world = entity.field_70170_p;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.entity.func_70874_b() != 0) {
            return false;
        }
        if (this.entity.func_70681_au().nextInt(500) != 0) {
            return false;
        }
        this.village = this.world.func_175714_ae().func_176056_a(new BlockPos((Entity)this.entity), 0);
        if (this.village == null) {
            return false;
        }
        if (this.checkSufficientDoorsPresentForNewVillager() && this.entity.getIsWillingToMate(true)) {
            EntityNibiruVillager entity = (EntityNibiruVillager)this.world.func_72857_a(EntityNibiruVillager.class, this.entity.func_174813_aQ().func_72314_b(8.0, 3.0, 8.0), (Entity)this.entity);
            if (entity == null) {
                return false;
            }
            this.mate = entity;
            return this.mate.func_70874_b() == 0 && this.mate.getIsWillingToMate(true);
        }
        return false;
    }

    public void func_75249_e() {
        this.matingTimeout = 300;
        this.entity.setMating(true);
    }

    public void func_75251_c() {
        this.village = null;
        this.mate = null;
        this.entity.setMating(false);
    }

    public boolean func_75253_b() {
        return this.matingTimeout >= 0 && this.checkSufficientDoorsPresentForNewVillager() && this.entity.func_70874_b() == 0 && this.entity.getIsWillingToMate(false);
    }

    public void func_75246_d() {
        --this.matingTimeout;
        this.entity.func_70671_ap().func_75651_a((Entity)this.mate, 10.0f, 30.0f);
        if (this.entity.func_70068_e((Entity)this.mate) > 2.25) {
            this.entity.func_70661_as().func_75497_a((Entity)this.mate, 0.25);
        } else if (this.matingTimeout == 0 && this.mate.isMating()) {
            this.giveBirth();
        }
        if (this.entity.func_70681_au().nextInt(35) == 0) {
            this.world.func_72960_a((Entity)this.entity, (byte)12);
        }
    }

    private boolean checkSufficientDoorsPresentForNewVillager() {
        if (!this.village.func_82686_i()) {
            return false;
        }
        int i = (int)((double)this.village.func_75567_c() * 0.35);
        return this.village.func_75562_e() < i;
    }

    private void giveBirth() {
        EntityNibiruVillager entity = this.entity.createChild(this.mate);
        this.mate.func_70873_a(6000);
        this.entity.func_70873_a(6000);
        this.mate.setIsWillingToMate(false);
        this.entity.setIsWillingToMate(false);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this.entity, (EntityLiving)this.mate, (EntityAgeable)entity);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getChild() == null) {
            return;
        }
        entity = event.getChild();
        entity.func_70873_a(-24000);
        entity.func_70012_b(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 0.0f, 0.0f);
        this.world.func_72838_d((Entity)entity);
        this.world.func_72960_a((Entity)entity, (byte)12);
    }
}

