/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.tileentity;

import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.tileentity.TileEntityDummy;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.tile.FluidTankGC;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityNuclearWasteTank
extends TileEntityDummy
implements IMultiBlock,
IFluidHandlerWrapper {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int renderTicks;
    public int rodCreateTime = 0;
    public int time = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean hasRod = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean createRod = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTankGC fluidTank = new FluidTankGC(3000, (TileEntity)this);

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.rodCreateTime = nbt.func_74762_e("RodCreateTime");
        this.time = nbt.func_74762_e("Time");
        this.hasRod = nbt.func_74767_n("HasRod");
        this.createRod = nbt.func_74767_n("CreateRod");
        this.fluidTank.readFromNBT(nbt.func_74775_l("FluidTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("RodCreateTime", this.rodCreateTime);
        nbt.func_74768_a("Time", this.time);
        nbt.func_74757_a("HasRod", this.hasRod);
        nbt.func_74757_a("CreateRod", this.createRod);
        if (this.fluidTank.getFluid() != null) {
            nbt.func_74782_a("FluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    public void func_73660_a() {
        super.func_73660_a();
        ++this.renderTicks;
        if (!this.field_145850_b.field_72995_K && this.createRod && this.fluidTank.getFluidAmount() == 3000 && this.rodCreateTime < this.time) {
            ++this.rodCreateTime;
            if (this.rodCreateTime == this.time) {
                this.createRod = false;
                this.hasRod = true;
                this.rodCreateTime = 0;
                this.time = 0;
                this.drain(null, 3000, true);
            }
        }
    }

    public boolean onActivated(EntityPlayer player) {
        return false;
    }

    public void onCreate(World world, BlockPos pos) {
        this.mainBlockPosition = pos;
    }

    public void onDestroy(TileEntity tile) {
        BlockPos thisBlock = this.func_174877_v();
        if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
            FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(thisBlock.func_177984_a(), MPBlocks.NWT_MIDDLE_DUMMY.func_176223_P());
            FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(thisBlock.func_177981_b(2), MPBlocks.NWT_TOP_DUMMY.func_176223_P());
        }
        this.destroyBlock(this.func_174877_v(), true);
        this.destroyBlock(thisBlock.func_177984_a(), false);
        this.destroyBlock(thisBlock.func_177981_b(2), false);
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
    }

    public boolean canRenderBreaking() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 3, 1));
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return null;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.fluidTank.fill(resource.copy(), doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.fluidTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return fluid == null || fluid.getName().equals("nuclear_waste_fluid");
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTank compositeTank = new FluidTank(this.fluidTank.getCapacity());
        int capacity = this.fluidTank.getCapacity();
        compositeTank.setCapacity(capacity);
        return new FluidTankInfo[]{compositeTank.getInfo()};
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isCreateRod() {
        return this.createRod && this.fluidTank.getFluidAmount() > 0;
    }

    public int getAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public void setTime() {
        this.time = 1200 + this.field_145850_b.field_73012_v.nextInt(1200);
    }

    private void destroyBlock(BlockPos pos, boolean dropBlock) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.isAir(state, (IBlockAccess)this.field_145850_b, pos)) {
            ItemStack itemStack = new ItemStack(MPBlocks.NUCLEAR_WASTE_TANK);
            if (dropBlock) {
                if (!this.hasRod) {
                    itemStack.func_77982_d(new NBTTagCompound());
                    itemStack.func_77978_p().func_74768_a("RodCreateTime", this.rodCreateTime);
                    itemStack.func_77978_p().func_74768_a("Time", this.time);
                    itemStack.func_77978_p().func_74757_a("HasRod", this.hasRod);
                    itemStack.func_77978_p().func_74757_a("CreateRod", this.createRod);
                    if (this.fluidTank.getFluid() != null) {
                        itemStack.func_77978_p().func_74782_a("FluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
                    }
                }
                Block.func_180635_a((World)this.field_145850_b, (BlockPos)pos, (ItemStack)itemStack);
            }
            this.field_145850_b.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            this.field_145850_b.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }
}

