/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.world.gen;

import com.google.common.collect.Sets;
import com.stevekung.lib.world.gen.MapGenCavesBase;
import com.stevekung.lib.world.gen.MapGenRavineBase;
import com.stevekung.lib.world.gen.WorldGenLiquidLake;
import com.stevekung.moreplanets.init.MPBiomes;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.planets.nibiru.world.gen.BiomeDecoratorNibiruOre;
import com.stevekung.moreplanets.planets.nibiru.world.gen.dungeon.MapGenNibiruDungeon;
import com.stevekung.moreplanets.planets.nibiru.world.gen.dungeon.RoomBossNibiru;
import com.stevekung.moreplanets.planets.nibiru.world.gen.dungeon.RoomChestNibiru;
import com.stevekung.moreplanets.planets.nibiru.world.gen.dungeon.RoomSpawnerNibiru;
import com.stevekung.moreplanets.planets.nibiru.world.gen.dungeon.RoomTreasureNibiru;
import com.stevekung.moreplanets.planets.nibiru.world.gen.structure.MapGenNibiruIgloo;
import com.stevekung.moreplanets.planets.nibiru.world.gen.structure.MapGenNibiruJungleTemple;
import com.stevekung.moreplanets.planets.nibiru.world.gen.structure.MapGenNibiruMineshaft;
import com.stevekung.moreplanets.planets.nibiru.world.gen.structure.MapGenNibiruOceanMonument;
import com.stevekung.moreplanets.planets.nibiru.world.gen.structure.MapGenNibiruPyramid;
import com.stevekung.moreplanets.planets.nibiru.world.gen.structure.MapGenNibiruStronghold;
import com.stevekung.moreplanets.planets.nibiru.world.gen.structure.MapGenNibiruVillage;
import com.stevekung.moreplanets.utils.world.gen.ChunkGeneratorBaseMP;
import com.stevekung.moreplanets.utils.world.gen.dungeon.DungeonConfigurationMP;
import com.stevekung.moreplanets.utils.world.gen.feature.WorldGenSpaceDungeons;
import java.util.List;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;

public class ChunkGeneratorNibiru
extends ChunkGeneratorBaseMP {
    private final MapGenCavesBase caveGenerator = new MapGenCavesBase((Set)Sets.newHashSet((Object[])new Block[]{MPBlocks.INFECTED_GRASS_BLOCK, MPBlocks.GREEN_VEIN_GRASS_BLOCK}), Blocks.field_150353_l.func_176223_P(), (Set)Sets.newHashSet((Object[])new Block[]{MPBlocks.INFECTED_DIRT, MPBlocks.NIBIRU_ROCK, MPBlocks.INFECTED_SANDSTONE, Blocks.field_150406_ce}), (Set)Sets.newHashSet((Object[])new Block[]{MPBlocks.INFECTED_WATER_FLUID_BLOCK, MPBlocks.PURIFIED_WATER_FLUID_BLOCK}));
    private final MapGenRavineBase ravineGenerator = new MapGenRavineBase((Set)Sets.newHashSet((Object[])new Block[]{MPBlocks.INFECTED_GRASS_BLOCK, MPBlocks.GREEN_VEIN_GRASS_BLOCK}), Blocks.field_150353_l.func_176223_P(), (Set)Sets.newHashSet((Object[])new Block[]{MPBlocks.INFECTED_DIRT, MPBlocks.NIBIRU_ROCK, MPBlocks.INFECTED_SANDSTONE, Blocks.field_150406_ce}), (Set)Sets.newHashSet((Object[])new Block[]{MPBlocks.INFECTED_WATER_FLUID_BLOCK, MPBlocks.PURIFIED_WATER_FLUID_BLOCK}));
    private final MapGenNibiruStronghold strongholdGenerator = new MapGenNibiruStronghold();
    private final MapGenNibiruVillage villageGenerator = new MapGenNibiruVillage();
    private final MapGenNibiruMineshaft mineshaftGenerator = new MapGenNibiruMineshaft();
    private final MapGenNibiruPyramid pyramidGenerator = new MapGenNibiruPyramid();
    private final MapGenNibiruJungleTemple jungleTempleGenerator = new MapGenNibiruJungleTemple();
    private final MapGenNibiruOceanMonument oceanMonumentGenerator = new MapGenNibiruOceanMonument();
    private final MapGenNibiruIgloo iglooGenerator = new MapGenNibiruIgloo();
    private final BiomeDecoratorNibiruOre decorator = new BiomeDecoratorNibiruOre();
    private final MapGenNibiruDungeon dungeonGenerator = new MapGenNibiruDungeon(new DungeonConfigurationMP(MPBlocks.NIBIRU_DUNGEON_BRICK.func_176223_P(), MPBlocks.DUNGEON_GLOWSTONE.func_176223_P(), Blocks.field_150321_G.func_176223_P(), MPBlocks.INFECTED_TORCH.func_176223_P(), MPBlocks.NIBIRU_ANCIENT_CHEST.func_176223_P(), 30, 8, 16, 7, 7, RoomBossNibiru.class, RoomTreasureNibiru.class, RoomSpawnerNibiru.class, RoomChestNibiru.class));

    public ChunkGeneratorNibiru(World world, long seed) {
        super(world, seed);
        this.isSingleBiomePlanet = false;
    }

    @Override
    protected void preGenerateChunk(ChunkPrimer primer, int chunkX, int chunkZ) {
    }

    @Override
    protected void generateChunk(ChunkPrimer primer, int chunkX, int chunkZ) {
        this.caveGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.ravineGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.mineshaftGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.strongholdGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.pyramidGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.jungleTempleGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.oceanMonumentGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.villageGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.dungeonGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.iglooGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
    }

    @Override
    protected void populate(BlockPos pos, ChunkPos chunkpos, Biome biome, int chunkX, int chunkZ, int x, int z) {
        int y;
        this.decorator.func_180292_a(this.world, this.rand, biome, pos);
        this.mineshaftGenerator.func_175794_a(this.world, this.rand, chunkpos);
        this.strongholdGenerator.func_175794_a(this.world, this.rand, chunkpos);
        this.pyramidGenerator.func_175794_a(this.world, this.rand, chunkpos);
        this.jungleTempleGenerator.func_175794_a(this.world, this.rand, chunkpos);
        this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, chunkpos);
        this.villageGenerator.func_175794_a(this.world, this.rand, chunkpos);
        this.dungeonGenerator.func_175794_a(this.world, this.rand, chunkpos);
        this.iglooGenerator.func_175794_a(this.world, this.rand, chunkpos);
        int worldX = chunkX << 4;
        int worldZ = chunkZ << 4;
        ChunkGeneratorBaseMP.generatePocket(this.world, this.rand, worldX + 15, worldZ + 15, GCBlocks.crudeOil.func_176223_P(), Sets.newHashSet((Object[])new Biome[]{MPBiomes.INFECTED_OCEAN, MPBiomes.INFECTED_DEEP_OCEAN, MPBiomes.INFECTED_RIVER}));
        if (this.rand.nextInt(10) == 0) {
            ChunkGeneratorBaseMP.generatePocket(this.world, this.rand, worldX + 15, worldZ + 15, MPBlocks.HELIUM_GAS_BLOCK.func_176223_P(), Sets.newHashSet((Object[])new Biome[]{MPBiomes.INFECTED_OCEAN, MPBiomes.INFECTED_DEEP_OCEAN, MPBiomes.INFECTED_RIVER}), 10 + this.rand.nextInt(10), 2 + this.rand.nextInt(2));
        }
        if (biome != MPBiomes.INFECTED_DESERT && biome != MPBiomes.GREEN_VEIN_FIELDS && this.rand.nextInt(4) == 0) {
            new WorldGenLiquidLake(MPBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P(), MPBlocks.NIBIRU_ROCK.func_176223_P(), false).func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
        }
        if (biome == MPBiomes.GREEN_VEIN_FIELDS && this.rand.nextInt(6) == 0) {
            new WorldGenLiquidLake(MPBlocks.PURIFIED_WATER_FLUID_BLOCK.func_176223_P(), MPBlocks.TERRASTONE.func_176223_P(), true).func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
        }
        if (this.rand.nextInt(8) == 0 && ((y = this.rand.nextInt(this.rand.nextInt(248) + 8)) < 63 || this.rand.nextInt(10) == 0)) {
            new WorldGenLiquidLake(Blocks.field_150353_l.func_176223_P(), MPBlocks.NIBIRU_ROCK.func_176223_P(), true).func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, y, this.rand.nextInt(16) + 8));
        }
        for (int i = 0; i < 8; ++i) {
            new WorldGenSpaceDungeons(MPBlocks.NIBIRU_ANCIENT_CHEST.func_176223_P(), MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), MPBlocks.NIBIRU_VEIN_COBBLESTONE.func_176223_P()).func_180709_b(this.world, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
        }
        biome.func_180624_a(this.world, this.rand, pos);
        pos = pos.func_177982_a(8, 0, 8);
        for (int snowX = 0; snowX < 16; ++snowX) {
            for (int snowZ = 0; snowZ < 16; ++snowZ) {
                BlockPos blockpos1 = this.world.func_175725_q(pos.func_177982_a(snowX, 0, snowZ));
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (this.world.func_175675_v(blockpos2)) {
                    this.world.func_180501_a(blockpos2, MPBlocks.INFECTED_ICE.func_176223_P(), 2);
                }
                if (!this.world.func_175708_f(blockpos1, true)) continue;
                Biome biome2 = this.world.func_180494_b(blockpos1);
                this.world.func_180501_a(blockpos1, biome2 == MPBiomes.COLD_GREEN_VEIN_MOUTAINS ? MPBlocks.PURIFIED_SNOW_LAYER.func_176223_P() : MPBlocks.INFECTED_SNOW_LAYER.func_176223_P(), 2);
            }
        }
    }

    @Override
    protected IBlockState getTopBlock() {
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    protected IBlockState getSubBlock() {
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    protected IBlockState getStoneBlock() {
        return MPBlocks.NIBIRU_ROCK.func_176223_P();
    }

    @Override
    protected IBlockState getLiquidBlock() {
        return MPBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P();
    }

    @Override
    public boolean func_185933_a(Chunk chunk, int chunkX, int chunkZ) {
        boolean flag = false;
        if (chunk.func_177416_w() < 3600L) {
            flag = this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, new ChunkPos(chunkX, chunkZ));
        }
        return flag;
    }

    @Override
    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType type, BlockPos pos) {
        if (type == EnumCreatureType.MONSTER) {
            if (this.pyramidGenerator.canMobSpawn(pos)) {
                return this.pyramidGenerator.getSpawnList();
            }
            if (this.jungleTempleGenerator.canMobSpawn(pos)) {
                return this.jungleTempleGenerator.getSpawnList();
            }
            if (this.oceanMonumentGenerator.func_175796_a(this.world, pos)) {
                return this.oceanMonumentGenerator.getSpawnList();
            }
        }
        return super.func_177458_a(type, pos);
    }

    public BlockPos func_180513_a(World world, String name, BlockPos pos, boolean findUnexplored) {
        if ("NibiruStronghold".equals(name) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_180706_b(world, pos, findUnexplored);
        }
        if ("NibiruOceanMonument".equals(name) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_180706_b(world, pos, findUnexplored);
        }
        if ("NibiruVillage".equals(name) && this.villageGenerator != null) {
            return this.villageGenerator.func_180706_b(world, pos, findUnexplored);
        }
        if ("NibiruMineshaft".equals(name) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_180706_b(world, pos, findUnexplored);
        }
        if ("NibiruBossDungeon".equals(name) && this.dungeonGenerator != null) {
            return this.dungeonGenerator.func_180706_b(world, pos, findUnexplored);
        }
        if ("NibiruIgloo".equals(name) && this.iglooGenerator != null) {
            return this.iglooGenerator.func_180706_b(world, pos, findUnexplored);
        }
        if ("NibiruPyramid".equals(name) && this.pyramidGenerator != null) {
            return this.pyramidGenerator.func_180706_b(world, pos, findUnexplored);
        }
        return "NibiruJungleTemple".equals(name) && this.jungleTempleGenerator != null ? this.jungleTempleGenerator.func_180706_b(world, pos, findUnexplored) : null;
    }

    public boolean func_193414_a(World world, String name, BlockPos pos) {
        if ("NibiruStronghold".equals(name) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_175795_b(pos);
        }
        if ("NibiruOceanMonument".equals(name) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_175795_b(pos);
        }
        if ("NibiruVillage".equals(name) && this.villageGenerator != null) {
            return this.villageGenerator.func_175795_b(pos);
        }
        if ("NibiruMineshaft".equals(name) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(pos);
        }
        if ("NibiruBossDungeon".equals(name) && this.dungeonGenerator != null) {
            return this.dungeonGenerator.func_175795_b(pos);
        }
        if ("NibiruIgloo".equals(name) && this.iglooGenerator != null) {
            return this.iglooGenerator.func_175795_b(pos);
        }
        if ("NibiruPyramid".equals(name) && this.pyramidGenerator != null) {
            return this.pyramidGenerator.func_175795_b(pos);
        }
        return "NibiruJungleTemple".equals(name) && this.jungleTempleGenerator != null && this.jungleTempleGenerator.func_175795_b(pos);
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        this.mineshaftGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
        this.strongholdGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
        this.pyramidGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
        this.jungleTempleGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
        this.oceanMonumentGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
        this.villageGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
        this.dungeonGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
        this.iglooGenerator.func_186125_a(this.world, chunkX, chunkZ, null);
    }
}

