/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.world.gen.biome;

import com.stevekung.lib.utils.WorldDecorateUtils;
import com.stevekung.moreplanets.planets.nibiru.world.gen.biome.BiomeNibiru;
import com.stevekung.moreplanets.planets.nibiru.world.gen.feature.WorldGenInfectedRoofedTree;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class BiomeInfectedForest
extends BiomeNibiru {
    private static final WorldGenInfectedRoofedTree ROOFED_TREE = new WorldGenInfectedRoofedTree(true);
    private static final WorldGenInfectedRoofedTree ROOFED_TREE_NO_LEAVES = new WorldGenInfectedRoofedTree(false);
    private final Type type;

    public BiomeInfectedForest(Biome.BiomeProperties prop, Type type) {
        super(prop);
        this.type = type;
        this.field_76760_I.field_76832_z = 10;
        this.field_76760_I.field_76803_B = 80;
        this.field_76760_I.orangeBushPerChunk = 3;
    }

    @Override
    public void func_180624_a(World world, Random rand, BlockPos pos) {
        super.func_180624_a(world, rand, pos);
        if (rand.nextInt(25) == 0) {
            BiomeNibiru.SCATTERED_DIRT.func_180709_b(world, rand, WorldDecorateUtils.getSimplePos((World)world, (BlockPos)pos, (Random)rand));
        }
        if (this.type == Type.DARK) {
            WorldGenAbstractTree tree = this.func_150567_a(rand);
            tree.func_175904_e();
            if (tree.func_180709_b(world, rand, pos)) {
                tree.func_180711_a(world, rand, pos);
            }
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random rand) {
        if (this.type == Type.DARK) {
            if (rand.nextInt(8) < 1) {
                return ROOFED_TREE_NO_LEAVES;
            }
            if (rand.nextInt(20) == 0) {
                return rand.nextInt(5) == 0 ? ROOFED_TREE : BiomeNibiru.TREE;
            }
            return BiomeNibiru.TREE_NO_LEAVES;
        }
        if (rand.nextInt(10) == 0) {
            return BiomeNibiru.BIG_TREE;
        }
        if (rand.nextInt(20) == 0) {
            return rand.nextInt(5) == 0 ? BiomeNibiru.BIG_TREE_NO_LEAVES : BiomeNibiru.TREE_NO_LEAVES;
        }
        return BiomeNibiru.TREE;
    }

    public static enum Type {
        NORMAL,
        DARK;

    }
}

