/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.world.gen.biome;

import com.stevekung.lib.world.gen.WorldGenMinableBase;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.planets.nibiru.world.gen.biome.BiomeNibiru;
import com.stevekung.moreplanets.planets.nibiru.world.gen.feature.WorldGenInfectedDeadSpruce;
import com.stevekung.moreplanets.planets.nibiru.world.gen.feature.WorldGenMultalicCrystal;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeInfectedMountains
extends BiomeNibiru {
    private static final WorldGenEmerald EMERALD = new WorldGenEmerald();
    private static final WorldGenMultalicCrystal CRYSTAL = new WorldGenMultalicCrystal();
    private static final WorldGenMinableBase INFESTED_ROCK = new WorldGenMinableBase(MPBlocks.INFESTED_NIBIRU_ROCK.func_176223_P(), MPBlocks.NIBIRU_ROCK.func_176223_P(), 8);
    private final Type type;

    public BiomeInfectedMountains(Biome.BiomeProperties prop, Type type) {
        super(prop);
        if (type == Type.EXTRA_TREES) {
            this.field_76760_I.field_76832_z = 3;
        }
        this.type = type;
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random rand) {
        if (rand.nextInt(3) > 0) {
            return new WorldGenInfectedDeadSpruce(true);
        }
        if (rand.nextInt(20) == 0) {
            return rand.nextInt(5) == 0 ? BiomeNibiru.BIG_TREE_NO_LEAVES : BiomeNibiru.TREE_NO_LEAVES;
        }
        return super.func_150567_a(rand);
    }

    @Override
    public void func_180624_a(World world, Random rand, BlockPos pos) {
        int i;
        super.func_180624_a(world, rand, pos);
        EMERALD.func_180709_b(world, rand, pos);
        for (i = 0; i < 7; ++i) {
            INFESTED_ROCK.func_180709_b(world, rand, pos.func_177982_a(rand.nextInt(16), rand.nextInt(64), rand.nextInt(16)));
        }
        for (i = 0; i < 24; ++i) {
            CRYSTAL.func_180709_b(world, rand, pos.func_177982_a(rand.nextInt(16), rand.nextInt(28) + 4, rand.nextInt(16)));
        }
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int chunkX, int chunkZ, double noiseVal) {
        this.field_76752_A = MPBlocks.INFECTED_GRASS_BLOCK.func_176223_P();
        this.field_76753_B = MPBlocks.INFECTED_DIRT.func_176223_P();
        if ((noiseVal < -1.0 || noiseVal > 2.0) && this.type == Type.MUTATED) {
            this.field_76752_A = MPBlocks.INFECTED_GRAVEL.func_176223_P();
            this.field_76753_B = MPBlocks.INFECTED_GRAVEL.func_176223_P();
        } else if (noiseVal > 1.0 && this.type != Type.EXTRA_TREES) {
            this.field_76752_A = MPBlocks.NIBIRU_ROCK.func_176223_P();
            this.field_76753_B = MPBlocks.NIBIRU_ROCK.func_176223_P();
        }
        super.func_180622_a(world, rand, primer, chunkX, chunkZ, noiseVal);
    }

    private static class WorldGenEmerald
    extends WorldGenerator {
        private WorldGenEmerald() {
        }

        public boolean func_180709_b(World world, Random rand, BlockPos pos) {
            int count = 3 + rand.nextInt(6);
            for (int i = 0; i < count; ++i) {
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(16) + 8, rand.nextInt(28) + 4, rand.nextInt(16) + 8);
                IBlockState state = world.func_180495_p(blockpos);
                if (state.func_177230_c() != MPBlocks.NIBIRU_ROCK) continue;
                world.func_180501_a(blockpos, MPBlocks.INFECTED_EMERALD_ORE.func_176223_P(), 18);
            }
            return true;
        }
    }

    public static enum Type {
        NORMAL,
        EXTRA_TREES,
        MUTATED;

    }
}

