/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.world.gen.dungeon;

import com.stevekung.lib.utils.BlockStateProperty;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.planets.nibiru.tileentity.TileEntityNibiruTreasureChest;
import com.stevekung.moreplanets.planets.nibiru.world.gen.dungeon.DungeonStartNibiru;
import com.stevekung.moreplanets.planets.nibiru.world.gen.dungeon.PieceNibiru;
import com.stevekung.moreplanets.planets.nibiru.world.gen.dungeon.RoomBossNibiru;
import com.stevekung.moreplanets.planets.nibiru.world.gen.dungeon.SizedPieceNibiru;
import com.stevekung.moreplanets.utils.world.gen.dungeon.DungeonConfigurationMP;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class RoomTreasureNibiru
extends SizedPieceNibiru {
    public RoomTreasureNibiru() {
    }

    public RoomTreasureNibiru(DungeonConfigurationMP configuration, Random rand, int blockPosX, int blockPosZ, EnumFacing entranceDir) {
        this(configuration, rand, blockPosX, blockPosZ, rand.nextInt(4) + 6, configuration.getRoomHeight(), rand.nextInt(4) + 6, entranceDir);
    }

    public RoomTreasureNibiru(DungeonConfigurationMP configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing entranceDir) {
        super(configuration, sizeX, sizeY, sizeZ, entranceDir.func_176734_d());
        this.func_186164_a(EnumFacing.SOUTH);
        int yPos = configuration.getYPosition();
        this.field_74887_e = new StructureBoundingBox(blockPosX, yPos, blockPosZ, blockPosX + this.sizeX, yPos + this.sizeY, blockPosZ + this.sizeZ);
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox boundingBox) {
        for (int i = 0; i <= this.sizeX; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                for (int k = 0; k <= this.sizeZ; ++k) {
                    if (i == 0 || i == this.sizeX || j == 0 || j == this.sizeY || k == 0 || k == this.sizeZ) {
                        int end;
                        int start;
                        boolean placeBlock = true;
                        if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z) {
                            start = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 - 1;
                            end = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 + 1;
                            if (i > start && i <= end && j < 3 && j > 0) {
                                if (this.getDirection() == EnumFacing.SOUTH && k == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.NORTH && k == this.sizeZ) {
                                    placeBlock = false;
                                }
                            }
                        } else {
                            start = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - 1;
                            end = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 1;
                            if (k > start && k <= end && j < 3 && j > 0) {
                                if (this.getDirection() == EnumFacing.EAST && i == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.WEST && i == this.sizeX) {
                                    placeBlock = false;
                                }
                            }
                        }
                        if (placeBlock) {
                            this.func_175811_a(world, this.configuration.getBrickBlock(), i, j, k, boundingBox);
                            continue;
                        }
                        this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                        continue;
                    }
                    if (i == 1 && k == 1 || i == 1 && k == this.sizeZ - 1 || i == this.sizeX - 1 && k == 1 || i == this.sizeX - 1 && k == this.sizeZ - 1) {
                        this.func_175811_a(world, this.configuration.getGlowstoneBlock(), i, j, k, boundingBox);
                        continue;
                    }
                    if (i == this.sizeX / 2 && j == 1 && k == this.sizeZ / 2) {
                        this.func_175811_a(world, MPBlocks.NIBIRU_TREASURE_CHEST.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)this.getDirection().func_176734_d()), i, j, k, boundingBox);
                        BlockPos blockpos = new BlockPos(this.func_74865_a(i, k), this.func_74862_a(j), this.func_74873_b(i, k));
                        if (world.func_175625_s(blockpos) != null) continue;
                        world.func_175690_a(blockpos, (TileEntity)new TileEntityNibiruTreasureChest());
                        continue;
                    }
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                }
            }
        }
        return true;
    }

    @Override
    public PieceNibiru getNextPiece(DungeonStartNibiru startPiece, Random rand) {
        StructureComponent component;
        if (startPiece.attachedComponents.size() > 2 && (component = startPiece.attachedComponents.get(startPiece.attachedComponents.size() - 3)) instanceof RoomBossNibiru) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(this.sizeX / 2, this.sizeZ / 2), this.func_74862_a(1), this.func_74873_b(this.sizeX / 2, this.sizeZ / 2));
            ((RoomBossNibiru)component).setChestPos(new BlockPos((Vec3i)blockpos));
        }
        return null;
    }
}

