/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.world.gen.feature;

import com.stevekung.lib.world.gen.WorldGenAbstractHugeTrees;
import com.stevekung.moreplanets.init.MPBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldGenInfectedMegaPineTree
extends WorldGenAbstractHugeTrees {
    private final boolean useBaseHeight;
    private final boolean genLeaves;

    public WorldGenInfectedMegaPineTree(boolean genLeaves, boolean useBaseHeight) {
        super(13, 15, MPBlocks.INFECTED_SPRUCE_LEAVES.func_176223_P());
        this.useBaseHeight = useBaseHeight;
        this.genLeaves = genLeaves;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int i = this.getHeight(rand);
        if (!this.ensureGrowable(world, pos, i)) {
            return false;
        }
        this.createCrown(world, pos.func_177958_n(), pos.func_177952_p(), pos.func_177956_o() + i, rand);
        for (int j = 0; j < i; ++j) {
            if (this.isAirLeaves(world, pos.func_177981_b(j))) {
                this.func_175903_a(world, pos.func_177981_b(j), MPBlocks.INFECTED_SPRUCE_LOG.func_176223_P());
            }
            if (j >= i - 1) continue;
            if (this.isAirLeaves(world, pos.func_177982_a(1, j, 0))) {
                this.func_175903_a(world, pos.func_177982_a(1, j, 0), MPBlocks.INFECTED_SPRUCE_LOG.func_176223_P());
            }
            if (this.isAirLeaves(world, pos.func_177982_a(1, j, 1))) {
                this.func_175903_a(world, pos.func_177982_a(1, j, 1), MPBlocks.INFECTED_SPRUCE_LOG.func_176223_P());
            }
            if (!this.isAirLeaves(world, pos.func_177982_a(0, j, 1))) continue;
            this.func_175903_a(world, pos.func_177982_a(0, j, 1), MPBlocks.INFECTED_SPRUCE_LOG.func_176223_P());
        }
        return true;
    }

    protected boolean isSoil(Block block) {
        return block == MPBlocks.INFECTED_GRASS_BLOCK || block == MPBlocks.INFECTED_DIRT || block == MPBlocks.INFECTED_COARSE_DIRT || block == MPBlocks.INFECTED_FARMLAND;
    }

    public void func_180711_a(World world, Random random, BlockPos pos) {
        this.placePodzolCircle(world, pos.func_177976_e().func_177978_c());
        this.placePodzolCircle(world, pos.func_177965_g(2).func_177978_c());
        this.placePodzolCircle(world, pos.func_177976_e().func_177970_e(2));
        this.placePodzolCircle(world, pos.func_177965_g(2).func_177970_e(2));
        for (int i = 0; i < 5; ++i) {
            int j = random.nextInt(64);
            int k = j % 8;
            int l = j / 8;
            if (k != 0 && k != 7 && l != 0 && l != 7) continue;
            this.placePodzolCircle(world, pos.func_177982_a(-3 + k, 0, -3 + l));
        }
    }

    protected void growLeavesLayerStrict(World world, BlockPos layerCenter, int width) {
        if (this.genLeaves) {
            super.growLeavesLayerStrict(world, layerCenter, width);
        }
    }

    protected void growLeavesLayer(World world, BlockPos layerCenter, int width) {
        if (this.genLeaves) {
            super.growLeavesLayer(world, layerCenter, width);
        }
    }

    private void createCrown(World world, int x, int z, int y, Random rand) {
        int i = rand.nextInt(5) + (this.useBaseHeight ? this.baseHeight : 3);
        int j = 0;
        for (int k = y - i; k <= y; ++k) {
            int l = y - k;
            int i1 = MathHelper.func_76141_d((float)((float)l / (float)i * 3.5f));
            this.growLeavesLayerStrict(world, new BlockPos(x, k, z), i1 + (l > 0 && i1 == j && (k & 1) == 0 ? 1 : 0));
            j = i1;
        }
    }

    private void placePodzolCircle(World world, BlockPos center) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.placePodzolAt(world, center.func_177982_a(i, 0, j));
            }
        }
    }

    private void placePodzolAt(World world, BlockPos pos) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pos.func_177981_b(i);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            if (this.isSoil(iblockstate.func_177230_c())) {
                this.func_175903_a(world, blockpos, MPBlocks.INFECTED_PODZOL.func_176223_P());
                break;
            }
            if (iblockstate.func_185904_a() != Material.field_151579_a && i < 0) break;
        }
    }

    private boolean isAirLeaves(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos);
    }
}

