/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.world.gen.structure;

import com.stevekung.lib.utils.enums.CachedEnum;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPLootTables;
import com.stevekung.moreplanets.utils.tileentity.TileEntityChestMP;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class StructureNibiruIglooPieces
extends StructureComponent {
    private static final ResourceLocation IGLOO_TOP_ID = new ResourceLocation("moreplanets:nibiru_igloo/igloo_top");
    private static final ResourceLocation IGLOO_MIDDLE_ID = new ResourceLocation("moreplanets:nibiru_igloo/igloo_middle");
    private static final ResourceLocation IGLOO_BOTTOM_ID = new ResourceLocation("moreplanets:nibiru_igloo/igloo_bottom");
    protected int width;
    protected int height;
    protected int depth;
    protected int horizontalPos = -1;

    public StructureNibiruIglooPieces() {
    }

    public StructureNibiruIglooPieces(Random rand, int x, int z) {
        this(rand, x, 64, z, 7, 5, 8);
    }

    protected StructureNibiruIglooPieces(Random rand, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        super(0);
        this.width = sizeX;
        this.height = sizeY;
        this.depth = sizeZ;
        this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, y, z, x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1) : new StructureBoundingBox(x, y, z, x + sizeZ - 1, y + sizeY - 1, z + sizeX - 1);
    }

    protected void func_143012_a(NBTTagCompound nbt) {
        nbt.func_74768_a("Width", this.width);
        nbt.func_74768_a("Height", this.height);
        nbt.func_74768_a("Depth", this.depth);
        nbt.func_74768_a("HPos", this.horizontalPos);
    }

    protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
        this.width = nbt.func_74762_e("Width");
        this.height = nbt.func_74762_e("Height");
        this.depth = nbt.func_74762_e("Depth");
        this.horizontalPos = nbt.func_74762_e("HPos");
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox structureBoundingBox) {
        if (!this.offsetToAverageGroundLevel(world, structureBoundingBox, -1)) {
            return false;
        }
        StructureBoundingBox box = this.func_74874_b();
        BlockPos pos = new BlockPos(box.field_78897_a, box.field_78895_b, box.field_78896_c);
        Rotation[] arotation = CachedEnum.rotationValues;
        MinecraftServer server = world.func_73046_m();
        TemplateManager manager = world.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(arotation[rand.nextInt(arotation.length)]).func_186225_a(Blocks.field_189881_dj).func_186223_a(box);
        Template template = manager.func_186237_a(server, IGLOO_TOP_ID);
        template.func_186260_a(world, pos, settings);
        if (rand.nextDouble() < 0.5) {
            Template template1 = manager.func_186237_a(server, IGLOO_MIDDLE_ID);
            Template template2 = manager.func_186237_a(server, IGLOO_BOTTOM_ID);
            int i = rand.nextInt(8) + 4;
            for (int j = 0; j < i; ++j) {
                BlockPos blockpos1 = template.func_186262_a(settings, new BlockPos(3, -1 - j * 3, 5), settings, new BlockPos(1, 2, 1));
                template1.func_186260_a(world, pos.func_177971_a((Vec3i)blockpos1), settings);
            }
            BlockPos blockpos4 = pos.func_177971_a((Vec3i)template.func_186262_a(settings, new BlockPos(3, -1 - i * 3, 5), settings, new BlockPos(3, 5, 7)));
            template2.func_186260_a(world, blockpos4, settings);
            Map map = template2.func_186258_a(blockpos4, settings);
            for (Map.Entry entry : map.entrySet()) {
                if (!"chest".equals(entry.getValue())) continue;
                BlockPos blockpos2 = (BlockPos)entry.getKey();
                world.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
                TileEntity tile = world.func_175625_s(blockpos2.func_177977_b());
                if (!(tile instanceof TileEntityChestMP)) continue;
                ((TileEntityChestMP)tile).func_189404_a(MPLootTables.COMMON_SPACE_DUNGEON, rand.nextLong());
            }
        } else {
            BlockPos blockpos3 = Template.func_186266_a((PlacementSettings)settings, (BlockPos)new BlockPos(3, 0, 5));
            world.func_180501_a(pos.func_177971_a((Vec3i)blockpos3), MPBlocks.INFECTED_SNOW.func_176223_P(), 3);
        }
        return true;
    }

    protected boolean offsetToAverageGroundLevel(World world, StructureBoundingBox structurebb, int yOffset) {
        if (this.horizontalPos >= 0) {
            return true;
        }
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
            for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                mutablePos.func_181079_c(l, 64, k);
                if (!structurebb.func_175898_b((Vec3i)mutablePos)) continue;
                i += Math.max(world.func_175672_r((BlockPos)mutablePos).func_177956_o(), world.field_73011_w.func_76557_i());
                ++j;
            }
        }
        if (j == 0) {
            return false;
        }
        this.horizontalPos = i / j;
        this.field_74887_e.func_78886_a(0, this.horizontalPos - this.field_74887_e.field_78895_b + yOffset, 0);
        return true;
    }
}

