/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.world.gen.structure;

import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPLootTables;
import com.stevekung.moreplanets.utils.tileentity.TileEntityChestMP;
import java.util.Random;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public abstract class StructureNibiruJungleTemplePieces
extends StructureComponent {
    protected int scatteredFeatureSizeX;
    protected int scatteredFeatureSizeY;
    protected int scatteredFeatureSizeZ;
    protected int horizontalPos = -1;

    public StructureNibiruJungleTemplePieces() {
    }

    protected StructureNibiruJungleTemplePieces(Random rand, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        super(0);
        this.scatteredFeatureSizeX = sizeX;
        this.scatteredFeatureSizeY = sizeY;
        this.scatteredFeatureSizeZ = sizeZ;
        this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, y, z, x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1) : new StructureBoundingBox(x, y, z, x + sizeZ - 1, y + sizeY - 1, z + sizeX - 1);
    }

    protected boolean func_186167_a(World world, StructureBoundingBox box, Random rand, int x, int y, int z, ResourceLocation loot) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (box.func_175898_b((Vec3i)blockpos) && world.func_180495_p(blockpos).func_177230_c() != MPBlocks.INFECTED_CHEST) {
            IBlockState iblockstate = MPBlocks.INFECTED_CHEST.func_176223_P();
            world.func_180501_a(blockpos, MPBlocks.INFECTED_CHEST.correctFacing(world, blockpos, iblockstate), 2);
            TileEntity tileentity = world.func_175625_s(blockpos);
            if (tileentity instanceof TileEntityChestMP) {
                ((TileEntityChestMP)tileentity).func_189404_a(loot, rand.nextLong());
            }
            return true;
        }
        return false;
    }

    protected void func_143012_a(NBTTagCompound nbt) {
        nbt.func_74768_a("Width", this.scatteredFeatureSizeX);
        nbt.func_74768_a("Height", this.scatteredFeatureSizeY);
        nbt.func_74768_a("Depth", this.scatteredFeatureSizeZ);
        nbt.func_74768_a("HPos", this.horizontalPos);
    }

    protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
        this.scatteredFeatureSizeX = nbt.func_74762_e("Width");
        this.scatteredFeatureSizeY = nbt.func_74762_e("Height");
        this.scatteredFeatureSizeZ = nbt.func_74762_e("Depth");
        this.horizontalPos = nbt.func_74762_e("HPos");
    }

    protected boolean offsetToAverageGroundLevel(World world, StructureBoundingBox box, int yOffset) {
        if (this.horizontalPos >= 0) {
            return true;
        }
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
            for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                blockpos$mutableblockpos.func_181079_c(l, 64, k);
                if (!box.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                i += Math.max(world.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o(), world.field_73011_w.func_76557_i());
                ++j;
            }
        }
        if (j == 0) {
            return false;
        }
        this.horizontalPos = i / j;
        this.field_74887_e.func_78886_a(0, this.horizontalPos - this.field_74887_e.field_78895_b + yOffset, 0);
        return true;
    }

    public static class JungleTemple
    extends StructureNibiruJungleTemplePieces {
        private boolean placedMainChest;
        private boolean placedHiddenChest;
        private boolean hasRandomChest;
        private boolean placedTrap1;
        private boolean placedTrap2;
        private final Stones scatteredStones = new Stones();

        public JungleTemple() {
        }

        public JungleTemple(Random rand, int x, int z) {
            super(rand, x, 64, z, 12, 10, 15);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("placedMainChest", this.placedMainChest);
            nbt.func_74757_a("placedHiddenChest", this.placedHiddenChest);
            nbt.func_74757_a("placedRandomChest", this.hasRandomChest);
            nbt.func_74757_a("placedTrap1", this.placedTrap1);
            nbt.func_74757_a("placedTrap2", this.placedTrap2);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.placedMainChest = nbt.func_74767_n("placedMainChest");
            this.placedHiddenChest = nbt.func_74767_n("placedHiddenChest");
            this.hasRandomChest = nbt.func_74767_n("placedRandomChest");
            this.placedTrap1 = nbt.func_74767_n("placedTrap1");
            this.placedTrap2 = nbt.func_74767_n("placedTrap2");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.offsetToAverageGroundLevel(world, box, 0)) {
                return false;
            }
            this.func_74882_a(world, box, 0, -4, 0, this.scatteredFeatureSizeX - 1, 0, this.scatteredFeatureSizeZ - 1, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 2, 1, 2, 9, 2, 2, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 2, 1, 12, 9, 2, 12, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 2, 1, 3, 2, 2, 11, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 9, 1, 3, 9, 2, 11, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 1, 3, 1, 10, 6, 1, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 1, 3, 13, 10, 6, 13, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 1, 3, 2, 1, 6, 12, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 10, 3, 2, 10, 6, 12, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 2, 3, 2, 9, 3, 12, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 2, 6, 2, 9, 6, 12, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 3, 7, 3, 8, 7, 11, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 4, 8, 4, 7, 8, 10, false, rand, this.scatteredStones);
            this.func_74878_a(world, box, 3, 1, 3, 8, 2, 11);
            this.func_74878_a(world, box, 4, 3, 6, 7, 3, 9);
            this.func_74878_a(world, box, 2, 4, 2, 9, 5, 12);
            this.func_74878_a(world, box, 4, 6, 5, 7, 6, 9);
            this.func_74878_a(world, box, 5, 7, 6, 6, 7, 8);
            this.func_74878_a(world, box, 5, 1, 2, 6, 2, 2);
            this.func_74878_a(world, box, 5, 2, 12, 6, 2, 12);
            this.func_74878_a(world, box, 5, 5, 1, 6, 5, 1);
            this.func_74878_a(world, box, 5, 5, 13, 6, 5, 13);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 1, 5, 5, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 10, 5, 5, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 1, 5, 9, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 10, 5, 9, box);
            for (int i = 0; i <= 14; i += 14) {
                this.func_74882_a(world, box, 2, 4, i, 2, 5, i, false, rand, this.scatteredStones);
                this.func_74882_a(world, box, 4, 4, i, 4, 5, i, false, rand, this.scatteredStones);
                this.func_74882_a(world, box, 7, 4, i, 7, 5, i, false, rand, this.scatteredStones);
                this.func_74882_a(world, box, 9, 4, i, 9, 5, i, false, rand, this.scatteredStones);
            }
            this.func_74882_a(world, box, 5, 6, 0, 6, 6, 0, false, rand, this.scatteredStones);
            for (int l = 0; l <= 11; l += 11) {
                for (int j = 2; j <= 12; j += 2) {
                    this.func_74882_a(world, box, l, 4, j, l, 5, j, false, rand, this.scatteredStones);
                }
                this.func_74882_a(world, box, l, 6, 5, l, 6, 5, false, rand, this.scatteredStones);
                this.func_74882_a(world, box, l, 6, 9, l, 6, 9, false, rand, this.scatteredStones);
            }
            this.func_74882_a(world, box, 2, 7, 2, 2, 9, 2, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 9, 7, 2, 9, 9, 2, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 2, 7, 12, 2, 9, 12, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 9, 7, 12, 9, 9, 12, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 4, 9, 4, 4, 9, 4, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 7, 9, 4, 7, 9, 4, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 4, 9, 10, 4, 9, 10, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 7, 9, 10, 7, 9, 10, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 5, 9, 7, 6, 9, 7, false, rand, this.scatteredStones);
            IBlockState iblockstate2 = MPBlocks.NIBIRU_COBBLESTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate3 = MPBlocks.NIBIRU_COBBLESTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
            IBlockState iblockstate = MPBlocks.NIBIRU_COBBLESTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            IBlockState iblockstate1 = MPBlocks.NIBIRU_COBBLESTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            this.func_175811_a(world, iblockstate1, 5, 9, 6, box);
            this.func_175811_a(world, iblockstate1, 6, 9, 6, box);
            this.func_175811_a(world, iblockstate, 5, 9, 8, box);
            this.func_175811_a(world, iblockstate, 6, 9, 8, box);
            this.func_175811_a(world, iblockstate1, 4, 0, 0, box);
            this.func_175811_a(world, iblockstate1, 5, 0, 0, box);
            this.func_175811_a(world, iblockstate1, 6, 0, 0, box);
            this.func_175811_a(world, iblockstate1, 7, 0, 0, box);
            this.func_175811_a(world, iblockstate1, 4, 1, 8, box);
            this.func_175811_a(world, iblockstate1, 4, 2, 9, box);
            this.func_175811_a(world, iblockstate1, 4, 3, 10, box);
            this.func_175811_a(world, iblockstate1, 7, 1, 8, box);
            this.func_175811_a(world, iblockstate1, 7, 2, 9, box);
            this.func_175811_a(world, iblockstate1, 7, 3, 10, box);
            this.func_74882_a(world, box, 4, 1, 9, 4, 1, 9, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 7, 1, 9, 7, 1, 9, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 4, 1, 10, 7, 2, 10, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 5, 4, 5, 6, 4, 5, false, rand, this.scatteredStones);
            this.func_175811_a(world, iblockstate2, 4, 4, 5, box);
            this.func_175811_a(world, iblockstate3, 7, 4, 5, box);
            if (!this.hasRandomChest && rand.nextBoolean()) {
                this.func_186167_a(world, box, rand, 6, 5, 5, MPLootTables.NIBIRU_JUNGLE_TEMPLE);
                this.func_186167_a(world, box, rand, 5, 5, 5, MPLootTables.NIBIRU_JUNGLE_TEMPLE);
                this.hasRandomChest = true;
            }
            this.func_175811_a(world, rand.nextBoolean() ? MPBlocks.MULTALIC_CRYSTAL_BLOCK.func_176223_P() : Blocks.field_150350_a.func_176223_P(), 6, 10, 7, box);
            this.func_175811_a(world, rand.nextBoolean() ? MPBlocks.MULTALIC_CRYSTAL_BLOCK.func_176223_P() : Blocks.field_150350_a.func_176223_P(), 5, 10, 7, box);
            for (int k = 0; k < 4; ++k) {
                this.func_175811_a(world, iblockstate, 5, -k, 6 + k, box);
                this.func_175811_a(world, iblockstate, 6, -k, 6 + k, box);
                this.func_74878_a(world, box, 5, -k, 7 + k, 6, -k, 9 + k);
            }
            this.func_74878_a(world, box, 1, -3, 12, 10, -1, 13);
            this.func_74878_a(world, box, 1, -3, 1, 3, -1, 13);
            this.func_74878_a(world, box, 1, -3, 1, 9, -1, 5);
            for (int i1 = 1; i1 <= 13; i1 += 2) {
                this.func_74882_a(world, box, 1, -3, i1, 1, -2, i1, false, rand, this.scatteredStones);
            }
            for (int j1 = 2; j1 <= 12; j1 += 2) {
                this.func_74882_a(world, box, 1, -1, j1, 3, -1, j1, false, rand, this.scatteredStones);
            }
            this.func_74882_a(world, box, 2, -2, 1, 5, -2, 1, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 7, -2, 1, 9, -2, 1, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 6, -3, 1, 6, -3, 1, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 6, -1, 1, 6, -1, 1, false, rand, this.scatteredStones);
            this.func_175811_a(world, Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.valueOf(true)), 1, -3, 8, box);
            this.func_175811_a(world, Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.valueOf(true)), 4, -3, 8, box);
            this.func_175811_a(world, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 2, -3, 8, box);
            this.func_175811_a(world, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 3, -3, 8, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 5, -3, 7, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 5, -3, 6, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 5, -3, 5, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 5, -3, 4, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 5, -3, 3, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 5, -3, 2, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 5, -3, 1, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 4, -3, 1, box);
            this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 3, -3, 1, box);
            if (!this.placedTrap1) {
                this.placedTrap1 = this.func_189419_a(world, box, rand, 3, -2, 1, EnumFacing.NORTH, MPLootTables.NIBIRU_JUNGLE_TEMPLE_DISPENSER);
            }
            this.func_175811_a(world, MPBlocks.INFECTED_VINES.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true)), 3, -2, 2, box);
            this.func_175811_a(world, Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.valueOf(true)), 7, -3, 1, box);
            this.func_175811_a(world, Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockTripWireHook.field_176265_M, (Comparable)Boolean.valueOf(true)), 7, -3, 5, box);
            this.func_175811_a(world, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 7, -3, 2, box);
            this.func_175811_a(world, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 7, -3, 3, box);
            this.func_175811_a(world, Blocks.field_150473_bD.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(true)), 7, -3, 4, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 8, -3, 6, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 9, -3, 6, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 9, -3, 5, box);
            this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 9, -3, 4, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 9, -2, 4, box);
            if (!this.placedTrap2) {
                this.placedTrap2 = this.func_189419_a(world, box, rand, 9, -2, 3, EnumFacing.WEST, MPLootTables.NIBIRU_JUNGLE_TEMPLE_DISPENSER);
            }
            this.func_175811_a(world, MPBlocks.INFECTED_VINES.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)), 8, -1, 3, box);
            this.func_175811_a(world, MPBlocks.INFECTED_VINES.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)), 8, -2, 3, box);
            if (!this.placedMainChest) {
                this.placedMainChest = this.func_186167_a(world, box, rand, 8, -3, 3, MPLootTables.NIBIRU_JUNGLE_TEMPLE);
            }
            this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 9, -3, 2, box);
            this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 8, -3, 1, box);
            this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 4, -3, 5, box);
            this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 5, -2, 5, box);
            this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 5, -1, 5, box);
            this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 6, -3, 5, box);
            this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 7, -2, 5, box);
            this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 7, -1, 5, box);
            this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 8, -3, 5, box);
            this.func_74882_a(world, box, 9, -1, 1, 9, -1, 5, false, rand, this.scatteredStones);
            this.func_74878_a(world, box, 8, -3, 8, 10, -1, 10);
            this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_STONE_BRICKS.func_176223_P(), 8, -2, 11, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_STONE_BRICKS.func_176223_P(), 9, -2, 11, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_STONE_BRICKS.func_176223_P(), 10, -2, 11, box);
            IBlockState iblockstate4 = Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.NORTH);
            this.func_175811_a(world, iblockstate4, 8, -2, 12, box);
            this.func_175811_a(world, iblockstate4, 9, -2, 12, box);
            this.func_175811_a(world, iblockstate4, 10, -2, 12, box);
            this.func_74882_a(world, box, 8, -3, 8, 8, -3, 10, false, rand, this.scatteredStones);
            this.func_74882_a(world, box, 10, -3, 8, 10, -3, 10, false, rand, this.scatteredStones);
            this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 10, -2, 9, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 8, -2, 9, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 8, -2, 10, box);
            this.func_175811_a(world, Blocks.field_150488_af.func_176223_P(), 10, -1, 9, box);
            this.func_175811_a(world, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.UP), 9, -2, 8, box);
            this.func_175811_a(world, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.WEST), 10, -2, 8, box);
            this.func_175811_a(world, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.WEST), 10, -1, 8, box);
            this.func_175811_a(world, Blocks.field_150413_aR.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH), 10, -2, 10, box);
            if (!this.placedHiddenChest) {
                this.placedHiddenChest = this.func_186167_a(world, box, rand, 9, -3, 10, MPLootTables.NIBIRU_JUNGLE_TEMPLE);
            }
            return true;
        }

        static class Stones
        extends StructureComponent.BlockSelector {
            private Stones() {
            }

            public void func_75062_a(Random rand, int x, int y, int z, boolean wall) {
                this.field_151562_a = rand.nextFloat() < 0.01f ? Blocks.field_150321_G.func_176223_P() : (rand.nextFloat() < 0.05f ? Blocks.field_150350_a.func_176223_P() : (rand.nextFloat() < 0.4f ? MPBlocks.NIBIRU_COBBLESTONE.func_176223_P() : MPBlocks.NIBIRU_VEIN_COBBLESTONE.func_176223_P()));
            }
        }
    }
}

