/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.world.gen.structure;

import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.planets.nibiru.entity.EntityInfectedElderGuardian;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class StructureNibiruOceanMonumentPieces {
    public static void registerOceanMonumentPieces() {
        MapGenStructureIO.func_143031_a(MonumentBuilding.class, (String)"NibiruOMB");
        MapGenStructureIO.func_143031_a(MonumentCoreRoom.class, (String)"NibiruOMCR");
        MapGenStructureIO.func_143031_a(DoubleXRoom.class, (String)"NibiruOMDXR");
        MapGenStructureIO.func_143031_a(DoubleXYRoom.class, (String)"NibiruOMDXYR");
        MapGenStructureIO.func_143031_a(DoubleYRoom.class, (String)"NibiruOMDYR");
        MapGenStructureIO.func_143031_a(DoubleYZRoom.class, (String)"NibiruOMDYZR");
        MapGenStructureIO.func_143031_a(DoubleZRoom.class, (String)"NibiruOMDZR");
        MapGenStructureIO.func_143031_a(EntryRoom.class, (String)"NibiruOMEntry");
        MapGenStructureIO.func_143031_a(Penthouse.class, (String)"NibiruOMPenthouse");
        MapGenStructureIO.func_143031_a(SimpleRoom.class, (String)"NibiruOMSimple");
        MapGenStructureIO.func_143031_a(SimpleTopRoom.class, (String)"NibiruOMSimpleT");
    }

    static class ZDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private ZDoubleRoomFitHelper() {
        }

        @Override
        public boolean fits(RoomDefinition definition) {
            return definition.hasOpening[EnumFacing.NORTH.func_176745_a()] && !definition.connections[EnumFacing.NORTH.func_176745_a()].claimed;
        }

        @Override
        public Piece create(EnumFacing facing, RoomDefinition room) {
            RoomDefinition roomdefinition = room;
            if (!room.hasOpening[EnumFacing.NORTH.func_176745_a()] || room.connections[EnumFacing.NORTH.func_176745_a()].claimed) {
                roomdefinition = room.connections[EnumFacing.SOUTH.func_176745_a()];
            }
            roomdefinition.claimed = true;
            roomdefinition.connections[EnumFacing.NORTH.func_176745_a()].claimed = true;
            return new DoubleZRoom(facing, roomdefinition);
        }
    }

    static class YZDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private YZDoubleRoomFitHelper() {
        }

        @Override
        public boolean fits(RoomDefinition definition) {
            if (definition.hasOpening[EnumFacing.NORTH.func_176745_a()] && !definition.connections[EnumFacing.NORTH.func_176745_a()].claimed && definition.hasOpening[EnumFacing.UP.func_176745_a()] && !definition.connections[EnumFacing.UP.func_176745_a()].claimed) {
                RoomDefinition roomdefinition = definition.connections[EnumFacing.NORTH.func_176745_a()];
                return roomdefinition.hasOpening[EnumFacing.UP.func_176745_a()] && !roomdefinition.connections[EnumFacing.UP.func_176745_a()].claimed;
            }
            return false;
        }

        @Override
        public Piece create(EnumFacing facing, RoomDefinition room) {
            room.claimed = true;
            room.connections[EnumFacing.NORTH.func_176745_a()].claimed = true;
            room.connections[EnumFacing.UP.func_176745_a()].claimed = true;
            room.connections[EnumFacing.NORTH.func_176745_a()].connections[EnumFacing.UP.func_176745_a()].claimed = true;
            return new DoubleYZRoom(facing, room);
        }
    }

    static class YDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private YDoubleRoomFitHelper() {
        }

        @Override
        public boolean fits(RoomDefinition room) {
            return room.hasOpening[EnumFacing.UP.func_176745_a()] && !room.connections[EnumFacing.UP.func_176745_a()].claimed;
        }

        @Override
        public Piece create(EnumFacing facing, RoomDefinition room) {
            room.claimed = true;
            room.connections[EnumFacing.UP.func_176745_a()].claimed = true;
            return new DoubleYRoom(facing, room);
        }
    }

    static class XYDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private XYDoubleRoomFitHelper() {
        }

        @Override
        public boolean fits(RoomDefinition room) {
            if (room.hasOpening[EnumFacing.EAST.func_176745_a()] && !room.connections[EnumFacing.EAST.func_176745_a()].claimed && room.hasOpening[EnumFacing.UP.func_176745_a()] && !room.connections[EnumFacing.UP.func_176745_a()].claimed) {
                RoomDefinition definition = room.connections[EnumFacing.EAST.func_176745_a()];
                return definition.hasOpening[EnumFacing.UP.func_176745_a()] && !definition.connections[EnumFacing.UP.func_176745_a()].claimed;
            }
            return false;
        }

        @Override
        public Piece create(EnumFacing facing, RoomDefinition room) {
            room.claimed = true;
            room.connections[EnumFacing.EAST.func_176745_a()].claimed = true;
            room.connections[EnumFacing.UP.func_176745_a()].claimed = true;
            room.connections[EnumFacing.EAST.func_176745_a()].connections[EnumFacing.UP.func_176745_a()].claimed = true;
            return new DoubleXYRoom(facing, room);
        }
    }

    static class XDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private XDoubleRoomFitHelper() {
        }

        @Override
        public boolean fits(RoomDefinition room) {
            return room.hasOpening[EnumFacing.EAST.func_176745_a()] && !room.connections[EnumFacing.EAST.func_176745_a()].claimed;
        }

        @Override
        public Piece create(EnumFacing facing, RoomDefinition room) {
            room.claimed = true;
            room.connections[EnumFacing.EAST.func_176745_a()].claimed = true;
            return new DoubleXRoom(facing, room);
        }
    }

    public static class WingRoom
    extends Piece {
        private int mainDesign;

        public WingRoom() {
        }

        public WingRoom(EnumFacing facing, StructureBoundingBox box, int type) {
            super(facing, box);
            this.mainDesign = type & 1;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.mainDesign == 0) {
                for (int i = 0; i < 4; ++i) {
                    this.func_175804_a(world, box, 10 - i, 3 - i, 20 - i, 12 + i, 3 - i, 20, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                this.func_175804_a(world, box, 7, 0, 6, 15, 0, 16, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 6, 0, 6, 6, 3, 20, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 16, 0, 6, 16, 3, 20, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 7, 1, 7, 7, 1, 20, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 15, 1, 7, 15, 1, 20, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 7, 1, 6, 9, 3, 6, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 13, 1, 6, 15, 3, 6, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 8, 1, 7, 9, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 13, 1, 7, 14, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 9, 0, 5, 13, 0, 5, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 10, 0, 7, 12, 0, 7, this.darkPrismarine, this.darkPrismarine, false);
                this.func_175804_a(world, box, 8, 0, 10, 8, 0, 12, this.darkPrismarine, this.darkPrismarine, false);
                this.func_175804_a(world, box, 14, 0, 10, 14, 0, 12, this.darkPrismarine, this.darkPrismarine, false);
                for (int i1 = 18; i1 >= 7; i1 -= 3) {
                    this.func_175811_a(world, this.seaLantern, 6, 3, i1, box);
                    this.func_175811_a(world, this.seaLantern, 16, 3, i1, box);
                }
                this.func_175811_a(world, this.seaLantern, 10, 0, 10, box);
                this.func_175811_a(world, this.seaLantern, 12, 0, 10, box);
                this.func_175811_a(world, this.seaLantern, 10, 0, 12, box);
                this.func_175811_a(world, this.seaLantern, 12, 0, 12, box);
                this.func_175811_a(world, this.seaLantern, 8, 3, 6, box);
                this.func_175811_a(world, this.seaLantern, 14, 3, 6, box);
                this.func_175811_a(world, this.bricksPrismarine, 4, 2, 4, box);
                this.func_175811_a(world, this.seaLantern, 4, 1, 4, box);
                this.func_175811_a(world, this.bricksPrismarine, 4, 0, 4, box);
                this.func_175811_a(world, this.bricksPrismarine, 18, 2, 4, box);
                this.func_175811_a(world, this.seaLantern, 18, 1, 4, box);
                this.func_175811_a(world, this.bricksPrismarine, 18, 0, 4, box);
                this.func_175811_a(world, this.bricksPrismarine, 4, 2, 18, box);
                this.func_175811_a(world, this.seaLantern, 4, 1, 18, box);
                this.func_175811_a(world, this.bricksPrismarine, 4, 0, 18, box);
                this.func_175811_a(world, this.bricksPrismarine, 18, 2, 18, box);
                this.func_175811_a(world, this.seaLantern, 18, 1, 18, box);
                this.func_175811_a(world, this.bricksPrismarine, 18, 0, 18, box);
                this.func_175811_a(world, this.bricksPrismarine, 9, 7, 20, box);
                this.func_175811_a(world, this.bricksPrismarine, 13, 7, 20, box);
                this.func_175804_a(world, box, 6, 0, 21, 7, 4, 21, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 15, 0, 21, 16, 4, 21, this.bricksPrismarine, this.bricksPrismarine, false);
                this.spawnElder(world, box, 11, 2, 16);
            } else if (this.mainDesign == 1) {
                this.func_175804_a(world, box, 9, 3, 18, 13, 3, 20, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 9, 0, 18, 9, 2, 18, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 13, 0, 18, 13, 2, 18, this.bricksPrismarine, this.bricksPrismarine, false);
                int j1 = 9;
                for (int l = 0; l < 2; ++l) {
                    this.func_175811_a(world, this.bricksPrismarine, j1, 6, 20, box);
                    this.func_175811_a(world, this.seaLantern, j1, 5, 20, box);
                    this.func_175811_a(world, this.bricksPrismarine, j1, 4, 20, box);
                    j1 = 13;
                }
                this.func_175804_a(world, box, 7, 3, 7, 15, 3, 14, this.bricksPrismarine, this.bricksPrismarine, false);
                j1 = 10;
                for (int k1 = 0; k1 < 2; ++k1) {
                    this.func_175804_a(world, box, j1, 0, 10, j1, 6, 10, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, j1, 0, 12, j1, 6, 12, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175811_a(world, this.seaLantern, j1, 0, 10, box);
                    this.func_175811_a(world, this.seaLantern, j1, 0, 12, box);
                    this.func_175811_a(world, this.seaLantern, j1, 4, 10, box);
                    this.func_175811_a(world, this.seaLantern, j1, 4, 12, box);
                    j1 = 12;
                }
                j1 = 8;
                for (int l1 = 0; l1 < 2; ++l1) {
                    this.func_175804_a(world, box, j1, 0, 7, j1, 2, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, j1, 0, 14, j1, 2, 14, this.bricksPrismarine, this.bricksPrismarine, false);
                    j1 = 14;
                }
                this.func_175804_a(world, box, 8, 3, 8, 8, 3, 13, this.darkPrismarine, this.darkPrismarine, false);
                this.func_175804_a(world, box, 14, 3, 8, 14, 3, 13, this.darkPrismarine, this.darkPrismarine, false);
                this.spawnElder(world, box, 11, 5, 13);
            }
            return true;
        }
    }

    public static class SimpleTopRoom
    extends Piece {
        public SimpleTopRoom() {
        }

        public SimpleTopRoom(EnumFacing facing, RoomDefinition room) {
            super(1, facing, room, 1, 1, 1);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(world, box, 0, 0, this.roomDefinition.hasOpening[EnumFacing.DOWN.func_176745_a()]);
            }
            if (this.roomDefinition.connections[EnumFacing.UP.func_176745_a()] == null) {
                this.generateBoxOnFillOnly(world, box, 1, 4, 1, 6, 4, 6, this.roughPrismarine);
            }
            for (int i = 1; i <= 6; ++i) {
                for (int j = 1; j <= 6; ++j) {
                    if (rand.nextInt(3) == 0) continue;
                    int k = 2 + (rand.nextInt(4) == 0 ? 0 : 1);
                    this.func_175804_a(world, box, i, k, j, i, 3, j, MPBlocks.INFECTED_WET_SPONGE.func_176223_P(), MPBlocks.INFECTED_WET_SPONGE.func_176223_P(), false);
                }
            }
            this.func_175804_a(world, box, 0, 1, 0, 0, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 7, 1, 0, 7, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 1, 0, 6, 1, 0, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 1, 7, 6, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 0, 2, 0, 0, 2, 7, this.darkPrismarine, this.darkPrismarine, false);
            this.func_175804_a(world, box, 7, 2, 0, 7, 2, 7, this.darkPrismarine, this.darkPrismarine, false);
            this.func_175804_a(world, box, 1, 2, 0, 6, 2, 0, this.darkPrismarine, this.darkPrismarine, false);
            this.func_175804_a(world, box, 1, 2, 7, 6, 2, 7, this.darkPrismarine, this.darkPrismarine, false);
            this.func_175804_a(world, box, 0, 3, 0, 0, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 7, 3, 0, 7, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 3, 0, 6, 3, 0, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 3, 7, 6, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 0, 1, 3, 0, 2, 4, this.darkPrismarine, this.darkPrismarine, false);
            this.func_175804_a(world, box, 7, 1, 3, 7, 2, 4, this.darkPrismarine, this.darkPrismarine, false);
            this.func_175804_a(world, box, 3, 1, 0, 4, 2, 0, this.darkPrismarine, this.darkPrismarine, false);
            this.func_175804_a(world, box, 3, 1, 7, 4, 2, 7, this.darkPrismarine, this.darkPrismarine, false);
            if (this.roomDefinition.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 1, 0, 4, 2, 0, false);
            }
            return true;
        }
    }

    public static class SimpleRoom
    extends Piece {
        private int mainDesign;

        public SimpleRoom() {
        }

        public SimpleRoom(EnumFacing facing, RoomDefinition room) {
            super(1, facing, room, 1, 1, 1);
            this.mainDesign = new Random().nextInt(3);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            boolean flag;
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(world, box, 0, 0, this.roomDefinition.hasOpening[EnumFacing.DOWN.func_176745_a()]);
            }
            if (this.roomDefinition.connections[EnumFacing.UP.func_176745_a()] == null) {
                this.generateBoxOnFillOnly(world, box, 1, 4, 1, 6, 4, 6, this.roughPrismarine);
            }
            boolean bl = flag = this.mainDesign != 0 && rand.nextBoolean() && !this.roomDefinition.hasOpening[EnumFacing.DOWN.func_176745_a()] && !this.roomDefinition.hasOpening[EnumFacing.UP.func_176745_a()] && this.roomDefinition.countOpenings() > 1;
            if (this.mainDesign == 0) {
                this.func_175804_a(world, box, 0, 1, 0, 2, 1, 2, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 0, 3, 0, 2, 3, 2, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 0, 2, 0, 0, 2, 2, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 1, 2, 0, 2, 2, 0, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175811_a(world, this.seaLantern, 1, 2, 1, box);
                this.func_175804_a(world, box, 5, 1, 0, 7, 1, 2, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 5, 3, 0, 7, 3, 2, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 7, 2, 0, 7, 2, 2, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 5, 2, 0, 6, 2, 0, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175811_a(world, this.seaLantern, 6, 2, 1, box);
                this.func_175804_a(world, box, 0, 1, 5, 2, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 0, 3, 5, 2, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 0, 2, 5, 0, 2, 7, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 1, 2, 7, 2, 2, 7, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175811_a(world, this.seaLantern, 1, 2, 6, box);
                this.func_175804_a(world, box, 5, 1, 5, 7, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 5, 3, 5, 7, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 7, 2, 5, 7, 2, 7, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 5, 2, 7, 6, 2, 7, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175811_a(world, this.seaLantern, 6, 2, 6, box);
                if (this.roomDefinition.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                    this.func_175804_a(world, box, 3, 3, 0, 4, 3, 0, this.bricksPrismarine, this.bricksPrismarine, false);
                } else {
                    this.func_175804_a(world, box, 3, 3, 0, 4, 3, 1, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 3, 2, 0, 4, 2, 0, this.roughPrismarine, this.roughPrismarine, false);
                    this.func_175804_a(world, box, 3, 1, 0, 4, 1, 1, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                if (this.roomDefinition.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                    this.func_175804_a(world, box, 3, 3, 7, 4, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                } else {
                    this.func_175804_a(world, box, 3, 3, 6, 4, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 3, 2, 7, 4, 2, 7, this.roughPrismarine, this.roughPrismarine, false);
                    this.func_175804_a(world, box, 3, 1, 6, 4, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                if (this.roomDefinition.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                    this.func_175804_a(world, box, 0, 3, 3, 0, 3, 4, this.bricksPrismarine, this.bricksPrismarine, false);
                } else {
                    this.func_175804_a(world, box, 0, 3, 3, 1, 3, 4, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 0, 2, 3, 0, 2, 4, this.roughPrismarine, this.roughPrismarine, false);
                    this.func_175804_a(world, box, 0, 1, 3, 1, 1, 4, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                if (this.roomDefinition.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                    this.func_175804_a(world, box, 7, 3, 3, 7, 3, 4, this.bricksPrismarine, this.bricksPrismarine, false);
                } else {
                    this.func_175804_a(world, box, 6, 3, 3, 7, 3, 4, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 7, 2, 3, 7, 2, 4, this.roughPrismarine, this.roughPrismarine, false);
                    this.func_175804_a(world, box, 6, 1, 3, 7, 1, 4, this.bricksPrismarine, this.bricksPrismarine, false);
                }
            } else if (this.mainDesign == 1) {
                this.func_175804_a(world, box, 2, 1, 2, 2, 3, 2, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 2, 1, 5, 2, 3, 5, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 5, 1, 5, 5, 3, 5, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 5, 1, 2, 5, 3, 2, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175811_a(world, this.seaLantern, 2, 2, 2, box);
                this.func_175811_a(world, this.seaLantern, 2, 2, 5, box);
                this.func_175811_a(world, this.seaLantern, 5, 2, 5, box);
                this.func_175811_a(world, this.seaLantern, 5, 2, 2, box);
                this.func_175804_a(world, box, 0, 1, 0, 1, 3, 0, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 0, 1, 1, 0, 3, 1, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 0, 1, 7, 1, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 0, 1, 6, 0, 3, 6, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 6, 1, 7, 7, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 7, 1, 6, 7, 3, 6, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 6, 1, 0, 7, 3, 0, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 7, 1, 1, 7, 3, 1, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175811_a(world, this.roughPrismarine, 1, 2, 0, box);
                this.func_175811_a(world, this.roughPrismarine, 0, 2, 1, box);
                this.func_175811_a(world, this.roughPrismarine, 1, 2, 7, box);
                this.func_175811_a(world, this.roughPrismarine, 0, 2, 6, box);
                this.func_175811_a(world, this.roughPrismarine, 6, 2, 7, box);
                this.func_175811_a(world, this.roughPrismarine, 7, 2, 6, box);
                this.func_175811_a(world, this.roughPrismarine, 6, 2, 0, box);
                this.func_175811_a(world, this.roughPrismarine, 7, 2, 1, box);
                if (!this.roomDefinition.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                    this.func_175804_a(world, box, 1, 3, 0, 6, 3, 0, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 1, 2, 0, 6, 2, 0, this.roughPrismarine, this.roughPrismarine, false);
                    this.func_175804_a(world, box, 1, 1, 0, 6, 1, 0, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                if (!this.roomDefinition.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                    this.func_175804_a(world, box, 1, 3, 7, 6, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 1, 2, 7, 6, 2, 7, this.roughPrismarine, this.roughPrismarine, false);
                    this.func_175804_a(world, box, 1, 1, 7, 6, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                if (!this.roomDefinition.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                    this.func_175804_a(world, box, 0, 3, 1, 0, 3, 6, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 0, 2, 1, 0, 2, 6, this.roughPrismarine, this.roughPrismarine, false);
                    this.func_175804_a(world, box, 0, 1, 1, 0, 1, 6, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                if (!this.roomDefinition.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                    this.func_175804_a(world, box, 7, 3, 1, 7, 3, 6, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 7, 2, 1, 7, 2, 6, this.roughPrismarine, this.roughPrismarine, false);
                    this.func_175804_a(world, box, 7, 1, 1, 7, 1, 6, this.bricksPrismarine, this.bricksPrismarine, false);
                }
            } else if (this.mainDesign == 2) {
                this.func_175804_a(world, box, 0, 1, 0, 0, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 7, 1, 0, 7, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 1, 1, 0, 6, 1, 0, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 1, 1, 7, 6, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 0, 2, 0, 0, 2, 7, this.darkPrismarine, this.darkPrismarine, false);
                this.func_175804_a(world, box, 7, 2, 0, 7, 2, 7, this.darkPrismarine, this.darkPrismarine, false);
                this.func_175804_a(world, box, 1, 2, 0, 6, 2, 0, this.darkPrismarine, this.darkPrismarine, false);
                this.func_175804_a(world, box, 1, 2, 7, 6, 2, 7, this.darkPrismarine, this.darkPrismarine, false);
                this.func_175804_a(world, box, 0, 3, 0, 0, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 7, 3, 0, 7, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 1, 3, 0, 6, 3, 0, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 1, 3, 7, 6, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 0, 1, 3, 0, 2, 4, this.darkPrismarine, this.darkPrismarine, false);
                this.func_175804_a(world, box, 7, 1, 3, 7, 2, 4, this.darkPrismarine, this.darkPrismarine, false);
                this.func_175804_a(world, box, 3, 1, 0, 4, 2, 0, this.darkPrismarine, this.darkPrismarine, false);
                this.func_175804_a(world, box, 3, 1, 7, 4, 2, 7, this.darkPrismarine, this.darkPrismarine, false);
                if (this.roomDefinition.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                    this.generateWaterBox(world, box, 3, 1, 0, 4, 2, 0, false);
                }
                if (this.roomDefinition.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                    this.generateWaterBox(world, box, 3, 1, 7, 4, 2, 7, false);
                }
                if (this.roomDefinition.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                    this.generateWaterBox(world, box, 0, 1, 3, 0, 2, 4, false);
                }
                if (this.roomDefinition.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                    this.generateWaterBox(world, box, 7, 1, 3, 7, 2, 4, false);
                }
            }
            if (flag) {
                this.func_175804_a(world, box, 3, 1, 3, 4, 1, 4, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 3, 2, 3, 4, 2, 4, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 3, 3, 3, 4, 3, 4, this.bricksPrismarine, this.bricksPrismarine, false);
            }
            return true;
        }
    }

    public static class RoomDefinition {
        final int index;
        final RoomDefinition[] connections = new RoomDefinition[6];
        final boolean[] hasOpening = new boolean[6];
        boolean claimed;
        boolean isSource;
        int scanIndex;

        public RoomDefinition(int index) {
            this.index = index;
        }

        public void setConnection(EnumFacing facing, RoomDefinition room) {
            this.connections[facing.func_176745_a()] = room;
            room.connections[facing.func_176734_d().func_176745_a()] = this;
        }

        public void updateOpenings() {
            for (int i = 0; i < 6; ++i) {
                this.hasOpening[i] = this.connections[i] != null;
            }
        }

        public boolean findSource(int index) {
            if (this.isSource) {
                return true;
            }
            this.scanIndex = index;
            for (int i = 0; i < 6; ++i) {
                if (this.connections[i] == null || !this.hasOpening[i] || this.connections[i].scanIndex == index || !this.connections[i].findSource(index)) continue;
                return true;
            }
            return false;
        }

        public boolean isSpecial() {
            return this.index >= 75;
        }

        public int countOpenings() {
            int i = 0;
            for (int j = 0; j < 6; ++j) {
                if (!this.hasOpening[j]) continue;
                ++i;
            }
            return i;
        }
    }

    public static abstract class Piece
    extends StructureComponent {
        protected final IBlockState roughPrismarine = MPBlocks.INFECTED_PRISMARINE.func_176223_P();
        protected final IBlockState bricksPrismarine = MPBlocks.INFECTED_PRISMARINE_BRICKS.func_176223_P();
        protected final IBlockState darkPrismarine = MPBlocks.INFECTED_DARK_PRISMARINE.func_176223_P();
        protected final IBlockState seaLantern = MPBlocks.INFECTED_SEA_LANTERN.func_176223_P();
        protected final IBlockState water = MPBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P();
        protected final int gridroomSourceIndex = Piece.getRoomIndex(2, 0, 0);
        protected final int gridroomTopConnectIndex = Piece.getRoomIndex(2, 2, 0);
        protected final int gridroomLeftwingConnectIndex = Piece.getRoomIndex(0, 1, 0);
        protected final int gridroomRightwingConnectIndex = Piece.getRoomIndex(4, 1, 0);
        protected RoomDefinition roomDefinition;

        protected static int getRoomIndex(int x, int y, int z) {
            return y * 25 + z * 5 + x;
        }

        public Piece() {
            super(0);
        }

        public Piece(int type) {
            super(type);
        }

        public Piece(EnumFacing facing, StructureBoundingBox box) {
            super(1);
            this.func_186164_a(facing);
            this.field_74887_e = box;
        }

        protected Piece(int type, EnumFacing facing, RoomDefinition room, int x, int y, int z) {
            super(type);
            this.func_186164_a(facing);
            this.roomDefinition = room;
            int i = room.index;
            int j = i % 5;
            int k = i / 5 % 5;
            int l = i / 25;
            this.field_74887_e = facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH ? new StructureBoundingBox(0, 0, 0, z * 8 - 1, y * 4 - 1, x * 8 - 1) : new StructureBoundingBox(0, 0, 0, x * 8 - 1, y * 4 - 1, z * 8 - 1);
            switch (facing) {
                case NORTH: {
                    this.field_74887_e.func_78886_a(j * 8, l * 4, -(k + z) * 8 + 1);
                    break;
                }
                case SOUTH: {
                    this.field_74887_e.func_78886_a(j * 8, l * 4, k * 8);
                    break;
                }
                case WEST: {
                    this.field_74887_e.func_78886_a(-(k + z) * 8 + 1, l * 4, j * 8);
                    break;
                }
                default: {
                    this.field_74887_e.func_78886_a(k * 8, l * 4, j * 8);
                }
            }
        }

        protected void func_143012_a(NBTTagCompound nbt) {
        }

        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
        }

        protected void generateWaterBox(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean isAir) {
            for (int i = minY; i <= maxY; ++i) {
                for (int j = minX; j <= maxX; ++j) {
                    for (int k = minZ; k <= maxZ; ++k) {
                        if (isAir && this.func_175807_a(world, j, i, k, box).func_185904_a() == Material.field_151579_a) continue;
                        if (this.func_74862_a(i) >= world.func_181545_F()) {
                            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), j, i, k, box);
                            continue;
                        }
                        this.func_175811_a(world, this.water, j, i, k, box);
                    }
                }
            }
        }

        protected void generateDefaultFloor(World world, StructureBoundingBox box, int x, int z, boolean open) {
            if (open) {
                this.func_175804_a(world, box, x, 0, z, x + 2, 0, z + 8 - 1, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, x + 5, 0, z, x + 8 - 1, 0, z + 8 - 1, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, x + 3, 0, z, x + 4, 0, z + 2, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, x + 3, 0, z + 5, x + 4, 0, z + 8 - 1, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, x + 3, 0, z + 2, x + 4, 0, z + 2, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, x + 3, 0, z + 5, x + 4, 0, z + 5, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, x + 2, 0, z + 3, x + 2, 0, z + 4, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, x + 5, 0, z + 3, x + 5, 0, z + 4, this.bricksPrismarine, this.bricksPrismarine, false);
            } else {
                this.func_175804_a(world, box, x, 0, z, x + 8 - 1, 0, z + 8 - 1, this.roughPrismarine, this.roughPrismarine, false);
            }
        }

        protected void generateBoxOnFillOnly(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockState state) {
            for (int i = minY; i <= maxY; ++i) {
                for (int j = minX; j <= maxX; ++j) {
                    for (int k = minZ; k <= maxZ; ++k) {
                        if (this.func_175807_a(world, j, i, k, box) != this.water) continue;
                        this.func_175811_a(world, state, j, i, k, box);
                    }
                }
            }
        }

        protected boolean doesChunkIntersect(StructureBoundingBox box, int minX, int minZ, int maxX, int maxZ) {
            int i = this.func_74865_a(minX, minZ);
            int j = this.func_74873_b(minX, minZ);
            int k = this.func_74865_a(maxX, maxZ);
            int l = this.func_74873_b(maxX, maxZ);
            return box.func_78885_a(Math.min(i, k), Math.min(j, l), Math.max(i, k), Math.max(j, l));
        }

        protected boolean spawnElder(World world, StructureBoundingBox box, int x, int y, int z) {
            int k;
            int j;
            int i = this.func_74865_a(x, z);
            if (box.func_175898_b((Vec3i)new BlockPos(i, j = this.func_74862_a(y), k = this.func_74873_b(x, z)))) {
                EntityInfectedElderGuardian entityguardian = new EntityInfectedElderGuardian(world);
                entityguardian.func_70691_i(entityguardian.func_110138_aP());
                entityguardian.func_70012_b((double)i + 0.5, j, (double)k + 0.5, 0.0f, 0.0f);
                entityguardian.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityguardian)), null);
                world.func_72838_d((Entity)entityguardian);
                return true;
            }
            return false;
        }
    }

    public static class Penthouse
    extends Piece {
        public Penthouse() {
        }

        public Penthouse(EnumFacing facing, StructureBoundingBox box) {
            super(facing, box);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            this.func_175804_a(world, box, 2, -1, 2, 11, -1, 11, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 0, -1, 0, 1, -1, 11, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 12, -1, 0, 13, -1, 11, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 2, -1, 0, 11, -1, 1, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 2, -1, 12, 11, -1, 13, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 0, 0, 0, 0, 0, 13, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 13, 0, 0, 13, 0, 13, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 0, 0, 12, 0, 0, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 0, 13, 12, 0, 13, this.bricksPrismarine, this.bricksPrismarine, false);
            for (int i = 2; i <= 11; i += 3) {
                this.func_175811_a(world, this.seaLantern, 0, 0, i, box);
                this.func_175811_a(world, this.seaLantern, 13, 0, i, box);
                this.func_175811_a(world, this.seaLantern, i, 0, 0, box);
            }
            this.func_175804_a(world, box, 2, 0, 3, 4, 0, 9, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 9, 0, 3, 11, 0, 9, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 4, 0, 9, 9, 0, 11, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175811_a(world, this.bricksPrismarine, 5, 0, 8, box);
            this.func_175811_a(world, this.bricksPrismarine, 8, 0, 8, box);
            this.func_175811_a(world, this.bricksPrismarine, 10, 0, 10, box);
            this.func_175811_a(world, this.bricksPrismarine, 3, 0, 10, box);
            this.func_175804_a(world, box, 3, 0, 3, 3, 0, 7, this.darkPrismarine, this.darkPrismarine, false);
            this.func_175804_a(world, box, 10, 0, 3, 10, 0, 7, this.darkPrismarine, this.darkPrismarine, false);
            this.func_175804_a(world, box, 6, 0, 10, 7, 0, 10, this.darkPrismarine, this.darkPrismarine, false);
            int l = 3;
            for (int j = 0; j < 2; ++j) {
                for (int k = 2; k <= 8; k += 3) {
                    this.func_175804_a(world, box, l, 0, k, l, 2, k, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                l = 10;
            }
            this.func_175804_a(world, box, 5, 0, 10, 5, 2, 10, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 8, 0, 10, 8, 2, 10, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 6, -1, 7, 7, -1, 8, this.darkPrismarine, this.darkPrismarine, false);
            this.generateWaterBox(world, box, 6, -1, 3, 7, -1, 4, false);
            this.spawnElder(world, box, 6, 1, 6);
            return true;
        }
    }

    static interface MonumentRoomFitHelper {
        public boolean fits(RoomDefinition var1);

        public Piece create(EnumFacing var1, RoomDefinition var2);
    }

    public static class MonumentCoreRoom
    extends Piece {
        public MonumentCoreRoom() {
        }

        public MonumentCoreRoom(EnumFacing facing, RoomDefinition room) {
            super(1, facing, room, 2, 2, 2);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            int i;
            this.generateBoxOnFillOnly(world, box, 1, 8, 0, 14, 8, 14, this.roughPrismarine);
            IBlockState iblockstate = this.bricksPrismarine;
            this.func_175804_a(world, box, 0, 7, 0, 0, 7, 15, iblockstate, iblockstate, false);
            this.func_175804_a(world, box, 15, 7, 0, 15, 7, 15, iblockstate, iblockstate, false);
            this.func_175804_a(world, box, 1, 7, 0, 15, 7, 0, iblockstate, iblockstate, false);
            this.func_175804_a(world, box, 1, 7, 15, 14, 7, 15, iblockstate, iblockstate, false);
            for (i = 1; i <= 6; ++i) {
                iblockstate = this.bricksPrismarine;
                if (i == 2 || i == 6) {
                    iblockstate = this.roughPrismarine;
                }
                for (int j = 0; j <= 15; j += 15) {
                    this.func_175804_a(world, box, j, i, 0, j, i, 1, iblockstate, iblockstate, false);
                    this.func_175804_a(world, box, j, i, 6, j, i, 9, iblockstate, iblockstate, false);
                    this.func_175804_a(world, box, j, i, 14, j, i, 15, iblockstate, iblockstate, false);
                }
                this.func_175804_a(world, box, 1, i, 0, 1, i, 0, iblockstate, iblockstate, false);
                this.func_175804_a(world, box, 6, i, 0, 9, i, 0, iblockstate, iblockstate, false);
                this.func_175804_a(world, box, 14, i, 0, 14, i, 0, iblockstate, iblockstate, false);
                this.func_175804_a(world, box, 1, i, 15, 14, i, 15, iblockstate, iblockstate, false);
            }
            this.func_175804_a(world, box, 6, 3, 6, 9, 6, 9, this.darkPrismarine, this.darkPrismarine, false);
            boolean crystal = rand.nextInt(50) == 0;
            this.func_175804_a(world, box, 7, 4, 7, 8, 5, 8, crystal ? MPBlocks.MULTALIC_CRYSTAL_BLOCK.func_176223_P() : Blocks.field_150340_R.func_176223_P(), crystal ? MPBlocks.MULTALIC_CRYSTAL_BLOCK.func_176223_P() : Blocks.field_150340_R.func_176223_P(), false);
            for (i = 3; i <= 6; i += 3) {
                for (int k = 6; k <= 9; k += 3) {
                    this.func_175811_a(world, this.seaLantern, k, i, 6, box);
                    this.func_175811_a(world, this.seaLantern, k, i, 9, box);
                }
            }
            this.func_175804_a(world, box, 5, 1, 6, 5, 2, 6, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 1, 9, 5, 2, 9, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 10, 1, 6, 10, 2, 6, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 10, 1, 9, 10, 2, 9, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 6, 1, 5, 6, 2, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 9, 1, 5, 9, 2, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 6, 1, 10, 6, 2, 10, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 9, 1, 10, 9, 2, 10, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 2, 5, 5, 6, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 2, 10, 5, 6, 10, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 10, 2, 5, 10, 6, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 10, 2, 10, 10, 6, 10, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 7, 1, 5, 7, 6, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 10, 7, 1, 10, 7, 6, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 7, 9, 5, 7, 14, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 10, 7, 9, 10, 7, 14, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 7, 5, 6, 7, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 7, 10, 6, 7, 10, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 9, 7, 5, 14, 7, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 9, 7, 10, 14, 7, 10, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 2, 1, 2, 2, 1, 3, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 3, 1, 2, 3, 1, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 13, 1, 2, 13, 1, 3, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 12, 1, 2, 12, 1, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 2, 1, 12, 2, 1, 13, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 3, 1, 13, 3, 1, 13, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 13, 1, 12, 13, 1, 13, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 12, 1, 13, 12, 1, 13, this.bricksPrismarine, this.bricksPrismarine, false);
            return true;
        }
    }

    public static class MonumentBuilding
    extends Piece {
        private RoomDefinition sourceRoom;
        private RoomDefinition coreRoom;
        private final List<Piece> childPieces = new ArrayList<Piece>();

        public MonumentBuilding() {
        }

        public MonumentBuilding(Random rand, int x, int z, EnumFacing facing) {
            super(0);
            this.func_186164_a(facing);
            EnumFacing enumfacing = this.func_186165_e();
            this.field_74887_e = new StructureBoundingBox(x, 39, z, x + 58 - 1, 61, z + 58 - 1);
            List<RoomDefinition> list = this.generateRoomGraph(rand);
            this.sourceRoom.claimed = true;
            this.childPieces.add(new EntryRoom(enumfacing, this.sourceRoom));
            this.childPieces.add(new MonumentCoreRoom(enumfacing, this.coreRoom));
            ArrayList<MonumentRoomFitHelper> list1 = new ArrayList<MonumentRoomFitHelper>();
            list1.add(new XYDoubleRoomFitHelper());
            list1.add(new YZDoubleRoomFitHelper());
            list1.add(new ZDoubleRoomFitHelper());
            list1.add(new XDoubleRoomFitHelper());
            list1.add(new YDoubleRoomFitHelper());
            list1.add(new FitSimpleRoomTopHelper());
            list1.add(new FitSimpleRoomHelper());
            block0: for (RoomDefinition roomdefinition : list) {
                if (roomdefinition.claimed || roomdefinition.isSpecial()) continue;
                for (MonumentRoomFitHelper monumentRoomFitHelper : list1) {
                    if (!monumentRoomFitHelper.fits(roomdefinition)) continue;
                    this.childPieces.add(monumentRoomFitHelper.create(enumfacing, roomdefinition));
                    continue block0;
                }
            }
            int j = this.field_74887_e.field_78895_b;
            int k = this.func_74865_a(9, 22);
            int l = this.func_74873_b(9, 22);
            for (Piece piece : this.childPieces) {
                piece.func_74874_b().func_78886_a(k, j, l);
            }
            StructureBoundingBox structureBoundingBox = StructureBoundingBox.func_175899_a((int)this.func_74865_a(1, 1), (int)this.func_74862_a(1), (int)this.func_74873_b(1, 1), (int)this.func_74865_a(23, 21), (int)this.func_74862_a(8), (int)this.func_74873_b(23, 21));
            StructureBoundingBox structureboundingbox2 = StructureBoundingBox.func_175899_a((int)this.func_74865_a(34, 1), (int)this.func_74862_a(1), (int)this.func_74873_b(34, 1), (int)this.func_74865_a(56, 21), (int)this.func_74862_a(8), (int)this.func_74873_b(56, 21));
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175899_a((int)this.func_74865_a(22, 22), (int)this.func_74862_a(13), (int)this.func_74873_b(22, 22), (int)this.func_74865_a(35, 35), (int)this.func_74862_a(17), (int)this.func_74873_b(35, 35));
            int i = rand.nextInt();
            this.childPieces.add(new WingRoom(enumfacing, structureBoundingBox, i++));
            this.childPieces.add(new WingRoom(enumfacing, structureboundingbox2, i++));
            this.childPieces.add(new Penthouse(enumfacing, structureboundingbox));
        }

        /*
         * WARNING - void declaration
         */
        private List<RoomDefinition> generateRoomGraph(Random rand) {
            RoomDefinition[] aroomdefinition = new RoomDefinition[75];
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int l = MonumentBuilding.getRoomIndex(i, 0, j);
                    aroomdefinition[l] = new RoomDefinition(l);
                }
            }
            for (int i2 = 0; i2 < 5; ++i2) {
                for (int l2 = 0; l2 < 4; ++l2) {
                    int j4 = MonumentBuilding.getRoomIndex(i2, 1, l2);
                    aroomdefinition[j4] = new RoomDefinition(j4);
                }
            }
            for (int j2 = 1; j2 < 4; ++j2) {
                for (int i3 = 0; i3 < 2; ++i3) {
                    int k4 = MonumentBuilding.getRoomIndex(j2, 2, i3);
                    aroomdefinition[k4] = new RoomDefinition(k4);
                }
            }
            this.sourceRoom = aroomdefinition[this.gridroomSourceIndex];
            for (int k2 = 0; k2 < 5; ++k2) {
                for (int j3 = 0; j3 < 5; ++j3) {
                    for (int i4 = 0; i4 < 3; ++i4) {
                        int l4 = MonumentBuilding.getRoomIndex(k2, i4, j3);
                        if (aroomdefinition[l4] == null) continue;
                        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                            int l1;
                            int i1 = k2 + enumFacing.func_82601_c();
                            int j1 = i4 + enumFacing.func_96559_d();
                            int k1 = j3 + enumFacing.func_82599_e();
                            if (i1 < 0 || i1 >= 5 || k1 < 0 || k1 >= 5 || j1 < 0 || j1 >= 3 || aroomdefinition[l1 = MonumentBuilding.getRoomIndex(i1, j1, k1)] == null) continue;
                            if (k1 == j3) {
                                aroomdefinition[l4].setConnection(enumFacing, aroomdefinition[l1]);
                                continue;
                            }
                            aroomdefinition[l4].setConnection(enumFacing.func_176734_d(), aroomdefinition[l1]);
                        }
                    }
                }
            }
            RoomDefinition roomdefinition = new RoomDefinition(1003);
            RoomDefinition roomdefinition1 = new RoomDefinition(1001);
            RoomDefinition roomdefinition2 = new RoomDefinition(1002);
            aroomdefinition[this.gridroomTopConnectIndex].setConnection(EnumFacing.UP, roomdefinition);
            aroomdefinition[this.gridroomLeftwingConnectIndex].setConnection(EnumFacing.SOUTH, roomdefinition1);
            aroomdefinition[this.gridroomRightwingConnectIndex].setConnection(EnumFacing.SOUTH, roomdefinition2);
            roomdefinition.claimed = true;
            roomdefinition1.claimed = true;
            roomdefinition2.claimed = true;
            this.sourceRoom.isSource = true;
            this.coreRoom = aroomdefinition[MonumentBuilding.getRoomIndex(rand.nextInt(4), 0, 2)];
            this.coreRoom.claimed = true;
            this.coreRoom.connections[EnumFacing.EAST.func_176745_a()].claimed = true;
            this.coreRoom.connections[EnumFacing.NORTH.func_176745_a()].claimed = true;
            this.coreRoom.connections[EnumFacing.EAST.func_176745_a()].connections[EnumFacing.NORTH.func_176745_a()].claimed = true;
            this.coreRoom.connections[EnumFacing.UP.func_176745_a()].claimed = true;
            this.coreRoom.connections[EnumFacing.EAST.func_176745_a()].connections[EnumFacing.UP.func_176745_a()].claimed = true;
            this.coreRoom.connections[EnumFacing.NORTH.func_176745_a()].connections[EnumFacing.UP.func_176745_a()].claimed = true;
            this.coreRoom.connections[EnumFacing.EAST.func_176745_a()].connections[EnumFacing.NORTH.func_176745_a()].connections[EnumFacing.UP.func_176745_a()].claimed = true;
            ArrayList<RoomDefinition> list = new ArrayList<RoomDefinition>();
            for (RoomDefinition roomDefinition : aroomdefinition) {
                if (roomDefinition == null) continue;
                roomDefinition.updateOpenings();
                list.add(roomDefinition);
            }
            roomdefinition.updateOpenings();
            Collections.shuffle(list, rand);
            boolean bl = true;
            for (RoomDefinition roomdefinition3 : list) {
                int n = 0;
                for (int k5 = 0; n < 2 && k5 < 5; ++k5) {
                    void var7_14;
                    int l5 = rand.nextInt(6);
                    if (!roomdefinition3.hasOpening[l5]) continue;
                    int i6 = EnumFacing.func_82600_a((int)l5).func_176734_d().func_176745_a();
                    roomdefinition3.hasOpening[l5] = false;
                    roomdefinition3.connections[l5].hasOpening[i6] = false;
                    if (roomdefinition3.findSource((int)var7_14++) && roomdefinition3.connections[l5].findSource((int)var7_14++)) {
                        ++n;
                        continue;
                    }
                    roomdefinition3.hasOpening[l5] = true;
                    roomdefinition3.connections[l5].hasOpening[i6] = true;
                }
            }
            list.add(roomdefinition);
            list.add(roomdefinition1);
            list.add(roomdefinition2);
            return list;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            int i = Math.max(world.func_181545_F(), 64) - this.field_74887_e.field_78895_b;
            this.generateWaterBox(world, box, 0, 0, 0, 58, i, 58, false);
            this.generateWing(false, 0, world, box);
            this.generateWing(true, 33, world, box);
            this.generateEntranceArchs(world, box);
            this.generateEntranceWall(world, box);
            this.generateRoofPiece(world, box);
            this.generateLowerWall(world, box);
            this.generateMiddleWall(world, box);
            this.generateUpperWall(world, box);
            for (int j = 0; j < 7; ++j) {
                int k = 0;
                while (k < 7) {
                    if (k == 0 && j == 3) {
                        k = 6;
                    }
                    int l = j * 9;
                    int i1 = k * 9;
                    for (int j1 = 0; j1 < 4; ++j1) {
                        for (int k1 = 0; k1 < 4; ++k1) {
                            this.func_175811_a(world, this.bricksPrismarine, l + j1, 0, i1 + k1, box);
                            this.func_175808_b(world, this.bricksPrismarine, l + j1, -1, i1 + k1, box);
                        }
                    }
                    if (j != 0 && j != 6) {
                        k += 6;
                        continue;
                    }
                    ++k;
                }
            }
            for (int l1 = 0; l1 < 5; ++l1) {
                this.generateWaterBox(world, box, -1 - l1, l1 * 2, -1 - l1, -1 - l1, 23, 58 + l1, false);
                this.generateWaterBox(world, box, 58 + l1, l1 * 2, -1 - l1, 58 + l1, 23, 58 + l1, false);
                this.generateWaterBox(world, box, -l1, l1 * 2, -1 - l1, 57 + l1, 23, -1 - l1, false);
                this.generateWaterBox(world, box, -l1, l1 * 2, 58 + l1, 57 + l1, 23, 58 + l1, false);
            }
            for (Piece piece : this.childPieces) {
                if (!piece.func_74874_b().func_78884_a(box)) continue;
                piece.func_74875_a(world, rand, box);
            }
            return true;
        }

        private void generateWing(boolean par0, int size, World world, StructureBoundingBox box) {
            if (this.doesChunkIntersect(box, size, 0, size + 23, 20)) {
                this.func_175804_a(world, box, size, 0, 0, size + 24, 0, 20, this.roughPrismarine, this.roughPrismarine, false);
                this.generateWaterBox(world, box, size, 1, 0, size + 24, 10, 20, false);
                for (int j = 0; j < 4; ++j) {
                    this.func_175804_a(world, box, size + j, j + 1, j, size + j, j + 1, 20, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, size + j + 7, j + 5, j + 7, size + j + 7, j + 5, 20, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, size + 17 - j, j + 5, j + 7, size + 17 - j, j + 5, 20, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, size + 24 - j, j + 1, j, size + 24 - j, j + 1, 20, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, size + j + 1, j + 1, j, size + 23 - j, j + 1, j, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, size + j + 8, j + 5, j + 7, size + 16 - j, j + 5, j + 7, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                this.func_175804_a(world, box, size + 4, 4, 4, size + 6, 4, 20, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, size + 7, 4, 4, size + 17, 4, 6, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, size + 18, 4, 4, size + 20, 4, 20, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, size + 11, 8, 11, size + 13, 8, 20, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175811_a(world, this.bricksPrismarine, size + 12, 9, 12, box);
                this.func_175811_a(world, this.bricksPrismarine, size + 12, 9, 15, box);
                this.func_175811_a(world, this.bricksPrismarine, size + 12, 9, 18, box);
                int j1 = size + (par0 ? 19 : 5);
                int k = size + (par0 ? 5 : 19);
                for (int l = 20; l >= 5; l -= 3) {
                    this.func_175811_a(world, this.bricksPrismarine, j1, 5, l, box);
                }
                for (int k1 = 19; k1 >= 7; k1 -= 3) {
                    this.func_175811_a(world, this.bricksPrismarine, k, 5, k1, box);
                }
                for (int l1 = 0; l1 < 4; ++l1) {
                    int i1 = par0 ? size + 24 - (17 - l1 * 3) : size + 17 - l1 * 3;
                    this.func_175811_a(world, this.bricksPrismarine, i1, 5, 5, box);
                }
                this.func_175811_a(world, this.bricksPrismarine, k, 5, 5, box);
                this.func_175804_a(world, box, size + 11, 1, 12, size + 13, 7, 12, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, size + 12, 1, 11, size + 12, 7, 13, this.roughPrismarine, this.roughPrismarine, false);
            }
        }

        private void generateEntranceArchs(World world, StructureBoundingBox box) {
            if (this.doesChunkIntersect(box, 22, 5, 35, 17)) {
                this.generateWaterBox(world, box, 25, 0, 0, 32, 8, 20, false);
                for (int i = 0; i < 4; ++i) {
                    this.func_175804_a(world, box, 24, 2, 5 + i * 4, 24, 4, 5 + i * 4, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 22, 4, 5 + i * 4, 23, 4, 5 + i * 4, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175811_a(world, this.bricksPrismarine, 25, 5, 5 + i * 4, box);
                    this.func_175811_a(world, this.bricksPrismarine, 26, 6, 5 + i * 4, box);
                    this.func_175811_a(world, this.seaLantern, 26, 5, 5 + i * 4, box);
                    this.func_175804_a(world, box, 33, 2, 5 + i * 4, 33, 4, 5 + i * 4, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 34, 4, 5 + i * 4, 35, 4, 5 + i * 4, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175811_a(world, this.bricksPrismarine, 32, 5, 5 + i * 4, box);
                    this.func_175811_a(world, this.bricksPrismarine, 31, 6, 5 + i * 4, box);
                    this.func_175811_a(world, this.seaLantern, 31, 5, 5 + i * 4, box);
                    this.func_175804_a(world, box, 27, 6, 5 + i * 4, 30, 6, 5 + i * 4, this.roughPrismarine, this.roughPrismarine, false);
                }
            }
        }

        private void generateEntranceWall(World world, StructureBoundingBox box) {
            if (this.doesChunkIntersect(box, 15, 20, 42, 21)) {
                this.func_175804_a(world, box, 15, 0, 21, 42, 0, 21, this.roughPrismarine, this.roughPrismarine, false);
                this.generateWaterBox(world, box, 26, 1, 21, 31, 3, 21, false);
                this.func_175804_a(world, box, 21, 12, 21, 36, 12, 21, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 17, 11, 21, 40, 11, 21, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 16, 10, 21, 41, 10, 21, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 15, 7, 21, 42, 9, 21, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 16, 6, 21, 41, 6, 21, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 17, 5, 21, 40, 5, 21, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 21, 4, 21, 36, 4, 21, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 22, 3, 21, 26, 3, 21, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 31, 3, 21, 35, 3, 21, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 23, 2, 21, 25, 2, 21, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 32, 2, 21, 34, 2, 21, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 28, 4, 20, 29, 4, 21, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175811_a(world, this.bricksPrismarine, 27, 3, 21, box);
                this.func_175811_a(world, this.bricksPrismarine, 30, 3, 21, box);
                this.func_175811_a(world, this.bricksPrismarine, 26, 2, 21, box);
                this.func_175811_a(world, this.bricksPrismarine, 31, 2, 21, box);
                this.func_175811_a(world, this.bricksPrismarine, 25, 1, 21, box);
                this.func_175811_a(world, this.bricksPrismarine, 32, 1, 21, box);
                for (int i = 0; i < 7; ++i) {
                    this.func_175811_a(world, this.darkPrismarine, 28 - i, 6 + i, 21, box);
                    this.func_175811_a(world, this.darkPrismarine, 29 + i, 6 + i, 21, box);
                }
                for (int j = 0; j < 4; ++j) {
                    this.func_175811_a(world, this.darkPrismarine, 28 - j, 9 + j, 21, box);
                    this.func_175811_a(world, this.darkPrismarine, 29 + j, 9 + j, 21, box);
                }
                this.func_175811_a(world, this.darkPrismarine, 28, 12, 21, box);
                this.func_175811_a(world, this.darkPrismarine, 29, 12, 21, box);
                for (int k = 0; k < 3; ++k) {
                    this.func_175811_a(world, this.darkPrismarine, 22 - k * 2, 8, 21, box);
                    this.func_175811_a(world, this.darkPrismarine, 22 - k * 2, 9, 21, box);
                    this.func_175811_a(world, this.darkPrismarine, 35 + k * 2, 8, 21, box);
                    this.func_175811_a(world, this.darkPrismarine, 35 + k * 2, 9, 21, box);
                }
                this.generateWaterBox(world, box, 15, 13, 21, 42, 15, 21, false);
                this.generateWaterBox(world, box, 15, 1, 21, 15, 6, 21, false);
                this.generateWaterBox(world, box, 16, 1, 21, 16, 5, 21, false);
                this.generateWaterBox(world, box, 17, 1, 21, 20, 4, 21, false);
                this.generateWaterBox(world, box, 21, 1, 21, 21, 3, 21, false);
                this.generateWaterBox(world, box, 22, 1, 21, 22, 2, 21, false);
                this.generateWaterBox(world, box, 23, 1, 21, 24, 1, 21, false);
                this.generateWaterBox(world, box, 42, 1, 21, 42, 6, 21, false);
                this.generateWaterBox(world, box, 41, 1, 21, 41, 5, 21, false);
                this.generateWaterBox(world, box, 37, 1, 21, 40, 4, 21, false);
                this.generateWaterBox(world, box, 36, 1, 21, 36, 3, 21, false);
                this.generateWaterBox(world, box, 33, 1, 21, 34, 1, 21, false);
                this.generateWaterBox(world, box, 35, 1, 21, 35, 2, 21, false);
            }
        }

        private void generateRoofPiece(World world, StructureBoundingBox box) {
            if (this.doesChunkIntersect(box, 21, 21, 36, 36)) {
                this.func_175804_a(world, box, 21, 0, 22, 36, 0, 36, this.roughPrismarine, this.roughPrismarine, false);
                this.generateWaterBox(world, box, 21, 1, 22, 36, 23, 36, false);
                for (int i = 0; i < 4; ++i) {
                    this.func_175804_a(world, box, 21 + i, 13 + i, 21 + i, 36 - i, 13 + i, 21 + i, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 21 + i, 13 + i, 36 - i, 36 - i, 13 + i, 36 - i, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 21 + i, 13 + i, 22 + i, 21 + i, 13 + i, 35 - i, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 36 - i, 13 + i, 22 + i, 36 - i, 13 + i, 35 - i, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                this.func_175804_a(world, box, 25, 16, 25, 32, 16, 32, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 25, 17, 25, 25, 19, 25, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 32, 17, 25, 32, 19, 25, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 25, 17, 32, 25, 19, 32, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 32, 17, 32, 32, 19, 32, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175811_a(world, this.bricksPrismarine, 26, 20, 26, box);
                this.func_175811_a(world, this.bricksPrismarine, 27, 21, 27, box);
                this.func_175811_a(world, this.seaLantern, 27, 20, 27, box);
                this.func_175811_a(world, this.bricksPrismarine, 26, 20, 31, box);
                this.func_175811_a(world, this.bricksPrismarine, 27, 21, 30, box);
                this.func_175811_a(world, this.seaLantern, 27, 20, 30, box);
                this.func_175811_a(world, this.bricksPrismarine, 31, 20, 31, box);
                this.func_175811_a(world, this.bricksPrismarine, 30, 21, 30, box);
                this.func_175811_a(world, this.seaLantern, 30, 20, 30, box);
                this.func_175811_a(world, this.bricksPrismarine, 31, 20, 26, box);
                this.func_175811_a(world, this.bricksPrismarine, 30, 21, 27, box);
                this.func_175811_a(world, this.seaLantern, 30, 20, 27, box);
                this.func_175804_a(world, box, 28, 21, 27, 29, 21, 27, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 27, 21, 28, 27, 21, 29, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 28, 21, 30, 29, 21, 30, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 30, 21, 28, 30, 21, 29, this.roughPrismarine, this.roughPrismarine, false);
            }
        }

        private void generateLowerWall(World world, StructureBoundingBox box) {
            if (this.doesChunkIntersect(box, 0, 21, 6, 58)) {
                this.func_175804_a(world, box, 0, 0, 21, 6, 0, 57, this.roughPrismarine, this.roughPrismarine, false);
                this.generateWaterBox(world, box, 0, 1, 21, 6, 7, 57, false);
                this.func_175804_a(world, box, 4, 4, 21, 6, 4, 53, this.roughPrismarine, this.roughPrismarine, false);
                for (int i = 0; i < 4; ++i) {
                    this.func_175804_a(world, box, i, i + 1, 21, i, i + 1, 57 - i, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                for (int j = 23; j < 53; j += 3) {
                    this.func_175811_a(world, this.bricksPrismarine, 5, 5, j, box);
                }
                this.func_175811_a(world, this.bricksPrismarine, 5, 5, 52, box);
                for (int k = 0; k < 4; ++k) {
                    this.func_175804_a(world, box, k, k + 1, 21, k, k + 1, 57 - k, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                this.func_175804_a(world, box, 4, 1, 52, 6, 3, 52, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 5, 1, 51, 5, 3, 53, this.roughPrismarine, this.roughPrismarine, false);
            }
            if (this.doesChunkIntersect(box, 51, 21, 58, 58)) {
                this.func_175804_a(world, box, 51, 0, 21, 57, 0, 57, this.roughPrismarine, this.roughPrismarine, false);
                this.generateWaterBox(world, box, 51, 1, 21, 57, 7, 57, false);
                this.func_175804_a(world, box, 51, 4, 21, 53, 4, 53, this.roughPrismarine, this.roughPrismarine, false);
                for (int l = 0; l < 4; ++l) {
                    this.func_175804_a(world, box, 57 - l, l + 1, 21, 57 - l, l + 1, 57 - l, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                for (int i1 = 23; i1 < 53; i1 += 3) {
                    this.func_175811_a(world, this.bricksPrismarine, 52, 5, i1, box);
                }
                this.func_175811_a(world, this.bricksPrismarine, 52, 5, 52, box);
                this.func_175804_a(world, box, 51, 1, 52, 53, 3, 52, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 52, 1, 51, 52, 3, 53, this.roughPrismarine, this.roughPrismarine, false);
            }
            if (this.doesChunkIntersect(box, 0, 51, 57, 57)) {
                this.func_175804_a(world, box, 7, 0, 51, 50, 0, 57, this.roughPrismarine, this.roughPrismarine, false);
                this.generateWaterBox(world, box, 7, 1, 51, 50, 10, 57, false);
                for (int j1 = 0; j1 < 4; ++j1) {
                    this.func_175804_a(world, box, j1 + 1, j1 + 1, 57 - j1, 56 - j1, j1 + 1, 57 - j1, this.bricksPrismarine, this.bricksPrismarine, false);
                }
            }
        }

        private void generateMiddleWall(World world, StructureBoundingBox box) {
            if (this.doesChunkIntersect(box, 7, 21, 13, 50)) {
                this.func_175804_a(world, box, 7, 0, 21, 13, 0, 50, this.roughPrismarine, this.roughPrismarine, false);
                this.generateWaterBox(world, box, 7, 1, 21, 13, 10, 50, false);
                this.func_175804_a(world, box, 11, 8, 21, 13, 8, 53, this.roughPrismarine, this.roughPrismarine, false);
                for (int i = 0; i < 4; ++i) {
                    this.func_175804_a(world, box, i + 7, i + 5, 21, i + 7, i + 5, 54, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                for (int j = 21; j <= 45; j += 3) {
                    this.func_175811_a(world, this.bricksPrismarine, 12, 9, j, box);
                }
            }
            if (this.doesChunkIntersect(box, 44, 21, 50, 54)) {
                this.func_175804_a(world, box, 44, 0, 21, 50, 0, 50, this.roughPrismarine, this.roughPrismarine, false);
                this.generateWaterBox(world, box, 44, 1, 21, 50, 10, 50, false);
                this.func_175804_a(world, box, 44, 8, 21, 46, 8, 53, this.roughPrismarine, this.roughPrismarine, false);
                for (int k = 0; k < 4; ++k) {
                    this.func_175804_a(world, box, 50 - k, k + 5, 21, 50 - k, k + 5, 54, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                for (int l = 21; l <= 45; l += 3) {
                    this.func_175811_a(world, this.bricksPrismarine, 45, 9, l, box);
                }
            }
            if (this.doesChunkIntersect(box, 8, 44, 49, 54)) {
                this.func_175804_a(world, box, 14, 0, 44, 43, 0, 50, this.roughPrismarine, this.roughPrismarine, false);
                this.generateWaterBox(world, box, 14, 1, 44, 43, 10, 50, false);
                for (int i1 = 12; i1 <= 45; i1 += 3) {
                    this.func_175811_a(world, this.bricksPrismarine, i1, 9, 45, box);
                    this.func_175811_a(world, this.bricksPrismarine, i1, 9, 52, box);
                    if (i1 != 12 && i1 != 18 && i1 != 24 && i1 != 33 && i1 != 39 && i1 != 45) continue;
                    this.func_175811_a(world, this.bricksPrismarine, i1, 9, 47, box);
                    this.func_175811_a(world, this.bricksPrismarine, i1, 9, 50, box);
                    this.func_175811_a(world, this.bricksPrismarine, i1, 10, 45, box);
                    this.func_175811_a(world, this.bricksPrismarine, i1, 10, 46, box);
                    this.func_175811_a(world, this.bricksPrismarine, i1, 10, 51, box);
                    this.func_175811_a(world, this.bricksPrismarine, i1, 10, 52, box);
                    this.func_175811_a(world, this.bricksPrismarine, i1, 11, 47, box);
                    this.func_175811_a(world, this.bricksPrismarine, i1, 11, 50, box);
                    this.func_175811_a(world, this.bricksPrismarine, i1, 12, 48, box);
                    this.func_175811_a(world, this.bricksPrismarine, i1, 12, 49, box);
                }
                for (int j1 = 0; j1 < 3; ++j1) {
                    this.func_175804_a(world, box, 8 + j1, 5 + j1, 54, 49 - j1, 5 + j1, 54, this.roughPrismarine, this.roughPrismarine, false);
                }
                this.func_175804_a(world, box, 11, 8, 54, 46, 8, 54, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 14, 8, 44, 43, 8, 53, this.roughPrismarine, this.roughPrismarine, false);
            }
        }

        private void generateUpperWall(World world, StructureBoundingBox box) {
            if (this.doesChunkIntersect(box, 14, 21, 20, 43)) {
                this.func_175804_a(world, box, 14, 0, 21, 20, 0, 43, this.roughPrismarine, this.roughPrismarine, false);
                this.generateWaterBox(world, box, 14, 1, 22, 20, 14, 43, false);
                this.func_175804_a(world, box, 18, 12, 22, 20, 12, 39, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 18, 12, 21, 20, 12, 21, this.bricksPrismarine, this.bricksPrismarine, false);
                for (int i = 0; i < 4; ++i) {
                    this.func_175804_a(world, box, i + 14, i + 9, 21, i + 14, i + 9, 43 - i, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                for (int j = 23; j <= 39; j += 3) {
                    this.func_175811_a(world, this.bricksPrismarine, 19, 13, j, box);
                }
            }
            if (this.doesChunkIntersect(box, 37, 21, 43, 43)) {
                this.func_175804_a(world, box, 37, 0, 21, 43, 0, 43, this.roughPrismarine, this.roughPrismarine, false);
                this.generateWaterBox(world, box, 37, 1, 22, 43, 14, 43, false);
                this.func_175804_a(world, box, 37, 12, 22, 39, 12, 39, this.roughPrismarine, this.roughPrismarine, false);
                this.func_175804_a(world, box, 37, 12, 21, 39, 12, 21, this.bricksPrismarine, this.bricksPrismarine, false);
                for (int k = 0; k < 4; ++k) {
                    this.func_175804_a(world, box, 43 - k, k + 9, 21, 43 - k, k + 9, 43 - k, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                for (int l = 23; l <= 39; l += 3) {
                    this.func_175811_a(world, this.bricksPrismarine, 38, 13, l, box);
                }
            }
            if (this.doesChunkIntersect(box, 15, 37, 42, 43)) {
                this.func_175804_a(world, box, 21, 0, 37, 36, 0, 43, this.roughPrismarine, this.roughPrismarine, false);
                this.generateWaterBox(world, box, 21, 1, 37, 36, 14, 43, false);
                this.func_175804_a(world, box, 21, 12, 37, 36, 12, 39, this.roughPrismarine, this.roughPrismarine, false);
                for (int i1 = 0; i1 < 4; ++i1) {
                    this.func_175804_a(world, box, 15 + i1, i1 + 9, 43 - i1, 42 - i1, i1 + 9, 43 - i1, this.bricksPrismarine, this.bricksPrismarine, false);
                }
                for (int j1 = 21; j1 <= 36; j1 += 3) {
                    this.func_175811_a(world, this.bricksPrismarine, j1, 13, 38, box);
                }
            }
        }
    }

    static class FitSimpleRoomTopHelper
    implements MonumentRoomFitHelper {
        private FitSimpleRoomTopHelper() {
        }

        @Override
        public boolean fits(RoomDefinition room) {
            return !room.hasOpening[EnumFacing.WEST.func_176745_a()] && !room.hasOpening[EnumFacing.EAST.func_176745_a()] && !room.hasOpening[EnumFacing.NORTH.func_176745_a()] && !room.hasOpening[EnumFacing.SOUTH.func_176745_a()] && !room.hasOpening[EnumFacing.UP.func_176745_a()];
        }

        @Override
        public Piece create(EnumFacing facing, RoomDefinition room) {
            room.claimed = true;
            return new SimpleTopRoom(facing, room);
        }
    }

    static class FitSimpleRoomHelper
    implements MonumentRoomFitHelper {
        private FitSimpleRoomHelper() {
        }

        @Override
        public boolean fits(RoomDefinition room) {
            return true;
        }

        @Override
        public Piece create(EnumFacing facing, RoomDefinition room) {
            room.claimed = true;
            return new SimpleRoom(facing, room);
        }
    }

    public static class EntryRoom
    extends Piece {
        public EntryRoom() {
        }

        public EntryRoom(EnumFacing facing, RoomDefinition room) {
            super(1, facing, room, 1, 1, 1);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            this.func_175804_a(world, box, 0, 3, 0, 2, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 3, 0, 7, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 0, 2, 0, 1, 2, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 6, 2, 0, 7, 2, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 0, 1, 0, 0, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 7, 1, 0, 7, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 0, 1, 7, 7, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 1, 0, 2, 3, 0, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 1, 0, 6, 3, 0, this.bricksPrismarine, this.bricksPrismarine, false);
            if (this.roomDefinition.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 1, 7, 4, 2, 7, false);
            }
            if (this.roomDefinition.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                this.generateWaterBox(world, box, 0, 1, 3, 1, 2, 4, false);
            }
            if (this.roomDefinition.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                this.generateWaterBox(world, box, 6, 1, 3, 7, 2, 4, false);
            }
            return true;
        }
    }

    public static class DoubleZRoom
    extends Piece {
        public DoubleZRoom() {
        }

        public DoubleZRoom(EnumFacing facing, RoomDefinition room) {
            super(1, facing, room, 1, 1, 2);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            RoomDefinition roomdefinition = this.roomDefinition.connections[EnumFacing.NORTH.func_176745_a()];
            RoomDefinition roomdefinition1 = this.roomDefinition;
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(world, box, 0, 8, roomdefinition.hasOpening[EnumFacing.DOWN.func_176745_a()]);
                this.generateDefaultFloor(world, box, 0, 0, roomdefinition1.hasOpening[EnumFacing.DOWN.func_176745_a()]);
            }
            if (roomdefinition1.connections[EnumFacing.UP.func_176745_a()] == null) {
                this.generateBoxOnFillOnly(world, box, 1, 4, 1, 6, 4, 7, this.roughPrismarine);
            }
            if (roomdefinition.connections[EnumFacing.UP.func_176745_a()] == null) {
                this.generateBoxOnFillOnly(world, box, 1, 4, 8, 6, 4, 14, this.roughPrismarine);
            }
            this.func_175804_a(world, box, 0, 3, 0, 0, 3, 15, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 7, 3, 0, 7, 3, 15, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 3, 0, 7, 3, 0, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 3, 15, 6, 3, 15, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 0, 2, 0, 0, 2, 15, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 7, 2, 0, 7, 2, 15, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 1, 2, 0, 7, 2, 0, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 1, 2, 15, 6, 2, 15, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 0, 1, 0, 0, 1, 15, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 7, 1, 0, 7, 1, 15, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 1, 0, 7, 1, 0, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 1, 15, 6, 1, 15, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 1, 1, 1, 1, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 6, 1, 1, 6, 1, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 3, 1, 1, 3, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 6, 3, 1, 6, 3, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 1, 13, 1, 1, 14, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 6, 1, 13, 6, 1, 14, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 3, 13, 1, 3, 14, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 6, 3, 13, 6, 3, 14, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 2, 1, 6, 2, 3, 6, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 1, 6, 5, 3, 6, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 2, 1, 9, 2, 3, 9, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 1, 9, 5, 3, 9, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 3, 2, 6, 4, 2, 6, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 3, 2, 9, 4, 2, 9, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 2, 2, 7, 2, 2, 8, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 2, 7, 5, 2, 8, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175811_a(world, this.seaLantern, 2, 2, 5, box);
            this.func_175811_a(world, this.seaLantern, 5, 2, 5, box);
            this.func_175811_a(world, this.seaLantern, 2, 2, 10, box);
            this.func_175811_a(world, this.seaLantern, 5, 2, 10, box);
            this.func_175811_a(world, this.bricksPrismarine, 2, 3, 5, box);
            this.func_175811_a(world, this.bricksPrismarine, 5, 3, 5, box);
            this.func_175811_a(world, this.bricksPrismarine, 2, 3, 10, box);
            this.func_175811_a(world, this.bricksPrismarine, 5, 3, 10, box);
            if (roomdefinition1.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 1, 0, 4, 2, 0, false);
            }
            if (roomdefinition1.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                this.generateWaterBox(world, box, 7, 1, 3, 7, 2, 4, false);
            }
            if (roomdefinition1.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                this.generateWaterBox(world, box, 0, 1, 3, 0, 2, 4, false);
            }
            if (roomdefinition.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 1, 15, 4, 2, 15, false);
            }
            if (roomdefinition.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                this.generateWaterBox(world, box, 0, 1, 11, 0, 2, 12, false);
            }
            if (roomdefinition.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                this.generateWaterBox(world, box, 7, 1, 11, 7, 2, 12, false);
            }
            return true;
        }
    }

    public static class DoubleYZRoom
    extends Piece {
        public DoubleYZRoom() {
        }

        public DoubleYZRoom(EnumFacing facing, RoomDefinition room) {
            super(1, facing, room, 1, 2, 2);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            RoomDefinition roomdefinition = this.roomDefinition.connections[EnumFacing.NORTH.func_176745_a()];
            RoomDefinition roomdefinition1 = this.roomDefinition;
            RoomDefinition roomdefinition2 = roomdefinition.connections[EnumFacing.UP.func_176745_a()];
            RoomDefinition roomdefinition3 = roomdefinition1.connections[EnumFacing.UP.func_176745_a()];
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(world, box, 0, 8, roomdefinition.hasOpening[EnumFacing.DOWN.func_176745_a()]);
                this.generateDefaultFloor(world, box, 0, 0, roomdefinition1.hasOpening[EnumFacing.DOWN.func_176745_a()]);
            }
            if (roomdefinition3.connections[EnumFacing.UP.func_176745_a()] == null) {
                this.generateBoxOnFillOnly(world, box, 1, 8, 1, 6, 8, 7, this.roughPrismarine);
            }
            if (roomdefinition2.connections[EnumFacing.UP.func_176745_a()] == null) {
                this.generateBoxOnFillOnly(world, box, 1, 8, 8, 6, 8, 14, this.roughPrismarine);
            }
            for (int i = 1; i <= 7; ++i) {
                IBlockState iblockstate = this.bricksPrismarine;
                if (i == 2 || i == 6) {
                    iblockstate = this.roughPrismarine;
                }
                this.func_175804_a(world, box, 0, i, 0, 0, i, 15, iblockstate, iblockstate, false);
                this.func_175804_a(world, box, 7, i, 0, 7, i, 15, iblockstate, iblockstate, false);
                this.func_175804_a(world, box, 1, i, 0, 6, i, 0, iblockstate, iblockstate, false);
                this.func_175804_a(world, box, 1, i, 15, 6, i, 15, iblockstate, iblockstate, false);
            }
            for (int j = 1; j <= 7; ++j) {
                IBlockState iblockstate1 = this.darkPrismarine;
                if (j == 2 || j == 6) {
                    iblockstate1 = this.seaLantern;
                }
                this.func_175804_a(world, box, 3, j, 7, 4, j, 8, iblockstate1, iblockstate1, false);
            }
            if (roomdefinition1.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 1, 0, 4, 2, 0, false);
            }
            if (roomdefinition1.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                this.generateWaterBox(world, box, 7, 1, 3, 7, 2, 4, false);
            }
            if (roomdefinition1.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                this.generateWaterBox(world, box, 0, 1, 3, 0, 2, 4, false);
            }
            if (roomdefinition.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 1, 15, 4, 2, 15, false);
            }
            if (roomdefinition.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                this.generateWaterBox(world, box, 0, 1, 11, 0, 2, 12, false);
            }
            if (roomdefinition.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                this.generateWaterBox(world, box, 7, 1, 11, 7, 2, 12, false);
            }
            if (roomdefinition3.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 5, 0, 4, 6, 0, false);
            }
            if (roomdefinition3.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                this.generateWaterBox(world, box, 7, 5, 3, 7, 6, 4, false);
                this.func_175804_a(world, box, 5, 4, 2, 6, 4, 5, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 6, 1, 2, 6, 3, 2, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 6, 1, 5, 6, 3, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            }
            if (roomdefinition3.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                this.generateWaterBox(world, box, 0, 5, 3, 0, 6, 4, false);
                this.func_175804_a(world, box, 1, 4, 2, 2, 4, 5, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 1, 1, 2, 1, 3, 2, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 1, 1, 5, 1, 3, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            }
            if (roomdefinition2.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 5, 15, 4, 6, 15, false);
            }
            if (roomdefinition2.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                this.generateWaterBox(world, box, 0, 5, 11, 0, 6, 12, false);
                this.func_175804_a(world, box, 1, 4, 10, 2, 4, 13, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 1, 1, 10, 1, 3, 10, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 1, 1, 13, 1, 3, 13, this.bricksPrismarine, this.bricksPrismarine, false);
            }
            if (roomdefinition2.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                this.generateWaterBox(world, box, 7, 5, 11, 7, 6, 12, false);
                this.func_175804_a(world, box, 5, 4, 10, 6, 4, 13, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 6, 1, 10, 6, 3, 10, this.bricksPrismarine, this.bricksPrismarine, false);
                this.func_175804_a(world, box, 6, 1, 13, 6, 3, 13, this.bricksPrismarine, this.bricksPrismarine, false);
            }
            return true;
        }
    }

    public static class DoubleYRoom
    extends Piece {
        public DoubleYRoom() {
        }

        public DoubleYRoom(EnumFacing facing, RoomDefinition room) {
            super(1, facing, room, 1, 2, 1);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(world, box, 0, 0, this.roomDefinition.hasOpening[EnumFacing.DOWN.func_176745_a()]);
            }
            RoomDefinition roomdefinition = this.roomDefinition.connections[EnumFacing.UP.func_176745_a()];
            if (roomdefinition.connections[EnumFacing.UP.func_176745_a()] == null) {
                this.generateBoxOnFillOnly(world, box, 1, 8, 1, 6, 8, 6, this.roughPrismarine);
            }
            this.func_175804_a(world, box, 0, 4, 0, 0, 4, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 7, 4, 0, 7, 4, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 4, 0, 6, 4, 0, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 4, 7, 6, 4, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 2, 4, 1, 2, 4, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 4, 2, 1, 4, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 4, 1, 5, 4, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 6, 4, 2, 6, 4, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 2, 4, 5, 2, 4, 6, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 4, 5, 1, 4, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 4, 5, 5, 4, 6, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 6, 4, 5, 6, 4, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            RoomDefinition roomdefinition1 = this.roomDefinition;
            for (int i = 1; i <= 5; i += 4) {
                int j = 0;
                if (roomdefinition1.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                    this.func_175804_a(world, box, 2, i, j, 2, i + 2, j, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 5, i, j, 5, i + 2, j, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 3, i + 2, j, 4, i + 2, j, this.bricksPrismarine, this.bricksPrismarine, false);
                } else {
                    this.func_175804_a(world, box, 0, i, j, 7, i + 2, j, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 0, i + 1, j, 7, i + 1, j, this.roughPrismarine, this.roughPrismarine, false);
                }
                j = 7;
                if (roomdefinition1.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                    this.func_175804_a(world, box, 2, i, j, 2, i + 2, j, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 5, i, j, 5, i + 2, j, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 3, i + 2, j, 4, i + 2, j, this.bricksPrismarine, this.bricksPrismarine, false);
                } else {
                    this.func_175804_a(world, box, 0, i, j, 7, i + 2, j, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, 0, i + 1, j, 7, i + 1, j, this.roughPrismarine, this.roughPrismarine, false);
                }
                int k = 0;
                if (roomdefinition1.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                    this.func_175804_a(world, box, k, i, 2, k, i + 2, 2, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, k, i, 5, k, i + 2, 5, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, k, i + 2, 3, k, i + 2, 4, this.bricksPrismarine, this.bricksPrismarine, false);
                } else {
                    this.func_175804_a(world, box, k, i, 0, k, i + 2, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, k, i + 1, 0, k, i + 1, 7, this.roughPrismarine, this.roughPrismarine, false);
                }
                k = 7;
                if (roomdefinition1.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                    this.func_175804_a(world, box, k, i, 2, k, i + 2, 2, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, k, i, 5, k, i + 2, 5, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, k, i + 2, 3, k, i + 2, 4, this.bricksPrismarine, this.bricksPrismarine, false);
                } else {
                    this.func_175804_a(world, box, k, i, 0, k, i + 2, 7, this.bricksPrismarine, this.bricksPrismarine, false);
                    this.func_175804_a(world, box, k, i + 1, 0, k, i + 1, 7, this.roughPrismarine, this.roughPrismarine, false);
                }
                roomdefinition1 = roomdefinition;
            }
            return true;
        }
    }

    public static class DoubleXYRoom
    extends Piece {
        public DoubleXYRoom() {
        }

        public DoubleXYRoom(EnumFacing facing, RoomDefinition room) {
            super(1, facing, room, 2, 2, 1);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            RoomDefinition roomdefinition = this.roomDefinition.connections[EnumFacing.EAST.func_176745_a()];
            RoomDefinition roomdefinition1 = this.roomDefinition;
            RoomDefinition roomdefinition2 = roomdefinition1.connections[EnumFacing.UP.func_176745_a()];
            RoomDefinition roomdefinition3 = roomdefinition.connections[EnumFacing.UP.func_176745_a()];
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(world, box, 8, 0, roomdefinition.hasOpening[EnumFacing.DOWN.func_176745_a()]);
                this.generateDefaultFloor(world, box, 0, 0, roomdefinition1.hasOpening[EnumFacing.DOWN.func_176745_a()]);
            }
            if (roomdefinition2.connections[EnumFacing.UP.func_176745_a()] == null) {
                this.generateBoxOnFillOnly(world, box, 1, 8, 1, 7, 8, 6, this.roughPrismarine);
            }
            if (roomdefinition3.connections[EnumFacing.UP.func_176745_a()] == null) {
                this.generateBoxOnFillOnly(world, box, 8, 8, 1, 14, 8, 6, this.roughPrismarine);
            }
            for (int i = 1; i <= 7; ++i) {
                IBlockState iblockstate = this.bricksPrismarine;
                if (i == 2 || i == 6) {
                    iblockstate = this.roughPrismarine;
                }
                this.func_175804_a(world, box, 0, i, 0, 0, i, 7, iblockstate, iblockstate, false);
                this.func_175804_a(world, box, 15, i, 0, 15, i, 7, iblockstate, iblockstate, false);
                this.func_175804_a(world, box, 1, i, 0, 15, i, 0, iblockstate, iblockstate, false);
                this.func_175804_a(world, box, 1, i, 7, 14, i, 7, iblockstate, iblockstate, false);
            }
            this.func_175804_a(world, box, 2, 1, 3, 2, 7, 4, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 3, 1, 2, 4, 7, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 3, 1, 5, 4, 7, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 13, 1, 3, 13, 7, 4, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 11, 1, 2, 12, 7, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 11, 1, 5, 12, 7, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 1, 3, 5, 3, 4, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 10, 1, 3, 10, 3, 4, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 7, 2, 10, 7, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 5, 2, 5, 7, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 10, 5, 2, 10, 7, 2, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 5, 5, 5, 7, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 10, 5, 5, 10, 7, 5, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175811_a(world, this.bricksPrismarine, 6, 6, 2, box);
            this.func_175811_a(world, this.bricksPrismarine, 9, 6, 2, box);
            this.func_175811_a(world, this.bricksPrismarine, 6, 6, 5, box);
            this.func_175811_a(world, this.bricksPrismarine, 9, 6, 5, box);
            this.func_175804_a(world, box, 5, 4, 3, 6, 4, 4, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 9, 4, 3, 10, 4, 4, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175811_a(world, this.seaLantern, 5, 4, 2, box);
            this.func_175811_a(world, this.seaLantern, 5, 4, 5, box);
            this.func_175811_a(world, this.seaLantern, 10, 4, 2, box);
            this.func_175811_a(world, this.seaLantern, 10, 4, 5, box);
            if (roomdefinition1.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 1, 0, 4, 2, 0, false);
            }
            if (roomdefinition1.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 1, 7, 4, 2, 7, false);
            }
            if (roomdefinition1.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                this.generateWaterBox(world, box, 0, 1, 3, 0, 2, 4, false);
            }
            if (roomdefinition.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 11, 1, 0, 12, 2, 0, false);
            }
            if (roomdefinition.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 11, 1, 7, 12, 2, 7, false);
            }
            if (roomdefinition.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                this.generateWaterBox(world, box, 15, 1, 3, 15, 2, 4, false);
            }
            if (roomdefinition2.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 5, 0, 4, 6, 0, false);
            }
            if (roomdefinition2.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 5, 7, 4, 6, 7, false);
            }
            if (roomdefinition2.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                this.generateWaterBox(world, box, 0, 5, 3, 0, 6, 4, false);
            }
            if (roomdefinition3.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 11, 5, 0, 12, 6, 0, false);
            }
            if (roomdefinition3.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 11, 5, 7, 12, 6, 7, false);
            }
            if (roomdefinition3.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                this.generateWaterBox(world, box, 15, 5, 3, 15, 6, 4, false);
            }
            return true;
        }
    }

    public static class DoubleXRoom
    extends Piece {
        public DoubleXRoom() {
        }

        public DoubleXRoom(EnumFacing facing, RoomDefinition room) {
            super(1, facing, room, 2, 1, 1);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            RoomDefinition roomdefinition = this.roomDefinition.connections[EnumFacing.EAST.func_176745_a()];
            RoomDefinition roomdefinition1 = this.roomDefinition;
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(world, box, 8, 0, roomdefinition.hasOpening[EnumFacing.DOWN.func_176745_a()]);
                this.generateDefaultFloor(world, box, 0, 0, roomdefinition1.hasOpening[EnumFacing.DOWN.func_176745_a()]);
            }
            if (roomdefinition1.connections[EnumFacing.UP.func_176745_a()] == null) {
                this.generateBoxOnFillOnly(world, box, 1, 4, 1, 7, 4, 6, this.roughPrismarine);
            }
            if (roomdefinition.connections[EnumFacing.UP.func_176745_a()] == null) {
                this.generateBoxOnFillOnly(world, box, 8, 4, 1, 14, 4, 6, this.roughPrismarine);
            }
            this.func_175804_a(world, box, 0, 3, 0, 0, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 15, 3, 0, 15, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 3, 0, 15, 3, 0, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 3, 7, 14, 3, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 0, 2, 0, 0, 2, 7, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 15, 2, 0, 15, 2, 7, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 1, 2, 0, 15, 2, 0, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 1, 2, 7, 14, 2, 7, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 0, 1, 0, 0, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 15, 1, 0, 15, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 1, 0, 15, 1, 0, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 1, 1, 7, 14, 1, 7, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 5, 1, 0, 10, 1, 4, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175804_a(world, box, 6, 2, 0, 9, 2, 3, this.roughPrismarine, this.roughPrismarine, false);
            this.func_175804_a(world, box, 5, 3, 0, 10, 3, 4, this.bricksPrismarine, this.bricksPrismarine, false);
            this.func_175811_a(world, this.seaLantern, 6, 2, 3, box);
            this.func_175811_a(world, this.seaLantern, 9, 2, 3, box);
            if (roomdefinition1.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 1, 0, 4, 2, 0, false);
            }
            if (roomdefinition1.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 3, 1, 7, 4, 2, 7, false);
            }
            if (roomdefinition1.hasOpening[EnumFacing.WEST.func_176745_a()]) {
                this.generateWaterBox(world, box, 0, 1, 3, 0, 2, 4, false);
            }
            if (roomdefinition.hasOpening[EnumFacing.SOUTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 11, 1, 0, 12, 2, 0, false);
            }
            if (roomdefinition.hasOpening[EnumFacing.NORTH.func_176745_a()]) {
                this.generateWaterBox(world, box, 11, 1, 7, 12, 2, 7, false);
            }
            if (roomdefinition.hasOpening[EnumFacing.EAST.func_176745_a()]) {
                this.generateWaterBox(world, box, 15, 1, 3, 15, 2, 4, false);
            }
            return true;
        }
    }
}

