/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.planets.nibiru.world.gen.structure;

import com.stevekung.lib.utils.BlockStateProperty;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPLootTables;
import com.stevekung.moreplanets.planets.nibiru.blocks.BlockVeinFrame;
import com.stevekung.moreplanets.planets.nibiru.entity.EntityInfectedWorm;
import com.stevekung.moreplanets.planets.nibiru.entity.EntityZergius;
import com.stevekung.moreplanets.planets.nibiru.tileentity.TileEntityJuicerEgg;
import com.stevekung.moreplanets.planets.nibiru.tileentity.TileEntityNuclearWasteTank;
import com.stevekung.moreplanets.tileentity.TileEntityDummy;
import com.stevekung.moreplanets.utils.tileentity.TileEntityChestMP;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class StructureNibiruStrongholdPieces {
    private static final PieceWeight[] PIECE_WEIGHTS = new PieceWeight[]{new PieceWeight(Straight.class, 40, 0), new PieceWeight(Prison.class, 5, 5), new PieceWeight(LeftTurn.class, 20, 0), new PieceWeight(RightTurn.class, 20, 0), new PieceWeight(RoomCrossing.class, 10, 6), new PieceWeight(StairsStraight.class, 5, 5), new PieceWeight(Stairs.class, 5, 5), new PieceWeight(Crossing.class, 5, 4), new PieceWeight(ChestCorridor.class, 5, 4), new PieceWeight(Library.class, 10, 2){

        @Override
        public boolean canSpawnMoreStructuresOfType(int type) {
            return super.canSpawnMoreStructuresOfType(type) && type > 4;
        }
    }, new PieceWeight(PortalRoom.class, 20, 1){

        @Override
        public boolean canSpawnMoreStructuresOfType(int type) {
            return super.canSpawnMoreStructuresOfType(type) && type > 5;
        }
    }};
    private static final List<PieceWeight> structurePieceList = new ArrayList<PieceWeight>();
    private static Class<? extends Stronghold> strongComponentType;
    static int totalWeight;
    private static final Stones STRONGHOLD_STONES;

    public static void registerStrongholdPieces() {
        MapGenStructureIO.func_143031_a(ChestCorridor.class, (String)"SHCC");
        MapGenStructureIO.func_143031_a(Corridor.class, (String)"SHFC");
        MapGenStructureIO.func_143031_a(Crossing.class, (String)"SH5C");
        MapGenStructureIO.func_143031_a(LeftTurn.class, (String)"SHLT");
        MapGenStructureIO.func_143031_a(Library.class, (String)"SHLi");
        MapGenStructureIO.func_143031_a(PortalRoom.class, (String)"SHPR");
        MapGenStructureIO.func_143031_a(Prison.class, (String)"SHPH");
        MapGenStructureIO.func_143031_a(RightTurn.class, (String)"SHRT");
        MapGenStructureIO.func_143031_a(RoomCrossing.class, (String)"SHRC");
        MapGenStructureIO.func_143031_a(Stairs.class, (String)"SHSD");
        MapGenStructureIO.func_143031_a(Stairs2.class, (String)"SHStart");
        MapGenStructureIO.func_143031_a(Straight.class, (String)"SHS");
        MapGenStructureIO.func_143031_a(StairsStraight.class, (String)"SHSSD");
    }

    public static void prepareStructurePieces() {
        for (PieceWeight pieceweight : PIECE_WEIGHTS) {
            pieceweight.instancesSpawned = 0;
            structurePieceList.add(pieceweight);
        }
        strongComponentType = null;
    }

    private static boolean canAddStructurePieces() {
        boolean flag = false;
        totalWeight = 0;
        for (PieceWeight pieceweight : structurePieceList) {
            if (pieceweight.instancesLimit > 0 && pieceweight.instancesSpawned < pieceweight.instancesLimit) {
                flag = true;
            }
            totalWeight += pieceweight.pieceWeight;
        }
        return flag;
    }

    private static Stronghold findAndCreatePieceFactory(Class<? extends Stronghold> clazz, List<StructureComponent> component, Random rand, int x, int y, int z, @Nullable EnumFacing facing, int type) {
        Stronghold stronghold = null;
        if (clazz == Straight.class) {
            stronghold = Straight.createPiece(component, rand, x, y, z, facing, type);
        } else if (clazz == Prison.class) {
            stronghold = Prison.createPiece(component, rand, x, y, z, facing, type);
        } else if (clazz == LeftTurn.class) {
            stronghold = LeftTurn.createPiece(component, rand, x, y, z, facing, type);
        } else if (clazz == RightTurn.class) {
            stronghold = LeftTurn.createPiece(component, rand, x, y, z, facing, type);
        } else if (clazz == RoomCrossing.class) {
            stronghold = RoomCrossing.createPiece(component, rand, x, y, z, facing, type);
        } else if (clazz == StairsStraight.class) {
            stronghold = StairsStraight.createPiece(component, rand, x, y, z, facing, type);
        } else if (clazz == Stairs.class) {
            stronghold = Stairs.createPiece(component, rand, x, y, z, facing, type);
        } else if (clazz == Crossing.class) {
            stronghold = Crossing.createPiece(component, rand, x, y, z, facing, type);
        } else if (clazz == ChestCorridor.class) {
            stronghold = ChestCorridor.createPiece(component, rand, x, y, z, facing, type);
        } else if (clazz == Library.class) {
            stronghold = Library.createPiece(component, rand, x, y, z, facing, type);
        } else if (clazz == PortalRoom.class) {
            stronghold = PortalRoom.createPiece(component, x, y, z, facing, type);
        }
        return stronghold;
    }

    private static Stronghold generatePieceFromSmallDoor(Stairs2 stairs, List<StructureComponent> component, Random rand, int x, int y, int z, EnumFacing facing, int type) {
        if (!StructureNibiruStrongholdPieces.canAddStructurePieces()) {
            return null;
        }
        if (strongComponentType != null) {
            Stronghold stronghold = StructureNibiruStrongholdPieces.findAndCreatePieceFactory(strongComponentType, component, rand, x, y, z, facing, type);
            strongComponentType = null;
            if (stronghold != null) {
                return stronghold;
            }
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int i = rand.nextInt(totalWeight);
            for (PieceWeight pieceweight : structurePieceList) {
                if ((i -= pieceweight.pieceWeight) >= 0) continue;
                if (!pieceweight.canSpawnMoreStructuresOfType(type) || pieceweight == stairs.lastPlaced) continue block0;
                Stronghold stronghold1 = StructureNibiruStrongholdPieces.findAndCreatePieceFactory(pieceweight.pieceClass, component, rand, x, y, z, facing, type);
                if (stronghold1 == null) continue;
                ++pieceweight.instancesSpawned;
                stairs.lastPlaced = pieceweight;
                if (!pieceweight.canSpawnMoreStructures()) {
                    structurePieceList.remove(pieceweight);
                }
                return stronghold1;
            }
        }
        StructureBoundingBox box = Corridor.findPieceBox(component, x, y, z, facing);
        if (box != null && box.field_78895_b > 1) {
            return new Corridor(type, box, facing);
        }
        return null;
    }

    private static StructureComponent generateAndAddPiece(Stairs2 stairs, List<StructureComponent> component, Random rand, int x, int y, int z, @Nullable EnumFacing facing, int type) {
        if (type > 50) {
            return null;
        }
        if (Math.abs(x - stairs.func_74874_b().field_78897_a) <= 112 && Math.abs(z - stairs.func_74874_b().field_78896_c) <= 112) {
            Stronghold structurecomponent = StructureNibiruStrongholdPieces.generatePieceFromSmallDoor(stairs, component, rand, x, y, z, facing, type + 1);
            if (structurecomponent != null) {
                component.add(structurecomponent);
                stairs.pendingChildren.add(structurecomponent);
            }
            return structurecomponent;
        }
        return null;
    }

    static {
        STRONGHOLD_STONES = new Stones();
    }

    public static abstract class Stronghold
    extends StructureComponent {
        protected Door entryDoor = Door.OPENING;

        public Stronghold() {
        }

        protected Stronghold(int type) {
            super(type);
        }

        protected void func_143012_a(NBTTagCompound nbt) {
            nbt.func_74778_a("EntryDoor", this.entryDoor.name());
        }

        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            this.entryDoor = Door.valueOf(nbt.func_74779_i("EntryDoor"));
        }

        protected void placeDoor(World world, StructureBoundingBox box, Door door, int x, int y, int z) {
            switch (door) {
                case OPENING: {
                    this.func_175804_a(world, box, x, y, z, x + 3 - 1, y + 3 - 1, z, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                    break;
                }
                case WOOD_DOOR: {
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x, y, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x, y + 1, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x, y + 2, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x + 1, y + 2, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x + 2, y + 2, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x + 2, y + 1, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x + 2, y, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_OAK_DOOR.func_176223_P(), x + 1, y, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_OAK_DOOR.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), x + 1, y + 1, z, box);
                    break;
                }
                case GRATES: {
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x + 1, y, z, box);
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x + 1, y + 1, z, box);
                    this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), x, y, z, box);
                    this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), x, y + 1, z, box);
                    this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), x, y + 2, z, box);
                    this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), x + 1, y + 2, z, box);
                    this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), x + 2, y + 2, z, box);
                    this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), x + 2, y + 1, z, box);
                    this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), x + 2, y, z, box);
                    break;
                }
                case IRON_DOOR: {
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x, y, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x, y + 1, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x, y + 2, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x + 1, y + 2, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x + 2, y + 2, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x + 2, y + 1, z, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), x + 2, y, z, box);
                    this.func_175811_a(world, Blocks.field_150454_av.func_176223_P(), x + 1, y, z, box);
                    this.func_175811_a(world, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), x + 1, y + 1, z, box);
                    this.func_175811_a(world, Blocks.field_150430_aB.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.NORTH), x + 2, y + 1, z + 1, box);
                    this.func_175811_a(world, Blocks.field_150430_aB.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.SOUTH), x + 2, y + 1, z - 1, box);
                }
            }
        }

        protected boolean func_191080_a(World world, StructureBoundingBox box, Random rand, BlockPos pos, ResourceLocation lootTable, @Nullable IBlockState state) {
            if (box.func_175898_b((Vec3i)pos) && world.func_180495_p(pos).func_177230_c() != MPBlocks.INFECTED_CHEST) {
                if (state == null) {
                    state = MPBlocks.INFECTED_CHEST.correctFacing(world, pos, MPBlocks.INFECTED_CHEST.func_176223_P());
                }
                world.func_180501_a(pos, state, 2);
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileEntityChestMP) {
                    ((TileEntityChestMP)tile).func_189404_a(lootTable, rand.nextLong());
                }
                return true;
            }
            return false;
        }

        protected Door getRandomDoor(Random rand) {
            int i = rand.nextInt(5);
            switch (i) {
                case 2: {
                    return Door.WOOD_DOOR;
                }
                case 3: {
                    return Door.GRATES;
                }
                case 4: {
                    return Door.IRON_DOOR;
                }
            }
            return Door.OPENING;
        }

        @Nullable
        protected StructureComponent getNextComponentNormal(Stairs2 stairs, List<StructureComponent> component, Random rand, int x, int z) {
            EnumFacing facing = this.func_186165_e();
            if (facing != null) {
                switch (facing) {
                    case SOUTH: {
                        return StructureNibiruStrongholdPieces.generateAndAddPiece(stairs, component, rand, this.field_74887_e.field_78897_a + x, this.field_74887_e.field_78895_b + z, this.field_74887_e.field_78892_f + 1, facing, this.func_74877_c());
                    }
                    case WEST: {
                        return StructureNibiruStrongholdPieces.generateAndAddPiece(stairs, component, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + z, this.field_74887_e.field_78896_c + x, facing, this.func_74877_c());
                    }
                    case EAST: {
                        return StructureNibiruStrongholdPieces.generateAndAddPiece(stairs, component, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + z, this.field_74887_e.field_78896_c + x, facing, this.func_74877_c());
                    }
                }
                return StructureNibiruStrongholdPieces.generateAndAddPiece(stairs, component, rand, this.field_74887_e.field_78897_a + x, this.field_74887_e.field_78895_b + z, this.field_74887_e.field_78896_c - 1, facing, this.func_74877_c());
            }
            return null;
        }

        @Nullable
        protected StructureComponent getNextComponentX(Stairs2 stairs, List<StructureComponent> component, Random rand, int x, int z) {
            EnumFacing facing = this.func_186165_e();
            if (facing != null) {
                switch (facing) {
                    case SOUTH: 
                    case WEST: 
                    case EAST: {
                        return StructureNibiruStrongholdPieces.generateAndAddPiece(stairs, component, rand, this.field_74887_e.field_78897_a + z, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
                return StructureNibiruStrongholdPieces.generateAndAddPiece(stairs, component, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78896_c + z, EnumFacing.WEST, this.func_74877_c());
            }
            return null;
        }

        @Nullable
        protected StructureComponent getNextComponentZ(Stairs2 stairs, List<StructureComponent> component, Random rand, int x, int z) {
            EnumFacing facing = this.func_186165_e();
            if (facing != null) {
                switch (facing) {
                    case WEST: 
                    case EAST: {
                        return StructureNibiruStrongholdPieces.generateAndAddPiece(stairs, component, rand, this.field_74887_e.field_78897_a + z, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
                return StructureNibiruStrongholdPieces.generateAndAddPiece(stairs, component, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + x, this.field_74887_e.field_78896_c + z, EnumFacing.EAST, this.func_74877_c());
            }
            return null;
        }

        protected static boolean canStrongholdGoDeeper(StructureBoundingBox box) {
            return box != null && box.field_78895_b > 10;
        }

        protected void createWasteTank(BlockPos pos, World world, Random rand, StructureBoundingBox box) {
            if (box.func_175898_b((Vec3i)pos)) {
                world.func_180501_a(pos, MPBlocks.NUCLEAR_WASTE_TANK.func_176223_P(), 2);
                world.func_180501_a(pos.func_177984_a(), MPBlocks.NWT_MIDDLE_DUMMY.func_176223_P(), 2);
                world.func_180501_a(pos.func_177981_b(2), MPBlocks.NWT_TOP_DUMMY.func_176223_P(), 2);
                TileEntity tile = world.func_175625_s(pos);
                TileEntity tile1 = world.func_175625_s(pos.func_177984_a());
                TileEntity tile2 = world.func_175625_s(pos.func_177981_b(2));
                if (tile1 instanceof TileEntityDummy && tile2 instanceof TileEntityDummy) {
                    TileEntityDummy dummy1 = (TileEntityDummy)tile1;
                    TileEntityDummy dummy2 = (TileEntityDummy)tile2;
                    dummy1.mainBlockPosition = pos;
                    dummy2.mainBlockPosition = pos;
                }
                if (tile instanceof TileEntityNuclearWasteTank) {
                    TileEntityNuclearWasteTank waste = (TileEntityNuclearWasteTank)tile;
                    waste.hasRod = rand.nextFloat() < 0.9f;
                    waste.onCreate(world, pos);
                }
            }
        }

        protected void createJuicerEgg(int x, int y, int z, World world, Random rand, StructureBoundingBox box) {
            BlockPos pos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (box.func_175898_b((Vec3i)pos)) {
                world.func_180501_a(pos, MPBlocks.JUICER_EGG.func_176223_P(), 2);
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileEntityJuicerEgg) {
                    TileEntityJuicerEgg egg = (TileEntityJuicerEgg)tile;
                    egg.setNeedPlayerNearby();
                }
            }
        }

        public static enum Door {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

        }
    }

    public static class Straight
    extends Stronghold {
        private boolean expandsX;
        private boolean expandsZ;

        public Straight() {
        }

        public Straight(int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.func_186164_a(facing);
            this.entryDoor = this.getRandomDoor(rand);
            this.field_74887_e = box;
            this.expandsX = rand.nextInt(2) == 0;
            this.expandsZ = rand.nextInt(2) == 0;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("Left", this.expandsX);
            nbt.func_74757_a("Right", this.expandsZ);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.expandsX = nbt.func_74767_n("Left");
            this.expandsZ = nbt.func_74767_n("Right");
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            this.getNextComponentNormal((Stairs2)component, list, rand, 1, 1);
            if (this.expandsX) {
                this.getNextComponentX((Stairs2)component, list, rand, 1, 2);
            }
            if (this.expandsZ) {
                this.getNextComponentZ((Stairs2)component, list, rand, 1, 2);
            }
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_74882_a(world, box, 0, 0, 0, 4, 4, 6, true, rand, STRONGHOLD_STONES);
            this.placeDoor(world, box, this.entryDoor, 1, 1, 0);
            this.placeDoor(world, box, Stronghold.Door.OPENING, 1, 1, 6);
            IBlockState iblockstate = MPBlocks.INFECTED_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate1 = MPBlocks.INFECTED_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST);
            this.func_175809_a(world, box, rand, 0.1f, 1, 2, 1, iblockstate);
            this.func_175809_a(world, box, rand, 0.1f, 3, 2, 1, iblockstate1);
            this.func_175809_a(world, box, rand, 0.1f, 1, 2, 5, iblockstate);
            this.func_175809_a(world, box, rand, 0.1f, 3, 2, 5, iblockstate1);
            if (this.expandsX) {
                this.func_175804_a(world, box, 0, 1, 2, 0, 3, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            if (this.expandsZ) {
                this.func_175804_a(world, box, 4, 1, 2, 4, 3, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }

        protected static Straight createPiece(List<StructureComponent> component, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (EnumFacing)facing);
            return Straight.canStrongholdGoDeeper(box) && StructureComponent.func_74883_a(component, (StructureBoundingBox)box) == null ? new Straight(type, rand, box, facing) : null;
        }
    }

    static class Stones
    extends StructureComponent.BlockSelector {
        private Stones() {
        }

        public void func_75062_a(Random rand, int x, int y, int z, boolean wall) {
            float f;
            this.field_151562_a = wall ? ((f = rand.nextFloat()) < 0.2f ? MPBlocks.INFECTED_CRACKED_STONE_BRICKS.func_176223_P() : (f < 0.5f ? MPBlocks.INFECTED_VEIN_STONE_BRICKS.func_176223_P() : (f < 0.55f ? MPBlocks.INFESTED_INFECTED_VEIN_STONE_BRICKS.func_176223_P() : MPBlocks.INFECTED_STONE_BRICKS.func_176223_P()))) : Blocks.field_150350_a.func_176223_P();
        }
    }

    public static class StairsStraight
    extends Stronghold {
        public StairsStraight() {
        }

        public StairsStraight(int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.func_186164_a(facing);
            this.entryDoor = this.getRandomDoor(rand);
            this.field_74887_e = box;
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            this.getNextComponentNormal((Stairs2)component, list, rand, 1, 1);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_74882_a(world, box, 0, 0, 0, 4, 10, 7, true, rand, STRONGHOLD_STONES);
            this.placeDoor(world, box, this.entryDoor, 1, 7, 0);
            this.placeDoor(world, box, Stronghold.Door.OPENING, 1, 1, 7);
            IBlockState iblockstate = MPBlocks.NIBIRU_COBBLESTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            for (int i = 0; i < 6; ++i) {
                this.func_175811_a(world, iblockstate, 1, 6 - i, 1 + i, box);
                this.func_175811_a(world, iblockstate, 2, 6 - i, 1 + i, box);
                this.func_175811_a(world, iblockstate, 3, 6 - i, 1 + i, box);
                if (i >= 5) continue;
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 1, 5 - i, 1 + i, box);
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 2, 5 - i, 1 + i, box);
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 3, 5 - i, 1 + i, box);
            }
            return true;
        }

        protected static StairsStraight createPiece(List<StructureComponent> p_175861_0_, Random p_175861_1_, int p_175861_2_, int p_175861_3_, int p_175861_4_, EnumFacing p_175861_5_, int p_175861_6_) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)p_175861_2_, (int)p_175861_3_, (int)p_175861_4_, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)8, (EnumFacing)p_175861_5_);
            return StairsStraight.canStrongholdGoDeeper(box) && StructureComponent.func_74883_a(p_175861_0_, (StructureBoundingBox)box) == null ? new StairsStraight(p_175861_6_, p_175861_1_, box, p_175861_5_) : null;
        }
    }

    public static class Stairs2
    extends Stairs {
        public PieceWeight lastPlaced;
        public PortalRoom strongholdPortalRoom;
        public final List<StructureComponent> pendingChildren = new ArrayList<StructureComponent>();

        public Stairs2() {
        }

        public Stairs2(Random rand, int x, int z) {
            super(0, rand, x, z);
        }
    }

    public static class Stairs
    extends Stronghold {
        private boolean source;

        public Stairs() {
        }

        public Stairs(int type, Random rand, int x, int z) {
            super(type);
            this.source = true;
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
            this.entryDoor = Stronghold.Door.OPENING;
            this.field_74887_e = new StructureBoundingBox(x, 64, z, x + 5 - 1, 74, z + 5 - 1);
        }

        public Stairs(int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.source = false;
            this.func_186164_a(facing);
            this.entryDoor = this.getRandomDoor(rand);
            this.field_74887_e = box;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("Source", this.source);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.source = nbt.func_74767_n("Source");
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            if (this.source) {
                strongComponentType = Crossing.class;
            }
            this.getNextComponentNormal((Stairs2)component, list, rand, 1, 1);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_74882_a(world, box, 0, 0, 0, 4, 10, 4, true, rand, STRONGHOLD_STONES);
            this.placeDoor(world, box, this.entryDoor, 1, 7, 0);
            this.placeDoor(world, box, Stronghold.Door.OPENING, 1, 1, 4);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 2, 6, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 1, 5, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 1, 6, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 1, 5, 2, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 1, 4, 3, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 1, 5, 3, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 2, 4, 3, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 3, 3, 3, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 3, 4, 3, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 3, 3, 2, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 3, 2, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 3, 3, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 2, 2, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 1, 1, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 1, 2, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 1, 1, 2, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 1, 1, 3, box);
            return true;
        }

        protected static Stairs createPiece(List<StructureComponent> component, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)5, (EnumFacing)facing);
            return Stairs.canStrongholdGoDeeper(box) && StructureComponent.func_74883_a(component, (StructureBoundingBox)box) == null ? new Stairs(type, rand, box, facing) : null;
        }
    }

    public static class RoomCrossing
    extends Stronghold {
        protected int roomType;

        public RoomCrossing() {
        }

        public RoomCrossing(int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.func_186164_a(facing);
            this.entryDoor = this.getRandomDoor(rand);
            this.field_74887_e = box;
            this.roomType = rand.nextInt(5);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74768_a("Type", this.roomType);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.roomType = nbt.func_74762_e("Type");
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            this.getNextComponentNormal((Stairs2)component, list, rand, 4, 1);
            this.getNextComponentX((Stairs2)component, list, rand, 1, 4);
            this.getNextComponentZ((Stairs2)component, list, rand, 1, 4);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_74882_a(world, box, 0, 0, 0, 10, 6, 10, true, rand, STRONGHOLD_STONES);
            this.placeDoor(world, box, this.entryDoor, 4, 1, 0);
            this.func_175804_a(world, box, 4, 1, 10, 6, 3, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 0, 1, 4, 0, 3, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 10, 1, 4, 10, 3, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            switch (this.roomType) {
                case 0: {
                    this.createWasteTank(new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5)), world, rand, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST), 4, 3, 5, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST), 6, 3, 5, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH), 5, 3, 4, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH), 5, 3, 6, box);
                    this.createJuicerEgg(4, 1, 4, world, rand, box);
                    this.createJuicerEgg(4, 1, 5, world, rand, box);
                    this.createJuicerEgg(4, 1, 6, world, rand, box);
                    this.createJuicerEgg(6, 1, 4, world, rand, box);
                    this.createJuicerEgg(6, 1, 5, world, rand, box);
                    this.createJuicerEgg(6, 1, 6, world, rand, box);
                    this.createJuicerEgg(5, 1, 4, world, rand, box);
                    this.createJuicerEgg(5, 1, 6, world, rand, box);
                    break;
                }
                case 1: {
                    for (int i1 = 0; i1 < 5; ++i1) {
                        this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 3, 1, 3 + i1, box);
                        this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 7, 1, 3 + i1, box);
                        this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 3 + i1, 1, 3, box);
                        this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 3 + i1, 1, 7, box);
                    }
                    this.createWasteTank(new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5)), world, rand, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P(), 5, 4, 5, box);
                    break;
                }
                case 2: {
                    for (int i = 1; i <= 9; ++i) {
                        this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 1, 3, i, box);
                        this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 9, 3, i, box);
                    }
                    for (int j = 1; j <= 9; ++j) {
                        this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), j, 3, 1, box);
                        this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), j, 3, 9, box);
                    }
                    this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 5, 1, 4, box);
                    this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 5, 1, 6, box);
                    this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 5, 3, 4, box);
                    this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 5, 3, 6, box);
                    this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 4, 1, 5, box);
                    this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 6, 1, 5, box);
                    this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 4, 3, 5, box);
                    this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 6, 3, 5, box);
                    for (int k = 1; k <= 3; ++k) {
                        this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 4, k, 4, box);
                        this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 6, k, 4, box);
                        this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 4, k, 6, box);
                        this.func_175811_a(world, MPBlocks.NIBIRU_COBBLESTONE.func_176223_P(), 6, k, 6, box);
                    }
                    this.func_175811_a(world, MPBlocks.INFECTED_TORCH.func_176223_P(), 5, 3, 5, box);
                    for (int l = 2; l <= 8; ++l) {
                        this.func_175811_a(world, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), 2, 3, l, box);
                        this.func_175811_a(world, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), 3, 3, l, box);
                        if (l <= 3 || l >= 7) {
                            this.func_175811_a(world, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), 4, 3, l, box);
                            this.func_175811_a(world, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), 5, 3, l, box);
                            this.func_175811_a(world, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), 6, 3, l, box);
                        }
                        this.func_175811_a(world, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), 7, 3, l, box);
                        this.func_175811_a(world, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), 8, 3, l, box);
                    }
                    IBlockState iblockstate = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST);
                    this.func_175811_a(world, iblockstate, 9, 1, 3, box);
                    this.func_175811_a(world, iblockstate, 9, 2, 3, box);
                    this.func_175811_a(world, iblockstate, 9, 3, 3, box);
                    this.func_186167_a(world, box, rand, 3, 4, 8, MPLootTables.NIBIRU_STRONGHOLD_CROSSING);
                }
            }
            return true;
        }

        protected static RoomCrossing createPiece(List<StructureComponent> component, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)11, (int)7, (int)11, (EnumFacing)facing);
            return RoomCrossing.canStrongholdGoDeeper(box) && StructureComponent.func_74883_a(component, (StructureBoundingBox)box) == null ? new RoomCrossing(type, rand, box, facing) : null;
        }
    }

    public static class RightTurn
    extends LeftTurn {
        @Override
        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            EnumFacing facing = this.func_186165_e();
            if (facing != EnumFacing.NORTH && facing != EnumFacing.EAST) {
                this.getNextComponentX((Stairs2)component, list, rand, 1, 1);
            } else {
                this.getNextComponentZ((Stairs2)component, list, rand, 1, 1);
            }
        }

        @Override
        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_74882_a(world, box, 0, 0, 0, 4, 4, 4, true, rand, STRONGHOLD_STONES);
            this.placeDoor(world, box, this.entryDoor, 1, 1, 0);
            EnumFacing facing = this.func_186165_e();
            if (facing != EnumFacing.NORTH && facing != EnumFacing.EAST) {
                this.func_175804_a(world, box, 0, 1, 1, 0, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            } else {
                this.func_175804_a(world, box, 4, 1, 1, 4, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }
    }

    public static class Prison
    extends Stronghold {
        public Prison() {
        }

        public Prison(int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.func_186164_a(facing);
            this.entryDoor = this.getRandomDoor(rand);
            this.field_74887_e = box;
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            this.getNextComponentNormal((Stairs2)component, list, rand, 1, 1);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_74882_a(world, box, 0, 0, 0, 8, 4, 10, true, rand, STRONGHOLD_STONES);
            this.placeDoor(world, box, this.entryDoor, 1, 1, 0);
            this.func_175804_a(world, box, 1, 1, 10, 3, 3, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(world, box, 4, 1, 1, 4, 3, 1, false, rand, STRONGHOLD_STONES);
            this.func_74882_a(world, box, 4, 1, 3, 4, 3, 3, false, rand, STRONGHOLD_STONES);
            this.func_74882_a(world, box, 4, 1, 7, 4, 3, 7, false, rand, STRONGHOLD_STONES);
            this.func_74882_a(world, box, 4, 1, 9, 4, 3, 9, false, rand, STRONGHOLD_STONES);
            this.func_175804_a(world, box, 4, 1, 4, 4, 3, 6, Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            this.func_175804_a(world, box, 5, 1, 5, 7, 3, 5, Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), 4, 3, 2, box);
            this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), 4, 3, 8, box);
            IBlockState iblockstate = Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST);
            IBlockState iblockstate1 = Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            this.func_175811_a(world, iblockstate, 4, 1, 2, box);
            this.func_175811_a(world, iblockstate1, 4, 2, 2, box);
            this.func_175811_a(world, iblockstate, 4, 1, 8, box);
            this.func_175811_a(world, iblockstate1, 4, 2, 8, box);
            return true;
        }

        protected static Prison createPiece(List<StructureComponent> component, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)9, (int)5, (int)11, (EnumFacing)facing);
            return Prison.canStrongholdGoDeeper(box) && StructureComponent.func_74883_a(component, (StructureBoundingBox)box) == null ? new Prison(type, rand, box, facing) : null;
        }
    }

    public static class PortalRoom
    extends Stronghold {
        public PortalRoom() {
        }

        public PortalRoom(int type, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            ((Stairs2)component).strongholdPortalRoom = this;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            this.func_74882_a(world, box, 0, 0, 0, 10, 7, 15, false, rand, STRONGHOLD_STONES);
            this.placeDoor(world, box, Stronghold.Door.GRATES, 4, 1, 0);
            int i = 6;
            this.func_74882_a(world, box, 1, i, 1, 1, i, 14, false, rand, STRONGHOLD_STONES);
            this.func_74882_a(world, box, 9, i, 1, 9, i, 14, false, rand, STRONGHOLD_STONES);
            this.func_74882_a(world, box, 2, i, 1, 8, i, 2, false, rand, STRONGHOLD_STONES);
            this.func_74882_a(world, box, 2, i, 14, 8, i, 14, false, rand, STRONGHOLD_STONES);
            if (rand.nextBoolean()) {
                this.createWasteTank(new BlockPos(this.func_74865_a(2, 1), this.func_74862_a(1), this.func_74873_b(2, 1)), world, rand, box);
                this.createWasteTank(new BlockPos(this.func_74865_a(1, 1), this.func_74862_a(1), this.func_74873_b(1, 1)), world, rand, box);
                this.createWasteTank(new BlockPos(this.func_74865_a(1, 2), this.func_74862_a(1), this.func_74873_b(1, 2)), world, rand, box);
                this.createWasteTank(new BlockPos(this.func_74865_a(8, 1), this.func_74862_a(1), this.func_74873_b(8, 1)), world, rand, box);
                this.createWasteTank(new BlockPos(this.func_74865_a(9, 1), this.func_74862_a(1), this.func_74873_b(9, 1)), world, rand, box);
                this.createWasteTank(new BlockPos(this.func_74865_a(9, 2), this.func_74862_a(1), this.func_74873_b(9, 2)), world, rand, box);
            } else {
                this.createJuicerEgg(3, 1, 1, world, rand, box);
                this.createJuicerEgg(7, 1, 1, world, rand, box);
                this.func_74882_a(world, box, 1, 1, 1, 2, 1, 4, false, rand, STRONGHOLD_STONES);
                this.func_74882_a(world, box, 8, 1, 1, 9, 1, 4, false, rand, STRONGHOLD_STONES);
                this.func_175804_a(world, box, 1, 1, 1, 1, 1, 3, MPBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P(), MPBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P(), false);
                this.func_175804_a(world, box, 9, 1, 1, 9, 1, 3, MPBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P(), MPBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P(), false);
            }
            this.createWasteTank(new BlockPos(this.func_74865_a(1, 14), this.func_74862_a(1), this.func_74873_b(1, 14)), world, rand, box);
            this.createWasteTank(new BlockPos(this.func_74865_a(9, 14), this.func_74862_a(1), this.func_74873_b(9, 14)), world, rand, box);
            this.func_74882_a(world, box, 3, 1, 8, 7, 1, 12, false, rand, STRONGHOLD_STONES);
            this.func_175804_a(world, box, 4, 1, 9, 6, 1, 11, MPBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P(), MPBlocks.NUCLEAR_WASTE_FLUID_BLOCK.func_176223_P(), false);
            for (int j = 3; j < 14; j += 2) {
                this.func_175804_a(world, box, 0, 3, j, 0, 4, j, Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
                this.func_175804_a(world, box, 10, 3, j, 10, 4, j, Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            for (int i1 = 2; i1 < 9; i1 += 2) {
                this.func_175804_a(world, box, i1, 3, 15, i1, 4, 15, Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            }
            IBlockState iblockstate3 = MPBlocks.INFECTED_STONE_BRICKS_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            this.func_74882_a(world, box, 4, 1, 5, 6, 1, 7, false, rand, STRONGHOLD_STONES);
            this.func_74882_a(world, box, 4, 2, 6, 6, 2, 7, false, rand, STRONGHOLD_STONES);
            this.func_74882_a(world, box, 4, 3, 7, 6, 3, 7, false, rand, STRONGHOLD_STONES);
            for (int k = 4; k <= 6; ++k) {
                this.func_175811_a(world, iblockstate3, k, 1, 4, box);
                this.func_175811_a(world, iblockstate3, k, 2, 5, box);
                this.func_175811_a(world, iblockstate3, k, 3, 6, box);
            }
            IBlockState iblockstate4 = MPBlocks.VEIN_FRAME.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)EnumFacing.NORTH);
            IBlockState iblockstate = MPBlocks.VEIN_FRAME.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)EnumFacing.SOUTH);
            IBlockState iblockstate1 = MPBlocks.VEIN_FRAME.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate2 = MPBlocks.VEIN_FRAME.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)EnumFacing.WEST);
            boolean[] aboolean = new boolean[12];
            for (int l = 0; l < aboolean.length; ++l) {
                aboolean[l] = rand.nextFloat() > 0.9f;
            }
            this.func_175811_a(world, iblockstate4.func_177226_a((IProperty)BlockVeinFrame.EYE, (Comparable)Boolean.valueOf(aboolean[0])), 4, 3, 8, box);
            this.func_175811_a(world, iblockstate4.func_177226_a((IProperty)BlockVeinFrame.EYE, (Comparable)Boolean.valueOf(aboolean[1])), 5, 3, 8, box);
            this.func_175811_a(world, iblockstate4.func_177226_a((IProperty)BlockVeinFrame.EYE, (Comparable)Boolean.valueOf(aboolean[2])), 6, 3, 8, box);
            this.func_175811_a(world, iblockstate.func_177226_a((IProperty)BlockVeinFrame.EYE, (Comparable)Boolean.valueOf(aboolean[3])), 4, 3, 12, box);
            this.func_175811_a(world, iblockstate.func_177226_a((IProperty)BlockVeinFrame.EYE, (Comparable)Boolean.valueOf(aboolean[4])), 5, 3, 12, box);
            this.func_175811_a(world, iblockstate.func_177226_a((IProperty)BlockVeinFrame.EYE, (Comparable)Boolean.valueOf(aboolean[5])), 6, 3, 12, box);
            this.func_175811_a(world, iblockstate1.func_177226_a((IProperty)BlockVeinFrame.EYE, (Comparable)Boolean.valueOf(aboolean[6])), 3, 3, 9, box);
            this.func_175811_a(world, iblockstate1.func_177226_a((IProperty)BlockVeinFrame.EYE, (Comparable)Boolean.valueOf(aboolean[7])), 3, 3, 10, box);
            this.func_175811_a(world, iblockstate1.func_177226_a((IProperty)BlockVeinFrame.EYE, (Comparable)Boolean.valueOf(aboolean[8])), 3, 3, 11, box);
            this.func_175811_a(world, iblockstate2.func_177226_a((IProperty)BlockVeinFrame.EYE, (Comparable)Boolean.valueOf(aboolean[9])), 7, 3, 9, box);
            this.func_175811_a(world, iblockstate2.func_177226_a((IProperty)BlockVeinFrame.EYE, (Comparable)Boolean.valueOf(aboolean[10])), 7, 3, 10, box);
            this.func_175811_a(world, iblockstate2.func_177226_a((IProperty)BlockVeinFrame.EYE, (Comparable)Boolean.valueOf(aboolean[11])), 7, 3, 11, box);
            this.createSpawner(world, new BlockPos(this.func_74865_a(5, 6), this.func_74862_a(3), this.func_74873_b(5, 6)), box, EntityInfectedWorm.class);
            this.createSpawner(world, new BlockPos(this.func_74865_a(1, 1), this.func_74862_a(0), this.func_74873_b(1, 1)), box, EntityZergius.class);
            this.createSpawner(world, new BlockPos(this.func_74865_a(9, 1), this.func_74862_a(0), this.func_74873_b(9, 1)), box, EntityZergius.class);
            this.createSpawner(world, new BlockPos(this.func_74865_a(1, 14), this.func_74862_a(0), this.func_74873_b(1, 14)), box, EntityZergius.class);
            this.createSpawner(world, new BlockPos(this.func_74865_a(9, 14), this.func_74862_a(0), this.func_74873_b(9, 14)), box, EntityZergius.class);
            return true;
        }

        protected static PortalRoom createPiece(List<StructureComponent> component, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)11, (int)8, (int)16, (EnumFacing)facing);
            return PortalRoom.canStrongholdGoDeeper(box) && StructureComponent.func_74883_a(component, (StructureBoundingBox)box) == null ? new PortalRoom(type, box, facing) : null;
        }

        private void createSpawner(World world, BlockPos pos, StructureBoundingBox box, Class<? extends Entity> entity) {
            if (box.func_175898_b((Vec3i)pos)) {
                world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileentity = world.func_175625_s(pos);
                if (tileentity instanceof TileEntityMobSpawner) {
                    ((TileEntityMobSpawner)tileentity).func_145881_a().func_190894_a(EntityList.func_191306_a(entity));
                }
            }
        }
    }

    public static class PieceWeight {
        public final Class<? extends Stronghold> pieceClass;
        public final int pieceWeight;
        public int instancesSpawned;
        public final int instancesLimit;

        public PieceWeight(Class<? extends Stronghold> pieceClass, int pieceWeight, int instancesLimit) {
            this.pieceClass = pieceClass;
            this.pieceWeight = pieceWeight;
            this.instancesLimit = instancesLimit;
        }

        public boolean canSpawnMoreStructuresOfType(int type) {
            return this.instancesLimit == 0 || this.instancesSpawned < this.instancesLimit;
        }

        public boolean canSpawnMoreStructures() {
            return this.instancesLimit == 0 || this.instancesSpawned < this.instancesLimit;
        }
    }

    public static class Library
    extends Stronghold {
        private boolean isLargeRoom;

        public Library() {
        }

        public Library(int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.func_186164_a(facing);
            this.entryDoor = this.getRandomDoor(rand);
            this.field_74887_e = box;
            this.isLargeRoom = box.func_78882_c() > 6;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("Tall", this.isLargeRoom);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.isLargeRoom = nbt.func_74767_n("Tall");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            int i = 11;
            if (!this.isLargeRoom) {
                i = 6;
            }
            this.func_74882_a(world, box, 0, 0, 0, 13, i - 1, 14, true, rand, STRONGHOLD_STONES);
            this.placeDoor(world, box, this.entryDoor, 4, 1, 0);
            this.func_189914_a(world, box, rand, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.field_150321_G.func_176223_P(), Blocks.field_150321_G.func_176223_P(), false, 0);
            for (int l = 1; l <= 13; ++l) {
                if ((l - 1) % 4 == 0) {
                    this.func_175804_a(world, box, 1, 1, l, 1, 4, l, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), false);
                    this.func_175804_a(world, box, 12, 1, l, 12, 4, l, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), false);
                    this.func_175811_a(world, MPBlocks.INFECTED_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST), 2, 3, l, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST), 11, 3, l, box);
                    if (!this.isLargeRoom) continue;
                    this.func_175804_a(world, box, 1, 6, l, 1, 9, l, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), false);
                    this.func_175804_a(world, box, 12, 6, l, 12, 9, l, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), false);
                    continue;
                }
                this.func_175804_a(world, box, 1, 1, l, 1, 4, l, MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), false);
                this.func_175804_a(world, box, 12, 1, l, 12, 4, l, MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), false);
                if (!this.isLargeRoom) continue;
                this.func_175804_a(world, box, 1, 6, l, 1, 9, l, MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), false);
                this.func_175804_a(world, box, 12, 6, l, 12, 9, l, MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), false);
            }
            for (int k1 = 3; k1 < 12; k1 += 2) {
                this.func_175804_a(world, box, 3, 1, k1, 4, 3, k1, MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), false);
                this.func_175804_a(world, box, 6, 1, k1, 7, 3, k1, MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), false);
                this.func_175804_a(world, box, 9, 1, k1, 10, 3, k1, MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), MPBlocks.INFECTED_OAK_BOOKSHELF.func_176223_P(), false);
            }
            if (this.isLargeRoom) {
                this.func_175804_a(world, box, 1, 5, 1, 3, 5, 13, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), false);
                this.func_175804_a(world, box, 10, 5, 1, 12, 5, 13, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), false);
                this.func_175804_a(world, box, 4, 5, 1, 9, 5, 2, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), false);
                this.func_175804_a(world, box, 4, 5, 12, 9, 5, 13, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), false);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), 9, 5, 11, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), 8, 5, 11, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_PLANKS.func_176223_P(), 9, 5, 10, box);
                this.func_175804_a(world, box, 3, 6, 2, 3, 6, 12, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), false);
                this.func_175804_a(world, box, 10, 6, 2, 10, 6, 10, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), false);
                this.func_175804_a(world, box, 4, 6, 2, 9, 6, 2, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), false);
                this.func_175804_a(world, box, 4, 6, 12, 8, 6, 12, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), false);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 9, 6, 11, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 8, 6, 11, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 9, 6, 10, box);
                IBlockState iblockstate1 = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.SOUTH);
                this.func_175811_a(world, iblockstate1, 10, 1, 13, box);
                this.func_175811_a(world, iblockstate1, 10, 2, 13, box);
                this.func_175811_a(world, iblockstate1, 10, 3, 13, box);
                this.func_175811_a(world, iblockstate1, 10, 4, 13, box);
                this.func_175811_a(world, iblockstate1, 10, 5, 13, box);
                this.func_175811_a(world, iblockstate1, 10, 6, 13, box);
                this.func_175811_a(world, iblockstate1, 10, 7, 13, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 6, 9, 7, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 7, 9, 7, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 6, 8, 7, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 7, 8, 7, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 6, 7, 7, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 7, 7, 7, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 5, 7, 7, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 8, 7, 7, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 6, 7, 6, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 6, 7, 8, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 7, 7, 6, box);
                this.func_175811_a(world, MPBlocks.INFECTED_OAK_FENCE.func_176223_P(), 7, 7, 8, box);
                IBlockState iblockstate = MPBlocks.INFECTED_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.UP);
                this.func_175811_a(world, iblockstate, 5, 8, 7, box);
                this.func_175811_a(world, iblockstate, 8, 8, 7, box);
                this.func_175811_a(world, iblockstate, 6, 8, 6, box);
                this.func_175811_a(world, iblockstate, 6, 8, 8, box);
                this.func_175811_a(world, iblockstate, 7, 8, 6, box);
                this.func_175811_a(world, iblockstate, 7, 8, 8, box);
            }
            this.func_186167_a(world, box, rand, 3, 3, 5, MPLootTables.NIBIRU_STRONGHOLD_LIBRARY);
            if (this.isLargeRoom) {
                this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 12, 9, 1, box);
                this.func_186167_a(world, box, rand, 12, 8, 1, MPLootTables.NIBIRU_STRONGHOLD_LIBRARY);
            }
            return true;
        }

        protected static Library createPiece(List<StructureComponent> component, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)14, (int)11, (int)15, (EnumFacing)facing);
            if (!(Library.canStrongholdGoDeeper(box) && StructureComponent.func_74883_a(component, (StructureBoundingBox)box) == null || Library.canStrongholdGoDeeper(box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)14, (int)6, (int)15, (EnumFacing)facing)) && StructureComponent.func_74883_a(component, (StructureBoundingBox)box) == null)) {
                return null;
            }
            return new Library(type, rand, box, facing);
        }
    }

    public static class LeftTurn
    extends Stronghold {
        public LeftTurn() {
        }

        public LeftTurn(int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.func_186164_a(facing);
            this.entryDoor = this.getRandomDoor(rand);
            this.field_74887_e = box;
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            EnumFacing facing = this.func_186165_e();
            if (facing != EnumFacing.NORTH && facing != EnumFacing.EAST) {
                this.getNextComponentZ((Stairs2)component, list, rand, 1, 1);
            } else {
                this.getNextComponentX((Stairs2)component, list, rand, 1, 1);
            }
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_74882_a(world, box, 0, 0, 0, 4, 4, 4, true, rand, STRONGHOLD_STONES);
            this.placeDoor(world, box, this.entryDoor, 1, 1, 0);
            EnumFacing facing = this.func_186165_e();
            if (facing != EnumFacing.NORTH && facing != EnumFacing.EAST) {
                this.func_175804_a(world, box, 4, 1, 1, 4, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            } else {
                this.func_175804_a(world, box, 0, 1, 1, 0, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }

        protected static LeftTurn createPiece(List<StructureComponent> component, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)5, (EnumFacing)facing);
            return LeftTurn.canStrongholdGoDeeper(box) && StructureComponent.func_74883_a(component, (StructureBoundingBox)box) == null ? new LeftTurn(type, rand, box, facing) : null;
        }
    }

    public static class Crossing
    extends Stronghold {
        private boolean leftLow;
        private boolean leftHigh;
        private boolean rightLow;
        private boolean rightHigh;

        public Crossing() {
        }

        public Crossing(int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.func_186164_a(facing);
            this.entryDoor = this.getRandomDoor(rand);
            this.field_74887_e = box;
            this.leftLow = rand.nextBoolean();
            this.leftHigh = rand.nextBoolean();
            this.rightLow = rand.nextBoolean();
            this.rightHigh = rand.nextInt(3) > 0;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("leftLow", this.leftLow);
            nbt.func_74757_a("leftHigh", this.leftHigh);
            nbt.func_74757_a("rightLow", this.rightLow);
            nbt.func_74757_a("rightHigh", this.rightHigh);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.leftLow = nbt.func_74767_n("leftLow");
            this.leftHigh = nbt.func_74767_n("leftHigh");
            this.rightLow = nbt.func_74767_n("rightLow");
            this.rightHigh = nbt.func_74767_n("rightHigh");
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            int i = 3;
            int j = 5;
            EnumFacing facing = this.func_186165_e();
            if (facing == EnumFacing.WEST || facing == EnumFacing.NORTH) {
                i = 8 - i;
                j = 8 - j;
            }
            this.getNextComponentNormal((Stairs2)component, list, rand, 5, 1);
            if (this.leftLow) {
                this.getNextComponentX((Stairs2)component, list, rand, i, 1);
            }
            if (this.leftHigh) {
                this.getNextComponentX((Stairs2)component, list, rand, j, 7);
            }
            if (this.rightLow) {
                this.getNextComponentZ((Stairs2)component, list, rand, i, 1);
            }
            if (this.rightHigh) {
                this.getNextComponentZ((Stairs2)component, list, rand, j, 7);
            }
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_74882_a(world, box, 0, 0, 0, 9, 8, 10, true, rand, STRONGHOLD_STONES);
            this.placeDoor(world, box, this.entryDoor, 4, 3, 0);
            if (this.leftLow) {
                this.func_175804_a(world, box, 0, 3, 1, 0, 5, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            if (this.rightLow) {
                this.func_175804_a(world, box, 9, 3, 1, 9, 5, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            if (this.leftHigh) {
                this.func_175804_a(world, box, 0, 5, 7, 0, 7, 9, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            if (this.rightHigh) {
                this.func_175804_a(world, box, 9, 5, 7, 9, 7, 9, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.func_175804_a(world, box, 5, 1, 10, 7, 3, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_74882_a(world, box, 1, 2, 1, 8, 2, 6, false, rand, STRONGHOLD_STONES);
            this.func_74882_a(world, box, 4, 1, 5, 4, 4, 9, false, rand, STRONGHOLD_STONES);
            this.func_74882_a(world, box, 8, 1, 5, 8, 4, 9, false, rand, STRONGHOLD_STONES);
            this.func_74882_a(world, box, 1, 4, 7, 3, 4, 9, false, rand, STRONGHOLD_STONES);
            this.func_74882_a(world, box, 1, 3, 5, 3, 3, 6, false, rand, STRONGHOLD_STONES);
            this.func_175804_a(world, box, 1, 3, 4, 3, 3, 4, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), false);
            this.func_175804_a(world, box, 1, 4, 6, 3, 4, 6, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), false);
            this.func_74882_a(world, box, 5, 1, 7, 7, 1, 8, false, rand, STRONGHOLD_STONES);
            this.func_175804_a(world, box, 5, 1, 9, 7, 1, 9, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), false);
            this.func_175804_a(world, box, 5, 2, 7, 7, 2, 7, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), false);
            this.func_175804_a(world, box, 4, 5, 7, 4, 5, 9, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), false);
            this.func_175804_a(world, box, 8, 5, 7, 8, 5, 9, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), false);
            this.func_175804_a(world, box, 5, 5, 7, 7, 5, 9, MPBlocks.DOUBLE_INFECTED_STONE_BRICKS_SLAB.func_176223_P(), MPBlocks.DOUBLE_INFECTED_STONE_BRICKS_SLAB.func_176223_P(), false);
            this.func_175811_a(world, MPBlocks.INFECTED_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH), 6, 5, 6, box);
            return true;
        }

        protected static Crossing createPiece(List<StructureComponent> component, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-4, (int)-3, (int)0, (int)10, (int)9, (int)11, (EnumFacing)facing);
            return Crossing.canStrongholdGoDeeper(box) && StructureComponent.func_74883_a(component, (StructureBoundingBox)box) == null ? new Crossing(type, rand, box, facing) : null;
        }
    }

    public static class Corridor
    extends Stronghold {
        private int steps;

        public Corridor() {
        }

        public Corridor(int type, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.func_186164_a(facing);
            this.field_74887_e = box;
            this.steps = facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH ? box.func_78883_b() : box.func_78880_d();
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74768_a("Steps", this.steps);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.steps = nbt.func_74762_e("Steps");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            for (int i = 0; i < this.steps; ++i) {
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 0, 0, i, box);
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 1, 0, i, box);
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 2, 0, i, box);
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 3, 0, i, box);
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 4, 0, i, box);
                for (int j = 1; j <= 3; ++j) {
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 0, j, i, box);
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 1, j, i, box);
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, j, i, box);
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 3, j, i, box);
                    this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 4, j, i, box);
                }
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 0, 4, i, box);
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 1, 4, i, box);
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 2, 4, i, box);
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 3, 4, i, box);
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), 4, 4, i, box);
            }
            return true;
        }

        protected static StructureBoundingBox findPieceBox(List<StructureComponent> component, int x, int y, int z, EnumFacing facing) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)4, (EnumFacing)facing);
            StructureComponent structurecomponent = StructureComponent.func_74883_a(component, (StructureBoundingBox)box);
            if (structurecomponent != null && structurecomponent.func_74874_b().field_78895_b == box.field_78895_b) {
                for (int j = 3; j >= 1; --j) {
                    box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)(j - 1), (EnumFacing)facing);
                    if (structurecomponent.func_74874_b().func_78884_a(box)) continue;
                    return StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)j, (EnumFacing)facing);
                }
            }
            return null;
        }
    }

    public static class ChestCorridor
    extends Stronghold {
        private boolean hasMadeChest;

        public ChestCorridor() {
        }

        public ChestCorridor(int type, Random rand, StructureBoundingBox box, EnumFacing facing) {
            super(type);
            this.func_186164_a(facing);
            this.entryDoor = this.getRandomDoor(rand);
            this.field_74887_e = box;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.hasMadeChest = nbt.func_74767_n("Chest");
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random rand) {
            this.getNextComponentNormal((Stairs2)component, list, rand, 1, 1);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_74882_a(world, box, 0, 0, 0, 4, 4, 6, true, rand, STRONGHOLD_STONES);
            this.placeDoor(world, box, this.entryDoor, 1, 1, 0);
            this.placeDoor(world, box, Stronghold.Door.OPENING, 1, 1, 6);
            this.func_175804_a(world, box, 3, 1, 2, 3, 1, 4, MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), MPBlocks.INFECTED_STONE_BRICKS.func_176223_P(), false);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 3, 1, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 3, 1, 5, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 3, 2, 2, box);
            this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 3, 2, 4, box);
            for (int i = 2; i <= 4; ++i) {
                this.func_175811_a(world, MPBlocks.INFECTED_STONE_BRICKS_SLAB.func_176223_P(), 2, 1, i, box);
            }
            if (!this.hasMadeChest && box.func_175898_b((Vec3i)new BlockPos(this.func_74865_a(3, 3), this.func_74862_a(2), this.func_74873_b(3, 3)))) {
                this.hasMadeChest = true;
                this.func_186167_a(world, box, rand, 3, 2, 3, MPLootTables.NIBIRU_STRONGHOLD_CORRIDOR);
            }
            return true;
        }

        protected static ChestCorridor createPiece(List<StructureComponent> component, Random rand, int x, int y, int z, EnumFacing facing, int type) {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (EnumFacing)facing);
            return ChestCorridor.canStrongholdGoDeeper(box) && StructureComponent.func_74883_a(component, (StructureBoundingBox)box) == null ? new ChestCorridor(type, rand, box, facing) : null;
        }
    }
}

