/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.tileentity;

import com.stevekung.lib.utils.JsonUtils;
import com.stevekung.lib.utils.LangUtils;
import com.stevekung.lib.utils.client.ClientUtils;
import com.stevekung.moreplanets.core.MorePlanetsMod;
import com.stevekung.moreplanets.core.event.ClientEventHandler;
import com.stevekung.moreplanets.entity.EntityBlackHole;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPPotions;
import com.stevekung.moreplanets.init.MPSounds;
import com.stevekung.moreplanets.network.PacketSimpleMP;
import com.stevekung.moreplanets.planets.diona.entity.EntityDarkLightningBolt;
import com.stevekung.moreplanets.planets.diona.tileentity.TileEntityInfectedPurloniteEnderCore;
import com.stevekung.moreplanets.planets.diona.tileentity.TileEntityZeliusEgg;
import com.stevekung.moreplanets.tileentity.TileEntityDummy;
import com.stevekung.moreplanets.utils.EnumParticleTypesMP;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDarkEnergyReceiver
extends TileEntityDummy
implements IMultiBlock {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean activated;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int activatedTick;
    public int failedTick;
    public boolean activatedMessage;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean successful;
    public boolean spawnedBlackHole;
    public boolean failed;
    public boolean rendered;
    public float solarRotate;
    public float rodUp;
    public static final Map<BlockPos, IBlockState> multiBlockLists = new HashMap<BlockPos, IBlockState>();
    public final Map<BlockPos, TileEntity> multiTileClientLists = new HashMap<BlockPos, TileEntity>();
    public final Map<BlockPos, IBlockState> multiBlockClientLists = new HashMap<BlockPos, IBlockState>();
    public boolean initMultiBlock;
    private final TileEntityZeliusEgg egg = new TileEntityZeliusEgg();
    private final TileEntityInfectedPurloniteEnderCore core = new TileEntityInfectedPurloniteEnderCore();

    public TileEntityDarkEnergyReceiver() {
        super("container.dark_energy_receiver.name");
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        this.initMultiBlock = true;
        this.storage.setMaxExtract(1000.0f);
        this.storage.setCapacity(250000.0f);
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 0;
        }
    }

    public int getPacketCooldown() {
        return 1;
    }

    public void func_73660_a() {
        block30: {
            block29: {
                super.func_73660_a();
                this.func_70296_d();
                if (this.initMultiBlock) {
                    this.multiTileClientLists.put(new BlockPos(1, -1, 0), this.egg);
                    this.multiTileClientLists.put(new BlockPos(0, -1, 1), this.egg);
                    this.multiTileClientLists.put(new BlockPos(-1, -1, 0), this.egg);
                    this.multiTileClientLists.put(new BlockPos(0, -1, -1), this.egg);
                    this.multiTileClientLists.put(new BlockPos(3, 2, 3), this.core);
                    this.multiTileClientLists.put(new BlockPos(-3, 2, 3), this.core);
                    this.multiTileClientLists.put(new BlockPos(3, 2, -3), this.core);
                    this.multiTileClientLists.put(new BlockPos(-3, 2, -3), this.core);
                    this.multiBlockClientLists.putAll(multiBlockLists);
                    this.initMultiBlock = false;
                }
                if (this.field_145850_b.field_72995_K) break block29;
                if (!this.activated || this.disabled) break block30;
                if (!this.successful) {
                    int radius = 32;
                    for (Entity entity : this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - radius), (double)(this.field_174879_c.func_177956_o() - radius), (double)(this.field_174879_c.func_177952_p() - radius), (double)(this.field_174879_c.func_177958_n() + radius), (double)(this.field_174879_c.func_177956_o() + radius), (double)(this.field_174879_c.func_177952_p() + radius)))) {
                        if (!(entity instanceof EntityLivingBase)) continue;
                        EntityLivingBase living = (EntityLivingBase)entity;
                        if (!(living instanceof EntityPlayer)) {
                            living.func_70690_d(new PotionEffect(MPPotions.DARK_ENERGY, 200, 0));
                        }
                        if (!(entity instanceof EntityPlayer)) continue;
                        EntityPlayer player = (EntityPlayer)entity;
                        if (player.field_71075_bZ.field_75098_d || player.func_70644_a(MPPotions.DARK_ENERGY_PROTECTION)) continue;
                        player.func_70690_d(new PotionEffect(MPPotions.DARK_ENERGY, 200, 0));
                    }
                }
                if (this.activatedTick < this.getSuccessfulTick()) {
                    if (this.activatedTick % 20 == 0) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), MPSounds.MACHINE_ACTIVATE_AMBIENT, SoundCategory.BLOCKS, 1.0f, 1.025f);
                    }
                    if (this.activatedTick >= this.getSuccessfulTick() - 5 && this.activatedTick <= this.getSuccessfulTick()) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), MPSounds.MACHINE_STOP, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    if (!this.failed) {
                        if (this.field_145850_b.field_73012_v.nextInt(30) == 0) {
                            EntityDarkLightningBolt bolt = new EntityDarkLightningBolt(this.field_145850_b, this.field_145850_b.field_73012_v.nextBoolean() ? (double)(this.field_174879_c.func_177958_n() + 3) : (double)(this.field_174879_c.func_177958_n() - 3), (double)this.field_174879_c.func_177956_o() + 2.5, this.field_145850_b.field_73012_v.nextBoolean() ? (double)(this.field_174879_c.func_177952_p() + 3) : (double)(this.field_174879_c.func_177952_p() - 3));
                            this.field_145850_b.func_72838_d((Entity)bolt);
                        }
                        ++this.activatedTick;
                    }
                }
                if (this.failed) {
                    ++this.failedTick;
                    if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                        EntityDarkLightningBolt bolt = new EntityDarkLightningBolt(this.field_145850_b, this.field_145850_b.field_73012_v.nextBoolean() ? (double)(this.field_174879_c.func_177958_n() + 3) : (double)(this.field_174879_c.func_177958_n() - 3), (double)this.field_174879_c.func_177956_o() + 2.5, this.field_145850_b.field_73012_v.nextBoolean() ? (double)(this.field_174879_c.func_177952_p() + 3) : (double)(this.field_174879_c.func_177952_p() - 3));
                        this.field_145850_b.func_72838_d((Entity)bolt);
                    }
                    if (this.failedTick % 20 == 0) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), MPSounds.MACHINE_ACTIVATE_AMBIENT, SoundCategory.BLOCKS, 1.0f, 1.025f);
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), MPSounds.MACHINE_DANGER, SoundCategory.BLOCKS, 5.0f, 1.0f);
                    }
                }
                if (TileEntityDarkEnergyReceiver.checkValidMultiblock(this.field_174879_c, this.field_145850_b) || this.getEnergyStoredGC() < 20000.0f) {
                    this.failed = true;
                }
                for (int yRender = this.field_174879_c.func_177956_o(); yRender < 256; ++yRender) {
                    IBlockState state2 = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), yRender, this.field_174879_c.func_177952_p()));
                    if (state2.func_185914_p() && state2.func_177230_c() != MPBlocks.DARK_ENERGY_CORE) {
                        this.failed = true;
                    }
                    if (this.func_145832_p() == 0 || this.func_145832_p() == 2) {
                        state2 = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n() + 1, yRender + 1, this.field_174879_c.func_177952_p()));
                        if (state2.func_185914_p() && state2.func_177230_c() != MPBlocks.DARK_ENERGY_CORE) {
                            this.failed = true;
                        }
                        state2 = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n() - 1, yRender + 1, this.field_174879_c.func_177952_p()));
                    } else {
                        state2 = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), yRender + 1, this.field_174879_c.func_177952_p() + 1));
                        if (state2.func_185914_p() && state2.func_177230_c() != MPBlocks.DARK_ENERGY_CORE) {
                            this.failed = true;
                        }
                        state2 = this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), yRender + 1, this.field_174879_c.func_177952_p() - 1));
                    }
                    if (!state2.func_185914_p() || state2.func_177230_c() == MPBlocks.DARK_ENERGY_CORE) continue;
                    this.failed = true;
                }
                if (!this.successful && this.activatedTick == this.getSuccessfulTick()) {
                    if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a()).func_177230_c() != MPBlocks.DARK_ENERGY_CORE) {
                        EntityDarkLightningBolt bolt = new EntityDarkLightningBolt(this.field_145850_b, this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 2.5, this.field_174879_c.func_177952_p());
                        this.field_145850_b.func_184133_a(null, this.func_174877_v().func_177982_a(0, 2, 0), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                        this.field_145850_b.func_72838_d((Entity)bolt);
                        this.field_145850_b.func_175656_a(this.func_174877_v().func_177984_a(), MPBlocks.DARK_ENERGY_CORE.func_176223_P());
                    }
                    multiBlockLists.forEach((mPos, state) -> {
                        BlockPos pos = this.field_174879_c.func_177971_a((Vec3i)mPos);
                        if (state != MPBlocks.DUNGEON_GLOWSTONE.func_176223_P() && state != MPBlocks.INFECTED_PURLONITE_SLIME_BLOCK.func_176223_P()) {
                            for (int i = 0; i < 120; ++i) {
                                MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.DARK_PORTAL, (double)pos.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)pos.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble(), (double)pos.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), 0.0, -this.field_145850_b.field_73012_v.nextDouble(), 0.0);
                            }
                            this.field_145850_b.func_175698_g(pos);
                        } else {
                            this.field_145850_b.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
                        }
                    });
                    this.setDisabled(0, true);
                    this.activatedMessage = true;
                    this.successful = true;
                }
                if (this.failedTick <= 600 || this.spawnedBlackHole) break block30;
                EntityBlackHole blackHole = new EntityBlackHole(this.field_145850_b);
                blackHole.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 2.0, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0f, 0.0f);
                blackHole.setRange(64);
                blackHole.setMaxLife(6000);
                this.field_145850_b.func_72838_d((Entity)blackHole);
                this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 5.0f, true);
                this.field_145850_b.func_175655_b(this.field_174879_c, false);
                this.spawnedBlackHole = true;
                break block30;
            }
            if (this.activated && !this.successful) {
                this.solarRotate += 1.0f;
                this.solarRotate %= 180.0f;
                if (this.getEnergyStoredGC() > 0.0f && !this.failed) {
                    if (this.rodUp < 58.0f) {
                        this.rodUp += 1.0f;
                    }
                } else if (this.rodUp > 0.0f) {
                    this.rodUp -= 0.25f;
                }
            }
            if (this.successful && this.solarRotate < 180.0f) {
                this.solarRotate += 1.0f;
            }
            if (this.activatedMessage) {
                ClientUtils.printClientMessage((ITextComponent)JsonUtils.create((String)LangUtils.translate((String)"gui.status.dark_energy_core_created.name")).func_150255_a(JsonUtils.green()));
                this.activatedMessage = false;
            }
            for (BlockPos renderPos : ClientEventHandler.RECEIVER_RENDER_POS) {
                this.multiBlockClientLists.entrySet().removeIf(entry -> this.field_145850_b.field_72995_K && this.field_174879_c.equals((Object)renderPos) && this.field_145850_b.func_180495_p(this.field_174879_c.func_177971_a((Vec3i)entry.getKey())) == entry.getValue());
                this.multiTileClientLists.entrySet().removeIf(entry -> this.field_145850_b.field_72995_K && this.field_174879_c.equals((Object)renderPos) && this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)entry.getKey())) != null && this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)entry.getKey())).getClass().equals(((TileEntity)entry.getValue()).getClass()));
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.activated = nbt.func_74767_n("Activated");
        this.activatedMessage = nbt.func_74767_n("ActivatedMessage");
        this.successful = nbt.func_74767_n("Successful");
        this.spawnedBlackHole = nbt.func_74767_n("SpawnedBlackHole");
        this.failed = nbt.func_74767_n("Failed");
        this.rendered = nbt.func_74767_n("Rendered");
        this.activatedTick = nbt.func_74762_e("ActivatedTick");
        this.failedTick = nbt.func_74762_e("FailedTick");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Activated", this.activated);
        nbt.func_74757_a("ActivatedMessage", this.activatedMessage);
        nbt.func_74757_a("Successful", this.successful);
        nbt.func_74757_a("SpawnedBlackHole", this.spawnedBlackHole);
        nbt.func_74757_a("Failed", this.failed);
        nbt.func_74757_a("Rendered", this.rendered);
        nbt.func_74768_a("ActivatedTick", this.activatedTick);
        nbt.func_74768_a("FailedTick", this.failedTick);
        return nbt;
    }

    public boolean onActivated(EntityPlayer player) {
        return MPBlocks.DARK_ENERGY_RECEIVER.func_180639_a(this.field_145850_b, this.mainBlockPosition, MPBlocks.DARK_ENERGY_RECEIVER.func_176223_P(), player, player.func_184600_cs(), player.func_174811_aO(), 0.0f, 0.0f, 0.0f);
    }

    public void onCreate(World world, BlockPos pos) {
        this.mainBlockPosition = pos;
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
    }

    public void onDestroy(TileEntity tile) {
        BlockPos thisBlock = this.func_174877_v();
        this.destroyBlock(thisBlock, true);
        if (this.func_145832_p() == 0 || this.func_145832_p() == 2) {
            for (int i = -1; i < 2; ++i) {
                BlockPos pos = new BlockPos(thisBlock.func_177958_n() + i, thisBlock.func_177956_o(), thisBlock.func_177952_p());
                if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                    Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, MPBlocks.DARK_ENERGY_RECEIVER.func_176223_P());
                }
                if (this.field_145850_b.func_180495_p(pos).func_177230_c() == MPBlocks.DER_SOLAR1_DUMMY || this.field_145850_b.func_180495_p(pos).func_177230_c() == MPBlocks.DER_SOLAR2_DUMMY) {
                    this.field_145850_b.func_175655_b(pos, false);
                }
                this.field_145850_b.func_175655_b(this.func_174877_v(), true);
            }
        } else {
            for (int i = -1; i < 2; ++i) {
                BlockPos pos = new BlockPos(thisBlock.func_177958_n(), thisBlock.func_177956_o(), thisBlock.func_177952_p() + i);
                if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                    Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, MPBlocks.DARK_ENERGY_RECEIVER.func_176223_P());
                }
                if (this.field_145850_b.func_180495_p(pos).func_177230_c() == MPBlocks.DER_SOLAR3_DUMMY || this.field_145850_b.func_180495_p(pos).func_177230_c() == MPBlocks.DER_SOLAR4_DUMMY) {
                    this.field_145850_b.func_175655_b(pos, false);
                }
                this.field_145850_b.func_175655_b(this.func_174877_v(), true);
            }
        }
    }

    public boolean canRenderBreaking() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.activated && !this.successful && !this.disabled;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return EnumFacing.DOWN;
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    @Override
    public EnumFacing getFront() {
        return EnumFacing.DOWN;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180461_b(int slotID, ItemStack itemStack, EnumFacing side) {
        return slotID == 0;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return null;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
        this.rendered = true;
        GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.C_REMOVE_GUIDE_POS, this.field_145850_b.field_73011_w.getDimension(), this.func_174877_v()), this.field_145850_b.field_73011_w.getDimension());
    }

    public int getSuccessfulTick() {
        return 12000;
    }

    public static boolean checkValidMultiblock(BlockPos pos, World world) {
        for (Map.Entry<BlockPos, IBlockState> list : multiBlockLists.entrySet()) {
            BlockPos blockpos = list.getKey();
            IBlockState state = list.getValue();
            BlockPos newPos = pos.func_177971_a((Vec3i)blockpos);
            if (world.func_180495_p(newPos) == state) continue;
            return true;
        }
        return false;
    }

    public String getGUIStatus() {
        if (this.successful) {
            return TextFormatting.DARK_RED + LangUtils.translate((String)"gui.status.off.name");
        }
        if (this.getEnergyStoredGC() == 0.0f) {
            return TextFormatting.DARK_RED + LangUtils.translate((String)"gui.status.missingpower.name");
        }
        if (this.getDisabled(0)) {
            return TextFormatting.GOLD + LangUtils.translate((String)"gui.status.ready.name");
        }
        if (this.getEnergyStoredGC() < this.storage.getMaxExtract()) {
            return TextFormatting.GOLD + LangUtils.translate((String)"gui.status.missingpower.name");
        }
        return TextFormatting.DARK_GREEN + LangUtils.translate((String)"gui.status.active.name");
    }

    public String getGuiStatusWaila() {
        if (this.successful) {
            return TextFormatting.GREEN + LangUtils.translate((String)"gui.status.dark_energy_core_created.name");
        }
        if (this.getEnergyStoredGC() == 0.0f) {
            return TextFormatting.DARK_RED + LangUtils.translate((String)"gui.status.dark_energy_offline.name");
        }
        if (this.getDisabled(0)) {
            return TextFormatting.GOLD + LangUtils.translate((String)"gui.status.ready.name");
        }
        return TextFormatting.DARK_GREEN + LangUtils.translate((String)"gui.status.active.name");
    }

    private boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        IBlockState iblockstate = this.field_145850_b.func_180495_p(pos);
        if (iblockstate.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        this.field_145850_b.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)iblockstate));
        if (dropBlock) {
            ItemStack machine = new ItemStack(MPBlocks.DARK_ENERGY_RECEIVER);
            TileEntityDarkEnergyReceiver electric = this;
            if (electric.getEnergyStoredGC() > 0.0f) {
                machine.func_77982_d(new NBTTagCompound());
                machine.func_77978_p().func_74776_a("EnergyStored", electric.getEnergyStoredGC());
            }
            if (!electric.successful && !electric.failed) {
                Block.func_180635_a((World)this.field_145850_b, (BlockPos)pos, (ItemStack)machine);
            }
        }
        return this.field_145850_b.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    static {
        multiBlockLists.put(new BlockPos(1, -1, 0), MPBlocks.ZELIUS_EGG.func_176223_P());
        multiBlockLists.put(new BlockPos(0, -1, 1), MPBlocks.ZELIUS_EGG.func_176223_P());
        multiBlockLists.put(new BlockPos(-1, -1, 0), MPBlocks.ZELIUS_EGG.func_176223_P());
        multiBlockLists.put(new BlockPos(0, -1, -1), MPBlocks.ZELIUS_EGG.func_176223_P());
        multiBlockLists.put(new BlockPos(1, -2, 1), MPBlocks.DUNGEON_GLOWSTONE.func_176223_P());
        multiBlockLists.put(new BlockPos(-1, -2, 1), MPBlocks.DUNGEON_GLOWSTONE.func_176223_P());
        multiBlockLists.put(new BlockPos(1, -2, -1), MPBlocks.DUNGEON_GLOWSTONE.func_176223_P());
        multiBlockLists.put(new BlockPos(-1, -2, -1), MPBlocks.DUNGEON_GLOWSTONE.func_176223_P());
        multiBlockLists.put(new BlockPos(1, -2, 0), MPBlocks.INFECTED_PURLONITE_SLIME_BLOCK.func_176223_P());
        multiBlockLists.put(new BlockPos(0, -2, 1), MPBlocks.INFECTED_PURLONITE_SLIME_BLOCK.func_176223_P());
        multiBlockLists.put(new BlockPos(-1, -2, 0), MPBlocks.INFECTED_PURLONITE_SLIME_BLOCK.func_176223_P());
        multiBlockLists.put(new BlockPos(0, -2, -1), MPBlocks.INFECTED_PURLONITE_SLIME_BLOCK.func_176223_P());
        multiBlockLists.put(new BlockPos(3, -1, 3), MPBlocks.INFECTED_PURLONITE_SEGMENT.func_176223_P());
        multiBlockLists.put(new BlockPos(3, 0, 3), MPBlocks.INFECTED_PURLONITE_EYE_CORE.func_176223_P());
        multiBlockLists.put(new BlockPos(3, 1, 3), MPBlocks.INFECTED_PURLONITE_SEGMENT.func_176223_P());
        multiBlockLists.put(new BlockPos(3, 2, 3), MPBlocks.INFECTED_PURLONITE_ENDER_CORE.func_176223_P());
        multiBlockLists.put(new BlockPos(-3, -1, 3), MPBlocks.INFECTED_PURLONITE_SEGMENT.func_176223_P());
        multiBlockLists.put(new BlockPos(-3, 0, 3), MPBlocks.INFECTED_PURLONITE_EYE_CORE.func_176223_P());
        multiBlockLists.put(new BlockPos(-3, 1, 3), MPBlocks.INFECTED_PURLONITE_SEGMENT.func_176223_P());
        multiBlockLists.put(new BlockPos(-3, 2, 3), MPBlocks.INFECTED_PURLONITE_ENDER_CORE.func_176223_P());
        multiBlockLists.put(new BlockPos(3, -1, -3), MPBlocks.INFECTED_PURLONITE_SEGMENT.func_176223_P());
        multiBlockLists.put(new BlockPos(3, 0, -3), MPBlocks.INFECTED_PURLONITE_EYE_CORE.func_176223_P());
        multiBlockLists.put(new BlockPos(3, 1, -3), MPBlocks.INFECTED_PURLONITE_SEGMENT.func_176223_P());
        multiBlockLists.put(new BlockPos(3, 2, -3), MPBlocks.INFECTED_PURLONITE_ENDER_CORE.func_176223_P());
        multiBlockLists.put(new BlockPos(-3, -1, -3), MPBlocks.INFECTED_PURLONITE_SEGMENT.func_176223_P());
        multiBlockLists.put(new BlockPos(-3, 0, -3), MPBlocks.INFECTED_PURLONITE_EYE_CORE.func_176223_P());
        multiBlockLists.put(new BlockPos(-3, 1, -3), MPBlocks.INFECTED_PURLONITE_SEGMENT.func_176223_P());
        multiBlockLists.put(new BlockPos(-3, 2, -3), MPBlocks.INFECTED_PURLONITE_ENDER_CORE.func_176223_P());
    }
}

