/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.utils;

import com.stevekung.moreplanets.init.MPPlanets;
import com.stevekung.moreplanets.utils.LoggerMP;
import java.lang.reflect.Method;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import net.minecraftforge.fml.common.Loader;

public class CompatibilityManagerMP {
    public static final String baublesModId = "baubles";
    public static final boolean isCTMLoaded = Loader.isModLoaded((String)"ctm");
    public static final boolean isBigReactorLoaded = Loader.isModLoaded((String)"bigreactors");
    public static final boolean isOpenBlocksLoaded = Loader.isModLoaded((String)"openblocks");
    public static final boolean isEnderIOLoaded = Loader.isModLoaded((String)"enderio");
    public static final boolean isMobGrindingUtilsLoaded = Loader.isModLoaded((String)"mob_grinding_utils");
    public static final boolean isCCLLoaded = Loader.isModLoaded((String)"codechickenlib");
    public static final boolean isBaubleLoaded = Loader.isModLoaded((String)"baubles");
    public static final boolean isAsmodeusCoreLoaded = Loader.isModLoaded((String)"asmodeuscore");
    private static Method erRegisterFluid;
    private static float conductivityEmerald;
    private static float conductivityCopper;
    private static float conductivityGold;

    public static void init() {
        if (isCTMLoaded) {
            LoggerMP.info("Enabled CTM integrations");
        }
        if (isBigReactorLoaded) {
            CompatibilityManagerMP.initBigReactorCompat();
            CompatibilityManagerMP.registerExtremeReactorFluid("infected_water_fluid", 0.45f, 0.925f, 1.25f, conductivityCopper);
            CompatibilityManagerMP.registerExtremeReactorFluid("purify_water_fluid", 0.525f, 0.75f, 4.0f, conductivityEmerald);
            CompatibilityManagerMP.registerExtremeReactorFluid("cheese_milk_fluid", 0.675f, 0.575f, 1.95f, conductivityGold);
            CompatibilityManagerMP.registerExtremeReactorFluid("infected_purlonite_water_fluid", 0.3f, 0.65f, 2.45f, conductivityCopper);
        }
    }

    public static boolean isModAddedXpFluid() {
        return !isOpenBlocksLoaded && !isEnderIOLoaded && !isMobGrindingUtilsLoaded;
    }

    public static void registerExtremeReactorFluid(String name, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        LoggerMP.info("Registering {} into reactor interior", name);
        try {
            erRegisterFluid.invoke(null, name, Float.valueOf(absorption), Float.valueOf(heatEfficiency), Float.valueOf(moderation), Float.valueOf(heatConductivity));
        }
        catch (Exception e) {
            LoggerMP.error("Couldn't register Extreme Reactor compatibility", e);
        }
    }

    public static void registerAsmodeusCoreCompatibility() {
        if (isAsmodeusCoreLoaded) {
            try {
                Class<?> bodyData = Class.forName("asmodeuscore.core.astronomy.BodiesData");
                Class<?> typeBody = Class.forName("asmodeuscore.api.dimension.IAdvancedSpace$TypeBody");
                Class<?> starClass = Class.forName("asmodeuscore.api.dimension.IAdvancedSpace$StarClass");
                Class<?> starColor = Class.forName("asmodeuscore.api.dimension.IAdvancedSpace$StarColor");
                Object typeBodyEnum = Enum.valueOf(typeBody, "STAR");
                Object starClassEnum = Enum.valueOf(starClass, "GIANT");
                Object starColorEnum = Enum.valueOf(starColor, "RED");
                Object data = bodyData.getConstructor(typeBody).newInstance(typeBodyEnum);
                Class<?> dataClass = data.getClass();
                Method setStarClassMethod = dataClass.getDeclaredMethod("setStarClass", starClass);
                setStarClassMethod.invoke(data, starClassEnum);
                Method setStarColorMethod = dataClass.getDeclaredMethod("setStarColor", starColor);
                setStarColorMethod.invoke(data, starColorEnum);
                Method setStarHabitableZoneMethod = dataClass.getDeclaredMethod("setStarHabitableZone", Float.TYPE, Float.TYPE);
                setStarHabitableZoneMethod.invoke(data, Float.valueOf(0.4f), Float.valueOf(0.1f));
                Class<?> bodyRegistries = Class.forName("asmodeuscore.core.astronomy.BodiesRegistry");
                Method registerBodyData = bodyRegistries.getDeclaredMethod("registerBodyData", CelestialBody.class, bodyData);
                registerBodyData.invoke(null, MPPlanets.LAZENDUS, data);
                LoggerMP.info("Successfully registered AsmodeusCore compatibility");
            }
            catch (Exception e) {
                LoggerMP.error("Couldn't register AsmodeusCore compatibility", e);
            }
        }
    }

    private static void initBigReactorCompat() {
        LoggerMP.info("Enabled Extreme Reactors integrations");
        try {
            Class<?> reactorInterior = Class.forName("erogenousbeef.bigreactors.api.registry.ReactorInterior");
            Class<?> iHeatEntity = Class.forName("erogenousbeef.bigreactors.api.IHeatEntity");
            erRegisterFluid = reactorInterior.getDeclaredMethod("registerFluid", String.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            conductivityEmerald = iHeatEntity.getDeclaredField("conductivityEmerald").getFloat(iHeatEntity);
            conductivityCopper = iHeatEntity.getDeclaredField("conductivityCopper").getFloat(iHeatEntity);
            conductivityGold = iHeatEntity.getDeclaredField("conductivityGold").getFloat(iHeatEntity);
        }
        catch (Exception e) {
            LoggerMP.error("Couldn't get values from Extreme Reactor", e);
        }
    }
}

