/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.utils;

import com.stevekung.moreplanets.core.MorePlanetsMod;
import com.stevekung.moreplanets.network.PacketSimpleMP;
import com.stevekung.moreplanets.utils.LoggerMP;
import com.stevekung.moreplanets.world.SurvivalPlanetProvider;
import java.util.Collection;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.inventory.InventoryExtended;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.dimension.WorldProviderMars;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import micdoodle8.mods.galacticraft.planets.venus.dimension.WorldProviderVenus;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TeleportUtils {
    public static void teleportEntity(Entity entity, int dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        MinecraftServer server = entity.func_184102_h();
        int sourceDim = entity.field_70170_p.field_73011_w.getDimension();
        if (!entity.func_184207_aI() && !entity.func_184218_aH()) {
            TeleportUtils.handleEntityTeleport(entity, server, sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        }
    }

    private static void handleEntityTeleport(Entity entity, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        boolean interDimensional;
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        boolean bl = interDimensional = sourceDim != targetDim;
        if (interDimensional && !ForgeHooks.onTravelToDimension((Entity)entity, (int)targetDim)) {
            return;
        }
        if (interDimensional) {
            if (entity instanceof EntityPlayerMP) {
                TeleportUtils.teleportPlayerInternational((EntityPlayerMP)entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            } else {
                TeleportUtils.teleportEntityInternational(entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
        } else if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
            player.func_70034_d(yaw);
        } else {
            entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            entity.func_70034_d(yaw);
        }
    }

    private static void teleportEntityInternational(Entity entity, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity.field_70128_L) {
            return;
        }
        WorldServer sourceWorld = server.func_71218_a(sourceDim);
        WorldServer targetWorld = server.func_71218_a(targetDim);
        if (!entity.field_70128_L && entity instanceof EntityMinecart) {
            entity.field_70128_L = true;
            entity.func_184204_a(targetDim);
            entity.field_70128_L = false;
        }
        entity.field_71093_bK = targetDim;
        sourceWorld.func_72900_e(entity);
        entity.field_70128_L = false;
        entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        sourceWorld.func_72866_a(entity, false);
        Entity newEntity = EntityList.func_191304_a(entity.getClass(), (World)targetWorld);
        if (newEntity != null) {
            newEntity.func_180432_n(entity);
            newEntity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            boolean flag = newEntity.field_98038_p;
            newEntity.field_98038_p = true;
            targetWorld.func_72838_d(newEntity);
            newEntity.field_98038_p = flag;
            targetWorld.func_72866_a(newEntity, false);
        }
        entity.field_70128_L = true;
        sourceWorld.func_82742_i();
        targetWorld.func_82742_i();
    }

    private static void teleportPlayerInternational(EntityPlayerMP player, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        WorldServer sourceWorld = server.func_71218_a(sourceDim);
        WorldServer targetWorld = server.func_71218_a(targetDim);
        PlayerList playerList = server.func_184103_al();
        player.field_71093_bK = targetDim;
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, targetWorld.func_175659_aa(), targetWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        playerList.func_187243_f(player);
        sourceWorld.func_72973_f((Entity)player);
        player.field_70128_L = false;
        player.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
        targetWorld.func_72838_d((Entity)player);
        targetWorld.func_72866_a((Entity)player, false);
        player.func_70029_a((World)targetWorld);
        playerList.func_72375_a(player, sourceWorld);
        player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
        player.field_71134_c.func_73080_a(targetWorld);
        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        playerList.func_72354_b(player, targetWorld);
        playerList.func_72385_f(player);
        player.func_70651_bq().forEach(potion -> player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potion)));
        player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, sourceDim, targetDim);
        player.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
    }

    public static void teleportPlayerToPlanet(EntityPlayerMP player, MinecraftServer server, int sourceDim, int targetDim) {
        ItemStack rocket;
        WorldServer sourceWorld = server.func_71218_a(sourceDim);
        WorldServer targetWorld = server.func_71218_a(targetDim);
        BlockPos spawnPos = targetWorld.func_175672_r(targetWorld.func_175694_M());
        PlayerList playerList = server.func_184103_al();
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        InventoryExtended inv = stats.getExtendedInventory();
        player.field_71093_bK = targetDim;
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, targetWorld.func_175659_aa(), targetWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        playerList.func_187243_f(player);
        sourceWorld.func_72973_f((Entity)player);
        player.field_70128_L = false;
        player.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), player.field_70177_z, player.field_70125_A);
        player.field_71135_a.func_147364_a((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), player.field_70177_z, player.field_70125_A);
        targetWorld.func_72838_d((Entity)player);
        targetWorld.func_72866_a((Entity)player, false);
        player.func_70029_a((World)targetWorld);
        MorePlanetsMod.PROXY.resetFloatingTick((EntityPlayer)player);
        playerList.func_72375_a(player, sourceWorld);
        player.field_71135_a.func_147364_a((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(targetWorld);
        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        playerList.func_72354_b(player, targetWorld);
        playerList.func_72385_f(player);
        if (targetWorld.field_73011_w instanceof SurvivalPlanetProvider) {
            SurvivalPlanetProvider dimension = (SurvivalPlanetProvider)targetWorld.field_73011_w;
            LoggerMP.info("Setting up survival player gear");
            dimension.setupGear(player);
        } else if (targetWorld.field_73011_w instanceof WorldProviderMoon) {
            LoggerMP.info("Setting up default survival player gear for Moon");
            inv.func_70299_a(0, new ItemStack(GCItems.oxMask));
            inv.func_70299_a(1, new ItemStack(GCItems.oxygenGear));
            inv.func_70299_a(2, new ItemStack(GCItems.oxTankMedium));
            inv.func_70299_a(3, new ItemStack(GCItems.oxTankMedium));
            inv.func_70299_a(4, new ItemStack(GCItems.parachute));
            inv.func_70299_a(5, new ItemStack(GCItems.basicItem, 1, 19));
            player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150364_r, 32 + player.field_70170_p.field_73012_v.nextInt(32)));
            player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150347_e, 32 + player.field_70170_p.field_73012_v.nextInt(32)));
            player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150346_d, 16));
            player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150345_g, 8 + player.field_70170_p.field_73012_v.nextInt(8)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151042_j, 32 + player.field_70170_p.field_73012_v.nextInt(16)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151014_N, 16 + player.field_70170_p.field_73012_v.nextInt(16)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151174_bG, 16 + player.field_70170_p.field_73012_v.nextInt(16)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151172_bF, 16 + player.field_70170_p.field_73012_v.nextInt(16)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as));
            player.field_71071_by.func_70441_a(new ItemStack(GCBlocks.landingPad, 9));
            rocket = new ItemStack(GCItems.rocketTier1);
            rocket.func_77982_d(new NBTTagCompound());
            rocket.func_77978_p().func_74768_a("RocketFuel", 1000);
            player.field_71071_by.func_70441_a(rocket);
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
        } else if (targetWorld.field_73011_w instanceof WorldProviderMars) {
            LoggerMP.info("Setting up default survival player gear for Mars");
            SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(GCItems.schematic, 1, 1));
            inv.func_70299_a(0, new ItemStack(GCItems.oxMask));
            inv.func_70299_a(1, new ItemStack(GCItems.oxygenGear));
            inv.func_70299_a(2, new ItemStack(GCItems.oxTankMedium));
            inv.func_70299_a(3, new ItemStack(GCItems.oxTankMedium));
            inv.func_70299_a(4, new ItemStack(GCItems.parachute));
            inv.func_70299_a(5, new ItemStack(GCItems.basicItem, 1, 19));
            inv.func_70299_a(6, new ItemStack(AsteroidsItems.thermalPadding));
            inv.func_70299_a(7, new ItemStack(AsteroidsItems.thermalPadding, 1, 1));
            inv.func_70299_a(8, new ItemStack(AsteroidsItems.thermalPadding, 1, 2));
            inv.func_70299_a(9, new ItemStack(AsteroidsItems.thermalPadding, 1, 3));
            player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150364_r, 32 + player.field_70170_p.field_73012_v.nextInt(32)));
            player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150347_e, 32 + player.field_70170_p.field_73012_v.nextInt(32)));
            player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150346_d, 16));
            player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150345_g, 8 + player.field_70170_p.field_73012_v.nextInt(8)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151042_j, 32 + player.field_70170_p.field_73012_v.nextInt(16)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151014_N, 16 + player.field_70170_p.field_73012_v.nextInt(16)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151174_bG, 16 + player.field_70170_p.field_73012_v.nextInt(16)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151172_bF, 16 + player.field_70170_p.field_73012_v.nextInt(16)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as));
            player.field_71071_by.func_70441_a(new ItemStack(GCBlocks.landingPad, 9));
            rocket = new ItemStack(MarsItems.rocketMars);
            rocket.func_77982_d(new NBTTagCompound());
            rocket.func_77978_p().func_74768_a("RocketFuel", 1000);
            player.field_71071_by.func_70441_a(rocket);
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
        } else if (targetWorld.field_73011_w instanceof WorldProviderVenus) {
            LoggerMP.info("Setting up default survival player gear for Venus");
            SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(GCItems.schematic, 1, 1));
            SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(MarsItems.schematic, 1, 0));
            inv.func_70299_a(0, new ItemStack(GCItems.oxMask));
            inv.func_70299_a(1, new ItemStack(GCItems.oxygenGear));
            inv.func_70299_a(2, new ItemStack(GCItems.oxTankHeavy));
            inv.func_70299_a(3, new ItemStack(GCItems.oxTankHeavy));
            inv.func_70299_a(4, new ItemStack(GCItems.parachute));
            inv.func_70299_a(5, new ItemStack(GCItems.basicItem, 1, 19));
            inv.func_70299_a(6, new ItemStack(VenusItems.thermalPaddingTier2));
            inv.func_70299_a(7, new ItemStack(VenusItems.thermalPaddingTier2, 1, 1));
            inv.func_70299_a(8, new ItemStack(VenusItems.thermalPaddingTier2, 1, 2));
            inv.func_70299_a(9, new ItemStack(VenusItems.thermalPaddingTier2, 1, 3));
            inv.func_70299_a(10, new ItemStack(VenusItems.basicItem));
            player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150364_r, 32 + player.field_70170_p.field_73012_v.nextInt(32)));
            player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150347_e, 32 + player.field_70170_p.field_73012_v.nextInt(32)));
            player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150346_d, 16));
            player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150345_g, 8 + player.field_70170_p.field_73012_v.nextInt(8)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151042_j, 32 + player.field_70170_p.field_73012_v.nextInt(16)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151014_N, 16 + player.field_70170_p.field_73012_v.nextInt(16)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151174_bG, 16 + player.field_70170_p.field_73012_v.nextInt(16)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151172_bF, 16 + player.field_70170_p.field_73012_v.nextInt(16)));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as));
            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as));
            player.field_71071_by.func_70441_a(new ItemStack(GCBlocks.landingPad, 9));
            rocket = new ItemStack(AsteroidsItems.tier3Rocket);
            rocket.func_77982_d(new NBTTagCompound());
            rocket.func_77978_p().func_74768_a("RocketFuel", 1000);
            player.field_71071_by.func_70441_a(rocket);
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
        } else if (targetWorld.field_73011_w instanceof WorldProviderAsteroids) {
            LoggerMP.info("Setting up default survival player gear for Asteroids");
            ITeleportType type = GalacticraftRegistry.getTeleportTypeForDimension(targetWorld.field_73011_w.getClass());
            Vector3 spawnPosVec = type.getPlayerSpawnLocation(targetWorld, player);
            ChunkPos pair = targetWorld.func_72964_e(spawnPosVec.intX() >> 4, spawnPosVec.intZ() >> 4).func_76632_l();
            player.func_70012_b(spawnPosVec.x, spawnPosVec.y, spawnPosVec.z, player.field_70177_z, player.field_70125_A);
            player.setSpawnChunk(new BlockPos(spawnPosVec.intX(), spawnPosVec.intY(), spawnPosVec.intZ()), true, GCCoreUtil.getDimensionID((World)targetWorld));
            targetWorld.func_72863_F().func_186028_c(pair.field_77276_a, pair.field_77275_b);
            type.setupAdventureSpawn(player);
            type.onSpaceDimensionChanged((World)targetWorld, player, false);
        } else {
            LoggerMP.info("Setting up default survival player gear for Non-IStartedDimension world");
            SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(GCItems.schematic, 1, 1));
            SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(MarsItems.schematic, 1, 0));
            inv.func_70299_a(0, new ItemStack(GCItems.oxMask));
            inv.func_70299_a(1, new ItemStack(GCItems.oxygenGear));
            inv.func_70299_a(2, new ItemStack(GCItems.oxTankHeavy));
            inv.func_70299_a(3, new ItemStack(GCItems.oxTankHeavy));
            inv.func_70299_a(5, new ItemStack(GCItems.basicItem, 1, 19));
            inv.func_70299_a(6, new ItemStack(AsteroidsItems.thermalPadding));
            inv.func_70299_a(7, new ItemStack(AsteroidsItems.thermalPadding, 1, 1));
            inv.func_70299_a(8, new ItemStack(AsteroidsItems.thermalPadding, 1, 2));
            inv.func_70299_a(9, new ItemStack(AsteroidsItems.thermalPadding, 1, 3));
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
            player.field_71071_by.func_70441_a(new ItemStack(AsteroidsItems.canisterLOX));
        }
        player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 300, 5));
        player.func_70651_bq().forEach(potion -> player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potion)));
        player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        player.field_71135_a.func_147359_a((Packet)new SPacketSpawnPosition(spawnPos));
        AttributeMap attributemap = (AttributeMap)player.func_110140_aT();
        Collection watchedAttribs = attributemap.func_111160_c();
        if (!watchedAttribs.isEmpty()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityProperties(player.func_145782_y(), watchedAttribs));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, sourceDim, targetDim);
        if (!(targetWorld.field_73011_w instanceof WorldProviderAsteroids)) {
            player.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), player.field_70177_z, player.field_70125_A);
            player.setSpawnChunk(spawnPos, true, GCCoreUtil.getDimensionID((World)player.field_70170_p));
        }
        if (!(targetWorld.field_73011_w instanceof WorldProviderAsteroids) && player.field_70122_E && player.getBedLocation(GCCoreUtil.getDimensionID((World)player.field_70170_p)) == null) {
            int i = 30000000;
            int x = Math.min(i, Math.max(-i, MathHelper.func_76128_c((double)(player.field_70165_t + 0.5))));
            int y = Math.min(256, Math.max(0, MathHelper.func_76128_c((double)(player.field_70163_u + 1.5))));
            int z = Math.min(i, Math.max(-i, MathHelper.func_76128_c((double)(player.field_70161_v + 0.5))));
            BlockPos spawnChunkPos = targetWorld.func_175672_r(new BlockPos(x, y, z));
            player.setSpawnChunk(spawnChunkPos, true, GCCoreUtil.getDimensionID((World)player.field_70170_p));
        }
        GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.C_RELOAD_RENDERER, player.field_71093_bK, new Object[0]), player);
        GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.C_MESSAGE_SURVIVAL_PLANET, player.field_71093_bK, WorldUtil.getProviderForDimensionServer((int)targetDim).func_186058_p().func_186065_b()), player);
    }
}

