/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.utils.blocks;

import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPItems;
import com.stevekung.moreplanets.utils.blocks.BlockBushMP;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockDoublePlantMP
extends BlockBushMP
implements IGrowable,
IShearable {
    private final BlockType type;

    public BlockDoublePlantMP(String name, BlockType type) {
        super(name, Material.field_151582_l);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER));
        this.type = type;
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && world.func_175623_d(pos.func_177984_a());
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return true;
        }
        return this.type.isGrass();
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return super.canBlockStay(world, pos, state);
        }
        if (state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        IBlockState otherState = world.func_180495_p(pos.func_177984_a());
        return otherState.func_177230_c() == this && super.canBlockStay(world, pos, otherState);
    }

    @Override
    protected boolean validBlock(Block block) {
        if (this.type == BlockType.CHEESE_TALL_GRASS) {
            return block == MPBlocks.CHEESE_GRASS_BLOCK || block == MPBlocks.CHEESE_DIRT || block == MPBlocks.CHEESE_COARSE_DIRT || block == MPBlocks.CHEESE_FARMLAND;
        }
        if (this.type == BlockType.GREEN_VEIN_TALL_GRASS) {
            return block == MPBlocks.GREEN_VEIN_GRASS_BLOCK || block == MPBlocks.INFECTED_DIRT || block == MPBlocks.INFECTED_COARSE_DIRT || block == MPBlocks.INFECTED_FARMLAND;
        }
        if (this.type == BlockType.INFECTED_ORANGE_ROSE_BUSH || this.type == BlockType.INFECTED_TALL_GRASS || this.type == BlockType.INFECTED_LARGE_FERN) {
            return block == MPBlocks.INFECTED_GRASS_BLOCK || block == MPBlocks.INFECTED_DIRT || block == MPBlocks.INFECTED_COARSE_DIRT || block == MPBlocks.INFECTED_FARMLAND;
        }
        if (this.type == BlockType.LARGE_WHEAT || this.type == BlockType.FRONOS_TALL_GRASS) {
            return block == MPBlocks.FRONOS_GRASS_BLOCK || block == MPBlocks.FRONOS_DIRT || block == MPBlocks.FRONOS_COARSE_DIRT || block == MPBlocks.FRONOS_FARMLAND;
        }
        return super.validBlock(block);
    }

    @Override
    protected void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos, state)) {
            BlockDoublePlantMP block1;
            boolean flag = state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER;
            BlockPos blockpos = flag ? pos : pos.func_177984_a();
            BlockPos blockpos1 = flag ? pos.func_177977_b() : pos;
            BlockDoublePlantMP block = flag ? this : world.func_180495_p(blockpos).func_177230_c();
            BlockDoublePlantMP blockDoublePlantMP = block1 = flag ? world.func_180495_p(blockpos1).func_177230_c() : this;
            if (!flag && !this.type.isGrass()) {
                this.func_176226_b(world, pos, state, 0);
            }
            if (block == this) {
                world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (block1 == this) {
                world.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            return Items.field_190931_a;
        }
        if (this.type == BlockType.CHEESE_TALL_GRASS) {
            return rand.nextInt(8) == 0 ? MPItems.CHEESE_SPORE_SEED : Items.field_190931_a;
        }
        if (this.type == BlockType.GREEN_VEIN_TALL_GRASS) {
            return rand.nextInt(8) == 0 ? MPItems.TERRABERRY : Items.field_190931_a;
        }
        if (this.type == BlockType.INFECTED_TALL_GRASS) {
            return rand.nextInt(8) == 0 ? MPItems.INFECTED_WHEAT_SEEDS : Items.field_190931_a;
        }
        if (this.type == BlockType.FRONOS_TALL_GRASS) {
            return rand.nextInt(8) == 0 ? Items.field_151014_N : Items.field_190931_a;
        }
        return this.type.isGrass() || this.type == BlockType.LARGE_WHEAT ? Items.field_190931_a : Item.func_150898_a((Block)this);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), 2);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        boolean isShears;
        boolean bl = isShears = !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == Items.field_151097_aZ;
        if (state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                if (player.field_71075_bZ.field_75098_d) {
                    world.func_175698_g(pos.func_177977_b());
                } else if (!this.type.isGrass()) {
                    world.func_175655_b(pos.func_177977_b(), true);
                } else if (world.field_72995_K) {
                    world.func_175698_g(pos.func_177977_b());
                } else if (isShears) {
                    this.onHarvest(player);
                    world.func_175698_g(pos.func_177977_b());
                } else {
                    world.func_175655_b(pos.func_177977_b(), true);
                }
            }
        } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
        if (!player.field_71075_bZ.field_75098_d && this.type == BlockType.LARGE_WHEAT) {
            if (isShears) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
            } else {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151015_O, 4 + world.field_73012_v.nextInt(5)));
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.type.isGrass();
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
    }

    public IBlockState func_176203_a(int meta) {
        return meta == 1 ? this.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER) : this.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER);
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDoublePlant.field_176492_b});
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public boolean isShearable(ItemStack itemStack, IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.LOWER && this.type.isGrass();
    }

    public List<ItemStack> onSheared(ItemStack itemStack, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.type == BlockType.CHEESE_TALL_GRASS) {
            ret.add(new ItemStack(MPBlocks.CHEESE_GRASS, 2));
        }
        if (this.type == BlockType.INFECTED_TALL_GRASS) {
            ret.add(new ItemStack(MPBlocks.INFECTED_GRASS, 2));
        }
        if (this.type == BlockType.INFECTED_LARGE_FERN) {
            ret.add(new ItemStack(MPBlocks.INFECTED_FERN, 2));
        }
        if (this.type == BlockType.GREEN_VEIN_TALL_GRASS) {
            ret.add(new ItemStack(MPBlocks.GREEN_VEIN_GRASS, 2));
        }
        if (this.type == BlockType.LARGE_WHEAT) {
            ret.add(new ItemStack((Block)MPBlocks.LARGE_WHEAT));
        }
        if (this.type == BlockType.FRONOS_TALL_GRASS) {
            ret.add(new ItemStack((Block)MPBlocks.FRONOS_TALL_GRASS));
        }
        return ret;
    }

    public void placeAt(World world, BlockPos lowerPos, Block block, int flags) {
        world.func_180501_a(lowerPos, block.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER), flags);
        world.func_180501_a(lowerPos.func_177984_a(), block.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), flags);
    }

    private void onHarvest(EntityPlayer player) {
        if (!this.type.isGrass()) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
        }
    }

    public static enum BlockType {
        CHEESE_TALL_GRASS(true),
        INFECTED_ORANGE_ROSE_BUSH(false),
        INFECTED_TALL_GRASS(true),
        INFECTED_LARGE_FERN(true),
        GREEN_VEIN_TALL_GRASS(true),
        LARGE_WHEAT(false),
        FRONOS_TALL_GRASS(true);

        private final boolean isGrass;

        private BlockType(boolean isGrass) {
            this.isGrass = isGrass;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isGrass() {
            return this.isGrass;
        }
    }
}

