/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.utils.blocks;

import com.stevekung.lib.utils.ColorUtils;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPItems;
import com.stevekung.moreplanets.planets.nibiru.world.gen.feature.WorldGenTerrashroom;
import com.stevekung.moreplanets.utils.CompatibilityManagerMP;
import com.stevekung.moreplanets.utils.blocks.BlockBushMP;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockPlaceableBushMP
extends BlockBushMP
implements IShearable,
IGrowable {
    private static final AxisAlignedBB GRASS = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
    private static final AxisAlignedBB FLOWER = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.8, 0.7);
    private static final AxisAlignedBB PURE_HERB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.6, 0.7);
    private static final AxisAlignedBB PHILIPY = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.6, 0.75);
    private static final AxisAlignedBB WHITE_TAIL = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.9, 0.75);
    private static final AxisAlignedBB VEALIUM_VINES = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB TERRASHROOM = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.6, 0.7);
    private static final AxisAlignedBB PURPLE_BUSH = new AxisAlignedBB(3.0, 0.0, 3.0, 13.0, 8.0, 13.0);
    private final BlockType type;

    public BlockPlaceableBushMP(String name, BlockType type) {
        super(name, Material.field_151585_k);
        this.type = type;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return !this.type.isFlower() ? Items.field_190931_a : Item.func_150898_a((Block)this);
    }

    public int func_149679_a(int fortune, Random rand) {
        return 1 + rand.nextInt(fortune * 2 + 1);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!this.type.isFlower()) {
            return GRASS;
        }
        if (this.type == BlockType.PURE_HERB) {
            return PURE_HERB;
        }
        if (this.type == BlockType.PHILIPY) {
            return PHILIPY;
        }
        if (this.type == BlockType.WHITE_TAIL) {
            return WHITE_TAIL;
        }
        if (this.type == BlockType.VEALIUM_VINES) {
            return VEALIUM_VINES;
        }
        if (this.type == BlockType.TERRASHROOM) {
            return TERRASHROOM;
        }
        if (this.type == BlockType.CREEP_VINES) {
            return Block.field_185505_j;
        }
        if (this.type == BlockType.PURPLE_BUSH) {
            return PURPLE_BUSH;
        }
        return FLOWER;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.type == BlockType.TERRASHROOM && rand.nextInt(25) == 0) {
            int i = 5;
            for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (world.func_180495_p(blockpos).func_177230_c() != this || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (world.func_175623_d(blockpos1) && this.func_176196_c(world, blockpos1)) {
                    pos = blockpos1;
                }
                blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            }
            if (world.func_175623_d(blockpos1) && this.func_176196_c(world, blockpos1)) {
                world.func_180501_a(blockpos1, this.func_176223_P(), 2);
            }
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.type == BlockType.PURE_HERB) {
            return 2;
        }
        if (this.type == BlockType.TERRAPUFF_HERB || this.type == BlockType.VEALIUM_VINES || this.type == BlockType.CREEP_VINES) {
            return 4;
        }
        if (this.type == BlockType.TERRASHROOM) {
            return 1;
        }
        return 0;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (RANDOM.nextInt(8) == 0) {
            if (this.type == BlockType.CHEESE_GRASS) {
                drops.add((Object)new ItemStack(MPItems.CHEESE_SPORE_SEED));
            } else if (this.type == BlockType.INFECTED_GRASS || this.type == BlockType.INFECTED_FERN) {
                drops.add((Object)new ItemStack(MPItems.INFECTED_WHEAT_SEEDS));
            } else if (this.type == BlockType.FRONOS_GRASS || this.type == BlockType.PURPLE_BUSH || this.type == BlockType.FRONOS_FERN) {
                drops.add((Object)new ItemStack(Items.field_151014_N));
            }
        }
        if (this.type == BlockType.GREEN_VEIN_GRASS && RANDOM.nextInt(24) == 0) {
            drops.add((Object)new ItemStack(MPItems.TERRABERRY));
        }
        if (this.type.isFlower()) {
            drops.add((Object)new ItemStack((Block)this));
        }
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return !this.type.isFlower();
    }

    public Block.EnumOffsetType func_176218_Q() {
        return this.type.isFlower() ? Block.EnumOffsetType.XZ : Block.EnumOffsetType.XYZ;
    }

    public boolean isShearable(ItemStack itemStack, IBlockAccess world, BlockPos pos) {
        return !this.type.isFlower();
    }

    public NonNullList<ItemStack> onSheared(ItemStack itemStack, IBlockAccess world, BlockPos pos, int fortune) {
        return !this.type.isFlower() ? NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this)) : NonNullList.func_191196_a();
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        if (CompatibilityManagerMP.isCTMLoaded && (this.type == BlockType.TERRAPUFF_HERB || this.type == BlockType.NEMOPHILA)) {
            return layer == BlockRenderLayer.CUTOUT;
        }
        return this.type == BlockType.TERRASHROOM ? layer == BlockRenderLayer.TRANSLUCENT : super.canRenderInLayer(state, layer);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        Block blockUp = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        if (this.type == BlockType.VEALIUM_VINES) {
            return blockUp == MPBlocks.INFECTED_JUNGLE_LEAVES || blockUp == this;
        }
        if (this.type == BlockType.CREEP_VINES) {
            return blockUp == MPBlocks.CREEP_BLOCK || blockUp == MPBlocks.GRAVITY_CREEP_BLOCK || blockUp == MPBlocks.GRAVITY_CREEP_EXTRACTOR;
        }
        if (this.type == BlockType.TERRASHROOM) {
            return super.func_176196_c(world, pos) || world.func_175699_k(pos) < 13 && world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.DOWN);
        }
        return super.func_176196_c(world, pos);
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        Block blockUp = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        if (this.type == BlockType.TERRASHROOM) {
            return super.canBlockStay(world, pos, state) || world.func_175699_k(pos) < 13 && world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.DOWN);
        }
        if (this.type == BlockType.VEALIUM_VINES) {
            return blockUp == MPBlocks.INFECTED_JUNGLE_LEAVES || blockUp == this;
        }
        if (this.type == BlockType.CREEP_VINES) {
            return blockUp == MPBlocks.CREEP_BLOCK || blockUp == MPBlocks.GRAVITY_CREEP_BLOCK || blockUp == MPBlocks.GRAVITY_CREEP_EXTRACTOR;
        }
        return super.canBlockStay(world, pos, state);
    }

    @Override
    protected boolean validBlock(Block block) {
        if (this.type == BlockType.CHEESE_GRASS) {
            return block == MPBlocks.CHEESE_GRASS_BLOCK || block == MPBlocks.CHEESE_DIRT || block == MPBlocks.CHEESE_COARSE_DIRT || block == MPBlocks.CHEESE_FARMLAND;
        }
        if (this.type == BlockType.GREEN_VEIN_GRASS || this.type == BlockType.TERRAPUFF_HERB) {
            return block == MPBlocks.GREEN_VEIN_GRASS_BLOCK || block == MPBlocks.INFECTED_DIRT || block == MPBlocks.INFECTED_COARSE_DIRT || block == MPBlocks.INFECTED_FARMLAND;
        }
        if (this.type == BlockType.INFECTED_GRASS || this.type == BlockType.INFECTED_FERN || this.type == BlockType.PURE_HERB || this.type == BlockType.PYOLONIA || this.type == BlockType.PHILIPY || this.type == BlockType.WHITE_TAIL) {
            return block == MPBlocks.INFECTED_GRASS_BLOCK || block == MPBlocks.INFECTED_DIRT || block == MPBlocks.INFECTED_COARSE_DIRT || block == MPBlocks.INFECTED_FARMLAND;
        }
        if (this.type == BlockType.BATASIA_DANDELION) {
            return block == MPBlocks.INFECTED_SAND;
        }
        if (this.type == BlockType.TERRASHROOM) {
            return block == MPBlocks.GREEN_VEIN_GRASS_BLOCK || block == MPBlocks.INFECTED_DIRT || block == MPBlocks.INFECTED_COARSE_DIRT || block == MPBlocks.TERRASTONE || block == MPBlocks.PURIFIED_GRAVEL;
        }
        if (this.type == BlockType.FRONOS_GRASS || this.type == BlockType.NEMOPHILA || this.type == BlockType.PINK_BLECHNUM || this.type == BlockType.PURPLE_BUSH || this.type == BlockType.FRONOS_FERN) {
            return block == MPBlocks.FRONOS_GRASS_BLOCK || block == MPBlocks.FRONOS_DIRT || block == MPBlocks.FRONOS_COARSE_DIRT || block == MPBlocks.FRONOS_FARMLAND;
        }
        return false;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        if (this.type == BlockType.CHEESE_GRASS) {
            return MPBlocks.CHEESE_TALL_GRASS.func_176196_c(world, pos);
        }
        if (this.type == BlockType.INFECTED_GRASS) {
            return MPBlocks.INFECTED_TALL_GRASS.func_176196_c(world, pos);
        }
        if (this.type == BlockType.INFECTED_FERN) {
            return MPBlocks.INFECTED_LARGE_FERN.func_176196_c(world, pos);
        }
        if (this.type == BlockType.GREEN_VEIN_GRASS) {
            return MPBlocks.GREEN_VEIN_TALL_GRASS.func_176196_c(world, pos);
        }
        if (this.type == BlockType.FRONOS_GRASS) {
            return MPBlocks.FRONOS_TALL_GRASS.func_176196_c(world, pos);
        }
        return this.type == BlockType.TERRASHROOM;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        if (this.type == BlockType.CHEESE_GRASS) {
            return MPBlocks.CHEESE_TALL_GRASS.func_176196_c(world, pos);
        }
        if (this.type == BlockType.INFECTED_GRASS) {
            return MPBlocks.INFECTED_TALL_GRASS.func_176196_c(world, pos);
        }
        if (this.type == BlockType.INFECTED_FERN) {
            return MPBlocks.INFECTED_LARGE_FERN.func_176196_c(world, pos);
        }
        if (this.type == BlockType.GREEN_VEIN_GRASS) {
            return MPBlocks.GREEN_VEIN_TALL_GRASS.func_176196_c(world, pos);
        }
        if (this.type == BlockType.FRONOS_GRASS) {
            return MPBlocks.FRONOS_TALL_GRASS.func_176196_c(world, pos);
        }
        return this.type == BlockType.TERRASHROOM && (double)rand.nextFloat() < 0.4;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        if (this.type == BlockType.CHEESE_GRASS) {
            if (MPBlocks.CHEESE_TALL_GRASS.func_176196_c(world, pos)) {
                MPBlocks.CHEESE_TALL_GRASS.placeAt(world, pos, MPBlocks.CHEESE_TALL_GRASS, 2);
            }
        } else if (this.type == BlockType.INFECTED_GRASS) {
            if (MPBlocks.INFECTED_TALL_GRASS.func_176196_c(world, pos)) {
                MPBlocks.INFECTED_TALL_GRASS.placeAt(world, pos, MPBlocks.INFECTED_TALL_GRASS, 2);
            }
        } else if (this.type == BlockType.INFECTED_FERN) {
            if (MPBlocks.INFECTED_LARGE_FERN.func_176196_c(world, pos)) {
                MPBlocks.INFECTED_LARGE_FERN.placeAt(world, pos, MPBlocks.INFECTED_LARGE_FERN, 2);
            }
        } else if (this.type == BlockType.GREEN_VEIN_GRASS) {
            if (MPBlocks.GREEN_VEIN_TALL_GRASS.func_176196_c(world, pos)) {
                MPBlocks.GREEN_VEIN_TALL_GRASS.placeAt(world, pos, MPBlocks.GREEN_VEIN_TALL_GRASS, 2);
            }
        } else if (this.type == BlockType.FRONOS_GRASS) {
            if (MPBlocks.FRONOS_TALL_GRASS.func_176196_c(world, pos)) {
                MPBlocks.FRONOS_TALL_GRASS.placeAt(world, pos, MPBlocks.FRONOS_TALL_GRASS, 2);
            }
        } else if (this.type == BlockType.TERRASHROOM) {
            this.generateBigMushroom(world, pos, state, rand);
        }
    }

    @Override
    public ColorUtils.RGB getRarityColor() {
        return this.type == BlockType.CREEP_VINES ? ColorUtils.stringToRGB((String)"178, 109, 237") : null;
    }

    private void generateBigMushroom(World world, BlockPos pos, IBlockState state, Random rand) {
        world.func_175698_g(pos);
        WorldGenTerrashroom worldGen = new WorldGenTerrashroom();
        if (!worldGen.func_180709_b(world, rand, pos)) {
            world.func_180501_a(pos, state, 3);
        }
    }

    public static enum BlockType {
        CHEESE_GRASS(false),
        INFECTED_GRASS(false),
        INFECTED_FERN(false),
        GREEN_VEIN_GRASS(false),
        PURE_HERB(true),
        TERRAPUFF_HERB(true),
        BATASIA_DANDELION(true),
        PYOLONIA(true),
        PHILIPY(true),
        WHITE_TAIL(true),
        VEALIUM_VINES(true),
        TERRASHROOM(true),
        CREEP_VINES(true),
        FRONOS_GRASS(false),
        NEMOPHILA(true),
        PINK_BLECHNUM(true),
        PURPLE_BUSH(false),
        FRONOS_FERN(false);

        private final boolean isFlower;

        private BlockType(boolean isFlower) {
            this.isFlower = isFlower;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isFlower() {
            return this.isFlower;
        }
    }
}

