/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.utils.client.renderer.tileentity;

import com.stevekung.lib.utils.CalendarUtils;
import com.stevekung.moreplanets.utils.blocks.BlockChestMP;
import com.stevekung.moreplanets.utils.tileentity.TileEntityChestMP;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.model.ModelLargeChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityChestRendererMP
extends TileEntitySpecialRenderer<TileEntityChestMP> {
    private static final ResourceLocation CHRISTMAS_DOUBLE = new ResourceLocation("textures/entity/chest/christmas_double.png");
    private static final ResourceLocation CHRISTMAS = new ResourceLocation("textures/entity/chest/christmas.png");
    private final ResourceLocation textureNormalDouble;
    private final ResourceLocation textureNormal;
    private final ResourceLocation morePlanetsChestNormal;
    private final ResourceLocation morePlanetsLargeChestNormal;
    private final ModelChest simpleChest = new ModelChest();
    private final ModelChest largeChest = new ModelLargeChest();

    public TileEntityChestRendererMP(String name) {
        this.textureNormalDouble = new ResourceLocation("moreplanets:textures/model/" + name + "_chest_double.png");
        this.textureNormal = new ResourceLocation("moreplanets:textures/model/" + name + "_chest.png");
        this.morePlanetsChestNormal = new ResourceLocation("moreplanets:textures/model/stevekung_chest.png");
        this.morePlanetsLargeChestNormal = new ResourceLocation("moreplanets:textures/model/stevekung_chest_double.png");
    }

    public void render(TileEntityChestMP tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int meta;
        if (!tile.func_145830_o()) {
            meta = 0;
        } else {
            Block block = tile.func_145838_q();
            meta = tile.func_145832_p();
            if (block instanceof BlockChestMP && meta == 0) {
                ((BlockChestMP)block).checkForSurroundingChests(tile.func_145831_w(), tile.func_174877_v(), tile.func_145831_w().func_180495_p(tile.func_174877_v()));
                meta = tile.func_145832_p();
            }
            tile.checkForAdjacentChests();
        }
        if (tile.adjacentChestZNeg == null && tile.adjacentChestXNeg == null) {
            float f2;
            ModelChest modelchest;
            if (tile.adjacentChestXPos == null && tile.adjacentChestZPos == null) {
                modelchest = this.simpleChest;
                if (destroyStage >= 0) {
                    this.func_147499_a(field_178460_a[destroyStage]);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                    GlStateManager.func_179128_n((int)5888);
                } else if (CalendarUtils.isChristmasDay()) {
                    this.func_147499_a(CHRISTMAS);
                } else if (CalendarUtils.isMorePlanetsBirthDay()) {
                    this.func_147499_a(this.morePlanetsChestNormal);
                } else {
                    this.func_147499_a(this.textureNormal);
                }
            } else {
                modelchest = this.largeChest;
                if (destroyStage >= 0) {
                    this.func_147499_a(field_178460_a[destroyStage]);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)8.0f, (float)4.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                    GlStateManager.func_179128_n((int)5888);
                } else if (CalendarUtils.isChristmasDay()) {
                    this.func_147499_a(CHRISTMAS_DOUBLE);
                } else if (CalendarUtils.isMorePlanetsBirthDay()) {
                    this.func_147499_a(this.morePlanetsLargeChestNormal);
                } else {
                    this.func_147499_a(this.textureNormalDouble);
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            if (destroyStage < 0) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            int short1 = 0;
            if (meta == 2) {
                short1 = 180;
            }
            if (meta == 3) {
                short1 = 0;
            }
            if (meta == 4) {
                short1 = 90;
            }
            if (meta == 5) {
                short1 = -90;
            }
            if (meta == 2 && tile.adjacentChestXPos != null) {
                GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (meta == 5 && tile.adjacentChestZPos != null) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            }
            GlStateManager.func_179114_b((float)short1, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float f1 = tile.prevLidAngle + (tile.lidAngle - tile.prevLidAngle) * partialTicks;
            if (tile.adjacentChestZNeg != null && (f2 = tile.adjacentChestZNeg.prevLidAngle + (tile.adjacentChestZNeg.lidAngle - tile.adjacentChestZNeg.prevLidAngle) * partialTicks) > f1) {
                f1 = f2;
            }
            if (tile.adjacentChestXNeg != null && (f2 = tile.adjacentChestXNeg.prevLidAngle + (tile.adjacentChestXNeg.lidAngle - tile.adjacentChestXNeg.prevLidAngle) * partialTicks) > f1) {
                f1 = f2;
            }
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            modelchest.field_78234_a.field_78795_f = -(f1 * (float)Math.PI / 2.0f);
            modelchest.func_78231_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (destroyStage >= 0) {
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
            }
        }
    }
}

