/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.utils.tileentity;

import com.stevekung.moreplanets.init.MPSounds;
import com.stevekung.moreplanets.network.PacketSimpleMP;
import com.stevekung.moreplanets.utils.items.IDungeonKeyable;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityTreasureChestMP
extends TileEntityAdvanced
implements IDungeonKeyable,
IInteractionObject {
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    private int ticksSinceSync;
    private final Block block;
    private ResourceLocation lootTable;
    private long lootTableSeed;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean locked = true;

    public TileEntityTreasureChestMP(String name, Block block) {
        super("container." + name + ".treasurechest.name");
        this.inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
        this.block = block;
    }

    public ItemStack func_70301_a(int index) {
        this.fillWithLoot(null);
        return super.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.fillWithLoot(null);
        return super.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        this.fillWithLoot(null);
        return super.func_70304_b(index);
    }

    public void func_70299_a(int index, @Nullable ItemStack itemStack) {
        this.fillWithLoot(null);
        super.func_70299_a(index, itemStack);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.locked = nbt.func_74767_n("Locked");
        if (!this.checkLootAndRead(nbt)) {
            super.func_145839_a(nbt);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("Locked", this.locked);
        if (!this.checkLootAndWrite(nbt)) {
            super.func_189515_b(nbt);
        }
        return nbt;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_73660_a() {
        float f;
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (this.locked) {
            this.numPlayersUsing = 0;
        }
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            this.numPlayersUsing = 0;
            f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - f), (double)((float)j - f), (double)((float)k - f), (double)((float)(i + 1) + f), (double)((float)(j + 1) + f), (double)((float)(k + 1) + f)));
            for (EntityPlayer player : list) {
                IInventory iinventory;
                if (!(player.field_71070_bA instanceof ContainerChest) || (iinventory = ((ContainerChest)player.field_71070_bA).func_85151_d()) != this && (!(iinventory instanceof InventoryLargeChest) || !((InventoryLargeChest)iinventory).func_90010_a((IInventory)this))) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        float f2 = f = this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider ? 0.05f : 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)i + 0.5;
            double d2 = (double)k + 0.5;
            this.field_145850_b.func_184148_a(null, d1, (double)j + 0.5, d2, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider ? this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.6f : this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if ((this.numPlayersUsing == 0 || this.locked) && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f22;
            float f1 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing == 0 || this.locked ? (this.lidAngle -= f) : (this.lidAngle += f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f22 = 0.5f) && f1 >= f22) {
                double d2 = (double)i + 0.5;
                double d0 = (double)k + 0.5;
                this.field_145850_b.func_184148_a(null, d2, (double)j + 0.5, d0, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider ? this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.6f : this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        super.func_73660_a();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() == this.block) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public String func_174875_k() {
        return "moreplanets:treasure_chest";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
        this.fillWithLoot(player);
        return new ContainerChest((IInventory)playerInventory, (IInventory)this, player);
    }

    public void func_174888_l() {
        super.func_174888_l();
        this.fillWithLoot(null);
    }

    @Override
    public boolean onActivated(EntityPlayer player, Item item, boolean isKey) {
        if (isKey && this.locked) {
            this.locked = false;
            if (!this.field_145850_b.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70448_g().func_190918_g(1);
                }
                return true;
            }
        } else {
            if (player.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.S_FAILED_UNLOCK_CHEST, GCCoreUtil.getDimensionID((World)this.field_145850_b), item.func_77653_i(item.func_190903_i())));
            }
            return true;
        }
        player.func_184185_a(MPSounds.UNLOCK_TREASURE_CHEST, 1.0f, 1.0f);
        return false;
    }

    public double getPacketRange() {
        return 20.0;
    }

    public int getPacketCooldown() {
        return 3;
    }

    public boolean isNetworkedTile() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(2, 2, 2));
    }

    public int[] func_180463_a(EnumFacing facing) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStack, EnumFacing facing) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack itemStack, EnumFacing facing) {
        return false;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceLocation lootTable, long seed) {
        this.lootTable = lootTable;
        this.lootTableSeed = seed;
    }

    public static TileEntityTreasureChestMP findClosest(Entity entity, Item item) {
        double distance = Double.MAX_VALUE;
        TileEntityTreasureChestMP chest = null;
        for (TileEntity tile : entity.field_70170_p.field_147482_g) {
            double dist;
            if (!(tile instanceof TileEntityTreasureChestMP) || ((TileEntityTreasureChestMP)tile).getDungeonKey() != item || !((dist = entity.func_70092_e((double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 0.5, (double)tile.func_174877_v().func_177952_p() + 0.5)) < distance)) continue;
            distance = dist;
            chest = (TileEntityTreasureChestMP)tile;
        }
        return chest;
    }

    protected boolean checkLootAndRead(NBTTagCompound compound) {
        if (compound.func_150297_b("LootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            this.lootTableSeed = compound.func_74763_f("LootTableSeed");
            return true;
        }
        return false;
    }

    protected boolean checkLootAndWrite(NBTTagCompound compound) {
        if (this.lootTable != null) {
            compound.func_74778_a("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.func_74772_a("LootTableSeed", this.lootTableSeed);
            }
            return true;
        }
        return false;
    }

    private void fillWithLoot(@Nullable EntityPlayer player) {
        if (this.lootTable != null) {
            LootTable loot = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTable);
            this.lootTable = null;
            Random rand = this.lootTableSeed == 0L ? new Random() : new Random(this.lootTableSeed);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da());
            }
            loot.func_186460_a((IInventory)this, rand, builder.func_186471_a());
        }
    }
}

