/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.utils.world.gen;

import java.util.List;
import java.util.Random;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.perlin.generator.GradientNoise;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public abstract class ChunkGeneratorBaseMP
implements IChunkGenerator {
    private final GradientNoise noise1;
    private final GradientNoise noise2;
    private final GradientNoise noise3;
    private final GradientNoise noise4;
    private final NoiseGeneratorOctaves minLimitPerlinNoise;
    private final NoiseGeneratorOctaves maxLimitPerlinNoise;
    private final NoiseGeneratorOctaves mainPerlinNoise;
    private final NoiseGeneratorPerlin surfaceNoise;
    private final NoiseGeneratorOctaves depthNoise;
    private double[] depthBuffer = new double[256];
    private final double[] heightMap;
    private Biome[] biomesForGeneration;
    private double[] mainNoiseRegion;
    private double[] minLimitRegion;
    private double[] maxLimitRegion;
    private double[] depthRegion;
    private final float[] biomeWeights;
    protected final World world;
    protected final Random rand;
    protected boolean isSingleBiomePlanet;

    public ChunkGeneratorBaseMP(World world, long seed) {
        this.world = world;
        this.rand = new Random(seed);
        this.isSingleBiomePlanet = true;
        this.noise1 = new GradientNoise(this.rand.nextLong(), 4, 0.25);
        this.noise2 = new GradientNoise(this.rand.nextLong(), 4, 0.25);
        this.noise3 = new GradientNoise(this.rand.nextLong(), 1, 0.25);
        this.noise4 = new GradientNoise(this.rand.nextLong(), 1, 0.25);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.biomeWeights[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer primer = new ChunkPrimer();
        if (this.isSingleBiomePlanet) {
            this.generateTerrain(chunkX, chunkZ, primer);
        } else {
            this.setBlocksInChunk(chunkX, chunkZ, primer);
        }
        this.preGenerateChunk(primer, chunkX, chunkZ);
        if (this.isSingleBiomePlanet) {
            this.replaceBiomeBlocks(chunkX, chunkZ, primer);
        } else {
            this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
            this.replaceBiomeBlocks(chunkX, chunkZ, primer, this.biomesForGeneration);
        }
        this.generateChunk(primer, chunkX, chunkZ);
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        if (!this.isSingleBiomePlanet) {
            this.initBiomesArray(chunk);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos pos = new BlockPos(x, 0, z);
        Biome biome = this.world.func_180494_b(pos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.world.func_72905_C());
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        this.populate(pos, chunkpos, biome, chunkX, chunkZ, x, z);
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType type, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(type);
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    protected int getCraterChance() {
        return 300;
    }

    protected int getTerrainHeight() {
        return 64;
    }

    protected void createCraters(int chunkX, int chunkZ, ChunkPrimer primer) {
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (this.getCraterChance() <= 0 || !(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < this.noise4.evalNoise((double)(x * 16 + x), (double)(cz * 16 + z)) / (double)this.getCraterChance())) continue;
                        Random random = new Random((long)cx * 16L + (long)x + ((long)cz * 16L + (long)z) * 5000L);
                        EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, primer);
                    }
                }
            }
        }
    }

    private void replaceBiomeBlocks(int chunkX, int chunkZ, ChunkPrimer chunk) {
        int seaLevel = 20;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int noise = (int)(this.noise4.evalNoise((double)(x + chunkX * 16), (double)(z * chunkZ * 16)) / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int j = -1;
                IBlockState topBlock = this.getTopBlock();
                IBlockState fillBlock = this.getSubBlock();
                for (int y = 255; y >= 0; --y) {
                    if (y <= this.rand.nextInt(5)) {
                        chunk.func_177855_a(x, y, z, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    IBlockState iblockstate2 = chunk.func_177856_a(x, y, z);
                    if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                        j = -1;
                        continue;
                    }
                    if (iblockstate2.func_177230_c() != this.getStoneBlock().func_177230_c()) continue;
                    if (j == -1) {
                        if (noise <= 0) {
                            topBlock = Blocks.field_150350_a.func_176223_P();
                            fillBlock = this.getStoneBlock();
                        } else if (y >= seaLevel - 4 && y <= seaLevel + 1) {
                            topBlock = this.getTopBlock();
                            fillBlock = this.getSubBlock();
                        }
                        j = noise;
                        if (y >= seaLevel - 1) {
                            chunk.func_177855_a(x, y, z, topBlock);
                            continue;
                        }
                        if (y < seaLevel - 2) continue;
                        chunk.func_177855_a(x, y, z, fillBlock);
                        continue;
                    }
                    if (j <= 0) continue;
                    --j;
                    chunk.func_177855_a(x, y, z, fillBlock);
                }
            }
        }
    }

    private void generateTerrain(int chunkX, int chunkZ, ChunkPrimer chunk) {
        this.noise1.setFrequencyAll((double)0.0125f);
        this.noise2.setFrequencyAll((double)0.015f);
        this.noise3.setFrequencyAll((double)0.01f);
        this.noise4.setFrequencyAll((double)0.02f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double d = this.noise1.evalNoise((double)(x + chunkX * 16), (double)(z + chunkZ * 16)) * 8.0;
                double d2 = this.noise2.evalNoise((double)(x + chunkX * 16), (double)(z + chunkZ * 16)) * 24.0;
                double d3 = this.noise3.evalNoise((double)(x + chunkX * 16), (double)(z + chunkZ * 16)) - 0.1;
                double yDev = (d3 *= 4.0) < 0.0 ? d : (d3 > 1.0 ? d2 : d + (d2 - d) * d3);
                for (int y = 0; y < 128; ++y) {
                    if (!((double)y < (double)this.getTerrainHeight() + yDev)) continue;
                    chunk.func_177855_a(x, y, z, this.getStoneBlock());
                }
            }
        }
    }

    private void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 127; y > 0; --y) {
                    if (Blocks.field_150350_a != primer.func_177856_a(x, y, z).func_177230_c() && (double)helper <= yDev) {
                        primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    protected void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.generateHeightmap(chunkX * 4, 0, chunkZ * 4);
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d1 = this.heightMap[i1 + i2];
                    double d2 = this.heightMap[j1 + i2];
                    double d3 = this.heightMap[k1 + i2];
                    double d4 = this.heightMap[l1 + i2];
                    double d5 = (this.heightMap[i1 + i2 + 1] - d1) * 0.125;
                    double d6 = (this.heightMap[j1 + i2 + 1] - d2) * 0.125;
                    double d7 = (this.heightMap[k1 + i2 + 1] - d3) * 0.125;
                    double d8 = (this.heightMap[l1 + i2 + 1] - d4) * 0.125;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d16 = (d11 - d10) * 0.25;
                            double lvt_45_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                lvt_45_1_ += d16;
                                if (d > 0.0) {
                                    primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, this.getStoneBlock());
                                    continue;
                                }
                                if (i2 * 8 + j2 >= this.world.func_181545_F()) continue;
                                primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, this.getLiquidBlock());
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    protected void replaceBiomeBlocks(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] biomes) {
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomes[j + i * 16];
                biome.func_180622_a(this.world, this.rand, primer, chunkX * 16 + i, chunkZ * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    protected void initBiomesArray(Chunk chunk) {
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
    }

    private void generateHeightmap(int x, int y, int z) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, x, z, 5, 5, 200.0, 200.0, 0.5);
        float f = 684.412f;
        float f1 = 684.412f;
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, x, y, z, 5, 33, 5, (double)(f / 80.0f), (double)(f1 / 160.0f), (double)(f / 80.0f));
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, x, y, z, 5, 33, 5, (double)f, (double)f1, (double)f);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, x, y, z, 5, 33, 5, (double)f, (double)f1, (double)f);
        int i = 0;
        int j = 0;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                Biome biome = this.biomesForGeneration[k + 2 + (l + 2) * 10];
                for (int j1 = -2; j1 <= 2; ++j1) {
                    for (int k1 = -2; k1 <= 2; ++k1) {
                        Biome biome1 = this.biomesForGeneration[k + j1 + 2 + (l + k1 + 2) * 10];
                        float f5 = biome1.func_185355_j();
                        float f6 = biome1.func_185360_m();
                        float f7 = this.biomeWeights[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                        if (biome1.func_185355_j() > biome.func_185355_j()) {
                            f7 /= 2.0f;
                        }
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d7 = this.depthRegion[j] / 8000.0;
                if (d7 < 0.0) {
                    d7 = -d7 * 0.3;
                }
                if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                    if ((d7 /= 2.0) < -1.0) {
                        d7 = -1.0;
                    }
                    d7 /= 1.4;
                    d7 /= 2.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    d7 /= 8.0;
                }
                ++j;
                double d8 = f3;
                double d9 = f2;
                d8 += d7 * 0.2;
                d8 = d8 * 8.5 / 8.0;
                double d0 = 8.5 + d8 * 4.0;
                for (int l1 = 0; l1 < 33; ++l1) {
                    double d1 = ((double)l1 - d0) * 12.0 * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d2 = this.minLimitRegion[i] / 512.0;
                    double d3 = this.maxLimitRegion[i] / 512.0;
                    double d4 = (this.mainNoiseRegion[i] / 10.0 + 1.0) / 2.0;
                    double d5 = MathHelper.func_151238_b((double)d2, (double)d3, (double)d4) - d1;
                    if (l1 > 29) {
                        double d6 = (float)(l1 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) + -10.0 * d6;
                    }
                    this.heightMap[i] = d5;
                    ++i;
                }
            }
        }
    }

    protected IBlockState getLiquidBlock() {
        return Blocks.field_150355_j.func_176223_P();
    }

    protected static void generatePocket(World world, Random rand, int xx, int zz, IBlockState pocket, Set<Biome> ignoreBiomes) {
        ChunkGeneratorBaseMP.generatePocket(world, rand, xx, zz, pocket, ignoreBiomes, 17 + rand.nextInt(10) + rand.nextInt(5), 3 + rand.nextInt(5));
    }

    protected static void generatePocket(World world, Random rand, int xx, int zz, IBlockState pocket, Set<Biome> ignoreBiomes, int y, int radius) {
        BlockVec3 pos = new BlockVec3();
        if (ChunkGeneratorBaseMP.canGeneratePocket(world, rand, xx, zz, pos, ignoreBiomes, y)) {
            int x = pos.x;
            int cy = pos.y;
            int z = pos.z;
            if (ChunkGeneratorBaseMP.checkPocketPresent(world, x, cy, z, radius, pocket)) {
                return;
            }
            int r2 = radius * radius;
            for (int bx = -radius; bx <= radius; ++bx) {
                for (int by = -radius + 2; by <= radius - 2; ++by) {
                    int xySquared = bx * bx + by * by * 3;
                    for (int bz = -radius; bz <= radius; ++bz) {
                        if (xySquared + bz * bz > r2 || ChunkGeneratorBaseMP.checkBlock(world, new BlockPos(bx + x - 1, by + cy, bz + z), pocket) || ChunkGeneratorBaseMP.checkBlock(world, new BlockPos(bx + x + 1, by + cy, bz + z), pocket) || ChunkGeneratorBaseMP.checkBlock(world, new BlockPos(bx + x, by + cy - 1, bz + z), pocket) || ChunkGeneratorBaseMP.checkBlock(world, new BlockPos(bx + x, by + cy, bz + z - 1), pocket) || ChunkGeneratorBaseMP.checkBlock(world, new BlockPos(bx + x, by + cy, bz + z + 1), pocket) || ChunkGeneratorBaseMP.checkBlockAbove(world, new BlockPos(bx + x, by + cy + 1, bz + z))) continue;
                        world.func_180501_a(new BlockPos(bx + x, by + cy, bz + z), pocket, 2);
                    }
                }
            }
        }
    }

    private static boolean canGeneratePocket(World world, Random rand, int x, int z, BlockVec3 pos, Set<Biome> ignoreBiomes, int y) {
        boolean flag2;
        Biome biome = world.func_180494_b(new BlockPos(x + 8, 0, z + 8));
        if (!ignoreBiomes.isEmpty()) {
            for (Biome ignoreBiome : ignoreBiomes) {
                if (biome != ignoreBiome) continue;
                return false;
            }
        }
        rand.setSeed(world.func_72905_C());
        long i1 = (long)rand.nextInt() / 2L * 2L + 1L;
        long j1 = (long)rand.nextInt() / 2L * 2L + 1L;
        rand.setSeed((long)x * i1 + (long)z * j1 ^ world.func_72905_C());
        double randMod = Math.min(0.2, 0.09000000000000001);
        if (biome.func_185355_j() >= 0.45f) {
            randMod /= 2.0;
        }
        if (biome.func_185355_j() < -0.5f) {
            randMod *= 1.8;
        }
        boolean flag1 = rand.nextDouble() <= randMod;
        boolean bl = flag2 = rand.nextDouble() <= randMod;
        if (flag1 || flag2) {
            pos.y = y;
            pos.x = x + 8 - rand.nextInt(16);
            pos.z = z + 8 - rand.nextInt(16);
            return true;
        }
        return false;
    }

    private static boolean checkBlock(World world, BlockPos pos, IBlockState pocket) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (state.func_185904_a() == Material.field_151579_a) {
            return true;
        }
        return block instanceof BlockLiquid && block != pocket.func_177230_c();
    }

    private static boolean checkBlockAbove(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof BlockFalling;
    }

    private static boolean checkPocketPresent(World world, int x, int cy, int z, int r, IBlockState pocket) {
        int r2 = r * r;
        for (int bx = -r; bx <= r; ++bx) {
            for (int by = -r + 2; by <= r - 2; ++by) {
                int xySquared = bx * bx + by * by * 3;
                for (int bz = -r; bz <= r; ++bz) {
                    if (xySquared + bz * bz > r2 || ChunkGeneratorBaseMP.checkBlock(world, new BlockPos(bx + x - 1, by + cy, bz + z), pocket) || ChunkGeneratorBaseMP.checkBlock(world, new BlockPos(bx + x + 1, by + cy, bz + z), pocket) || ChunkGeneratorBaseMP.checkBlock(world, new BlockPos(bx + x, by + cy - 1, bz + z), pocket) || ChunkGeneratorBaseMP.checkBlock(world, new BlockPos(bx + x, by + cy, bz + z - 1), pocket) || ChunkGeneratorBaseMP.checkBlock(world, new BlockPos(bx + x, by + cy, bz + z + 1), pocket) || ChunkGeneratorBaseMP.checkBlockAbove(world, new BlockPos(bx + x, by + cy + 1, bz + z)) || world.func_180495_p(new BlockPos(bx + x, by + cy, bz + z)).func_177230_c() != pocket.func_177230_c()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected abstract void preGenerateChunk(ChunkPrimer var1, int var2, int var3);

    protected abstract void generateChunk(ChunkPrimer var1, int var2, int var3);

    protected abstract void populate(BlockPos var1, ChunkPos var2, Biome var3, int var4, int var5, int var6, int var7);

    protected abstract IBlockState getTopBlock();

    protected abstract IBlockState getSubBlock();

    protected abstract IBlockState getStoneBlock();
}

