/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block;

import java.util.List;
import java.util.function.Supplier;
import net.je.common.block.custom.BejeweledPedestalBlock;
import net.je.common.block.custom.BoundObsidianBlock;
import net.je.common.block.custom.CustomTransparentBlock;
import net.je.common.block.custom.EndStoneFurnaceBlock;
import net.je.common.block.custom.EnderVaultBlock;
import net.je.common.block.custom.GravityDistorterBlock;
import net.je.common.block.custom.InterdimensionalAnchorBlock;
import net.je.common.block.custom.InvertedShadowBlock;
import net.je.common.block.custom.LushEndStoneBlock;
import net.je.common.block.custom.RespawnNexusBlock;
import net.je.common.block.custom.ShadowBeamEmitterBlock;
import net.je.common.block.custom.ShadowBeamReceiverBlock;
import net.je.common.block.custom.ShadowBlock;
import net.je.common.block.custom.ShadowPrismBlock;
import net.je.common.block.custom.TopWardedBlock;
import net.je.common.block.custom.TransparentWardedBlock;
import net.je.common.block.custom.UnstableShadowPrismBlock;
import net.je.common.block.custom.VoidbloomBlock;
import net.je.common.block.custom.WardedBlock;
import net.je.common.fluid.ModFluids;
import net.je.common.item.ModItems;
import net.je.common.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"je");
    public static final RegistryObject<LiquidBlock> VOIDBLIGHT = ModBlocks.registerBlock("source_voidblight", () -> new LiquidBlock(ModFluids.SOURCE_VOIDBLIGHT, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_MAGENTA).replaceable().noCollission().strength(100.0f).pushReaction(PushReaction.DESTROY).liquid().noLootTable().lightLevel(p_50755_ -> 7).sound(SoundType.SCULK_SHRIEKER).emissiveRendering(ModBlocks::always)));
    public static final RegistryObject<Block> VOIDMASS = ModBlocks.registerBlock("voidmass", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_MAGENTA).strength(1.5f).lightLevel(p_50755_ -> 7).emissiveRendering(ModBlocks::always).sound(SoundType.SCULK_SHRIEKER)));
    public static final RegistryObject<Block> END_STONE_FURNACE = ModBlocks.registerBlock("end_stone_furnace", () -> new EndStoneFurnaceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).strength(50.0f, 1200.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> COMPRESSED_END_STONE = ModBlocks.registerBlock("compressed_end_stone", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).strength(50.0f, 1200.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> VOIDMETAL_BLOCK = ModBlocks.registerBlock("voidmetal_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(5.0f, 6.0f).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().sound(SoundType.METAL)));
    public static final RegistryObject<Block> END_STONE_PILLAR = ModBlocks.registerBlock("end_stone_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> CHISELED_END_STONE = ModBlocks.registerBlock("chiseled_end_stone", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> END_STONE_TILES = ModBlocks.registerBlock("end_stone_tiles", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> POLISHED_END_STONE = ModBlocks.registerBlock("polished_end_stone", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> POLISHED_END_STONE_STAIRS = ModBlocks.registerBlock("polished_end_stone_stairs", () -> new StairBlock(((Block)POLISHED_END_STONE.get()).defaultBlockState(), BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> POLISHED_END_STONE_SLAB = ModBlocks.registerBlock("polished_end_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> POLISHED_END_STONE_WALL = ModBlocks.registerBlock("polished_end_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> VOID_STONE = ModBlocks.registerBlock("void_stone", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(1.5f, 6.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> LUSH_END_STONE = ModBlocks.registerBlock("lush_end_stone", () -> new LushEndStoneBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).strength(3.0f, 9.0f).requiresCorrectToolForDrops().sound(SoundType.NYLIUM).randomTicks()){

        public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.je.unobtainable"));
            super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        }
    });
    public static final RegistryObject<Block> FADED_END_STONE = ModBlocks.registerBlock("faded_end_stone", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundType.CALCITE)));
    public static final RegistryObject<Block> FADED_END_STONE_BRICKS = ModBlocks.registerBlock("faded_end_stone_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundType.CALCITE)));
    public static final RegistryObject<Block> CORRUPTED_DIRT = ModBlocks.registerBlock("corrupted_dirt", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PINK).strength(0.5f).sound(SoundType.GRAVEL)));
    public static final RegistryObject<Block> LANTERN_OF_WARDING = ModBlocks.registerBlock("lantern_of_warding", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).strength(0.5f).requiresCorrectToolForDrops().sound(SoundType.COPPER_BULB).lightLevel(p_50755_ -> 15).emissiveRendering(ModBlocks::always).hasPostProcess(ModBlocks::always)){

        public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.je.unobtainable"));
            super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        }
    });
    public static final RegistryObject<Block> INTERDIMENSIONAL_ANCHOR = ModBlocks.registerBlock("interdimensional_anchor", () -> new InterdimensionalAnchorBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).strength(3.0f, 9.0f).requiresCorrectToolForDrops().sound((SoundType)ModSounds.INTERDIMENSIONAL_ANCHOR_SOUNDS).randomTicks()));
    public static final RegistryObject<Block> ENDER_VAULT = ModBlocks.registerBlock("ender_vault", () -> new EnderVaultBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).strength(50.0f, 1200.0f).requiresCorrectToolForDrops().sound(SoundType.ANVIL).noLootTable().lightLevel(p_50755_ -> 15)));
    public static final RegistryObject<Block> VOIDBLOOM = ModBlocks.registerBlock("voidbloom", () -> new VoidbloomBlock(BlockBehaviour.Properties.of().noCollission().instabreak().sound(SoundType.SCULK_SHRIEKER).pushReaction(PushReaction.DESTROY).emissiveRendering(ModBlocks::always).lightLevel(p_50755_ -> 5)));
    public static final RegistryObject<Block> BEJEWELED_PEDESTAL = ModBlocks.registerBlock("bejeweled_pedestal", () -> new BejeweledPedestalBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(50.0f, 1200.0f).noLootTable().sound(SoundType.STONE).noLootTable().pushReaction(PushReaction.IGNORE)));
    public static final RegistryObject<Block> SHADOW_STONE = ModBlocks.registerBlock("shadow_stone", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> CORRUPTED_SHADOW_STONE = ModBlocks.registerBlock("corrupted_shadow_stone", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> BLIGHTED_SHADOW_STONE = ModBlocks.registerBlock("blighted_shadow_stone", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(1.5f, 4.5f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundType.SCULK_SHRIEKER)));
    public static final RegistryObject<Block> SHADOW_STONE_STAIRS = ModBlocks.registerBlock("shadow_stone_stairs", () -> new StairBlock(((Block)SHADOW_STONE.get()).defaultBlockState(), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> SHADOW_STONE_SLAB = ModBlocks.registerBlock("shadow_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> SHADOW_STONE_WALL = ModBlocks.registerBlock("shadow_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> CHISELED_SHADOW_STONE = ModBlocks.registerBlock("chiseled_shadow_stone", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> SHADOW_STONE_BRICKS = ModBlocks.registerBlock("shadow_stone_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> CRACKED_SHADOW_STONE_BRICKS = ModBlocks.registerBlock("cracked_shadow_stone_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> SHADOW_STONE_BRICK_STAIRS = ModBlocks.registerBlock("shadow_stone_brick_stairs", () -> new StairBlock(((Block)SHADOW_STONE.get()).defaultBlockState(), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> SHADOW_STONE_BRICK_SLAB = ModBlocks.registerBlock("shadow_stone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> SHADOW_STONE_BRICK_WALL = ModBlocks.registerBlock("shadow_stone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> POLISHED_SHADOW_STONE = ModBlocks.registerBlock("polished_shadow_stone", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> POLISHED_SHADOW_STONE_STAIRS = ModBlocks.registerBlock("polished_shadow_stone_stairs", () -> new StairBlock(((Block)SHADOW_STONE.get()).defaultBlockState(), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> POLISHED_SHADOW_STONE_SLAB = ModBlocks.registerBlock("polished_shadow_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> POLISHED_SHADOW_STONE_WALL = ModBlocks.registerBlock("polished_shadow_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> SHADOW_BLOCK = ModBlocks.registerBlock("shadow_block", () -> new ShadowBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(-1.0f, 3600000.0f).noLootTable().noOcclusion().isRedstoneConductor(ModBlocks::never).isSuffocating(ModBlocks::never).isViewBlocking((s, l, p) -> false).pushReaction(PushReaction.IGNORE)));
    public static final RegistryObject<Block> ECLIPSED_SHADOW_BLOCK = ModBlocks.registerBlock("eclipsed_shadow_block", () -> new InvertedShadowBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(-1.0f, 3600000.0f).noLootTable().noOcclusion().isRedstoneConductor(ModBlocks::never).isSuffocating(ModBlocks::never).isViewBlocking((s, l, p) -> false).pushReaction(PushReaction.IGNORE)));
    public static final RegistryObject<Block> SHADOW_PRISM = ModBlocks.registerBlock("shadow_prism", () -> new ShadowPrismBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(-1.0f, 3600000.0f).noLootTable().noOcclusion().lightLevel(p_50755_ -> 15).isRedstoneConductor(ModBlocks::never).isSuffocating(ModBlocks::never).pushReaction(PushReaction.IGNORE)));
    public static final RegistryObject<Block> UNSTABLE_SHADOW_PRISM = ModBlocks.registerBlock("unstable_shadow_prism", () -> new UnstableShadowPrismBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(-1.0f, 3600000.0f).noLootTable().noOcclusion().lightLevel(p_50755_ -> 15).isRedstoneConductor(ModBlocks::never).isSuffocating(ModBlocks::never).pushReaction(PushReaction.IGNORE)), false);
    public static final RegistryObject<Block> WARDED_SHADOW_STONE = ModBlocks.registerBlock("warded_shadow_stone", () -> new WardedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> WARDED_SHADOW_STONE_BRICKS = ModBlocks.registerBlock("warded_shadow_stone_bricks", () -> new WardedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> FRACTURED_WARDSTONE = ModBlocks.registerBlock("fractured_wardstone", () -> new TopWardedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops(), Direction.UP){

        public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.je.fractured_wardstone"));
            super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        }
    });
    public static final RegistryObject<Block> TOP_FRACTURED_WARDSTONE = ModBlocks.registerBlock("top_fractured_wardstone", () -> new TopWardedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().noLootTable(), Direction.DOWN){

        public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.je.top_fractured_wardstone"));
            super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        }
    });
    public static final RegistryObject<Block> WARDED_CRACKED_SHADOW_STONE_BRICKS = ModBlocks.registerBlock("warded_cracked_shadow_stone_bricks", () -> new WardedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> WARDED_POLISHED_SHADOW_STONE = ModBlocks.registerBlock("warded_polished_shadow_stone", () -> new WardedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> WARDED_CORRUPTED_SHADOW_STONE = ModBlocks.registerBlock("warded_corrupted_shadow_stone", () -> new WardedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> WARDED_VOID_LANTERN = ModBlocks.registerBlock("warded_void_lantern", () -> new WardedBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn(ModBlocks::never).isRedstoneConductor(ModBlocks::never).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).lightLevel(l -> 15)));
    public static final RegistryObject<Block> WARDED_FADED_END_STONE_BRICKS = ModBlocks.registerBlock("warded_faded_end_stone_bricks", () -> new WardedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundType.CALCITE)));
    public static final RegistryObject<Block> WARDED_BLIGHTED_SHADOW_STONE = ModBlocks.registerBlock("warded_blighted_shadow_stone", () -> new WardedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundType.SCULK).lightLevel(p -> 4)));
    public static final RegistryObject<Block> WARDED_CHISELED_SHADOW_STONE = ModBlocks.registerBlock("warded_chiseled_shadow_stone", () -> new WardedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 9.0f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> BOUND_OBSIDIAN = ModBlocks.registerBlock("bound_obsidian", BoundObsidianBlock::new);
    public static final RegistryObject<Block> VOID_LANTERN = ModBlocks.registerBlock("void_lantern", () -> new Block(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn(ModBlocks::never).isRedstoneConductor(ModBlocks::never).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).lightLevel(l -> 15)));
    public static final RegistryObject<Block> VOIDGLASS = ModBlocks.registerBlock("voidglass", () -> new CustomTransparentBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn(ModBlocks::never).isRedstoneConductor(ModBlocks::never).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never)));
    public static final RegistryObject<Block> WARDED_VOIDGLASS = ModBlocks.registerBlock("warded_voidglass", () -> new TransparentWardedBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn(ModBlocks::never).isRedstoneConductor(ModBlocks::never).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).mapColor(MapColor.COLOR_LIGHT_GRAY)));
    public static final RegistryObject<Block> GRAVITY_DISTORTER = ModBlocks.registerBlock("gravity_distorter", () -> new GravityDistorterBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(1.5f, 6.0f).instrument(NoteBlockInstrument.PLING).requiresCorrectToolForDrops().sound((SoundType)ModSounds.INTERDIMENSIONAL_ANCHOR_SOUNDS)));
    public static final RegistryObject<Block> RESPAWN_NEXUS = ModBlocks.registerBlock("respawn_nexus", () -> new RespawnNexusBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(50.0f, 1200.0f)));
    public static final RegistryObject<Block> SHADOW_BEAM_EMITTER = ModBlocks.registerBlock("shadow_beam_emitter", () -> new ShadowBeamEmitterBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.CHIME).requiresCorrectToolForDrops().strength(50.0f, 1200.0f)));
    public static final RegistryObject<Block> SHADOW_BEAM_RECEIVER = ModBlocks.registerBlock("shadow_beam_receiver", () -> new ShadowBeamReceiverBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.CHIME).requiresCorrectToolForDrops().strength(50.0f, 1200.0f)));

    private static boolean always(BlockState p_50775_, BlockGetter p_50776_, BlockPos p_50777_) {
        return true;
    }

    private static boolean never(BlockState p_50806_, BlockGetter p_50807_, BlockPos p_50808_) {
        return false;
    }

    private static Boolean never(BlockState p_50779_, BlockGetter p_50780_, BlockPos p_50781_, EntityType<?> p_50782_) {
        return false;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, boolean blockItem) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        if (blockItem) {
            ModBlocks.registerBlockItem(name, toReturn);
        }
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

