/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.custom;

import com.mojang.serialization.MapCodec;
import net.je.common.block.entity.BejeweledPedestalBlockEntity;
import net.je.common.block.entity.ModBlockEntities;
import net.je.common.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BejeweledPedestalBlock
extends BaseEntityBlock {
    public static final MapCodec<BejeweledPedestalBlock> CODEC = BejeweledPedestalBlock.simpleCodec(BejeweledPedestalBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty HAS_EYE = BooleanProperty.create((String)"eye");
    protected static final VoxelShape BASE_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected static final VoxelShape EYE_SHAPE = Block.box((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape FULL_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape)EYE_SHAPE);

    public BejeweledPedestalBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true)));
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.getValue((Property)HAS_EYE) != false ? FULL_SHAPE : BASE_SHAPE;
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected MapCodec<BejeweledPedestalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection())).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(true));
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof BejeweledPedestalBlockEntity) {
            BejeweledPedestalBlockEntity be = (BejeweledPedestalBlockEntity)blockEntity;
            if (((Boolean)be.getBlockState().getValue((Property)HAS_EYE)).booleanValue()) {
                if (pLevel.isClientSide) {
                    float pitch = (float)(Math.random() * 0.1 + 0.6);
                    pLevel.playLocalSound((double)pPos.getX(), (double)pPos.above().getY(), (double)pPos.getZ(), (SoundEvent)ModSounds.ENDERSENT_SUMMON.get(), SoundSource.BLOCKS, 1.0f, pitch, false);
                    return InteractionResult.SUCCESS;
                }
                be.spawnEndersent();
                Direction facing = (Direction)pLevel.getBlockState(pPos).getValue((Property)FACING);
                pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HAS_EYE, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)facing));
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, HAS_EYE});
    }

    protected boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return (Boolean)pBlockState.getValue((Property)HAS_EYE) != false ? 15 : 0;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new BejeweledPedestalBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return BejeweledPedestalBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.BEJEWELED_PEDESTAL_BE.get()), BejeweledPedestalBlockEntity::tick);
    }
}

