/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.custom;

import net.je.common.block.custom.WardedBlock;
import net.je.common.item.ModItems;
import net.je.common.particle.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public class BoundObsidianBlock
extends WardedBlock {
    public BoundObsidianBlock() {
        super(BlockBehaviour.Properties.of().strength(50.0f, 3600000.0f).mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASS).pushReaction(PushReaction.IGNORE).sound(SoundType.CHAIN).requiresCorrectToolForDrops());
    }

    @Override
    protected void attack(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (!pLevel.isClientSide() && pStack.is((Item)ModItems.SHADOW_KEY.get())) {
            pStack.shrink(1);
            pLevel.playSound(null, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), SoundType.CHAIN.getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.unlock(pLevel, pPos);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void spawnParticles(Level pLevel, BlockPos pPos) {
        float i;
        ServerLevel server = (ServerLevel)pLevel;
        for (i = 0.0f; i <= 1.0f; i += 0.2f) {
            server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)pPos.getX() - 0.1, (double)pPos.getY() + 0.1, (double)((float)pPos.getZ() + i), 1, 0.0, 0.0, 0.0, 0.1);
        }
        for (i = 0.0f; i <= 1.0f; i += 0.2f) {
            server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)((float)pPos.getX() + i), (double)pPos.getY() + 0.1, (double)pPos.getZ() - 0.1, 1, 0.0, 0.0, 0.0, 0.1);
        }
        for (i = 0.0f; i <= 1.0f; i += 0.2f) {
            server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)pPos.getX() + 1.1, (double)pPos.getY() + 0.1, (double)((float)pPos.getZ() + i), 1, 0.0, 0.0, 0.0, 0.1);
        }
        for (i = 0.0f; i <= 1.0f; i += 0.2f) {
            server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)((float)pPos.getX() + i), (double)pPos.getY() + 0.1, (double)pPos.getZ() + 1.1, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    public void unlock(Level pLevel, BlockPos pPos) {
        BoundObsidianBlock block;
        pLevel.removeBlock(pPos, false);
        this.spawnParticles(pLevel, pPos);
        if (pLevel.getBlockState(pPos.above()).is((Block)this)) {
            block = (BoundObsidianBlock)pLevel.getBlockState(pPos.above()).getBlock();
            block.unlock(pLevel, pPos.above());
        }
        if (pLevel.getBlockState(pPos.below()).is((Block)this)) {
            block = (BoundObsidianBlock)pLevel.getBlockState(pPos.below()).getBlock();
            block.unlock(pLevel, pPos.below());
        }
        if (pLevel.getBlockState(pPos.east()).is((Block)this)) {
            block = (BoundObsidianBlock)pLevel.getBlockState(pPos.east()).getBlock();
            block.unlock(pLevel, pPos.east());
        }
        if (pLevel.getBlockState(pPos.west()).is((Block)this)) {
            block = (BoundObsidianBlock)pLevel.getBlockState(pPos.west()).getBlock();
            block.unlock(pLevel, pPos.west());
        }
        if (pLevel.getBlockState(pPos.north()).is((Block)this)) {
            block = (BoundObsidianBlock)pLevel.getBlockState(pPos.north()).getBlock();
            block.unlock(pLevel, pPos.north());
        }
        if (pLevel.getBlockState(pPos.south()).is((Block)this)) {
            block = (BoundObsidianBlock)pLevel.getBlockState(pPos.south()).getBlock();
            block.unlock(pLevel, pPos.south());
        }
    }
}

